#!/usr/local/bin/python -O
#


import sys, os
import webbrowser

from optik import OptionParser
import misc

def main():
    usage = ("Enemy Territory clientside logfile parser.\n"
             "usage: %prog logfile [htmlfile] [options]\n"
             "If htmlfile is specified, --dir argument is ignored.\n" 
             "If htmlfile is '-' output is printed to stdout.\n" 
             r"Example1: %prog c:\wet\etmain\etconsole.log " 
             r"c:\stats\foo.html" "\n" 
             r"Example2: %prog c:\wet\etmain\etconsole.log "
             r"-d c:\stats")
    
    parser = OptionParser(usage=usage, version="%prog " + misc.VERSION)
    
    parser.add_option("-d", "--dir", dest="dir", metavar="DIR",
                      help=".html output directory. The filename is "
                      "created automaticly based team names. If "
                      "directory does not exists, its created automaticly.")

    parser.add_option("-b", "--browser", dest="browser", action="store_true",
                      default=0,
                      help="starts system default browser after creating the "
                      ".html-file")

    parser.add_option("-a", "--alt-date", dest="alt_date", action="store_true",
                      default=0,
                      help="places date in beginning of filename")


    options, args = parser.parse_args()
    if len(args) == 0:
        parser.print_help()
        sys.exit()
    if len(args) > 2:
        parser.error("incorrect number of arguments")        

    if len(args) == 1 and not options.dir:
        print "specify output file or directory. see --help"
        return
    
    logfile_name = args[0]
    if not os.path.isfile(logfile_name):
        print 'Logfile not found: %s' % logfile_name
        return

    try:
        open(logfile_name, 'r')
    except IOError:
        print "Could not open logfile %s" % logfile_name
        return

    if len(args) == 2:
        outfile_name = args[1]
    else:
        outfile_name = ''

    misc.options = options
    
    # parser -> analyser -> output
    from q3parser import Q3LogParser
    from analyzer import Q3Analyzer
    from output import Q3OutputAnalysis, OutputError

    output = Q3OutputAnalysis(Q3Analyzer(Q3LogParser(logfile_name)))

    fname = output.write_html(outfile_name, options)

    if fname and options.browser:
        webbrowser.open_new(fname)
   
# startup
if __name__ == '__main__':
    main()

