"""
Write HTML from anylyzed events.
Ugly, stay away if possible!
Won't validate in validator.w3.org.
"""

# external HTMLgen-lib required 
from HTMLgen import *
from analyzer import return_list_sorted_by, Player
from misc import keys_by_decreasing_values, VERSION, quote
import _strptime

class OutputError(Exception): pass

class Q3OutputAnalysis:
    
    #color_background = "#000000"
    color_background =  "#20272f"
    #color_forecolor = "#00FF00"
    color_forecolor = "#FFFFFF"
    # text=#FFFFFF
    color_white = "#FFFFFF"

    tr_bg_color = ("#666666", "#838383")
    tr_bg_heading = "#333333"

    q3_color_html = {
        '1':'#FF0000',
        '2':'#58d701',
        '3':'#FAF900',
        '4':'#0804b2',
        '5':'#00EEEE',
        '6':'#e000fa',
        '7':'#ffffff',
        '8':'#ffa105',
        '9':'#888888',
        '0':'#000000',
        '-':'#a59005',
        '!':'#e28100',
        '@':'#a54d05',
        '#':'#930698',
        '$':'#04b2a8',
        '&':'#0494b2',
        '*':'#8d2207',
        '(':'#0d680a',
        ')':'#fe3a1e',
        '_':'#8d0707',
        '=':'#982a06',
        'A':'FF0000',
        'B':'#097368',
        'C':'#89078d',
        'D':'#07868d',
        'E':'#46078d',
        'F':'#0494b2',
        'G':'#b1f3b6',
        'H':'#09730c',
        'I':'#ff2405',
        'J':'#d72b01',
        'K':'#b25204',
        'L':'#bd8d03',
        'M':'#8d8c07',
        'N':'#f0f3bb',
        'O':'#eff581',
        'P':'#000000',
        'Q':'#e21c00',
        'R':'#58d701',
        'S':'#e8fd29',
        'T':'#e8fd29',
        'U':'#07228d',
        'V':'#02b1ca',
        'W':'#a004b2',
        'X':'#FFFFFF',
        'Y':'#ff7505',
        'Z':'#DDDDDD',
        'a':'FF0000',
        'b':'#097368',
        'c':'#89078d',
        'd':'#07868d',
        'e':'#46078d',
        'f':'#0494b2',
        'g':'#b1f3b6',
        'h':'#09730c',
        'i':'#ff2405',
        'j':'#d72b01',
        'k':'#b25204',
        'l':'#bd8d03',
        'm':'#8d8c07',
        'n':'#f0f3bb',
        'o':'#eff581',
        'p':'#000000',
        'q':'#e21c00',
        'r':'#58d701',
        's':'#e8fd29',
        't':'#e8fd29',
        'u':'#07228d',
        'v':'#02b1ca',
        'w':'#a004b2',
        'x':'#FFFFFF',
        'y':'#ff7505',
        'z':'#DDDDDD',
        '[':'#807108',
        ']':'#DDDDDD',
        '/':'#f6f574',
        '?':'#8d1807',
        ',':'#bd8403',
        '.':'#f1f4d2',
        '<':'#09734e',
        '>':'#060798',
        '|':'#12680a',
        }

    def __init__(self, analysis):
        self.teamsinfo = analysis.teams
        self.timestamp = analysis.timestamp        
        self.players = analysis.players.players
        self.mm1 = analysis.mm1
        self.awards = analysis.awards        
        self.weapons = analysis.weapons
        self.best_weapon_users = analysis.best_weapon_users
        self.OSP = analysis.players.hasOSPInfo
        self.is_etpro = analysis.is_etpro
        
        #self.OSP = 0 #testing only
        
    def build_html_names(self, players):
        """Convert q3-codes to font-tags, and binds new attribute
        .html_name to player-objects"""        
        for player in players.values():
            player.html_name = self.q3_name_to_html(player.name)

    def q3_name_to_html(self, q3_name):
        # ^7loolfdfdsf^^^^aPLC^^ 
        q3_name = '^7' + q3_name
        orig = q3_name
        q3_name = str(Text(q3_name))
        top = len(q3_name)
        out = ''
        while q3_name:
            if len(q3_name) <= 1:
                out += q3_name
                break
            if q3_name[0] == '^':
                # go forward until something else
                while q3_name[1:].startswith('^'):
                    out += '^'
                    q3_name = q3_name[1:]
                # check if we hit the end
                if len(q3_name) <= 1:
                    out += '^'                    
                    break

                assert q3_name[1] != '^'
                
                if q3_name[1] in self.q3_color_html.keys():
                    out += '</font><font color="%s">' % (
                        self.q3_color_html[q3_name[1]])
                else:
                    out += '</font><font color="%s">' % (
                        self.q3_color_html['7'])
                q3_name = q3_name[2:]
            else:
                out += q3_name[0]
                q3_name = q3_name[1:]
            
        
        assert out.startswith('</font>'), "%s : %s" % (out, orig)
        out = out[7:]
        out += '</font>'
        return out

    def write_html(self, file_name, options):
        "Uses HTMLgen and some manual dirty work to print out our analysis"
        self.build_html_names(self.players)
        
        doc = SimpleDocument()
        doc.title = "Enemy Territory Teamstats"
        doc.textcolor = self.color_forecolor
        doc.bgcolor = self.color_background
        doc.linkcolor = self.color_forecolor
        doc.alinkcolor = self.color_forecolor
        doc.vlinkcolor = self.color_forecolor

        doc.append('<font face="Arial">')
        # HEADER
        #
        doc.append(BR())
        
        def defHeading(title):            
            return TableLite(TR(TD(
                Font(Bold(title), color='black', size=5),
                bgcolor='#8080ff', align='center')), width='100%')

        doc.append(Name("general"))

        red_html = self.q3_name_to_html(self.teamsinfo['red'].tag)
        blue_html = self.q3_name_to_html(self.teamsinfo['blue'].tag)

        blue_tag = self.teamsinfo['blue'].tag
        red_tag = self.teamsinfo['red'].tag

        
        if blue_tag and red_tag:
            doc.append(defHeading("War %s-%s at %s" %
                                  (blue_tag, red_tag,
                                   formatTimeStamp(self.timestamp))))
        else:
            doc.append(defHeading("Enemy Territory Teamstats (%s)" %
                                  formatTimeStamp(self.timestamp)))
            
        doc.append(BR())

        doc.append("<center>")
        for i in ['general', 'kills', 'awards', 'weapons', 'mm1']:
            doc.append(Href("#%s" % i , i), " ")
        doc.append("</center>", BR())       


        body = None
        plr_list = [x for x in self.players.values()]
        plr_list = return_list_sorted_by(plr_list, 'effiency')

        team_list = ['blue', 'red']

        h = ['Name', 'Effiency', 'Frag', 'Death', 'Suicide', 'TK']

        if self.is_etpro:
            h.extend(['Gibs', 'Dg', 'Dr', 'Dg/Dr', 'Td', 'Dg/Frag', ])
        elif self.OSP:
            h.extend(['Dg', 'Dr', 'Dg/Dr', 'Td', 'Dg/Frag', ])
            
        THList = map(TH, h)
        
        for team in team_list:
            
            body = None
            if team != 'total':
                plr_list = [x for x in self.players.values() if x.team == team]
            else:
                plr_list = [x for x in self.players.values()]
                
            plr_list = return_list_sorted_by(plr_list, 'effiency')

            i = 0
            for plr in plr_list:
                line = TR(bgcolor=self.tr_bg_color[i%2])
                i += 1
                line += [TD(plr.html_name, html_escape='no')]
                l = [plr.effiency, plr.frags, plr.deaths, plr.suicides,
                     plr.teamkills]
                if self.is_etpro:
                    l.extend([plr.gibs, plr.dg, plr.dr, plr.dg_dr_ratio,
                              plr.td, plr.dkratio])
                elif self.OSP:
                    l.extend([plr.dg, plr.dr, plr.dg_dr_ratio, plr.td,
                              plr.dkratio])
                
                    
                line += map(TD, l)
                if body is None:
                    body = line
                else:
                    body += [line]
            
            # team totals
            t = self.teamsinfo[team]
            line = TR(bgcolor=self.tr_bg_color[i%2])
            line += [TD('Total')]
            l = [t.effiency, t.frags, t.deaths, t.suicides, t.teamkills]
            if self.is_etpro:
                l.extend([t.gibs, t.dg, t.dr, t.dg_dr_ratio, t.td, t.dkratio])
            elif self.OSP:
                l.extend([t.dg, t.dr, t.dg_dr_ratio, t.td, t.dkratio])
                
            line += map(TD, l)

            if body is None:
                body = TR() + [TD('')]
            else:
                body += [line]
                
            heading = TR(bgcolor=self.tr_bg_heading) + THList
            if team == 'red':
                if red_tag:
                    cap = Caption(red_html, html_escape='no')
                else:
                    cap = Caption("Team 2", html_escape='no')
            else:
                if blue_tag:
                    cap = Caption(blue_html, html_escape='no')
                else:
                    cap = Caption("Team 1: " + blue_html, html_escape='no')
                
            t = TableLite(border=0, cellspacing=1, cellpadding=3,
                          html_escape='no', align='center')
            t.append(cap, heading, body)
            
            doc.append(t, BR(), BR())


        doc.append(Name("kills"))
        doc.append(defHeading("Kills"), BR())
        self.buildMatrix(doc)
        
        # AWARDS
        # 
        doc.append('<center>')
        doc.append(Name("awards"))
        doc.append(defHeading("Awards"))
        doc.append(BR())
        
        for award in self.awards:
            doc.append(Font(award.title + ' Award -- '))#, size=4))            
            plrs = ', '.join([x.html_name for x in award.winners])
            f = Font("%s %s" % (plrs, award.desc), html_escape='no',
                     color=self.color_white)
            
            doc.append(f, BR(), BR())
            
        doc.append(BR())
        doc.append('</center>')

        
        # weapons usage
        doc.append(Name("weapons"))
        doc.append(defHeading("Weapons"), BR())
        THList = map(TH, ['Weapon', 'Kills', 'Best user'])
        body = None
        i = 0
        for w in keys_by_decreasing_values(self.weapons):
            line = TR(bgcolor=self.tr_bg_color[i%2])
            i += 1
            line += [TD(w),
                     TD(self.weapons[w]),
                     TD(", ".join([x.html_name for x in
                                   self.best_weapon_users[w][0]]),
                        " (%d kills)" % self.best_weapon_users[w][1],
                        html_escape='no')]
            if not body:
                body = line
            else:
                body += [line]
            
        cap = Caption('')
        t = TableLite(border=0, cellspacing=1, cellpadding=3,
                      html_escape='no', align='center')
        heading = TR(bgcolor=self.tr_bg_heading) + THList
        t.append(cap, heading, body)
        doc.append(t)
        
        doc.append(BR())

        # MM1 Log
        #
        if self.mm1:
            doc.append(Name("mm1"))
            doc.append(defHeading("Messagelog"))
            doc.append(BR())

            heading = ''


            msg = self.mm1[0]
            line = TR()
            line += [TD(str(msg.timestamp)),
                     TD(self.q3_name_to_html(msg.talker), html_escape='no'),
                     TD(self.q3_name_to_html(msg.msg), html_escape='no')]
            body = line

            for msg in self.mm1[1:]:
                line = TR()
                line += [TD(msg.timestamp),
                         TD(self.q3_name_to_html(msg.talker),html_escape='no'),
                         TD(self.q3_name_to_html(msg.msg), html_escape='no')]
                body += [line]

            cap = Caption('')
            t = TableLite(border=0, html_escape='no', align='center')
            t.append(cap, heading, body)
            doc.append(t)
        
        # FOOTER
        #
        doc.append(BR())
        doc.append(HR())
        doc.append('Logfile created: ' + self.timestamp)
        doc.append('Stats created: %s' %
                   time.asctime(time.localtime(time.time())), BR())
        doc.append("effiency=frags/(deaths+suicides). /kill's are not ",
                   "counted in suicides. Dg=damage given to enemy, ",
                   "Dr=damage received by enemy, "
                   "Td=Damage given to teammates, ",
                   "Dg/frag=Damage given per frag (counted from end-of-round "
                   "reported frags). Getting tk'd does not count as death.",
                   BR())
        doc.append(Href("http://frangen.sourceforge.net/etstat.html",
                        'Enemy Territory Teamstats'),
                   "v%s" % VERSION, 'by frangen@users.sf.net')
        doc.append(" / ", Href("http://clan.gs", "Clan GunSlingers"))

        if file_name == '-':
            doc.write() # stdout
        elif not file_name:
            team1, team2 = "team1", "team2"
            if red_tag and blue_tag:
                team1 = red_tag
                team2 = blue_tag

            if options.alt_date:
                adate = time.strftime("%Y-%m-%d",
                                      time.strptime(self.timestamp))
                title = "%s_%s_vs_%s" % (adate, team1, team2,)
            else:
                title = "%s_vs_%s_%s" % (team1, team2,
                                         formatTimeStamp(self.timestamp))
                
            title = title.replace(" ", "_")
            ext = "html"
            print repr(title)
            title = quote(title, safe='')

            fullPath = os.path.join(options.dir, title+"."+ext)
            if os.path.exists(fullPath):
                for i in range(2, 100000):
                    fullPath = os.path.join(options.dir, "%s_%d.%s" %
                                            (title,i,ext))
                    if not os.path.exists(fullPath):
                        break
                else:
                    raise OutputError("could not make unique file(!!!)")
                
            try:
                if not os.path.isdir(options.dir):
                    os.makedirs(options.dir)
            except OSError, msg:
                raise OutputError("could not create dir %s (%s)" %
                                  (options.dir, msg))
            print repr(fullPath)
            doc.write(fullPath)
            return fullPath
        else:
            if os.path.isdir(file_name):
                raise OutputError("%s is a directory, could not write.\n"
                                  "Please use --dir option." %
                                  file_name)
            doc.write(file_name)
            return file_name

    def buildMatrix(self, doc):
        plr_list = [x for x in self.players.values()]
        plr_list = return_list_sorted_by(plr_list, 'effiency')        
        
        THList = [TH(x, width=20) for x in ['Name'] + \
                     [str(x) for x in range(1, len(plr_list)+1)] + \
                     ['Effiency', 'Frag', 'Death', 'Suicide', 'TK']]

        body = None
        k = 0
        for i in range(len(plr_list)):
            plr = plr_list[i]            
            line = TR(bgcolor=self.tr_bg_color[k%2])
            k += 1
            line += [TD("%d %s" % (i+1, plr.html_name), html_escape='no')]

            tmp = []

            for j in range(len(plr_list)):
                if i == j:                    
                    tmp.append(TD(Font(plr.suicides, color="#FF0000")))
                else:
                    if plr.players_killed.has_key(plr_list[j]):
                        td = TD(plr.players_killed[plr_list[j]],
                                html_escape='no')
                    elif plr.players_teamkilled.has_key(plr_list[j]):
                        td = TD(Font(plr.players_teamkilled[plr_list[j]],
                                     color="#0000FF"),
                                html_escape='no')
                    else:
                        td = TD("")
                        
                    tmp.append(td)

            line += tmp
            line += map(TD, [plr.effiency, plr.frags, plr.deaths,
                                 plr.suicides, plr.teamkills])
            if not body:
                body = line
            else:
                body += [line]
            
        cap = Caption('')
        t = TableLite(border=0, cellspacing=1, cellpadding=3,
                      html_escape='no', align='center')
        heading = TR(bgcolor=self.tr_bg_heading) + THList
        t.append(cap, heading, body)
        doc.append(t, BR())
        doc.append("<center>")
        doc.append("Red=suicide(diagonal), white=frag, blue=teamkill")
        doc.append("</center>")
        doc.append(BR())
        
def formatTimeStamp(ts):
    parts = ts.split()
    del parts[3]
    return ' '.join(parts)
