import re
import os
VERSION = "1.06"
DEBUG = int(os.getenv("TS_DEBUG", 0))


options = None

def debug(*msg):
    if DEBUG:
        print "[DEBUG]", ' '.join([str(x) for x in msg])

def warning(*msg):
    print "[WARNING]", ' '.join([str(x) for x in msg])
    
def keys_by_increasing_values(d):
    "d -> return list of dict d's keys k in increasing order of d[kj."
    result = []
    for key, value in d.items():
        result.append((value, key))
    result.sort()
    # Strip out the values.
    for i in xrange(len(result)):
        result[i] = result[i][1]
    return result

def keys_by_decreasing_values(d):
    "d -> return list of dict d's keys k in decreasing order of d[kj."
    result = keys_by_increasing_values(d)
    result.reverse()
    return result

_removeColorRE = re.compile(r"\^.?")
def stripColor(name, space=0):
    if space:
        return _removeColorRE.sub(" ", name)
    else:
        return _removeColorRE.sub("", name)


# ripped from cgi


# ripped from urllib

always_safe = ('ABCDEFGHIJKLMNOPQRSTUVWXYZ'
               'abcdefghijklmnopqrstuvwxyz'
               '0123456789' '_.-')

_fast_safe_test = always_safe + '/'
_fast_safe = None

def _fast_quote(s):
    global _fast_safe
    if _fast_safe is None:
        _fast_safe = {}
        for c in _fast_safe_test:
            _fast_safe[c] = c
    res = list(s)
    for i in range(len(res)):
        c = res[i]
        if not _fast_safe.has_key(c):
            res[i] = '%%%02X' % ord(c)
    return ''.join(res)

def quote(s, safe = '/'):
    """quote('abc def') -> 'abc%20def'

    Each part of a URL, e.g. the path info, the query, etc., has a
    different set of reserved characters that must be quoted.

    RFC 2396 Uniform Resource Identifiers (URI): Generic Syntax lists
    the following reserved characters.

    reserved    = ";" | "/" | "?" | ":" | "@" | "&" | "=" | "+" |
                  "$" | ","

    Each of these characters is reserved in some component of a URL,
    but not necessarily in all of them.

    By default, the quote function is intended for quoting the path
    section of a URL.  Thus, it will not encode '/'.  This character
    is reserved, but in typical usage the quote function is being
    called on a path where the existing slash characters are used as
    reserved characters.
    """
    s = s.replace("/", "")
    safe = always_safe + safe
    if _fast_safe_test == safe:
        return _fast_quote(s)
    res = list(s)
    for i in range(len(res)):
        c = res[i]
        if c not in safe:
            res[i] = '%%%02X' % ord(c)
    return ''.join(res)



class Indexed:
    def __init__(self, seq):
        self.seq = seq
    def __getitem__(self, i):
        return self.seq[i], i

