﻿Imports ICSharpCode.SharpZipLib.Zip

Public Class frmOptions

    Dim AGChecks As List(Of CheckBox)

    Private Sub frmOptions_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        LoadOptions()

        AGChecks = New List(Of CheckBox)
        For Each c As Control In grpAG.Controls
            If TypeOf c Is CheckBox And c.Enabled = True Then
                AGChecks.Add(DirectCast(c, CheckBox))
            End If
        Next

        grpAG.Enabled = chkAutoGenerate.Checked
    End Sub

    Private Sub chkAutoGenerate_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkAutoGenerate.CheckedChanged
        grpAG.Enabled = chkAutoGenerate.Checked
    End Sub

    Private Sub btnSelectAllAG_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSelectAllAG.Click
        For Each c As CheckBox In AGChecks
            c.Checked = True
        Next
    End Sub

    Private Sub btnDeselectAllAG_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDeselectAllAG.Click
        For Each c As CheckBox In AGChecks
            c.Checked = False
        Next
    End Sub

    Private Sub btnOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOK.Click
        SaveOptions()
        Me.Close()
    End Sub

    Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub

    Private Sub btnApply_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnApply.Click
        SaveOptions()
    End Sub

    Private Sub btnBrowseWolfPath_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBrowse.Click
        Using fbd As New FolderBrowserDialog With {.Description = "Select your 'W:ET\etmain' directory."}

            If fbd.ShowDialog = Windows.Forms.DialogResult.OK Then
                If fbd.SelectedPath.EndsWith("\etmain") Then
                    txtWolfPath.Text = fbd.SelectedPath
                    If txtWolfPath.Text.EndsWith("\") Or txtWolfPath.Text.EndsWith("/") Then
                        txtWolfPath.Text = txtWolfPath.Text.Substring(0, txtWolfPath.Text.Length - 1)
                    End If
                Else
                    MessageBox.Show("Please select your 'etmain' directory.", "Select etmain Directory", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                End If
            End If

        End Using
    End Sub

    Private Sub txtWolfPath_Leave(ByVal sender As System.Object, ByVal e As System.EventArgs)
        If txtWolfPath.Text.EndsWith("\") Or txtWolfPath.Text.EndsWith("/") Then
            txtWolfPath.Text = txtWolfPath.Text.Substring(0, txtWolfPath.Text.Length - 1)
        End If
    End Sub

#Region " LOAD & SAVE "

    Private Sub LoadOptions()
        Dim s As My.MySettings = My.Settings
        s.Reload()

        txtWolfPath.Text = s.WolfPath

        chkAutoGenerate.Checked = s.AutoGenerate
        chkAG_Arena.Checked = s.AG_Arena
        chkAG_CommandMapImg.Checked = s.AG_CommandMapImg
        chkAG_Lightmap.Checked = s.AG_Lightmap
        chkAG_LoadingImg.Checked = s.AG_LoadingImg
        chkAG_Loc.Checked = s.AG_Loc
        chkAG_ObjData.Checked = s.AG_ObjData
        chkAG_Script.Checked = s.AG_Script
        chkAG_Shaders.Checked = s.AG_Shaders
        chkAG_Tracemap.Checked = s.AG_Tracemap
        chkAG_SoundsFile.Checked = s.AG_SoundsFile
        chkAG_SPS.Checked = s.AG_SPS
        chkAG_Textures.Checked = s.AG_Textures
        chkAG_Models.Checked = s.AG_Models
        numCompressionQ.Value = s.CompressionQuality


    End Sub

    Private Sub SaveOptions()
        Dim s As My.MySettings = My.Settings
        s.Reload()

        s.WolfPath = txtWolfPath.Text

        s.AutoGenerate = chkAutoGenerate.Checked
        s.AG_Arena = chkAG_Arena.Checked
        s.AG_CommandMapImg = chkAG_CommandMapImg.Checked
        s.AG_Lightmap = chkAG_Lightmap.Checked
        s.AG_LoadingImg = chkAG_LoadingImg.Checked
        s.AG_Loc = chkAG_Loc.Checked
        s.AG_Models = chkAG_Models.Checked
        s.AG_ObjData = chkAG_ObjData.Checked
        s.AG_Script = chkAG_Script.Checked
        s.AG_Shaders = chkAG_Shaders.Checked
        s.AG_Textures = chkAG_Textures.Checked
        s.AG_Tracemap = chkAG_Tracemap.Checked
        s.AG_SoundsFile = chkAG_SoundsFile.Checked
        s.AG_SPS = chkAG_SPS.Checked
        s.CompressionQuality = CInt(numCompressionQ.Value)

        s.Save()
    End Sub

#End Region

End Class