﻿Public Class frmHelp

    Public Sub New(ByVal subject As String)
        InitializeComponent()

        Dim gen As String = String.Empty
        Dim loc As String = String.Empty

        Dim lines() As String = My.Resources.helpSubjects.Split(CChar(Environment.NewLine))
        Dim str As String = String.Empty

        Select Case subject
            Case "BSP File"
                str = "[BSPFILE_"
            Case "Lightmap Directory"
                str = "[LIGHTMAP_"
            Case "Tracemap"
                str = "[TRACEMAP_"
            Case "Script File"
                str = "[SCRIPT_"
            Case "Objective Data File"
                str = "[OBJDATA_"
            Case "Arena File"
                str = "[ARENA_"
            Case "Location File"
                str = "[LOC_"
            Case "Sounds File"
                str = "[SOUNDS_"
            Case "Loading Image"
                str = "[LOADINGIMAGE_"
            Case "Commandmap Image"
                str = "[COMMANDMAP_"
            Case "SPS File"
                str = "[SPSFILE_"
        End Select

        If str <> String.Empty Then
            For i As Integer = 0 To lines.Length - 1
                Dim l As String = lines(i)
                If l.Trim.StartsWith(str & "HELP]") Then
                    gen = l.Trim.Substring((str & "HELP]").Length)
                    loc = lines(i + 1).Trim.Substring((str & "LOCATION]").Length)
                    Exit For
                End If
            Next

            txtGeneral.Text = gen
            txtLocation.Text = loc
        End If

        Me.Text = "Help on " & subject
    End Sub

    Public Sub New(ByVal subject As String, ByVal general As String, ByVal location As String)
        InitializeComponent()

        Me.Text = "Help on " & subject
        txtGeneral.Text = general
        txtLocation.Text = location
    End Sub

    Private Sub btnOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOK.Click
        Me.Close()
    End Sub
End Class