﻿Public Class frmGenerateObjData

    Private Const frmHeightNormal As Integer = 354
    Private Const frmHeightExpanded As Integer = 750
    Dim expanded As Boolean = False

    Dim _bspName As String
    Dim cList As List(Of objDataInfo)

    Public Sub New(ByVal n As Integer, ByVal bspName As String)
        InitializeComponent()

        _bspName = bspName
        cList = New List(Of objDataInfo)

        'Create tabpages on the fly
        For i As Integer = 1 To n
            Dim t As TabPage = New TabPage

            t.Text = "Objective " & i
            Dim c As objDataInfo = New objDataInfo(i)
            AddHandler c.DescriptionChanged, AddressOf Description_Changed

            t.UseVisualStyleBackColor = True
            t.Controls.Add(c)
            c.Dock = DockStyle.Fill
            c.Visible = True

            tab.TabPages.Add(t)

            cList.Add(c)
        Next
    End Sub

    Private Sub Description_Changed(ByVal objNr As Integer)
        If expanded Then txtBox.Text = GenerateObjDataFile()
    End Sub

    Private Function GenerateObjDataFile() As String
        Dim axisMapDescr As String = txtAxis.Text
        Dim alliedMapDescr As String = txtAllied.Text
        Dim neutralMapDescr As String = txtNeutral.Text

        Dim axisList As New List(Of String)
        Dim alliedList As New List(Of String)
        Dim isPrimary As New List(Of Boolean)

        For Each c As objDataInfo In cList
            axisList.Add(c.txtAxis.Text)
            alliedList.Add(c.txtAllied.Text)
            isPrimary.Add(c.optPrimary.Checked)
        Next

        Dim nl As String = Environment.NewLine
        Dim q As Char = Chr(34)
        Dim t As String = ControlChars.Tab

        Dim str As String = "// Map Descriptions" & nl & _
                            "wm_mapdescription axis" & t & t & q & axisMapDescr & q & nl & _
                            "wm_mapdescription allied" & t & q & alliedMapDescr & q & nl & _
                            "wm_mapdescription neutral" & t & q & neutralMapDescr & q & nl & _
                            nl & "// Axis Objective Descriptions" & nl
        For i As Integer = 1 To cList.Count
            str &= "wm_objective_axis_desc " & i & t
            If isPrimary(i - 1) Then
                str &= q & "Primary Objective:**"
            Else
                str &= q & "Secondary Objective:**"
            End If
            str &= axisList(i - 1) & q & nl
        Next
        str &= nl & "// Allied Objective Descriptions" & nl

        For i As Integer = 1 To cList.Count
            str &= "wm_objective_allied_desc " & i & t
            If isPrimary(i - 1) Then
                str &= q & "Primary Objective:**"
            Else
                str &= q & "Secondary Objective:**"
            End If
            str &= alliedList(i - 1) & q & nl
        Next

        Return str
    End Function

    Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub

    Private Sub frmGenerateObjData_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        expanded = False
        Me.Height = frmHeightNormal
    End Sub

    Private Sub btnPreview_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPreview.Click
        If expanded Then
            Me.Height = frmHeightNormal
            btnPreview.Text = "Show Live Preview"
            expanded = False
        Else
            Me.Height = frmHeightExpanded
            btnPreview.Text = "Hide Live Preview"
            expanded = True
            txtBox.Text = GenerateObjDataFile()
        End If
    End Sub

    Private Sub txtAxis_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtNeutral.TextChanged, txtAxis.TextChanged, txtAllied.TextChanged
        Description_Changed(0)
    End Sub

    Private Sub btnGenerate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGenerate.Click
        Dim s As String = GenerateObjDataFile()
        If s <> String.Empty Then
            Dim path As String = IO.Path.Combine(My.Settings.WolfPath, "maps\" & _bspName & ".objdata")

            If MessageBox.Show("PK3Creator will now generate the following file:" & Environment.NewLine & Environment.NewLine & path & _
                               Environment.NewLine & Environment.NewLine & "Do you want to continue?", "Confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = Windows.Forms.DialogResult.Yes Then

                Dim bln As Boolean = True
                If IO.File.Exists(path) Then
                    If MessageBox.Show("The file '" & _bspName & ".objdata' already exists." & Environment.NewLine & "Do you want to overwrite this file?", "Overwrite", MessageBoxButtons.YesNo, MessageBoxIcon.Warning) = Windows.Forms.DialogResult.Yes Then
                        bln = True
                    Else
                        bln = False
                    End If
                End If

                If bln Then
                    IO.File.WriteAllText(path, s)
                End If

            End If
        End If
    End Sub
End Class