﻿Public Class frmGenerateArena

    Private Const frmWidthExpanded As Integer = 910
    Private Const frmWidthNormal As Integer = 493
    Dim expanded As Boolean = False

    Dim briefing As String

    Private Sub btnChooseMapPos_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnChooseMapPos.Click
        Dim f As New frmChooseMapPos
        If f.ShowDialog(Me) = Windows.Forms.DialogResult.OK Then
            numMapPosX.Value = f.X
            numMapPosY.Value = f.Y
        End If
    End Sub

    Private Sub txtBriefing_Enter(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtBriefing.Enter
        txtBriefing.Text = txtBriefing.Text.Trim.Replace("*", Environment.NewLine)
    End Sub

    Private Sub txtBriefing_Leave(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtBriefing.Leave
        txtBriefing.Text = txtBriefing.Text.Trim.Replace(Environment.NewLine, "*")
    End Sub

    Private Function GenerateArenaFile() As String
        Dim nl As String = Environment.NewLine
        Dim t As String = ControlChars.Tab

        Dim q As String = Chr(34)

        Dim type As String = String.Empty
        If chkOBJ.Checked Then type &= "wolfmp "
        If chkSW.Checked Then type &= "wolfsw "
        If chkLMS.Checked Then type &= "wolflms"
        type = type.Trim()

        Dim str As String = "{" & nl & _
                              t & "map" & t & t & t & q & txtMapname.Text & q & nl & _
                              t & "longname" & t & t & q & txtLongname.Text & q & nl & _
                              t & "type" & t & t & t & q & type & q & nl & _
                              t & "timelimit" & t & t & numTimeLimit.Value.ToString & nl & _
                              t & "axisRespawnTime" & t & t & numAxisSpawn.Value.ToString & nl & _
                              t & "alliedRespawnTime" & t & numAlliedSpawn.Value.ToString & nl & _
                              t & "briefing" & t & t & q & txtBriefing.Text & q & nl & _
                              t & "mapposition_x" & t & t & numMapPosX.Value.ToString & nl & _
                              t & "mapposition_y" & t & t & numMapPosY.Value.ToString & nl & _
                              "}"


        Return str
    End Function

    Private Sub frmGenerateArena_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Me.Width = frmWidthNormal
        expanded = False
        btnPreview.Text = "Show Live Preview"
    End Sub

    Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub

    Private Sub btnPreview_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPreview.Click
        If expanded Then
            Me.Width = frmWidthNormal
            btnPreview.Text = "Show Live Preview"
            expanded = False
        Else
            Me.Width = frmWidthExpanded
            btnPreview.Text = "Hide Live Preview"
            expanded = True
            txtBox.Text = GenerateArenaFile()
        End If
    End Sub

    Private Sub btnGenerate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGenerate.Click
        If txtMapname.Text = String.Empty Then
            MessageBox.Show("Mapname cannot be empty.", "Required field", MessageBoxButtons.OK, MessageBoxIcon.Information)
            Exit Sub
        End If
        If txtLongname.Text = String.Empty Then
            MessageBox.Show("Long name cannot be empty.", "Required field", MessageBoxButtons.OK, MessageBoxIcon.Information)
            Exit Sub
        End If
        If chkLMS.Checked = False And chkOBJ.Checked = False And chkSW.Checked = False Then
            MessageBox.Show("At least one Type is required.", "Required field", MessageBoxButtons.OK, MessageBoxIcon.Information)
            Exit Sub
        End If


        Dim s As String = GenerateArenaFile()
        If s <> String.Empty Then
            Dim path As String = IO.Path.Combine(My.Settings.WolfPath, "scripts\" & txtMapname.Text & ".arena")

            If MessageBox.Show("PK3Creator will now generate the following file:" & Environment.NewLine & Environment.NewLine & path & _
                               Environment.NewLine & Environment.NewLine & "Do you want to continue?", "Confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = Windows.Forms.DialogResult.Yes Then

                Dim bln As Boolean = True
                If IO.File.Exists(path) Then
                    If MessageBox.Show("The file '" & txtMapname.Text & ".arena' already exists." & Environment.NewLine & "Do you want to overwrite this file?", "Overwrite", MessageBoxButtons.YesNo, MessageBoxIcon.Warning) = Windows.Forms.DialogResult.Yes Then
                        bln = True
                    Else
                        bln = False
                    End If
                End If

                If bln Then
                    IO.File.WriteAllText(path, s)
                End If

            End If
        End If
    End Sub



    Private Sub Anything_Changed(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtMapname.TextChanged, txtLongname.TextChanged, txtBriefing.TextChanged, chkSW.CheckedChanged, chkOBJ.CheckedChanged, chkLMS.CheckedChanged, numTimeLimit.ValueChanged, numMapPosY.ValueChanged, numMapPosX.ValueChanged, numAxisSpawn.ValueChanged, numAlliedSpawn.ValueChanged
        If expanded Then txtBox.Text = GenerateArenaFile()
    End Sub

End Class