﻿Imports System.Runtime.InteropServices
Imports ICSharpCode.SharpZipLib.Zip

Module modPublicFunctions

    Public Structure SHFILEINFO
        Public hIcon As IntPtr            ' : icon
        Public iIcon As Integer           ' : icondex
        Public dwAttributes As Integer    ' : SFGAO_ flags
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=260)> _
        Public szDisplayName As String
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=80)> _
        Public szTypeName As String
    End Structure

    'Retries windows icon from filename
    Public Declare Auto Function SHGetFileInfo Lib "shell32.dll" _
            (ByVal pszPath As String, _
             ByVal dwFileAttributes As Integer, _
             ByRef psfi As SHFILEINFO, _
             ByVal cbFileInfo As Integer, _
             ByVal uFlags As Integer) As IntPtr

    Public Const SHGFI_ICON As Int32 = &H100
    Public Const SHGFI_SMALLICON As Int32 = &H1
    Public Const SHGFI_LARGEICON As Int32 = &H0    ' Large icon
    Public nIndex As Int32 = 0


    'Checks Pak0,1,2.pk3 for existance of file
    Public Function ExistsInPakxPK3(ByVal file As String) As Boolean
        Dim z0 As New ZipFile(IO.Path.Combine(My.Settings.WolfPath, "pak0.pk3"))
        Dim z1 As New ZipFile(IO.Path.Combine(My.Settings.WolfPath, "pak1.pk3"))
        Dim z2 As New ZipFile(IO.Path.Combine(My.Settings.WolfPath, "pak2.pk3"))
        Dim rtn As Boolean = True

        If file.Contains("\etmain\") Then
            Dim shortPath As String = file.Substring(file.IndexOf("\etmain\") + "\etmain\".Length)
            If shortPath <> String.Empty Then
                'Replace backslash with forward slash, otherwise it can't be found in zip
                shortPath = shortPath.Replace("\", "/")
                If z0.FindEntry(shortPath, True) < 0 AndAlso z1.FindEntry(shortPath, True) < 0 AndAlso z2.FindEntry(shortPath, True) < 0 Then
                    rtn = False
                Else
                    rtn = True
                End If
            End If
        End If

        Return rtn
    End Function

End Module
