﻿Imports System.Runtime.InteropServices

Public Class clsTexture
    Inherits ListViewItem

    Public Sub New(ByVal file As String)
        Me.File = file.Replace("/", "\")

        Dim shinfo As New SHFILEINFO()
        shinfo.szDisplayName = New String(Chr(0), 260)
        shinfo.szTypeName = New String(Chr(0), 80)

        Dim hImgSmall As IntPtr = SHGetFileInfo(Me.File, 0, shinfo, _
            Marshal.SizeOf(shinfo), SHGFI_ICON Or SHGFI_SMALLICON)

        Me.Icon = System.Drawing.Icon.FromHandle(shinfo.hIcon)
        Me.IconPtr = shinfo.hIcon

        MyBase.Text = Me.ToString

        If ExistsInPakxPK3(file) Then
            Me.IsStandard = True
        Else
            Me.IsStandard = False
        End If
    End Sub

    Private _File As String
    Public Property File() As String
        Get
            Return _File
        End Get
        Set(ByVal value As String)
            _File = value
        End Set
    End Property

    Private _IconPtr As IntPtr
    Public Property IconPtr() As IntPtr
        Get
            Return _IconPtr
        End Get
        Set(ByVal value As IntPtr)
            _IconPtr = value
        End Set
    End Property

    Private _Icon As Icon
    Public Property Icon() As Icon
        Get
            Return _Icon
        End Get
        Set(ByVal value As Icon)
            _Icon = value
        End Set
    End Property

    Public ReadOnly Property ShortFile() As String
        Get
            Return IO.Path.GetFileName(Me.File)
        End Get
    End Property

    Private _IsStandard As Boolean
    Public Property IsStandard() As Boolean
        Get
            Return _IsStandard
        End Get
        Set(ByVal value As Boolean)
            _IsStandard = value
        End Set
    End Property

    Public Overrides Function ToString() As String
        Return Me.ShortFile
    End Function

    Public Overloads ReadOnly Property Text() As String
        Get
            Return Me.ToString
        End Get
    End Property

End Class

Public Class clsTextureFolder
    Inherits ListViewItem

    Public Sub New(ByVal folderName As String)
        NewSub(folderName)
    End Sub

    Public Sub New(ByVal folderName As String, ByVal files() As String)
        NewSub(folderName)
        For Each s As String In files
            _Files.Add(New clsTexture(s))
        Next
    End Sub

    Private Sub NewSub(ByVal folderName As String)
        Me.FolderName = folderName
        _Files = New List(Of clsTexture)
        MyBase.Text = Me.ToString

        Dim shinfo As New SHFILEINFO()
        shinfo.szDisplayName = New String(Chr(0), 260)
        shinfo.szTypeName = New String(Chr(0), 80)

        Dim hImgSmall As IntPtr = SHGetFileInfo(folderName, 0, shinfo, _
            Marshal.SizeOf(shinfo), SHGFI_ICON Or SHGFI_SMALLICON)

        Me.Icon = System.Drawing.Icon.FromHandle(shinfo.hIcon)
        Me.IconPtr = shinfo.hIcon
    End Sub

    Private _FolderName As String
    Public Property FolderName() As String
        Get
            Return _FolderName
        End Get
        Set(ByVal value As String)
            _FolderName = value
        End Set
    End Property

    Private _IconPtr As IntPtr
    Public Property IconPtr() As IntPtr
        Get
            Return _IconPtr
        End Get
        Set(ByVal value As IntPtr)
            _IconPtr = value
        End Set
    End Property

    Private _Icon As Icon
    Public Property Icon() As Icon
        Get
            Return _Icon
        End Get
        Set(ByVal value As Icon)
            _Icon = value
        End Set
    End Property

    Public ReadOnly Property ShortFolderName() As String
        Get
            Return Me.FolderName.Substring(Me.FolderName.IndexOf("\textures\") + 10)
        End Get
    End Property

    Private _Files As List(Of clsTexture)
    Public Property Files() As List(Of clsTexture)
        Get
            Return _Files
        End Get
        Set(ByVal value As List(Of clsTexture))
            _Files = value
        End Set
    End Property

    Public ReadOnly Property ShortFiles() As List(Of String)
        Get
            Dim l As New List(Of String)
            For Each tex As clsTexture In Me.Files
                l.Add(tex.ShortFile)
            Next
            Return l
        End Get
    End Property

    Public Overrides Function ToString() As String
        Return Me.ShortFolderName
    End Function

    Public Overloads ReadOnly Property Text() As String
        Get
            Return Me.ToString
        End Get
    End Property

End Class
