#! /bin/sh

###################################################################################################
#     This file is part of "Liberty Gaming NQ Stats Analyzer".
#
#     "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 3 of the License, or
#     (at your option) any later version.
#
#     "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this program.  If not, see <http://www.gnu.org/licenses/>.
###################################################################################################



# The directory name where game server logs are stored
LOG_DIR="/home/et1/.etwolf/noquarter"
# Name of game server log file
SERVER_LOG="etserver.log"
# Shrubbot config file name
SHRUBBOT_FILE="$LOG_DIR/shrubbot.cfg"


# FTP server host name or IP address
FTP_HOST="yourserver.com"
# FTP username
FTP_USER="johndoe"
# FTP password
FTP_PASS="secret"
# Directory on FTP server to put log files into
FTP_DIR="/stats/data"


# Configuration ends here
#######################################################




NOW_DATE=$(date +'%Y%m%d%H%I%S')

cp "$LOG_DIR/$SERVER_LOG" "$LOG_DIR/$NOW_DATE.server.log"
echo -n "" > "$LOG_DIR/$SERVER_LOG"
chmod 0600 "$LOG_DIR/$SERVER_LOG"


/usr/bin/ftp -n -i "$FTP_HOST" <<End-Of-Session >/dev/null 2>&1
user $FTP_USER $FTP_PASS
cd "$FTP_DIR"
binary
put "$LOG_DIR/$NOW_DATE.server.log" "./$NOW_DATE.server.log"
put "$SHRUBBOT_FILE" "shrubbot.cfg"
quit
End-Of-Session
