/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

function initWindow() {
  window.onresize=function() {
    winWidth=getWinWidth();
  }
  startMousePosCapture();
}

function initPlayerSearchForm() {
  var psi=$('player_search_input');
  if (psi) {
    psi.value_init='Player search';
    if (psi.value=='') {
      psi.value=psi.value_init;
    }
    psi.onfocus=function() {
      if (this.value==this.value_init) {
        this.value='';
      }
    }
    psi.onblur=function() {
      this.value=trimString(this.value);
      if (this.value=='') {
        this.value=this.value_init;
      }
    }
  }
}

function checkPlayerSearchName() {
  var psi=$('player_search_input');
  psi.value=trimString(psi.value);
  if (psi.value==psi.value_init) {
    psi.value='';
  }
  return psi.value!='';
}

function initHRows(tbl_id) {
  var tbl=$(tbl_id);
  var className='';
  if (tbl) {
    for (var i=0; i<tbl.rows.length; i++) {
      if (tbl.rows[i].className=='tbl_hrow_1' || tbl.rows[i].className=='tbl_hrow_2') {
        tbl.rows[i].originalClassName=tbl.rows[i].className;
        tbl.rows[i].onmouseover=function() {
          setCssClass(this, 'tbl_hrow_h');
        }
        tbl.rows[i].onmouseout=function() {
          setCssClass(this, this.originalClassName);
        }
      }
    }
  }
}

var openedImage=null;
var loadedThumbs=new Array();

function initThumbs() {
  var thumb=null;
  var img=null;
  var img_id='';
  for (var i=0; i<loadedThumbs.length; i++) {
    thumb=loadedThumbs[i][0];
    img_id=loadedThumbs[i][1];
    img=$(img_id);
    if (thumb && img) {
      thumb.onmouseout=function() {
        if (openedImage) {
          openedImage.style.display='none';
          MouseMoveFunc=null;
        }
      }
      thumb.img_id=img_id;
      thumb.onmouseover=function() {
        if (openedImage) {
          openedImage.style.display='none';
        }
        MouseMoveFunc=function() {
          if (openedImage) {
            if ((openedImage.width+mouseX+20)>winWidth) {
              openedImage.style.left=(winWidth-openedImage.width-30)+'px';
            } else {
              openedImage.style.left=(mouseX+10)+'px';
            }
            openedImage.style.top=(mouseY+10)+'px';
          }
        }
        $(this.img_id).style.display='';
        openedImage=$(this.img_id);
        openedImage.style.top=(mouseY+10)+'px';
        if ((openedImage.width+mouseX+20)>winWidth) {
          openedImage.style.left=(winWidth-openedImage.width-30)+'px';
        } else {
          openedImage.style.left=(mouseX+10)+'px';
        }
      }
    }
  }
}
