/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Screen width, in pixels.
 * @var int
 */
var winWidth=getWinWidth();

// User agent and OS
var usrAgnt=navigator.userAgent.toLowerCase();
var isWin=(usrAgnt.indexOf('win')!=-1);
var usrAgntVer=parseInt(navigator.appVersion);
var isIE=(usrAgnt.indexOf('msie')!=-1);
var isOpera=(usrAgnt.indexOf('opera')!=-1);
var isMozilla=(navigator.product=='Gecko');

/**
 * Current mouse X-coordinate
 * @var int
 */
var mouseX=0;

/**
 * Current mouse X-coordinate
 * @var int
 */
var mouseY=0;

/**
 * Function handler that will be called each time mouse moves
 * @var object
 */
var MouseMoveFunc=null;

/**
 * Object handler the MouseMoveFunc() will be applied on
 * @var object
 */
var MouseMoveFuncObj=null;

/**
 * Chache used by setCssClass() function
 * @var object
 */
var setCss_cache=new Array();

/**
 * JS to CSS and vice versa map
 * NOTE: This array is *NOT* complete!!!
 * @var object
 */
var CSS_to_JS_map=new Array();
CSS_to_JS_map['background']='background';
CSS_to_JS_map['background-attachment']='backgroundAttachment';
CSS_to_JS_map['background-color']='backgroundColor';
CSS_to_JS_map['background-image']='backgroundImage';
CSS_to_JS_map['background-position']='backgroundPosition';
CSS_to_JS_map['background-repeat']='backgroundRepeat';
CSS_to_JS_map['border']='border';
CSS_to_JS_map['border-bottom']='borderBottom';
CSS_to_JS_map['border-bottom-color']='borderBottomColor';
CSS_to_JS_map['border-bottom-style']='borderBottomStyle';
CSS_to_JS_map['border-bottom-width']='borderBottomWidth';
CSS_to_JS_map['border-color']='borderColor';
CSS_to_JS_map['border-left']='borderLeft';
CSS_to_JS_map['border-left-color']='borderLeftColor';
CSS_to_JS_map['border-left-style']='borderLeftStyle';
CSS_to_JS_map['border-left-width']='borderLeftWidth';
CSS_to_JS_map['border-right']='borderRight';
CSS_to_JS_map['border-right-color']='borderRightColor';
CSS_to_JS_map['border-right-style']='borderRightStyle';
CSS_to_JS_map['border-right-width']='borderRightWidth';
CSS_to_JS_map['border-style']='borderStyle';
CSS_to_JS_map['border-top']='borderTop';
CSS_to_JS_map['border-top-color']='borderTopColor';
CSS_to_JS_map['border-top-style']='borderTopStyle';
CSS_to_JS_map['border-top-width']='borderTopWidth';
CSS_to_JS_map['border-width']='borderWidth';
CSS_to_JS_map['clear']='clear';
CSS_to_JS_map['clip']='clip';
CSS_to_JS_map['color']='color';
CSS_to_JS_map['cursor']='cursor';
CSS_to_JS_map['display']='display';
CSS_to_JS_map['filter']='filter';
CSS_to_JS_map['font']='font';
CSS_to_JS_map['font-family']='fontFamily';
CSS_to_JS_map['font-size']='fontSize';
CSS_to_JS_map['font-style']='fontStyle';
CSS_to_JS_map['font-variant']='fontVariant';
CSS_to_JS_map['font-weight']='fontWeight';
CSS_to_JS_map['height']='height';
CSS_to_JS_map['left']='left';
CSS_to_JS_map['letter-spacing']='letterSpacing';
CSS_to_JS_map['line-height']='lineHeight';
CSS_to_JS_map['list-style']='listStyle';
CSS_to_JS_map['list-style-image']='listStyleImage';
CSS_to_JS_map['list-style-position']='listStylePosition';
CSS_to_JS_map['list-style-type']='listStyleType';
CSS_to_JS_map['margin']='margin';
CSS_to_JS_map['margin-bottom']='marginBottom';
CSS_to_JS_map['margin-left']='marginLeft';
CSS_to_JS_map['margin-right']='marginRight';
CSS_to_JS_map['margin-top']='marginTop';
CSS_to_JS_map['overflow']='overflow';
CSS_to_JS_map['padding']='padding';
CSS_to_JS_map['padding-bottom']='paddingBottom';
CSS_to_JS_map['padding-left']='paddingLeft';
CSS_to_JS_map['padding-right']='paddingRight';
CSS_to_JS_map['padding-top']='paddingTop';
CSS_to_JS_map['page-break-after']='pageBreakAfter';
CSS_to_JS_map['page-break-before']='pageBreakBefore';
CSS_to_JS_map['position']='position';
CSS_to_JS_map['float']='styleFloat';
CSS_to_JS_map['text-align']='textAlign';
CSS_to_JS_map['text-decoration']='textDecoration';
CSS_to_JS_map['text-decoration: blink']='textDecorationBlink';
CSS_to_JS_map['text-decoration: line-through']='textDecorationLineThrough';
CSS_to_JS_map['text-decoration: none']='textDecorationNone';
CSS_to_JS_map['text-decoration: overline']='textDecorationOverline';
CSS_to_JS_map['text-decoration: underline']='textDecorationUnderline';
CSS_to_JS_map['text-indent']='textIndent';
CSS_to_JS_map['text-transform']='textTransform';
CSS_to_JS_map['top']='top';
CSS_to_JS_map['vertical-align']='verticalAlign';
CSS_to_JS_map['visibility']='visibility';
CSS_to_JS_map['width']='width';
CSS_to_JS_map['z-index']='zIndex';


/**
 * Obtain the width in pixels of the given window
 * @param   object    wh    Window handler. Default: current window
 * @return  int   Window width in pixels
 */
function getWinWidth(wh){
  var winWidth=-1;
  if(typeof(wh)=='undefined'){
    wh=window;
  }
  if(typeof(wh.innerWidth)=='number'){
    // Non-IE browser
    winWidth=wh.innerWidth;
  }else if(wh.document.documentElement && (wh.document.documentElement.clientWidth || wh.document.documentElement.clientHeight)){
    // IE 6+ browser in 'standards compliant mode'
    winWidth=wh.document.documentElement.clientWidth;
  }else if(wh.document.body && (wh.document.body.clientWidth || wh.document.body.clientHeight)){
    // IE 4 compatible browser
    winWidth=wh.document.body.clientWidth;
  }
  return winWidth;
}

/**
 * Convert CSS property name into JS CSS property name
 * @param   string    css_name    CSS property name
 * @return string
 */
function cssToJs(css_name) {
  var js_property_name='';
  if (typeof(CSS_to_JS_map[css_name])=='string') {
    js_property_name=CSS_to_JS_map[css_name];
  }
  return js_property_name;
}


/**
 * [document.]getElementById() wrapper
 * @param     string    elementId   ID of the element
 * @param     object    targetDoc   OPTIONAL target document handler. Default: document
 * @return    object    Specified object or NULL if noting found
 */
function $(elementId, targetDoc) {
  var el=null;
  if (typeof(targetDoc)!='object' || targetDoc==null) {
    targetDoc=document;
  }
  try {
    el=targetDoc.getElementById(elementId);
  } catch (e) { }
  return el;
}


/**
 * [document.]getElementsByTagName() wrapper
 * @param   string    tag       Tag name
 * @param   object    parent_   Parent element. Default: document
 */
function $$(tag, parent_) {
  var elements=null;
  if (typeof(tag)=='string' && tag!='') {
    if (typeof(parent_)!='object' || parent_==null) {
      parent_=document;
    }
    try {
      eval('elements=parent_.getElementsByTagName(\''+tag+'\')');
    } catch (e) {
      elements=null;
    }
  }
  return elements;
}

/**
 * Assign specified CSS class to an element
 * @param   object    targetElement     Target element
 * @param   string    cssName           CSS class name
 * @param   boolean   skipCache         If TRUE, then no chached CSS data will be used. Default is FALSE.
 */
function setCssClass(targetElement, cssName, skipCache) {
  if (typeof(targetElement)=='object' && targetElement && targetElement.style && typeof(cssName)=='string' && cssName!='') {
    cssName=cssName.toLowerCase();
    var css_text='';
    var css_rules_array=null;
    var css_rules=null;
    var tmp=null;
    var selector_text_array=null;
    var selector_text='';
    var css_found=false;
    var cssName_curr='';
    var cssName_2='.'+cssName;
    var cssName_3='#'+cssName;
    var property_name='';
    var property_value='';
    var original_value=null;
    if ((typeof(skipCache)!='boolean' || skipCache==false) && typeof(setCss_cache[cssName])=='object' && setCss_cache[cssName]) {
      css_found=true;
      css_rules_array=setCss_cache[cssName];
    } else {
      for (var stylesheet_nr=0; stylesheet_nr<document.styleSheets.length; stylesheet_nr++) {
        if (document.styleSheets[stylesheet_nr].cssText) {
          // IE
          css_text=document.styleSheets[stylesheet_nr].cssText;
        } else {
          // Others
          css_rules=document.styleSheets[stylesheet_nr].cssRules;
          for (var rule_nr=0; rule_nr<css_rules.length; rule_nr++) {
            css_text+=css_rules[rule_nr].cssText+"\n";
          }
        }
        tmp=css_text.split('}');
        for (var i=0; i<tmp.length; i++) {
          selector_text=trimString(tmp[i].substring(0, tmp[i].indexOf('{')));
          if (selector_text!='') {
            selector_text_array=selector_text.split(',');
          }
          for (var ii=0; ii<selector_text_array.length; ii++) {
            cssName_curr=trimString(selector_text_array[ii]).toLowerCase();
            if (cssName_curr==cssName || cssName_curr==cssName_2 || cssName_curr==cssName_3) {
              setCss_cache[cssName]=(trimString(tmp[i].substring(tmp[i].indexOf('{')+1))).split(';');
              for (var nn=0; nn<setCss_cache[cssName].length; nn++) {
                if (-1!=setCss_cache[cssName][nn].indexOf('"')) {
                  setCss_cache[cssName][nn]=setCss_cache[cssName][nn].split('"').join('\\"');
                }
              }
              css_rules_array=setCss_cache[cssName];
              css_found=true;
              break;
            }
          }
          if (css_found==true) {
            break;
          }
        }
        if (css_found) {
          break;
        }
      }
    }
    if (css_found && css_rules_array!=null) {
      for (var iii=0; iii<css_rules_array.length; iii++) {
        if (css_rules_array[iii]!='') {
          tmp=css_rules_array[iii].split(':');
          property_name=cssToJs(trimString(tmp.shift()).toLowerCase());
          property_value=trimString(tmp.join(':'));
          if (property_name!='') {
            if (isIE && null!=(original_value=targetElement.style.getAttribute(property_name))) {
              if (original_value!=property_value) {
                targetElement.style.setAttribute(property_name, property_value);
              }
            } else {
              eval('targetElement.style.'+property_name+'="'+property_value+'";');
            }
          }
        }
      }
    }
  }
}


/**
 * Get absolute top position of static-positioned element
 * @param   object    tgt_element   Element
 * @return  int
 */
function getTopPos(tgt_element) {
  var pos=0;
  if (typeof(tgt_element)=='object' && tgt_element && tgt_element.offsetParent) {
    pos=tgt_element.offsetTop;
    while (tgt_element=tgt_element.offsetParent) {
      pos+=tgt_element.offsetTop;
    }
  }
  return pos;
}

/**
 * Get absolute top position of static-positioned element
 * @param   object    tgt_element   Element
 * @return  int
 */
function getLeftPos(tgt_element) {
  var pos=0;
  if (typeof(tgt_element)=='object' && tgt_element && tgt_element.offsetParent) {
    pos=tgt_element.offsetLeft;
    while (tgt_element=tgt_element.offsetParent) {
      pos+=tgt_element.offsetLeft;
    }
  }
  return pos;
}

/**
 * Start mouse position capture
 */
function startMousePosCapture() {
  if (window.event) {
    // IE & Co.
    document.onmousemove=function() {
      mouseX=window.event.x+document.documentElement.scrollLeft;
      mouseY=window.event.y+document.documentElement.scrollTop;
      if (MouseMoveFunc) {
        MouseMoveFunc();
      }
      return true;
    }
  } else {
    // Mozilla
    document.onmousemove=function(e) {
      mouseX=e.pageX;
      mouseY=e.pageY;
      if (MouseMoveFunc) {
        MouseMoveFunc();
      }
      return true;
    }
  }
}
