<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

define('PCPIN_DIR_OFFSET', './');

require_once(PCPIN_DIR_OFFSET.'/init.php');

if (!empty($use_html_cache)) {
  $cache=new PCPIN_Cache($session);
  if (false!==$html=$cache->getRecord($_SERVER['REQUEST_URI'])) {
    echo $html;
    die();
  }
}

require_once(PCPIN_DIR_OFFSET.'/defs.php');
require_once(PCPIN_DIR_OFFSET.'/class/pcpintpl.class.php');

/**
 * Player GUIDs to exclude from "Players" and "Awards" lists
 */
$excludeguids=new PCPIN_ExcludeGUIDs($session);
if (!isset($exclude_guids) || !is_array($exclude_guids)) $exclude_guids=array();
$exclude_guids=array_unique(array_merge($exclude_guids, $excludeguids->getGUIDs()));
if (!empty($exclude_guids)) {
  define('PCPIN_LIST_EXCLUDE_GUIDS', implode(',', $exclude_guids));
} else {
  define('PCPIN_LIST_EXCLUDE_GUIDS', '');
}

$_body_onload=array('initWindow()');
$_body_onload[]='initPlayerSearchForm()';

$_js_files=array(PCPIN_DIR_OFFSET.'/js/base.js',
                 PCPIN_DIR_OFFSET.'/js/strings.js',
                 PCPIN_DIR_OFFSET.'/js/time.js',
                 PCPIN_DIR_OFFSET.'/js/main.js',
                 );
// CSS files
$_css_files=array(PCPIN_DIR_OFFSET.'/css/main.css');


$tplhandle=new PcpinTpl();
$tplhandle->setBasedir(PCPIN_DIR_OFFSET.'/template');
$tplhandle->readTemplatesFromFile('main.tpl');

$tplhandle->addGlobalVars(array('formlink'=>PCPIN_FORMLINK));

if (empty($do)) {
  $do='players';
}


switch ($do) {

  case 'players':
  default:
    // List players
    require(PCPIN_DIR_OFFSET.'/inc/players.inc.php');
  break;

  case 'player_stats':
    // Load stats for a single player
    require(PCPIN_DIR_OFFSET.'/inc/player_stats.inc.php');
  break;

  case 'games':
    // List games
    require(PCPIN_DIR_OFFSET.'/inc/games.inc.php');
  break;

  case 'game_stats':
    // Load stats for a single game
    require(PCPIN_DIR_OFFSET.'/inc/game_stats.inc.php');
  break;

  case 'awards':
    // Load awards page
    require(PCPIN_DIR_OFFSET.'/inc/awards.inc.php');
  break;

  case 'weapons':
    // Load weapons page
    require(PCPIN_DIR_OFFSET.'/inc/weapons.inc.php');
  break;

}

$tplhandle->addVars('main', array('title'=>coloredToPlain($_conf['server_name']).htmlspecialchars(' Server stats '.chr(226).chr(128).chr(162).' Liberty Gaming NQ Stats Analyzer'),
                                  'server_name'=>coloredToHTML($_conf['server_name']),
                                  'server_ip'=>htmlspecialchars($_conf['server_ip']),
                                  'server_port'=>htmlspecialchars($_conf['server_port']),
                                  'owner_url'=>$_conf['owner_homepage_url'],
                                  'owner_title'=>htmlspecialchars($_conf['owner_homepage_title']),
                                  'main_contents'=>$tpl->getParsedTemplate('main'),
                                  'player_search_name'=>htmlspecialchars(isset($player_search_name)? $player_search_name : '')
                                  ));

// Add CSS files to template
foreach ($_css_files as $file) {
  if (file_exists($file)) {
    $tplhandle->addVar('css_files', 'file', $file.'?'.filemtime($file));
    $tplhandle->parseTemplate('css_files', 'a');
  }
}

// Add JavaScript files to template
foreach ($_js_files as $file) {
  if (file_exists($file)) {
    $tplhandle->addVar('js_files', 'file', $file.'?'.filemtime($file));
    $tplhandle->parseTemplate('js_files', 'a');
  }
}

// Add OnLoad event handlers for BODY element
if (!empty($_body_onload) && is_array($_body_onload)) {
  $tplhandle->addVar('main', 'body_onload', implode(' ; ', $_body_onload));
}

$html=$tplhandle->getParsedTemplate('main');
if (!empty($use_html_cache)) {
  $cache->addRecord($_SERVER['REQUEST_URI'], $html);
}
echo $html;
?>