<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


$game=new PCPIN_Game($session);
$gameclientdeath=new PCPIN_GameClientDeath($session);
$gameclientkill=new PCPIN_GameClientKill($session);

if (!isset($games)) {
  $games=0;
} else {
  $games*=1;
}

$min_game_id=0;

if (!empty($games)) {
  // Get last N games
  $game->_db_getList('id', 'id DESC', 1);
  if (empty($game->_db_list)) {
    $games=0;
  } else {
    $min_game_id=$game->_db_list[0]['id']-$games;
    $game->_db_freeList();
  }
}


// Get weapon stats
$mods=$gameclientdeath->countDeathsByMod($min_game_id);
foreach ($mods as $key=>$data) {
  $mods[$key]['MostKills']=$gameclientkill->getBestModKiller($data['MOD'], $min_game_id);
  $mods[$key]['MostDeaths']=$gameclientdeath->getBestModVictim($data['MOD'], $min_game_id);
}


$tpl=new PcpinTpl();
$tpl->setBasedir(PCPIN_DIR_OFFSET.'/template');
$tpl->readTemplatesFromFile('weapons.tpl');
$tpl->addGlobalVars(array('formlink'=>PCPIN_FORMLINK,
                          ));


// Show weapons
$col=0;
foreach ($mods as $data) {
  if (empty($data['MostKills']) || $data['MOD']=='MOD_KICKED') {
    continue;
  }
  $img=PCPIN_DIR_OFFSET.'/image/mods/'.$data['MOD'].'.gif';
  if (!file_exists($img)) {
    $img=PCPIN_DIR_OFFSET.'/image/mods/UNKNOWN.gif';
  }
  $tpl->addVars('weapon_col', array('name'=>htmlspecialchars(MODToWeaponName($data['MOD'])),
                                    'img'=>$img,
                                    'total_kills'=>htmlspecialchars($data['Count']),
                                    'most_kills_count'=>htmlspecialchars($data['MostKills']['Count']),
                                    'most_kills_name'=>coloredToHTML($data['MostKills']['Name']),
                                    'most_kills_name_txt'=>htmlspecialchars($data['MostKills']['NameTxt']),
                                    'most_kills_guid_key'=>htmlspecialchars($data['MostKills']['GUID_Key']),
                                    'most_deaths_count'=>htmlspecialchars($data['MostDeaths']['Count']),
                                    'most_deaths_name'=>coloredToHTML($data['MostDeaths']['Name']),
                                    'most_deaths_name_txt'=>htmlspecialchars($data['MostDeaths']['NameTxt']),
                                    'most_deaths_guid_key'=>htmlspecialchars($data['MostDeaths']['GUID_Key']),
                                    ));
  $tpl->parseTemplate('weapon_col', 'a');
  $col++;
  if ($col==2) {
    $tpl->parseTemplate('weapon_row', 'a');
    $tpl->clearTemplate('weapon_col');
    $col=0;
  }
}
if ($col>0) {
  while ($col<2) {
    $tpl->addVar('weapon_col', 'name', false);
    $tpl->parseTemplate('weapon_col', 'a');
    $col++;
  }
  $tpl->parseTemplate('weapon_row', 'a');
}

// Show active games count limit
if (!empty($games)) {
  $tpl->addVar('games_link_last_'.$games, 'active', true);
} else {
  $tpl->addVar('games_link_all', 'active', true);
}

?>