<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


$records_per_page=50;
$max_page_numbers=10;

$_js_files[]=PCPIN_DIR_OFFSET.'/js/players.js';

if (!empty($player_search_name_enc)) {
  $player_search_name=urldecode($player_search_name_enc);
}
if (!isset($player_search_name)) $player_search_name='';
if (!isset($show_aliases_key)) $show_aliases_key='';
if (!isset($sort_by)) {
  $sort_by='rating';
  $sort_dir='desc';
}
if (!isset($sort_dir)) $sort_dir='asc';
if (empty($page) || !pcpin_ctype_digit($page)) $page=1;


$player_search_name=trim($player_search_name);

$_body_onload[]='initHRows(\'contents_tbl\')';

// Get players stats
$gameclient=new PCPIN_GameClient($session);
$list=$gameclient->listPlayers($exclude_guids, $player_search_name, $sort_by, $sort_dir, $records_per_page*($page-1), $records_per_page);

$total_pages=ceil($list['TotalResults']/$records_per_page);

$tpl=new PcpinTpl();
$tpl->setBasedir(PCPIN_DIR_OFFSET.'/template');
$tpl->readTemplatesFromFile('players.tpl');
$tpl->addGlobalVars(array('formlink'=>PCPIN_FORMLINK,
                          'player_search_name'=>htmlspecialchars($player_search_name),
                          'player_search_name_enc'=>urlencode($player_search_name),
                          'sort_by'=>htmlspecialchars($sort_by),
                          'sort_dir'=>htmlspecialchars($sort_dir),
                          'page'=>htmlspecialchars($page),
                          ));

$tpl->addVar('players_list', 'display', $list['TotalResults']>0);

$row=1;
$nr=$records_per_page*($page-1);
foreach ($list['ListedResults'] as $data) {
  $tpl->addVars('player_row', array('row'=>htmlspecialchars($row),
                                    'key'=>htmlspecialchars($data['GUID_Key']),
                                    'nr'=>htmlspecialchars(++$nr),
                                    'name'=>coloredToHTML($data['Name']),
                                    'name_txt'=>htmlspecialchars($data['NameTxt']),
                                    'kills'=>htmlspecialchars($data['KilledEnemies']),
                                    'deaths'=>htmlspecialchars($data['Deaths']),
                                    'rating'=>htmlspecialchars(round($data['Rating'])),
                                    'kd'=>htmlspecialchars(number_format(round($data['K/D'], 2), 2, '.', '')),
                                    'kg'=>htmlspecialchars(number_format(round($data['K/G'], 2), 2, '.', '')),
                                    'kill_sprees'=>htmlspecialchars($data['KillSprees']),
                                    'death_sprees'=>htmlspecialchars($data['DeathSprees']),
                                    'games'=>htmlspecialchars($data['TotalGames']),
                                    'time_played'=>htmlspecialchars(makeTimeFromSeconds($data['TimePlayed'])),
                                    ));
  if (count($data['UsedNames'])>1) {
    if ($show_aliases_key==$data['GUID_Key']) {
      $tpl->addVar('player_row_aka_btn_hide', 'display', true);
      foreach ($data['UsedNames'] as $name_data) {
        if ($data['Name']!=$name_data['Name']) {
          $tpl->addVars('player_row_aka_list', array('display'=>true,
                                                     'name'=>coloredToHTML($name_data['Name']),
                                                     'name_txt'=>htmlspecialchars($data['NameTxt']),
                                                     'key'=>htmlspecialchars($data['GUID_Key']),
                                                     ));
          $tpl->parseTemplate('player_row_aka_list', 'a');
        }
      }
    } else {
      $tpl->addVar('player_row_aka_btn_show', 'key', htmlspecialchars($data['GUID_Key']));
      foreach ($data['UsedNames'] as $name_data) {
        if ($data['Name']!=$name_data['Name']) {
          $tpl->addVars('player_row_aka_list_js', array('display'=>true,
                                                        'name'=>coloredToHTML($name_data['Name']),
                                                        'name_txt'=>htmlspecialchars($data['NameTxt']),
                                                        'key'=>htmlspecialchars($data['GUID_Key']),
                                                        ));
          $tpl->parseTemplate('player_row_aka_list_js', 'a');
        }
      }
    }
  }
  $tpl->parseTemplate('player_row', 'a');
  $tpl->clearTemplate('player_row_aka_btn_show');
  $tpl->clearTemplate('player_row_aka_btn_hide');
  $tpl->clearTemplate('player_row_aka_list');
  $tpl->clearTemplate('player_row_aka_list_js');
  $row^=3;
}

// Display page numbers
if ($total_pages>1) {
  $tpl->addVar('pages', 'total_pages', htmlspecialchars($total_pages));
  // Calculate page numbers range
  $pn_start=($page>=$max_page_numbers)? $page-floor($max_page_numbers/2) : 1;
  $pn_end=($pn_start+$max_page_numbers<=$total_pages)? $pn_start+$max_page_numbers : $total_pages+1;
  if ($pn_start>1 && $pn_end-$pn_start<$max_page_numbers) {
    $pn_start--;
  }
  if ($page>1) {
    $tpl->addVar('pages_previous', 'page', htmlspecialchars($page-1));
  }
  for ($i=$pn_start; $i<$pn_end; $i++) {
    $tpl->addVars('pages_page', array('linked'=>$i!=$page,
                                      'page'=>$i,
                                      ));
    $tpl->parseTemplate('pages_page', 'a');
  }
  if ($page<$total_pages) {
    $tpl->addVar('pages_next', 'page', htmlspecialchars($page+1));
  }
}
?>