<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


$records_per_page=50;
$max_page_numbers=10;

$_body_onload[]='initThumbs()';
$_body_onload[]='initHRows(\'contents_tbl\')';


if (!isset($sort_by)) {
  $sort_by='nr';
  $sort_dir='desc';
}
if (!isset($sort_dir)) $sort_dir='asc';
if (empty($page) || !pcpin_ctype_digit($page)) $page=1;


// Get game stats
$game=new PCPIN_Game($session);
$list=$game->listGames($sort_by, $sort_dir, $records_per_page*($page-1), $records_per_page);

$total_pages=ceil($list['TotalResults']/$records_per_page);


$tpl=new PcpinTpl();
$tpl->setBasedir(PCPIN_DIR_OFFSET.'/template');
$tpl->readTemplatesFromFile('games.tpl');
$tpl->addGlobalVars(array('formlink'=>PCPIN_FORMLINK,
                          'sort_by'=>htmlspecialchars($sort_by),
                          'sort_dir'=>htmlspecialchars($sort_dir),
                          'page'=>htmlspecialchars($page),
                          ));


$tpl->addVar('games_list', 'display', $list['TotalResults']>0);


$row=1;
$nr=$records_per_page*($page-1);
foreach ($list['ListedResults'] as $data) {
  $img=PCPIN_DIR_OFFSET.'/image/maps/'.$data['MapName'].'.gif';
  if (!file_exists($img)) {
    $img=PCPIN_DIR_OFFSET.'/image/maps/UNKNOWNMAP.gif';
  }
  $tmp=explode('_', $data['MapName']);
  foreach ($tmp as $key=>$tmp_val) {
    $tmp[$key]=ucfirst($tmp_val);
  }
  $data['MapNameStr']=implode(' ', $tmp);
  $tpl->addVars('game_row', array('row'=>htmlspecialchars($row),
                                  'nr'=>htmlspecialchars($data['GameNr']),
                                  'map'=>coloredToHTML($data['MapNameStr']),
                                  'players'=>htmlspecialchars($data['Players']),
                                  'clients'=>htmlspecialchars($data['Clients']),
                                  'duration'=>htmlspecialchars(makeTimeFromSeconds($data['Duration'])),
                                  'map_img'=>$img,
                                  ));
  $tpl->parseTemplate('game_row', 'a');
  $row^=3;
}

// Display page numbers
if ($total_pages>1) {
  $tpl->addVar('pages', 'total_pages', htmlspecialchars($total_pages));
  // Calculate page numbers range
  $pn_start=($page>=$max_page_numbers)? $page-floor($max_page_numbers/2) : 1;
  $pn_end=($pn_start+$max_page_numbers<=$total_pages)? $pn_start+$max_page_numbers : $total_pages+1;
  if ($pn_start>1 && $pn_end-$pn_start<$max_page_numbers) {
    $pn_start--;
  }
  if ($page>1) {
    $tpl->addVar('pages_previous', 'page', htmlspecialchars($page-1));
  }
  for ($i=$pn_start; $i<$pn_end; $i++) {
    $tpl->addVars('pages_page', array('linked'=>$i!=$page,
                                      'page'=>$i,
                                      ));
    $tpl->parseTemplate('pages_page', 'a');
  }
  if ($page<$total_pages) {
    $tpl->addVar('pages_next', 'page', htmlspecialchars($page+1));
  }
}
?>