<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


if (!isset($game_nr)) $game_nr=0;

$game=new PCPIN_Game($session);
$gameclient=new PCPIN_GameClient($session);
$gameclientkill=new PCPIN_GameClientKill($session);
$gameclientsuicide=new PCPIN_GameClientSuicide($session);
$gameclientdeath=new PCPIN_GameClientDeath($session);
$gameclientmisc=new PCPIN_GameClientMisc($session);
$gameclientrevive=new PCPIN_GameClientRevive($session);
$gameclientammo=new PCPIN_GameClientAmmo($session);
$gameclienthealth=new PCPIN_GameClientHealth($session);


$_body_onload[]='initThumbs()';
$_body_onload[]='initHRows(\'game_header_tbl\')';
$_body_onload[]='initHRows(\'game_awards_tbl\')';
$_body_onload[]='initHRows(\'axis_overview_tbl\')';
$_body_onload[]='initHRows(\'allies_overview_tbl\')';
$_body_onload[]='initHRows(\'axis_players_overview_tbl\')';
$_body_onload[]='initHRows(\'allies_players_overview_tbl\')';


$team_tpl=array('kills'=>0,
                'teamkills'=>0,
                'suicides'=>0,
                'deaths_from_enemies'=>0,
                'world_deaths'=>0,
                'revives'=>0,
                'dynamite_planted'=>0,
                'dynamite_diffused'=>0,
                'repairs'=>0,
                'objectives_taken'=>0,
                'ammo_given'=>0,
                'health_given'=>0,
                'dynamites_planted'=>0,
                'dynamites_diffused'=>0,
                'repairs'=>0,
                'disguises'=>0,
                'objectives_taken'=>0,
                'revives'=>0,
                'ammo_given'=>0,
                'health_given'=>0,
                );

$ws_tpl=array('kills'=>0,
              'deaths'=>0,
              'teamkills'=>0,
              'teamdeaths'=>0,
              'suicides'=>0,
              );

// Get game stats
$list=$game->listGames('', '', 0, 1, $game_nr);

$first_killer=null;
$first_victim=null;
$most_kills=null;
$longest_kill_spree=null;
$most_kill_sprees=null;
$most_deaths=null;
$longest_death_spree=null;
$most_death_sprees=null;

$team_stats=array(1=>$team_tpl, 2=>$team_tpl);

if (!empty($list['ListedResults'])) {
  $game_data=reset($list['ListedResults']);
  // Get players
  $players=$gameclient->listPlayers(array(), '', 'rating', 'desc', 0, 0, '', $game_data['GameNr']);
  $players=$players['ListedResults'];
#print_r($players);
  foreach ($players as $key=>$player_data) {
    if ($player_data['FirstKillTotal']>0) {
      $first_killer=&$players[$key];
    }
    if ($player_data['FirstDeathTotal']>0) {
      $first_victim=&$players[$key];
    }
    if (   !empty($player_data['KilledEnemies'])
        && (   empty($most_kills)
            || $most_kills['KilledEnemies']<$player_data['KilledEnemies']
            || $most_kills['KilledEnemies']==$player_data['KilledEnemies'] && $most_kills['Deaths']<$player_data['Deaths']
            || $most_kills['KilledEnemies']==$player_data['KilledEnemies'] && $most_kills['Deaths']==$player_data['Deaths'] && $most_kills['Rating']<$player_data['Rating']
            )
        ) {
      $most_kills=&$players[$key];
    }
    if (   !empty($player_data['LongestKillSpree'])
        && (   empty($longest_kill_spree)
            || $longest_kill_spree['LongestKillSpree']<$player_data['LongestKillSpree']
            || $longest_kill_spree['LongestKillSpree']==$player_data['LongestKillSpree'] && $longest_kill_spree['KilledEnemies']<$player_data['KilledEnemies']
            || $longest_kill_spree['LongestKillSpree']==$player_data['LongestKillSpree'] && $longest_kill_spree['KilledEnemies']==$player_data['KilledEnemies'] && $longest_kill_spree['Rating']<$player_data['Rating']
            )
        ) {
      $longest_kill_spree=&$players[$key];
    }
    if (   !empty($player_data['KillSprees'])
        && (   empty($most_kill_sprees)
            || $most_kill_sprees['KillSprees']<$player_data['KillSprees']
            || $most_kill_sprees['KillSprees']==$player_data['KillSprees'] && $most_kill_sprees['KilledEnemies']<$player_data['KilledEnemies']
            || $most_kill_sprees['KillSprees']==$player_data['KillSprees'] && $most_kill_sprees['KilledEnemies']==$player_data['KilledEnemies'] && $most_kill_sprees['Rating']<$player_data['Rating']
            )
        ) {
      $most_kill_sprees=&$players[$key];
    }
    if (   !empty($player_data['Deaths'])
        && (   empty($most_deaths)
            || $most_deaths['Deaths']<$player_data['Deaths']
            || $most_deaths['Deaths']==$player_data['Deaths'] && $most_deaths['KilledEnemies']>$player_data['KilledEnemies']
            || $most_deaths['Deaths']==$player_data['Deaths'] && $most_deaths['KilledEnemies']==$player_data['KilledEnemies'] && $most_deaths['Rating']>$player_data['Rating']
            )
        ) {
      $most_deaths=&$players[$key];
    }
    if (   !empty($player_data['LongestDeathSpree'])
        && (   empty($longest_death_spree)
            || $longest_death_spree['LongestDeathSpree']<$player_data['LongestDeathSpree']
            || $longest_death_spree['LongestDeathSpree']==$player_data['LongestDeathSpree'] && $longest_death_spree['KilledEnemies']>$player_data['KilledEnemies']
            || $longest_death_spree['LongestDeathSpree']==$player_data['LongestDeathSpree'] && $longest_death_spree['KilledEnemies']==$player_data['KilledEnemies'] && $longest_death_spree['Rating']>$player_data['Rating']
            )
        ) {
      $longest_death_spree=&$players[$key];
    }
    if (   !empty($player_data['DeathSprees'])
        && (   empty($most_death_sprees)
            || $most_death_sprees['DeathSprees']<$player_data['DeathSprees']
            || $most_death_sprees['DeathSprees']==$player_data['DeathSprees'] && $most_death_sprees['KilledEnemies']>$player_data['KilledEnemies']
            || $most_death_sprees['DeathSprees']==$player_data['DeathSprees'] && $most_death_sprees['KilledEnemies']==$player_data['KilledEnemies'] && $most_death_sprees['Rating']>$player_data['Rating']
            )
        ) {
      $most_death_sprees=&$players[$key];
    }
  }
  // Create weapon stats
  $ws_guid=array();
  // ... suicides
  $weapon_suicides=$gameclientsuicide->getSuicidesWeaponTeam($game_data['GameNr']);
  foreach ($weapon_suicides as $data) {
    if (!isset($ws_guid[$data['GUID']])) {
      $ws_guid[$data['GUID']]=array(1=>array(), 2=>array());
    }
    if (!isset($ws_guid[$data['GUID']][$data['Team']][$data['MOD']])) {
      $ws_guid[$data['GUID']][$data['Team']][$data['MOD']]=$ws_tpl;
    }
    $ws_guid[$data['GUID']][$data['Team']][$data['MOD']]['suicides']+=$data['Count'];
  }

  // ... kills and teamkills
  $weapon_kills=$gameclientkill->getKillsGuidTeamMod($game_data['GameNr']);
  foreach ($weapon_kills as $data) {
    if (!isset($ws_guid[$data['GUID']])) {
      $ws_guid[$data['GUID']]=array(1=>array(), 2=>array());
    }
    if (!isset($ws_guid[$data['GUID']][$data['Team']][$data['MOD']])) {
      $ws_guid[$data['GUID']][$data['Team']][$data['MOD']]=$ws_tpl;
    }
    $ws_guid[$data['GUID']][$data['Team']][$data['MOD']]['kills']+=$data['Kills'];
    $ws_guid[$data['GUID']][$data['Team']][$data['MOD']]['teamkills']+=$data['Teamkills'];
  }
  // ... deaths and teamdeaths
  $weapon_deaths=$gameclientdeath->getDeathsGuidTeamMod($game_data['GameNr']);
  foreach ($weapon_deaths as $data) {
    if (!isset($ws_guid[$data['GUID']])) {
      $ws_guid[$data['GUID']]=array(1=>array(), 2=>array());
    }
    if (!isset($ws_guid[$data['GUID']][$data['Team']][$data['MOD']])) {
      $ws_guid[$data['GUID']][$data['Team']][$data['MOD']]=$ws_tpl;
    }
    $ws_guid[$data['GUID']][$data['Team']][$data['MOD']]['deaths']+=$data['Deaths'];
    $ws_guid[$data['GUID']][$data['Team']][$data['MOD']]['teamdeaths']+=$data['Teamdeaths'];
  }
  // Get team stats: kills and teamkills
  $kill_stats=$gameclientkill->getKillsByTeam($game_data['GameNr']);
  $kill_stats_guid=array();
#print_r($kill_stats);
  foreach ($kill_stats as $data) {
    if (!isset($kill_stats_guid[$data['GUID']])) {
      $kill_stats_guid[$data['GUID']]=array(1=>array('total_enemies'=>0,
                                                     'total_teammates'=>0,
                                                     ),
                                            2=>array('total_enemies'=>0,
                                                     'total_teammates'=>0,
                                                     ),
                                            );
    }
    $kill_stats_guid[$data['GUID']][$data['Team']]['total_enemies']+=$data['KilledEnemies'];
    $kill_stats_guid[$data['GUID']][$data['Team']]['total_teammates']+=$data['KilledTeammates'];
    $team_stats[$data['Team']]['kills']+=$data['KilledEnemies'];
    $team_stats[$data['Team']]['teamkills']+=$data['KilledTeammates'];
  }
  // Get team stats: deaths
  $death_stats=$gameclientdeath->getDeathsByTeam($game_data['GameNr']);
  $death_stats_guid=array();
  foreach ($death_stats as $data) {
    if (!isset($death_stats_guid[$data['GUID']])) {
      $death_stats_guid[$data['GUID']]=array(1=>array('total_by_enemies'=>0,
                                                      'total_by_teammates'=>0,
                                                      'total_by_world'=>0,
                                                      ),
                                             2=>array('total_by_enemies'=>0,
                                                      'total_by_teammates'=>0,
                                                      'total_by_world'=>0,
                                                      ),
                                             );
    }
    $death_stats_guid[$data['GUID']][$data['Team']]['total_by_enemies']+=$data['KilledByEnemies'];
    $death_stats_guid[$data['GUID']][$data['Team']]['total_by_teammates']+=$data['KilledByTeammates'];
    $death_stats_guid[$data['GUID']][$data['Team']]['total_by_world']+=$data['KilledByWorld'];

    $team_stats[$data['Team']]['world_deaths']+=$data['KilledByWorld'];
    $team_stats[$data['Team']]['deaths_from_enemies']+=$data['KilledByEnemies'];
  }
  // Get team stats: suicides
  $suicide_stats=$gameclientsuicide->getSuicidesByTeam($game_data['GameNr']);
  $suicide_stats_guid=array();
#print_r($suicide_stats);
  foreach ($suicide_stats as $data) {
    if (!isset($suicide_stats_guid[$data['guid']])) {
      $suicide_stats_guid[$data['guid']]=array(1=>0, 2=>0);
    }
    $suicide_stats_guid[$data['guid']][$data['team']]+=$data['count'];
    $team_stats[$data['team']]['suicides']+=$data['count'];
  }
  // Get misc team stats
  $misc_stats=$gameclientmisc->getMiscTeam($game_data['GameNr']);
  $misc_stats_guid=array();
#print_r($misc_stats);
  foreach ($misc_stats as $data) {
    if (!isset($misc_stats_guid[$data['GUID']])) {
      $misc_stats_guid[$data['GUID']]=array(1=>array('dynamites_planted'=>0,
                                                     'dynamites_diffused'=>0,
                                                     'repairs'=>0,
                                                     'disguises'=>0,
                                                     'objectives_taken'=>0,
                                                     ),
                                            2=>array('dynamites_planted'=>0,
                                                     'dynamites_diffused'=>0,
                                                     'repairs'=>0,
                                                     'disguises'=>0,
                                                     'objectives_taken'=>0,
                                                     ),
                                            );
    }
    $misc_stats_guid[$data['GUID']][$data['Team']]['dynamites_planted']+=$data['DynamitesPlanted'];
    $misc_stats_guid[$data['GUID']][$data['Team']]['dynamites_diffused']+=$data['DynamitesDiffused'];
    $misc_stats_guid[$data['GUID']][$data['Team']]['repairs']+=$data['Repairs'];
    $misc_stats_guid[$data['GUID']][$data['Team']]['disguises']+=$data['Disguises'];
    $misc_stats_guid[$data['GUID']][$data['Team']]['objectives_taken']+=$data['ObjectivesTaken'];

    $team_stats[$data['Team']]['dynamites_planted']+=$data['DynamitesPlanted'];
    $team_stats[$data['Team']]['dynamites_diffused']+=$data['DynamitesDiffused'];
    $team_stats[$data['Team']]['repairs']+=$data['Repairs'];
    $team_stats[$data['Team']]['disguises']+=$data['Disguises'];
    $team_stats[$data['Team']]['objectives_taken']+=$data['ObjectivesTaken'];
  }
  // Revived teammates
  $revive_stats=$gameclientrevive->getRevivesByTeam($game_data['GameNr']);
  $revive_stats_guid=array();
#print_r($revive_stats);
  foreach ($revive_stats as $data) {
    if (!isset($revive_stats_guid[$data['GUID']])) {
      $revive_stats_guid[$data['GUID']]=array(1=>0, 2=>0);
    }
    $revive_stats_guid[$data['GUID']][$data['Team']]+=$data['Count'];
    $team_stats[$data['Team']]['revives']+=$data['Count'];
  }
  // Ammo packs
  $ammo_stats=$gameclientammo->getAmmoByTeam($game_data['GameNr']);
  $ammo_stats_guid=array();
#print_r($ammo_stats);
  foreach ($ammo_stats as $data) {
    if (!isset($ammo_stats_guid[$data['GUID']])) {
      $ammo_stats_guid[$data['GUID']]=array(1=>0, 2=>0);
    }
    $ammo_stats_guid[$data['GUID']][$data['Team']]+=$data['Count'];
    $team_stats[$data['Team']]['ammo_given']+=$data['Count'];
  }
  // Health packs
  $health_stats=$gameclienthealth->getHealthByTeam($game_data['GameNr']);
  $health_stats_guid=array();
#print_r($health_stats);
  foreach ($health_stats as $data) {
    if (!isset($health_stats_guid[$data['GUID']])) {
      $health_stats_guid[$data['GUID']]=array(1=>0, 2=>0);
    }
    $health_stats_guid[$data['GUID']][$data['Team']]+=$data['Count'];
    $team_stats[$data['Team']]['health_given']+=$data['Count'];
  }

}


$tmp=explode('_', $game_data['MapName']);
foreach ($tmp as $key=>$data) {
  $tmp[$key]=ucfirst($data);
}
$game_data['MapNameStr']=implode(' ', $tmp);


$tpl=new PcpinTpl();
$tpl->setBasedir(PCPIN_DIR_OFFSET.'/template');
$tpl->readTemplatesFromFile('game_stats.tpl');
$tpl->addGlobalVars(array('formlink'=>PCPIN_FORMLINK,
                          ));


// Show map image
$img=PCPIN_DIR_OFFSET.'/image/maps/'.$game_data['MapName'].'.gif';
if (!file_exists($img)) {
  $img=PCPIN_DIR_OFFSET.'/image/maps/UNKNOWNMAP.gif';
}


$img_nr=0;
if ($list['TotalResults']>0) {
  $tpl->addVars('game_page', array('display'=>true,
                                   'map_name'=>htmlspecialchars($game_data['MapNameStr']),
                                   'map_img'=>$img,
                                   'game_duration'=>htmlspecialchars(makeTimeFromSeconds($game_data['Duration'])),
                                   'axis_players_count'=>htmlspecialchars($game_data['PlayersAxis']),
                                   'allies_players_count'=>htmlspecialchars($game_data['PlayersAllies']),
                                   'spectators_count'=>htmlspecialchars($game_data['Spectators']),

                                   'first_kill'=>!empty($first_killer)? coloredToHTML($first_killer['Name']) : '-',
                                   'first_death'=>!empty($first_victim)? coloredToHTML($first_victim['Name']) : '-',

                                   'most_kills'=>!empty($most_kills)? coloredToHTML($most_kills['Name']) : '-',
                                   'most_kills_count'=>!empty($most_kills)? htmlspecialchars('('.$most_kills['KilledEnemies'].')') : '',

                                   'most_kill_sprees'=>!empty($most_kill_sprees)? coloredToHTML($most_kill_sprees['Name']) : '-',
                                   'most_kill_sprees_count'=>!empty($most_kill_sprees)? htmlspecialchars('('.$most_kill_sprees['KillSprees'].')') : '',

                                   'longest_kill_spree'=>!empty($longest_kill_spree)? coloredToHTML($longest_kill_spree['Name']) : '-',
                                   'longest_kill_spree_length'=>!empty($longest_kill_spree)? htmlspecialchars('('.$longest_kill_spree['LongestKillSpree'].')') : '',

                                   'most_deaths'=>!empty($most_deaths)? coloredToHTML($most_deaths['Name']) : '-',
                                   'most_deaths_count'=>!empty($most_deaths)? htmlspecialchars('('.$most_deaths['Deaths'].')') : '',

                                   'longest_death_spree'=>!empty($longest_death_spree)? coloredToHTML($longest_death_spree['Name']) : '-',
                                   'longest_death_spree_length'=>!empty($longest_death_spree)? htmlspecialchars('('.$longest_death_spree['LongestDeathSpree'].')') : '',

                                   'most_death_sprees'=>!empty($most_death_sprees)? coloredToHTML($most_death_sprees['Name']) : '-',
                                   'most_death_sprees_count'=>!empty($most_death_sprees)? htmlspecialchars('('.$most_death_sprees['DeathSprees'].')') : '',

                                   // Team stats
                                   'axis_kills'=>htmlspecialchars($team_stats[1]['kills']),
                                   'axis_teamkills'=>htmlspecialchars($team_stats[1]['teamkills']),
                                   'axis_deaths_from_enemies'=>htmlspecialchars($team_stats[1]['deaths_from_enemies']),
                                   'axis_suicides'=>htmlspecialchars($team_stats[1]['suicides']),
                                   'axis_world_deaths'=>htmlspecialchars($team_stats[1]['world_deaths']),
                                   'axis_dynamites_planted'=>htmlspecialchars($team_stats[1]['dynamites_planted']),
                                   'axis_dynamites_diffused'=>htmlspecialchars($team_stats[1]['dynamites_diffused']),
                                   'axis_repaired_objects'=>htmlspecialchars($team_stats[1]['repairs']),
                                   'axis_covert_disguises'=>htmlspecialchars($team_stats[1]['disguises']),
                                   'axis_objectives_taken'=>htmlspecialchars($team_stats[1]['objectives_taken']),
                                   'axis_revived_teammates'=>htmlspecialchars($team_stats[1]['revives']),
                                   'axis_ammo_given'=>htmlspecialchars($team_stats[1]['ammo_given']),
                                   'axis_health_given'=>htmlspecialchars($team_stats[1]['health_given']),

                                   'allies_kills'=>htmlspecialchars($team_stats[2]['kills']),
                                   'allies_teamkills'=>htmlspecialchars($team_stats[2]['teamkills']),
                                   'allies_deaths_from_enemies'=>htmlspecialchars($team_stats[2]['deaths_from_enemies']),
                                   'allies_suicides'=>htmlspecialchars($team_stats[2]['suicides']),
                                   'allies_world_deaths'=>htmlspecialchars($team_stats[2]['world_deaths']),
                                   'allies_dynamites_planted'=>htmlspecialchars($team_stats[2]['dynamites_planted']),
                                   'allies_dynamites_diffused'=>htmlspecialchars($team_stats[2]['dynamites_diffused']),
                                   'allies_repaired_objects'=>htmlspecialchars($team_stats[2]['repairs']),
                                   'allies_covert_disguises'=>htmlspecialchars($team_stats[2]['disguises']),
                                   'allies_objectives_taken'=>htmlspecialchars($team_stats[2]['objectives_taken']),
                                   'allies_revived_teammates'=>htmlspecialchars($team_stats[2]['revives']),
                                   'allies_ammo_given'=>htmlspecialchars($team_stats[2]['ammo_given']),
                                   'allies_health_given'=>htmlspecialchars($team_stats[2]['health_given']),
                                   ));

  // Show axis/allies players overview
  $rows=array('axis'=>1, 'allies'=>1);
  foreach ($players as $data) {
    $team_prefixes=array();
    if ($data['TimeAxis']>0) {
      $team_prefixes[1]='axis';
    }
    if ($data['TimeAllies']>0) {
      $team_prefixes[2]='allies';
    }
    foreach ($team_prefixes as $team=>$prefix) {
      $tpl->addVars($prefix.'_players_overview', array('row'=>htmlspecialchars($rows[$prefix]),
                                                       'name'=>coloredToHTML($data['Name']),
                                                       'guid_key'=>htmlspecialchars($data['GUID_Key']),
                                                       'time'=>htmlspecialchars(makeTimeFromSeconds($data['Time'.ucfirst($prefix)])),
                                                       'kills'=>htmlspecialchars(!empty($kill_stats_guid[$data['GUID']])? $kill_stats_guid[$data['GUID']][$team]['total_enemies'] : 0),
                                                       'teamkills'=>htmlspecialchars(!empty($kill_stats_guid[$data['GUID']])? $kill_stats_guid[$data['GUID']][$team]['total_teammates'] : 0),
                                                       'deaths'=>htmlspecialchars(!empty($death_stats_guid[$data['GUID']])? $death_stats_guid[$data['GUID']][$team]['total_by_enemies']+$death_stats_guid[$data['GUID']][$team]['total_by_world'] : 0),
                                                       'teamdeaths'=>htmlspecialchars(!empty($death_stats_guid[$data['GUID']])? $death_stats_guid[$data['GUID']][$team]['total_by_teammates'] : 0),
                                                       ));
      $tpl->parseTemplate($prefix.'_players_overview', 'a');
      $rows[$prefix]^=3;
      // Display player table
      $_body_onload[]='initHRows(\''.$prefix.'_player_'.$data['GUID_Key'].'\')';
      $tpl->addVars($prefix.'_player_tables', array('display'=>true,
                                                    'guid_key'=>htmlspecialchars($data['GUID_Key']),
                                                    'name'=>coloredToHTML($data['Name']),
                                                    'time'=>htmlspecialchars(makeTimeFromSeconds($data['Time'.ucfirst($prefix)])),
                                                    'kills'=>htmlspecialchars(isset($kill_stats_guid[$data['GUID']])? $kill_stats_guid[$data['GUID']][$team]['total_enemies'] : 0),
                                                    'deaths'=>htmlspecialchars(isset($death_stats_guid[$data['GUID']])? $death_stats_guid[$data['GUID']][$team]['total_by_enemies'] : 0),
                                                    'world_deaths'=>htmlspecialchars(isset($death_stats_guid[$data['GUID']])? $death_stats_guid[$data['GUID']][$team]['total_by_world'] : 0),
                                                    'teamkills'=>htmlspecialchars(isset($kill_stats_guid[$data['GUID']])? $kill_stats_guid[$data['GUID']][$team]['total_teammates'] : 0),
                                                    'teamdeaths'=>htmlspecialchars(isset($death_stats_guid[$data['GUID']])? $death_stats_guid[$data['GUID']][$team]['total_by_teammates'] : 0),
                                                    'suicides'=>htmlspecialchars(isset($suicide_stats_guid[$data['GUID']])? $suicide_stats_guid[$data['GUID']][$team] : 0),
                                                    'dynamites_planted'=>htmlspecialchars(isset($misc_stats_guid[$data['GUID']])? $misc_stats_guid[$data['GUID']][$team]['dynamites_planted'] : 0),
                                                    'dynamites_diffused'=>htmlspecialchars(isset($misc_stats_guid[$data['GUID']])? $misc_stats_guid[$data['GUID']][$team]['dynamites_diffused'] : 0),
                                                    'repairs'=>htmlspecialchars(isset($misc_stats_guid[$data['GUID']])? $misc_stats_guid[$data['GUID']][$team]['repairs'] : 0),
                                                    'disguises'=>htmlspecialchars(isset($misc_stats_guid[$data['GUID']])? $misc_stats_guid[$data['GUID']][$team]['disguises'] : 0),
                                                    'objectives_taken'=>htmlspecialchars(isset($misc_stats_guid[$data['GUID']])? $misc_stats_guid[$data['GUID']][$team]['objectives_taken'] : 0),
                                                    'revives'=>htmlspecialchars(isset($revive_stats_guid[$data['GUID']])? $revive_stats_guid[$data['GUID']][$team] : 0),
                                                    'health_given'=>htmlspecialchars(isset($health_stats_guid[$data['GUID']])? $health_stats_guid[$data['GUID']][$team] : 0),
                                                    'ammo_given'=>htmlspecialchars(isset($ammo_stats_guid[$data['GUID']])? $ammo_stats_guid[$data['GUID']][$team] : 0),
                                                    ));

      // Show weapon stats
      if (!empty($ws_guid[$data['GUID']][$team])) {
        $tpl->addVar($prefix.'_player_table_weapon_stats', 'display', true);
        $tpl->addVar($prefix.'_player_table_weapon_stats', 'guid_key', htmlspecialchars($data['GUID_Key']));
        $_body_onload[]='initHRows(\''.$prefix.'_player_ws_'.$data['GUID_Key'].'\')';
        $ws_row=1;
        foreach ($ws_guid[$data['GUID']][$team] as $mod=>$mod_stats) {
          $img=PCPIN_DIR_OFFSET.'/image/mods/'.$mod.'.gif';
          if (!file_exists($img)) {
            $img=PCPIN_DIR_OFFSET.'/image/mods/UNKNOWN.gif';
          }
          $tpl->addVars($prefix.'_player_table_weapon_stats_weapon', array('display'=>true,
                                                                           'row'=>htmlspecialchars($ws_row),
                                                                           'img_nr'=>htmlspecialchars($img_nr++),
                                                                           'weapon'=>htmlspecialchars(MODToWeaponName($mod)),
                                                                           'kills'=>htmlspecialchars($mod_stats['kills']),
                                                                           'deaths'=>htmlspecialchars($mod_stats['deaths']),
                                                                           'teamkills'=>htmlspecialchars($mod_stats['teamkills']),
                                                                           'teamdeaths'=>htmlspecialchars($mod_stats['teamdeaths']),
                                                                           'suicides'=>htmlspecialchars($mod_stats['suicides']),
                                                                           'mod_img'=>$img,
                                                                           ));
          $tpl->parseTemplate($prefix.'_player_table_weapon_stats_weapon', 'a');
          $ws_row^=3;
        }
      }

      $tpl->parseTemplate($prefix.'_player_tables', 'a');
      $tpl->clearTemplate($prefix.'_player_table_weapon_stats');
      $tpl->clearTemplate($prefix.'_player_table_weapon_stats_weapon');
    }
  }
  // Display empty rows
  $diff=$game_data['PlayersAxis']>$game_data['PlayersAllies']? $game_data['PlayersAxis']-$game_data['PlayersAllies'] : $game_data['PlayersAllies']-$game_data['PlayersAxis'];
  $tpl_name=$game_data['PlayersAxis']>$game_data['PlayersAllies']? 'allies_players_overview' : 'axis_players_overview';
  $row_var=$game_data['PlayersAxis']>$game_data['PlayersAllies']? $rows['allies'] : $rows['axis'];
  for ($i=0; $i<$diff; $i++) {
      $tpl->addVars($tpl_name, array('row'=>htmlspecialchars($row_var),
                                     'name'=>'&nbsp;',
                                     'time'=>'&nbsp;',
                                     'kills'=>'&nbsp;',
                                     'teamkills'=>'&nbsp;',
                                     'deaths'=>'&nbsp;',
                                     'teamdeaths'=>'&nbsp;',
                                     ));
    $tpl->parseTemplate($tpl_name, 'a');
    $row_var^=3;
  }
}

?>