<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


$game=new PCPIN_Game($session);
$gameclientkill=new PCPIN_GameClientKill($session);
$gameclientdeath=new PCPIN_GameClientDeath($session);
$gameclient=new PCPIN_GameClient($session);

if (!isset($games)) {
  $games=0;
} else {
  $games*=1;
}

$min_game_id=0;

if (!empty($games)) {
  // Get last N games
  $game->_db_getList('id', 'id DESC', 1);
  if (empty($game->_db_list)) {
    $games=0;
  } else {
    $min_game_id=$game->_db_list[0]['id']-$games;
    $game->_db_freeList();
  }
}


// Get awards
$awards=array();

// ... Best soldier
$award=$gameclientkill->getBestModKiller('MOD_PANZERFAUST,MOD_BAZOOKA,MOD_VENOM,MOD_MG42,MOD_MOBILE_MG42,MOD_BROWNING,MOD_MOBILE_BROWNING,MOD_FLAMETHROWER,MOD_MAPMORTAR,MOD_MAPMORTAR_SPLASH,MOD_MORTAR', $min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Best Soldier',
                  'award_description'=>'Achieved the best class score',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>$award['Count'],
                  'image'=>'./image/awards/best_soldier.gif'
                  );
}
// ... Best medic ( Reviving the most teammates and gave most health packs to teammates )
$award=$gameclient->getBestMedic($min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Best Medic',
                  'award_description'=>'Achieved the best class score',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>round($award['ClassScore']),
                  'image'=>'./image/awards/best_medic.gif'
                  );
}
// ... Best engineer ( Planting/diffusing most dynamites, repairing most objects, Scored most construction kills )
$award=$gameclient->getBestEngineer($min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Best Engineer',
                  'award_description'=>'Achieved the best class score',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>round($award['ClassScore']),
                  'image'=>'./image/awards/best_engineer.gif'
                  );
}
// ... Best field ops ( Scored most kills with arty, air strikes and giving most ammo packs to teammates )
$award=$gameclient->getBestFieldOp($min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Best Field Op',
                  'award_description'=>'Achieved the best class score',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>round($award['ClassScore']),
                  'image'=>'./image/awards/best_fieldop.gif'
                  );
}
// ... Best covert ops ( Scored most kills with covertop-only weapons, Scored most disguises )
$award=$gameclient->getBestCovertOp($min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Best Covert Op',
                  'award_description'=>'Achieved the best class score',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>round($award['ClassScore']),
                  'image'=>'./image/awards/best_covertop.gif'
                  );
}
// ... Zombie Master
$award=$gameclientkill->getBestModKiller('MOD_POISON', $min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Zombie Master',
                  'award_description'=>'Scored the most poison kills',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>$award['Count'],
                  'image'=>''
                  );
}
// ... Super Mario
$award=$gameclientkill->getBestModKiller('MOD_GOOMBA', $min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Super Mario',
                  'award_description'=>'Scored the most goomba kills',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>$award['Count'],
                  'image'=>''
                  );
}
// ... Jack The Ripper
$award=$gameclientkill->getBestModKiller('MOD_KNIFE,MOD_THROWKNIFE,MOD_BACKSTAB', $min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Jack The Ripper',
                  'award_description'=>'Scored the most knife kills',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>$award['Count'],
                  'image'=>''
                  );
}
// ... Slaughterhouse
$award=$gameclient->getLongestKillSpree($min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Slaughterhouse',
                  'award_description'=>'Achieved the longest kill spree',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>$award['Count'],
                  'image'=>''
                  );
}
// ... Carnage Master
$award=$gameclient->getMostKillSprees($min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Carnage Master',
                  'award_description'=>'Scored the most kill sprees',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>$award['Count'],
                  'image'=>''
                  );
}
// ... Bounty Hunter
$award=$gameclient->getBestBountyHunter($min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Bounty Hunter',
                  'award_description'=>'Scored the most bounty points',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>$award['Count'],
                  'image'=>''
                  );
}
// ... Dominator
$award=$gameclient->getBestKD($min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Dominator',
                  'award_description'=>'Achieved the best Kills/Deaths ratio',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>round($award['K/D'], 2),
                  'image'=>''
                  );
}
// ... Terminator
$award=$gameclient->getBestKG($min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Terminator',
                  'award_description'=>'Achieved the best Kills/Game ratio',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>round($award['K/G'], 2),
                  'image'=>''
                  );
}
// ... Fear Monster
$award=$gameclientkill->getBestModKiller('MOD_FEAR', $min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Fear Monster',
                  'award_description'=>'Scared most enemies to death',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>$award['Count'],
                  'image'=>''
                  );
}
// ... Darwin
$award=$gameclientdeath->getMostWorldDeaths($min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Darwin',
                  'award_description'=>'Got killed due to own stupidity/carelessness',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>$award['Count'],
                  'image'=>''
                  );
}
// ... Isaac Newton
$award=$gameclientdeath->getBestModVictim('MOD_FALLING', $min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Isaac Newton',
                  'award_description'=>'Most falling deaths',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>$award['Count'],
                  'image'=>''
                  );
}
// ... Don't Hurt Me Please
$award=$gameclient->getLongestDeathSpree($min_game_id);
if (!empty($award)) {
  $awards[]=array('award_name'=>'Don\'t Hurt Me Please',
                  'award_description'=>'Achieved the longest death spree',
                  'winner_guid_key'=>$award['GUID_Key'],
                  'winner_name_txt'=>$award['NameTxt'],
                  'winner_name'=>$award['Name'],
                  'points'=>$award['Count'],
                  'image'=>''
                  );
}




$tpl=new PcpinTpl();
$tpl->setBasedir(PCPIN_DIR_OFFSET.'/template');
$tpl->readTemplatesFromFile('awards.tpl');
$tpl->addGlobalVars(array('formlink'=>PCPIN_FORMLINK,
                          ));

// Display awards
$col=0;
foreach ($awards as $award) {
  $tpl->addVars('award_col', array('display'=>true,
                                   'award_name'=>htmlspecialchars($award['award_name']),
                                   'award_description'=>htmlspecialchars($award['award_description']),
                                   'winner_guid_key'=>htmlspecialchars($award['winner_guid_key']),
                                   'winner_name_txt'=>htmlspecialchars($award['winner_name_txt']),
                                   'winner_name'=>coloredToHTML($award['winner_name']),
                                   'points'=>coloredToHTML($award['points']),
                                   'image'=>file_exists($award['image'])? $award['image'] : './image/clearpixel.gif',
                                   ));
  $tpl->parseTemplate('award_col', 'a');
  $col++;
  if ($col==3) {
    $tpl->addVar('award_row', 'display', true);
    $tpl->parseTemplate('award_row', 'a');
    $tpl->clearTemplate('award_col');
    $col=0;
  }
}
if ($col>0) {
  while ($col<3) {
    $tpl->addVar('award_col', 'display', false);
    $tpl->parseTemplate('award_col', 'a');
    $col++;
  }
  $tpl->addVar('award_row', 'display', true);
  $tpl->parseTemplate('award_row', 'a');
}



// Show active games count limit
if (!empty($games)) {
  $tpl->addVar('games_link_last_'.$games, 'active', true);
} else {
  $tpl->addVar('games_link_all', 'active', true);
}

?>