<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * Class PCPIN_GameClientWS
 * Manage weapon stats
 * @author Konstantin Reznichak <k.reznichak@pcpin.com>
 * @copyright Copyright &copy; 2007, Konstantin Reznichak
 */
class PCPIN_GameClientWS extends PCPIN_Session {

  /**
   * GUID
   * @var string
   */
  var $guid='';

  /**
   * Weapon Nr.
   * @var int
   */
  var $weapon=0;

  /**
   * Hits
   * @var int
   */
  var $hits=0;

  /**
   * Shots
   * @var int
   */
  var $shots=0;

  /**
   * Kills
   * @var int
   */
  var $kills=0;

  /**
   * Deaths
   * @var int
   */
  var $deaths=0;

  /**
   * Headshots
   * @var int
   */
  var $headshots=0;



  /**
   * Constructor
   * @param   object  &$sessionhandler  Session handler
   */
  function PCPIN_GameClientWS(&$sessionhandler) {
    // Init object
    $this->_s_init($sessionhandler, $this);
  }


  /**
   * Store new record
   * @param   string    $guid             GUID
   * @param   int       $weapon           Weapon Nr.
   * @param   int       $hits             Hits
   * @param   int       $shots            Shots
   * @param   int       $kills            Kills
   * @param   int       $deaths           Deaths
   * @param   int       $headshots        Headshots
   */
  function addRecord($guid, $weapon, $hits, $shots, $kills, $deaths, $headshots) {
    $this->guid=$guid;
    $this->weapon=$weapon;
    $this->hits=0;
    $this->shots=0;
    $this->kills=0;
    $this->deaths=0;
    $this->headshots=0;
    if ($this->_db_getList('guid = '.$guid, 'weapon = '.$weapon, 1)) {
      $this->_db_setObject($this->_db_list[0]);
      $this->_db_freeList();
      $this->_db_deleteRowMultiCond(array('guid'=>$guid, 'weapon'=>$weapon));
    }
    $this->hits+=$hits;
    $this->shots+=$shots;
    $this->kills+=$kills;
    $this->deaths+=$deaths;
    $this->headshots+=$headshots;
    $this->_db_insertObj();
  }


  /**
   * Get weapon stats for a client
   * @param   string    $guid       GUID
   * @return array
   */
  function getWeaponStats($guid) {
    $ws=array();
    $query=$this->_db_makeQuery(1050, $guid);
    $result=$this->_db_query($query);
    while ($data=$this->_db_fetch($result)) {
      $ws[]=$data;
    }
    $this->_db_freeResult($result);
    return $ws;
  }


}
?>