<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * Class PCPIN_GameClientTeamClass
 * Manage team/class timers
 * @author Konstantin Reznichak <k.reznichak@pcpin.com>
 * @copyright Copyright &copy; 2007, Konstantin Reznichak
 */
class PCPIN_GameClientTeamClass extends PCPIN_Session {

  /**
   * Game ID
   * @var int
   */
  var $game_id=0;

  /**
   * GUID
   * @var string
   */
  var $guid='';

  /**
   * Team
   * @var int
   */
  var $team=0;

  /**
   * Class
   * @var int
   */
  var $class=0;

  /**
   * Time played
   * @var int
   */
  var $time=0;



  /**
   * Constructor
   * @param   object  &$sessionhandler  Session handler
   */
  function PCPIN_GameClientTeamClass(&$sessionhandler) {
    // Init object
    $this->_s_init($sessionhandler, $this);
  }


  /**
   * Store new record
   * @param   int       $game_id    Game ID
   * @param   string    $guid       GUID
   * @param   int       $team       Team
   * @param   int       $class      Class
   * @param   int       $time      Time
   */
  function addRecord($game_id, $guid, $team, $class, $time) {
    $this->game_id=$game_id;
    $this->guid=$guid;
    $this->team=$team;
    $this->class=$class;
    $this->time=$time;
    $this->_db_insertObj();
  }


  /**
   * Get played classes
   * @param   string    $guid       GUID
   * @return array
   */
  function getPlayedClasses($guid) {
    $classes=array();
    $query=$this->_db_makeQuery(1040, $guid);
    $result=$this->_db_query($query);
    while ($data=$this->_db_fetch($result)) {
      $classes[]=$data;
    }
    $this->_db_freeResult($result);
    return $classes;
  }


}
?>