<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * Class PCPIN_Game
 * Manage game data
 * @author Konstantin Reznichak <k.reznichak@pcpin.com>
 * @copyright Copyright &copy; 2007, Konstantin Reznichak
 */
class PCPIN_Game extends PCPIN_Session {

  /**
   * Game ID
   * @var   int
   */
  var $id=0;

  /**
   * Map name
   * @var   string
   */
  var $mapname='';

  /**
   * Game duration in seconds
   * @var   int
   */
  var $duration=0;

  /**
   * Total clients count
   * @var   int
   */
  var $clients=0;

  /**
   * Active players count
   * @var   int
   */
  var $players=0;




  /**
   * Constructor
   * @param   object  &$sessionhandler  Session handler
   */
  function PCPIN_Game(&$sessionhandler) {
    // Init object
    $this->_s_init($sessionhandler, $this);
  }


  /**
   * Add new game
   * @param   string    $mapname      Map name
   * @param   int       $duration     Duration in seconds
   * @param   int       $clients      Total clients count
   * @param   int       $players      Active players count
   */
  function addGame($mapname, $duration, $clients, $players) {
    if ($duration<0) {
      $duration+=86400;
    }
    $this->id=0;
    $this->mapname=$mapname;
    $this->duration=$duration;
    $this->clients=$clients;
    $this->players=$players;
    if ($this->_db_insertObj()) {
      $this->id=$this->_db_lastInsertID();
    }
  }


  /**
   * Get game list with stats
   * @param   string    $sort_by          Optional: Sort by ...
   * @param   string    $sort_dir         Optional: Sort dir ("asc" or "desc")
   * @param   int       $limitstart       Optional: Start from N'th result
   * @param   int       $limit            Optional: Max results to return
   * @param   int       $game_nr          Optional: If not empty: only game with this Nr (ID) will be returned
   * @param   string    $guid             Optional: If not empty: only games played by GUID will be returned
   * @return array
   */
  function listGames($sort_by='', $sort_dir='', $limitstart=0, $limit=0, $game_nr=0, $guid='') {
    $games=array();
    $query=$this->_db_makeQuery(1130, $sort_by, $sort_dir, $limitstart, $limit, $game_nr, $guid);
    $result=$this->_db_query($query);
    while ($data=$this->_db_fetch($result)) {
      $games[]=$data;
    }
    $this->_db_freeResult($result);
    // Get total results count
    $query=$this->_db_makeQuery(1135, $game_nr, $guid);
    $result=$this->_db_query($query);
    $data=$this->_db_fetch($result);
    $this->_db_freeResult($result);
    $total_results=$data['TotalResults'];
    return array('TotalResults'=>$total_results,
                 'ListedResults'=>$games);
  }


}
?>