<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class PCPIN_ExcludeGUID
 * Manage player GUIDs which have to be excluded from "Players" and "Awards" lists
 * @author Konstantin Reznichak <k.reznichak@pcpin.com>
 * @copyright Copyright &copy; 2007, Konstantin Reznichak
 */
class PCPIN_ExcludeGUIDs extends PCPIN_Session {

  /**
   * GUID
   * @var string
   */
  var $guid='';



  /**
   * Constructor
   * @param   object  &$sessionhandler  Session handler
   */
  function PCPIN_ExcludeGUIDs(&$sessionhandler) {
    // Init object
    $this->_s_init($sessionhandler, $this);
  }


  /**
   * Store new GUID
   * @param   string    $guid       GUID
   */
  function addRecord($guid) {
    $this->guid=$guid;
    $this->_db_insertObj();
  }


  /**
   * Get all GUIDs from database
   * @return array
   */
  function getGUIDs() {
    $guids=array();
    if ($this->_db_getList('guid')) {
      foreach ($this->_db_list as $data) {
        $guids[]=$data['guid'];
      }
      $this->_db_freeList();
    }
    return $guids;
  }


  /**
   * Delete all GUIDs from database
   */
  function deleteAllGUIDs() {
    $this->_db_query($this->_db_makeQuery(1310));
  }


}
?>