<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * Class PCPIN_Cache
 * Manage cache
 * @author Konstantin Reznichak <k.reznichak@pcpin.com>
 * @copyright Copyright &copy; 2007, Konstantin Reznichak
 */
class PCPIN_Cache extends PCPIN_Session {

  /**
   * Request URI
   * @var   string
   */
  var $uri='';

  /**
   * Cached HTML
   * @var   string
   */
  var $html='';



  /**
   * Constructor
   * @param   object  &$sessionhandler  Session handler
   */
  function PCPIN_Cache(&$sessionhandler) {
    // Init object
    $this->_s_init($sessionhandler, $this);
  }


  /**
   * Add record to cache
   * @param   string    $uri    Request URI
   * @param   string    $html   HTML
   */
  function addRecord($uri, $html) {
    if ($uri!='') {
      $this->_db_deleteRow($uri, 'uri');
      $this->uri=$uri;
      $this->html=$html;
      $this->_db_insertObj();
    }
  }


  /**
   * Look for record and return it as string or return FALSE if no record fount
   * @param   string    $uri    Request URI
   * @return  mixed
   */
  function getRecord($uri) {
    $html=false;
    if ($uri!='' && $this->_db_getList('html', 'uri =# '.$uri, 1)) {
      $html=$this->_db_list[0]['html'];
      $this->_db_freeList();
    }
    return $html;
  }


  /**
   * Delete all cache records
   */
  function clearCache() {
    $this->_db_emptyTable();
  }


}
?>