#!/usr/bin/perl -w
use strict;
use threads;
use File::Copy;
use Time::Piece;
use Tk;
use Tk::Checkbox;
use Tk::FileDialog;
use Tk::Label;
use Archive::Zip qw( :ERROR_CODES :CONSTANTS );

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~#
#   MapDevelopment Tool  v0.5   #                 
#           by Dinius           #
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~#

# TODO
# - Make it look good :P
# - Make AutoPK3 work for getting images for skyboxes, aka textures/skybox_*
#   Not too hard, but requires a lot of rewriting of the code.
#   (Would need to catch each shader\texture from .shader files in a block, and check for surfaceparm sky etc)
# - Create an icon for the actual window(s),, But its soo retarded and limited :<
# - Fix the scrollbar @ maplist so it works with mouse scrolling?? (no idea why it doesnt..)
# - LIVE feedback into the console, instead of just passing the feedback into it after the command is finished
#   (Good for monitoring \ seeing how far along the compile is, etc)
# - Popup window on error in the compilation, not leaks, but most other stuff, etcetc.. (give notice@lower bar @ leak)
#   (need live feedback first, then just if (=~ /error/i) {show_error_window_with_zeh_error_!}) 
# - IMPROVE the TEMPLATE system, should be rather easy..
#   (Don't write any additional files by default, but check
#   if the user has created levelshots folder, levelshots shader,
#   and possibly any other files, and then copy those as well)
#   NOTE: Using levelshots for testmaps is usually retarded, could be cool,
#         but it would only really increase the size of what is NOT supposed to be
#         a map made for releasees.
#         Better to just write w\e @ the loading text instead! =)
# - Improve the loading text?
#   VERY HARD, since I don't really see it anymore since @ new PC....... :DDD
# - Dynamic templates, with variables like "date and time used for compilation, .bsp size, number of custom textures" etc,
#   Could be a possible feature..
# - Improve useability \ userfriendlyness (or rather, MAKE it userfriendly at all)


# KNOWN BUGS
# - Some random crashes,, dunno why
# - "Open basedir" button, if you already have an opened basedir window, and press this again, it sometimes starts failing (until PC restart?)

# FIXED BUGS
# - AutoPK3 is supposed to open the .pk3's location in a window when the pk3 is ready, this is somewhat buggy. Again, no idea why.
# - Getting textures can in some cases be a bit buggy, dont know exactly why, but got some ideas. Though it usually works :P


# Windows only - Hides the console.
if ($^O eq 'MSWin32')
{
    use Win32::GUI();
    use Win32::Process;
    
    BEGIN {
        Win32::SetChildShowWindow(0)
        if defined &Win32::SetChildShowWindow
    };
}

# Error reporting for Win32::Process
sub errorreport
{
    print Win32::FormatMessage( Win32::GetLastError() );
}


# Declarations
my @maps;
my @copies;
my @nocopies;
my @concmd;
my $check1          = 0;
my $curmap          = 0;
my $curmap_clean    = 0;
my $ext             = 0;
my $thread          = 0;
my $thread2         = 0;
my $txt             = "MapDev Tool - by Dinius";

my $settingsfile    = "config.pl";

########################
#  LOAD SETTINGS FILE  #
require "$settingsfile";
########################

# Declarations..
# Configuration
our $initcmd;

our $game;
our $ip;
our $gamedir;
our $config;

our $playerconfig;
our $serverconfig;

our $exe;
our $parm;

our $radex14;
our $radex15;

# Directories
my $basedir     = $gamedir  .   "etmain/";
my $textures    = $basedir  .   "textures/";
my $mapdir      = $basedir  .   "maps/";
my $scripts     = $basedir  .   "scripts/";
my $moddir      = $gamedir  .   "etpro/";
my $backupdir   = $mapdir   .   "backups/";

# Builds (q3map2)
our $q3map2;
our $initial;

our $meta;
our $vis;
our $light;
our $final_1;
our $final_2;
our $final_3;

our $decompile;


# GUI
my $mw = MainWindow->new(-title=>"Mapdev Tool     -     Game: $game   -   www.Trickjump.me   -   by Dinius");
$mw ->resizable( 0, 0 );
#$mw -> geometry ("800x600");


my $top = $mw->Frame()->pack(-anchor=>"n", -side=>"top", -fill=>"x");
my $topx = $mw->Frame()->pack(-anchor=>"n", -side=>"top", -fill=>"x", -after=>$top);
my $left = $mw->Frame()->pack(-anchor=>"nw", -side=>"left");
my $right = $mw->Frame()->pack(-anchor=>"ne", -side=>"right", -fill=>"x", -expand=>1);


# Top
my $button_t14 = $top
    ->Button(-text=>"Radiant 1.4", -padx=>5, -pady=>1, -justify=>"left", -relief=>"flat", -command=>\&radiant14)
    ->pack(-side=>"left", -fill=>"x", -expand=>1)
    ;
my $button_t15 = $top
    ->Button(-text=>"Radiant 1.5", -padx=>5, -pady=>1, -justify=>"left", -relief=>"flat", -command=>\&radiant15)
    ->pack(-side=>"left", -fill=>"x", -expand=>1)
    ;
my $button_t2 = $top
    ->Button(-text=>"Open Basedir", -padx=>5, -pady=>1, -justify=>"left", -relief=>"flat", -command=>\&odir)
    ->pack(-side=>"left", -fill=>"x", -expand=>1)
    ;
my $button_t3 = $top
    ->Button(-text=>"Backup", -padx=>5, -pady=>1, -justify=>"left", -relief=>"flat", -command=>\&backup)
    ->pack(-side=>"left", -fill=>"x", -expand=>1)
    ;
my $button_t4 = $top
    ->Button(-text=>"Decompile", -padx=>5, -pady=>1, -justify=>"left", -relief=>"flat", -command=>\&decompile)
    ->pack(-side=>"left", -fill=>"x", -expand=>1)
    ;


# Left side - The list..
my $maplist = $left
    ->Scrolled("Listbox", -scrollbars => 'e', -width=>45, -height=>20, -relief=>"groove")
    ->pack();


# Right side
my $build1 = $right
    ->Button(-text=>"Meta", -padx=>50, -pady=>15, -relief=>"groove", -command=>\&metabuild)
    ->pack(-fill=>"x", -expand=>1)
    ;
my $build2 = $right
    ->Button(-text=>"Vis", -padx=>50, -pady=>10, -relief=>"groove", -command=>\&visbuild)
    ->pack(-fill=>"x")
    ;
my $build3 = $right
    ->Button(-text=>"Light", -padx=>50, -pady=>10, -relief=>"groove", -command=>\&lightbuild)
    ->pack(-fill=>"x")
    ;
my $build4 = $right
    ->Button(-text=>"Final", -padx=>50, -pady=>10, -relief=>"groove", -command=>\&finalbuild)
    ->pack(-fill=>"x")
    ;
my $build5 = $right
    ->Button(-text=>"Meta -> Go play!", -padx=>50, -pady=>15, -relief=>"groove", -command=>\&metaplay)
    ->pack(-fill=>"x")
    ;

my $goplay = $right
    ->Button(-text=>"Go Play!", -padx=>50, -pady=>20, -relief=>"groove", -command=>\&goplay)
    ->pack(-fill=>"x")
    ;


# Lower button row
my $button_refreshfiles = $left
    ->Button(-text=>"Load .MAPs", -padx=>5, -pady=>1, -justify=>"left", -relief=>"flat", -command=>\&getmaps)
    ->pack(-side=>"left", -fill=>"x", -expand=>1)
    ;
my $button_b1 = $left
    ->Button(-text=>"Load .BSPs", -padx=>5, -pady=>1, -relief=>"flat", -justify=>"left", -command=>\&getbsps)
    ->pack(-side=>"left", -fill=>"x", -expand=>1)
    ;
my $button_showallmaps = $right
    ->Button(-text=>"Show copies", -padx=>5, -pady=>1, -justify=>"left", -relief=>"flat", -command=>\&showallmaps)
    ->pack(-side=>"left", -fill=>"x", -expand=>1)
    ;
my $button_b2 = $right
    ->Button(-text=>"Auto-PK3", -padx=>5, -pady=>1, -relief=>"flat", -justify=>"left", -command=>\&autopk3)
    ->pack(-side=>"left", -fill=>"x", -expand=>1)
    ;
    
    
# Bottom
my $bottom = $mw->Frame()->pack(-anchor=>"se", -side=>"bottom", -pady=>0, -after=>$top, -fill=>"x", -expand=>1);
my $label = $bottom
    ->Label(-text=>$txt, -relief=>"flat", -height=>2, -background=>"#e6e6e6", -foreground=>"#666666")
    ->pack(-anchor=>"se", -side=>"bottom", -fill=>"x", -expand=>1)
    ;

my $consolecontainer = $mw->Frame()->pack(-anchor=>"se", -side=>"bottom", -pady=>0, -after=>$bottom, -fill=>"x", -expand=>1);
my $console = $consolecontainer
    ->Scrolled( "Text", -scrollbars=>"e", -height=>15, -background=>"#ebe8df", -foreground=>"#333333", -relief=>"ridge")
    ->pack(-anchor=>"se", -side=>"bottom", -fill=>"x", -expand=>1)
    ;


###########################
# SUBROUTINES (functions) #
###########################

# For unbound buttons
sub test
{
    $label->configure(-text=>"I'm too lazy to create this, so far at least! :<");
}

sub odir
{
    system("start $mapdir");
}

sub consoleinit
{
    $console->delete("0.0", "end");
    @concmd = qx{$initcmd};
    $console->insert("end", "@concmd");  
    $console->yview(moveto => 1);
}

sub radiant14
{
    if ($^O eq 'MSWin32')
    {
        Win32::Process::Create(my $winrad14,
            "$radex14",                 # Proggy..
            "",                         # Cmd args, nothx
            0,                          # Care
            NORMAL_PRIORITY_CLASS,      # REALTIME_PRIORITY_CLASS
            ".")|| die ErrorReport();   # Working dir
    }
    else
    {
        my $radthread14 = threads->new(\&radlaunch14);    
        sub radlaunch14
        {
            system($radex14);
        }
        $radthread14->detach();
    }
}

sub radiant15
{
    if ($^O eq 'MSWin32')
    {
        Win32::Process::Create(my $winrad15,
            "$radex15",                   # Proggy..
            "",                         # Cmd args, nothx
            0,                          # Care
            NORMAL_PRIORITY_CLASS,      # REALTIME_PRIORITY_CLASS
            ".")|| die ErrorReport();   # Working dir
    }
    else
    {
        my $radthread15 = threads->new(\&radlaunch15);    
        sub radlaunch15
        {
            system($radex15);
        }
        $radthread15->detach();
    }
}


sub backup
{
    $curmap = $maplist->get($maplist -> curselection());
    $curmap_clean = substr($curmap, 0, -4);
    
    # Time
    my $t = localtime;
    my $year    = $t->year;
    my $day     = $t->day_of_month;
    my $month   = $t->month;
    my $hour    = $t->hour;
    my $min     = $t->min;
    my $sec     = $t->sec;
    my $backed  = "$year-$month-$day"."_"."$hour.$min.$sec";

    if (-d $backupdir)
    {
        open(INPUT, "<$mapdir$curmap") or die ($label->configure(-text=>"ERROR: Failed to open .map file for reading! ($mapdir$curmap)"));
        open(OUTPUT, ">$backupdir$curmap_clean"."_backup($backed)") or die ($label->configure(-text=>"ERROR: Failed to create backup! ($backupdir$curmap_clean"."_backup($backed))"));
        
        while (<INPUT>)
        {
            print OUTPUT $_;
        }
        
        close(INPUT) or die ($label->configure(-text=>"ERROR: Failed to close INPUT"));
        close(OUTPUT) or die ($label->configure(-text=>"ERROR: Failed to close OUTPUT"));
        $label->configure(-text=>"Successfully backed up $curmap to backups/$curmap_clean"."_backup($backed)");
    }
    else
    {
        mkdir "$backupdir";
        $label->configure(-text=>"Backup dir not found, created, reattempting backup!");
        &backup();
    }
}

# Builds
sub metabuild
{  
    $curmap = $maplist->get($maplist -> curselection());
    $ext = substr($curmap, -4, length $curmap);
    if ($ext =~ ".bsp")
    {
        $label->configure(-text=>"Cant compile a .BSP file! ($curmap)");
    }
    elsif ($ext =~ ".map")
    {
        $console->delete("0.0", "end");
        $console->insert('end',"Dinius' Mapdev Tool\n- STARTING BUILD -\nQ3Map2 Version: ");
        
        @concmd = qx{$meta$curmap\"};
        $console->insert('end',"@concmd");
        
        $console->yview(moveto => 1);
        $label->configure(-text=>"Finished! (Meta)"); 
    }
    else
    {
        $label->configure(-text=>"File ($curmap) is not a .MAP file, can't compile...");
    }
}

sub visbuild
{
    $curmap = $maplist->get($maplist -> curselection());
    $ext = substr($curmap, -4, length $curmap);
    if ($ext =~ ".bsp")
    {
        $label->configure(-text=>"Cant compile a .BSP file! ($curmap)");
    }
    elsif ($ext =~ ".map")
    {
        $console->delete("0.0", "end");
        $console->insert('end',"Dinius' Mapdev Tool\n- STARTING BUILD -\nQ3Map2 Version: ");
        
        @concmd = qx{$meta$curmap\"};
        $console->insert('end',"@concmd");
        
        @concmd = qx{$vis$curmap\"};
        $console->insert('end',"@concmd");
        
        $console->yview(moveto => 1);
        $label->configure(-text=>"Finished! (Vis)"); 
    }
    else
    {
        $label->configure(-text=>"File ($curmap) is not a .MAP file, can't compile...");
    }
}

sub lightbuild
{
    $curmap = $maplist->get($maplist -> curselection());
    $ext = substr($curmap, -4, length $curmap);
    if ($ext =~ ".bsp")
    {
        $label->configure(-text=>"Cant compile a .BSP file! ($curmap)");
    }
    elsif ($ext =~ ".map")
    {
        $console->delete("0.0", "end");
        $console->insert('end',"Dinius' Mapdev Tool\n- STARTING BUILD -\nQ3Map2 Version: ");
        
        @concmd = qx{$meta$curmap\"};
        $console->insert('end',"@concmd");
        
        @concmd = qx{$vis$curmap\"};
        $console->insert('end',"@concmd");
        
        @concmd = qx{$light$curmap\"};
        $console->insert('end',"@concmd");
        
        $console->yview(moveto => 1);
        $label->configure(-text=>"Finished! (Light)"); 
    }
    else
    {
        $label->configure(-text=>"File ($curmap) is not a .MAP file, can't compile...");
    }
}

sub finalbuild
{
    $curmap = $maplist->get($maplist -> curselection());
    $ext = substr($curmap, -4, length $curmap);
    if ($ext =~ ".bsp")
    {
        $label->configure(-text=>"Cant compile a .BSP file! ($curmap)");
    }
    elsif ($ext =~ ".map")
    {
        $console->delete("0.0", "end");
        $console->insert('end',"Dinius' Mapdev Tool\n- STARTING BUILD -\nQ3Map2 Version: ");
        
        @concmd = qx{$final_1$curmap\"};
        $console->insert('end',"@concmd");
        
        @concmd = qx{$final_3$curmap\"};
        $console->insert('end',"@concmd");
        
        @concmd = qx{$final_2$curmap\"};
        $console->insert('end',"@concmd");
        
        $console->yview(moveto => 1);
        $label->configure(-text=>"Finished! (FINAL)"); 
    }
    else
    {
        $label->configure(-text=>"File ($curmap) is not a .MAP file, can't compile...");
    }
}

# Compiles into meta -> Goes and plays
sub metaplay
{
    $curmap = $maplist->get($maplist -> curselection());
    $ext = substr($curmap, -4, length $curmap);
    if ($ext =~ ".bsp")
    {
        $label->configure(-text=>"Cant compile a .BSP file! ($curmap)");
    }
    elsif ($ext =~ ".map")
    {
        @concmd = qx{$meta$curmap\"};
        $console->insert('end',"@concmd");
        
        $label->configure(-text=>"Finished! (Meta) ... Starting Game");
        &goplay();
    }
    else
    {
        $label->configure(-text=>"File ($curmap) is not a .MAP file, can't compile...");
    }    
}

# Decompiles, only if .bsp is selected.
sub decompile
{
    $curmap = $maplist->get($maplist -> curselection());
    $ext = substr($curmap, -4, length $curmap);
    if ($ext =~ ".bsp")
    {
        $console->delete("0.0", "end");
        $console->insert('end',"Dinius' Mapdev Tool\n- STARTING DECOMPILATION -\nQ3Map2 Version: ");
        
        @concmd = qx{$decompile$curmap\"};
        $console->insert('end',"@concmd");
        
        $console->yview(moveto => 1);
        $label->configure(-text=>"Finished! (Decompile)");
        
    }
    elsif ($ext =~ ".map")
    {
        $label->configure(-text=>"No need to decompile a .map file, smartass! ($curmap)");
    }
    else
    {
        $label->configure(-text=>"File ($curmap) is not a .BSP, can't decompile...");
    }
}

# Start server -> Wait a sec (avoid crash) -> Start player
my $playerexe;
my $serverexe;
sub goplay
{
    $curmap = $maplist->get($maplist -> curselection());
    $curmap_clean = substr($curmap, 0, -4);
    
    if ($^O eq 'MSWin32') # Windows, using Win32::Process
    {
        # End the processes, if defined (aka its already running)
        if (defined($playerexe)) {$playerexe->Kill(1);}
        
        sleep(1);   # Avoid crash
        
        # Start the process
        Win32::Process::Create($playerexe,
            "$gamedir$exe",
            "$parm $curmap_clean +config $config",
            0,  NORMAL_PRIORITY_CLASS,  ".")|| die errorreport()
        ;
    }
    else # Linux
    {
        $thread2 = threads->new(\&thread2);
        sub thread2
        {
            $curmap = $maplist->get($maplist -> curselection());
            $curmap_clean = substr($curmap, 0, -4);
            system "$gamedir$exe $parm $curmap_clean +config $config";
        }
        $thread2->detach();
    }
}

# Get all .map files in $mapdir
sub getmaps
{
    @maps = ();
    @nocopies = ();
    @copies = ();
    $maplist -> delete (0, "end");
    
    opendir(DIR, $mapdir);
    @maps = grep(/\.map$/, readdir(DIR));
    closedir(DIR);
    
    foreach my $map (@maps)
    {
        if ($map !~ /( \- copy.map| \- copy \(\d+\).map)/i)
        {
            push(@nocopies, $map);
        }
        else
        {
            push(@copies, $map);
        }
    }
    $maplist -> insert ("end", @nocopies);
    $check1 = 0;
    $label->configure(-text=>"Found " . scalar(@nocopies) . " .Map files (" . scalar(@copies) . " copies)");
}

# Get all .bsp files in $mapdir
sub getbsps
{
    @maps = ();
    @nocopies = ();
    @copies = ();
    $maplist -> delete (0, "end");
    
    opendir(DIR, $mapdir);
    @maps = grep(/\.bsp$/, readdir(DIR));
    closedir(DIR);
    
    foreach my $map (@maps)
    {
        if ($map !~ /( \- copy.bsp| \- copy \(\d+\).bsp)/i)
        {
            push(@nocopies, $map);
        }
        else
        {
            push(@copies, $map);
        }
    }
    $maplist -> insert ("end", @nocopies);
    $check1 = 0;
    $label->configure(-text=>"Found " . scalar(@nocopies) . " .BSP files (" . scalar(@copies) . " copies)");
}

# Shows the filtered (@copies) maps
# Shows @copies for the current type (map\bsp) in list.
sub showallmaps
{
    if ($check1 == 0)
    {
        $maplist -> insert ("end", @copies);
        $check1 = 1;
    }
    else
    {
        $label->configure(-text=>"Already showing all maps..");
    }
}


sub settings
{
    if (-d $gamedir) #Launch App, all iz good!
    {
        &getmaps();
        &consoleinit();
    }
    elsif (-e $settingsfile)   # Setting file exists, but has errors..
    {
        $mw->withdraw();
        my $failwindow = MainWindow->new(-title=>"You seem to fail...");
        $failwindow->geometry("250x75");
        $failwindow->resizable(0,0);
        
        my $faillabel = $failwindow->Label(-text=>"Check your configuration file.\nSomething is WRONG! :<\n(\$gamedir doesn't exist!)")->pack(-fill=>"both", -expand=>1);
    }
    else
    {
        $mw->withdraw();
        my $failwindow = MainWindow->new(-title=>"You seem to fail...");
        $failwindow->geometry("250x75");
        $failwindow->resizable(0,0);
        
        my $faillabel = $failwindow->Label(-text=>"You don't have a configuration file!\nThis .exe must be in same directory as \"config.pl\"\n(Maybe make a shortcut to this .exe instead?)")->pack(-fill=>"both", -expand=>1);
    }
}

sub autopk3
{
    # Declarations
    my @shaderlines;
    my @shaders;
    my %shaders;
    my @shaders_1;
    my @shaders_2;
    my %relshaders;
    my @customshaders;
    my %shaderfiles;
    my @shaderfiles;

    # Gets the currently selected .BSP (preferably..)
    $curmap = $maplist->get($maplist -> curselection());
    $curmap_clean = substr($curmap, 0, -4);

    # AutoPK3 Configuration
    my $autopk3             = $mapdir   .   "AutoPK3/";
    my $autopk3_base        = $autopk3  .   "$curmap_clean";
    my $autopk3_maps        = $autopk3_base  .   "/maps/";
    my $autopk3_scripts     = $autopk3_base  .   "/scripts/";
    my $autopk3_textures    = $autopk3_base  .   "/textures/";
    
    my $autopk3_template    = $autopk3          .   "/TEMPLATE/";
    my $autopk3_tp_scripts  = $autopk3_template .   "scripts/";
    my $autopk3_tp_maps     = $autopk3_template .   "maps/";
    
    
    if (-e "$autopk3_base/$curmap_clean.pk3")
    {
        # Detele teh .pk3 file if it exists, then rerun function.
        unlink("$autopk3_base/$curmap_clean.pk3");
        &autopk3();
    }
    else
    {    
        # Check if the directories exists, if not, then create them.    
        #    if (-d $dir) & if (-e $file)
        unless (-d $autopk3)            { mkdir($autopk3);          }
        unless (-d $autopk3_base)       { mkdir($autopk3_base);     }
        unless (-d $autopk3_maps)       { mkdir($autopk3_maps);     }
        unless (-d $autopk3_scripts)    { mkdir($autopk3_scripts);  }
        unless (-d $autopk3_textures)   { mkdir($autopk3_textures); }
        
        unless (-d $autopk3_template)   { mkdir($autopk3_template);     }
        unless (-d $autopk3_tp_scripts) { mkdir($autopk3_tp_scripts);   }
        unless (-d $autopk3_tp_maps)    { mkdir($autopk3_tp_maps);      }
        
        my $t_arena = ($autopk3_tp_scripts   .  "arenatemplate.arena");
        my $t_script = ($autopk3_tp_maps     .  "scripttemplate.script");
        
        # START TEMPLATE STUFF   
        # TEMPLATE/SCRIPTS/$CURMAP_CLEAN.ARENA
        unless (-e $t_arena)
        {
            open(ARENAFILE, "+>$t_arena") or die ($label->configure(-text=>"ERROR: Failed at ARENAFILE"));
            
            printf ARENAFILE "{\n    map                 \"$curmap_clean\"\n    longname            \"$curmap_clean\"\n";
            printf ARENAFILE "    type                \"wolfmp wolfsw wolflms\"\n    timelimit           0\n    axisRespawnTime     1\n    alliedRespawnTime   1\n";
            printf ARENAFILE "    briefing            \"^zwww.^7Trickjump^z.me**^dCreated with AutoPK3***^1>>> DO NOT RELEASE <<<***This is a test map, do not release, or show this map to anyone without the authors permission!*******^zwww.^7Trickjump^z.me\"\n";
            printf ARENAFILE "    mapposition_x	100\n    mapposition_y	450\n}";
            
            close(ARENAFILE)
        }
        
        # TEMPLATE/MAPS/$CURMAP_CLEAN.SCRIPT
        unless (-e $t_script)
        {
            open(SCRIPTFILE, "+>$t_script") or die ($label->configure(-text=>"ERROR: Failed at SCRIPTFILE"));
            printf SCRIPTFILE "game_manager\n{\n    spawn\n    {\n        wm_axis_respawntime 1\n        wm_allied_respawntime 1\n        wm_set_round_timelimit 0\n    }\n}";
            close(SCRIPTFILE)
        }
        
        # COPY template files, though DONT if they already exist!
        unless (-e "$autopk3_scripts/$curmap_clean.arena")
        {
            copy("$t_arena", "$autopk3_scripts/$curmap_clean.arena");
        }
        unless (-e "$autopk3_maps/$curmap_clean.script")
        {
            copy("$t_script", "$autopk3_maps/$curmap_clean.script");
        }
        # END TEMPLATE STUFF
        
        # Note: ALL COPY FUNCTIONS WILL OVERWRITE EXISTING FILES  
        # Copy the .BSP file into its AutoPK3 folder.
        # Can just as well do this now, rather than later..
        copy("$mapdir$curmap_clean.bsp", "$autopk3_maps$curmap_clean.bsp");
        
        # Read file contents into @filedata
        # Will read from either .map or .bsp files
        open(DATA, "$mapdir$curmap") or die ($label->configure(-text=>"ERROR: Failed to open file! ($mapdir$curmap)"));
        my @filedata = <DATA>;
        close(DATA) or die ($label->configure(-text=>"ERROR: Failed to close file! ($mapdir$curmap)"));
        
        # Get all the shader-containing lines into @shaderlines.
        foreach my $line (@filedata)
        {
            # Checks that the shaders aren't default ones, no need then.. 
            # OLD = ( 2752 2752 4368 ) ( 2752 2688 4368 ) ( 2496 2752 4368 ) some/shadername
            # NEW = some/shadername/texturename (bsp + map compatible)
            if ($line =~ /(\w*)\/(\w*)/)
            {
                unless (exists $shaders{"$1/$2"}    ||
                        $1 eq "_unsorted"           ||
                        $1 eq "alpha"               ||
                        $1 eq "alpha_sd"            ||
                        $1 eq "assault"             ||
                        $1 eq "assault_rock"        ||
                        $1 eq "awf_props"           ||
                        $1 eq "battery"             ||
                        $1 eq "battery_wall"        ||
                        $1 eq "bbmodels_mapobjects" ||
                        $1 eq "blimp"               ||
                        $1 eq "bunker_sd"           ||
                        $1 eq "castle_door"         ||
                        $1 eq "castle_floor"        ||
                        $1 eq "castle_window"       ||
                        $1 eq "castle_wood"         ||
                        $1 eq "chat"                ||
                        $1 eq "chat_window"         ||
                        $1 eq "chat_wood"           ||
                        $1 eq "chateau"             ||
                        $1 eq "common"              ||
                        $1 eq "decals"              ||
                        $1 eq "doors"               ||
                        $1 eq "eerie"               ||
                        $1 eq "egypt_door_sd"       ||
                        $1 eq "egypt_floor_sd"      ||
                        $1 eq "egypt_props_sd"      ||
                        $1 eq "egypt_rock_sd"       ||
                        $1 eq "egypt_trim_sd"       ||
                        $1 eq "egypt_walls_sd"      ||
                        $1 eq "egypt_windows_sd"    ||
                        $1 eq "egypt_wood_sd"       ||
                        $1 eq "factory_sd"          ||
                        $1 eq "fueldump"            ||
                        $1 eq "gfx_2d"              ||
                        $1 eq "gfx_clipboard"       ||
                        $1 eq "gfx_damage"          ||
                        $1 eq "gfx_hud"             ||
                        $1 eq "gfx_limbo"           ||
                        $1 eq "gfx_misc"            ||
                        $1 eq "goldrush"            ||
                        $1 eq "icons"               ||
                        $1 eq "levelshots"          ||
                        $1 eq "lights"              ||
                        $1 eq "liquids"             ||
                        $1 eq "liquids_sd"          ||
                        $1 eq "mapfx"               ||
                        $1 eq "metal_misc"          ||
                        $1 eq "metals_sd"           ||
                        $1 eq "miltary_door"        ||
                        $1 eq "miltary_trim"        ||
                        $1 eq "miltary_wall"        ||
                        $1 eq "models_ammo"         ||
                        $1 eq "models_foliage"      ||
                        $1 eq "models_furniture"    ||
                        $1 eq "models_mapobjects"   ||
                        $1 eq "models_multiplayer"  ||
                        $1 eq "models_players"      ||
                        $1 eq "models_shards"       ||
                        $1 eq "models_weapons2"     ||
                        $1 eq "mp_goldrush"         ||
                        $1 eq "mp_guns"             ||
                        $1 eq "mp_railgun"          ||
                        $1 eq "mp_rocket"           ||
                        $1 eq "mp_seawall"          ||
                        $1 eq "mp_siwa"             ||
                        $1 eq "mp_wurzburg"         ||
                        $1 eq "props"               ||
                        $1 eq "props_sd"            ||
                        $1 eq "radar"               ||
                        $1 eq "railgun_props"       ||
                        $1 eq "railway_sd"          ||
                        $1 eq "rock"                ||
                        $1 eq "rubble"              ||
                        $1 eq "seawall_wall"        ||
                        $1 eq "sfx"                 ||
                        $1 eq "shadows"             ||
                        $1 eq "siwa_fx_sd"          ||
                        $1 eq "siwa_props_sd"       ||
                        $1 eq "siwa_skyboxes_sd"    ||
                        $1 eq "skies"               ||
                        $1 eq "skies_sd"            ||
                        $1 eq "snow"                ||
                        $1 eq "snow_sd"             ||
                        $1 eq "sprites"             ||
                        $1 eq "stone"               ||
                        $1 eq "swf"                 ||
                        $1 eq "temperate_sd"        ||
                        $1 eq "terrain"             ||
                        $1 eq "textures"            ||
                        $1 eq "tobruk_wall_sd"      ||
                        $1 eq "tobruk_windows_sd"   ||
                        $1 eq "town_props"          ||
                        $1 eq "town_roof"           ||
                        $1 eq "town_wall"           ||
                        $1 eq "town_window"         ||
                        $1 eq "town_wood"           ||
                        $1 eq "tree"                ||
                        $1 eq "ui_assets"           ||
                        $1 eq "ui_assets2"          ||
                        $1 eq "villa_sd"            ||
                        $1 eq "village"             ||
                        $1 eq "wood"                ||
                        $1 eq "xlab_door"           ||
                        $1 eq "xlab_props"          ||
                        $1 eq "xlab_wall"           ||
                        $1 eq "radiant"
                    )
                {
                    $shaders{"$1/$2"} = "$1/$2";    # Into hash, for checking @ above unless
                    push(@shaderlines, $line);      # ( 960 1280 3136 ) ( 1024 1216 3008 ) ( 960 1280 3008 ) common/caulk 64 24.0004882813 0 0.4999999702 0.4999999702 134217728 0 0
                    push(@shaders_1, $1);           # shadername    (common)
                    push(@shaders_2, $2);           # texturename   (caulk)
                    push(@customshaders, "$1/$2");  # shadername/texturename
                }
            }
        }
     
        if (scalar(@customshaders > 0))
        {
            my $i=0;
            while ($i < scalar(@customshaders))
            {
                my $first       = $shaders_1[$i];
                my $second      = $shaders_2[$i];
                my $full        = $customshaders[$i];
                my $sourceimg  = "$textures$full";
                my $destdir     = "$autopk3_textures$first";
                my $destination = "$autopk3_textures$full";
                    
                if (-e "$sourceimg.jpg")
                {
                    unless (-d "$destdir")   { mkdir("$destdir" );}
                    copy("$sourceimg.jpg", "$destination.jpg") or die ($label->configure(-text=>"ERROR: Failed to copy $sourceimg.jpg to $destination.jpg"));
                }
                elsif (-e "$sourceimg.tga")
                {
                    unless (-d "$destdir")   { mkdir("$destdir" );}
                    copy("$sourceimg.tga", "$destination.tga") or die ($label->configure(-text=>"ERROR: Failed to copy $sourceimg.tga to $destination.tga"));
                }
            $i++;
            }
        }


        # In either case, continue with pk3 making.
        # "Create" the .pk3 from directory tree using archive::zip
        my $pk3 = Archive::Zip->new();
        $pk3->addTree("$autopk3_base", "");
    
        # Save the .pk3
        unless ( $pk3->writeToFileNamed("$autopk3_base/$curmap_clean.pk3") == AZ_OK )
        {
            die ($label->configure(-text=>"ERROR: Failed to create .PK3 File!!!"));
        }

        # When all is done.
        system("start $autopk3_base");
        $label->configure(-text=>"Successfully created $curmap_clean.pk3!");
    }
}




&settings();
#&getmaps();
#&consoleinit();
MainLoop;
# Fin