/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Delete all whitespaces from the beginning and the end of the string.
 * Optional: collapse all double whitespaces within the string.
 * Optional: delete all line breaks (ASCII 0A and 0D) from the beginning and the end of the string.
 * @param   string    inputString   String to trim
 * @param   boolean   doDouble      TRUE: collapse all double whitespaces within the string
 *                                  FALSE: (default) do not collapse all double whitespaces within the string
 * @param   int       trimType      Trim type (1: Left trim, 2: Right trim, 0: Both)
 */
function trimString(inputString, doDouble, doLineBreaks, trimType) {
  if (typeof(doLineBreaks)!='boolean') {
    doLineBreaks=true;
  }
  if (typeof(trimType)!='number') {
    trimType=0;
  }
  var retValue='';
  if (typeof(inputString)=='string') {
    retValue=inputString;
    // Processing line start
    if (trimType==0 || trimType==1) {
      var oneChar=retValue.charCodeAt(0);
      while (retValue.length && (oneChar==32 || oneChar==9) || doLineBreaks && (oneChar==10 || oneChar==13)) {
        retValue=retValue.substring(1, retValue.length);
        oneChar=retValue.charCodeAt(0);
      }
    }
    // Processing line end
    if (trimType==0 || trimType==2) {
      oneChar=retValue.charCodeAt(retValue.length-1);
      while (retValue.length && (oneChar==32 || oneChar==9) || doLineBreaks && (oneChar==10 || oneChar==13)) {
        // Deleting all whitespaces at the end of the string
        retValue=retValue.substring(0, retValue.length-1);
        oneChar=retValue.charCodeAt(retValue.length-1);
      }
    }
    if (typeof(doDouble)=='boolean' && doDouble) {
      // Deleting all double whitespaces within the string
      while (retValue.indexOf('  ')>0) {
        retValue=retValue.substring(0, retValue.indexOf('  '))+retValue.substring(retValue.indexOf('  ')+1, retValue.length);
      }
    }
  }
  return retValue;
}
