<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#################################################
# DO NOT CHANGE THIS FILE !!!
#################################################

error_reporting(0);
error_reporting(E_ALL); ini_set('display_errors', 'on');

// Load GUIDs to exclude from players list
require_once(PCPIN_DIR_OFFSET.'/exclude.php');

// Load calculation factors
require_once(PCPIN_DIR_OFFSET.'/factors.php');

// Load configuration
require_once(PCPIN_DIR_OFFSET.'/config.php');
require_once(PCPIN_DIR_OFFSET.'/funcs.php');

// Load classes
require_once(PCPIN_DIR_OFFSET.'/class/common.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/db.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/config.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/session.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/cache.class.php');

require_once(PCPIN_DIR_OFFSET.'/class/game.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/playerdata.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/gameclient.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/clientname.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/gameclientteamclass.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/gameclientkill.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/gameclientdeath.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/gameclientsuicide.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/gameclientrevive.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/gameclienthealth.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/gameclientammo.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/gameclientmisc.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/gameclientws.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/gameclientdamage.class.php');
require_once(PCPIN_DIR_OFFSET.'/class/excludeguids.class.php');

/**
 * Target for all links and forms
 */
define('PCPIN_FORMLINK', './index.php');

/**
 * Exclude bots from player list?
 */
define('PCPIN_LIST_EXCLUDE_BOTS', !empty($_conf['list_exclude_bots']));

// Minimum required PHP version
// DO NOT CHANGE !!!
define('PCPIN_REQUIRESPHP', '4.3.3');

// Minimum required MySQL version
// DO NOT CHANGE !!!
define('PCPIN_REQUIRESMYSQL', '4.0.15');

// Check PHP version
$_pcpin_php_needed=explode('.', PCPIN_REQUIRESPHP);
$_pcpin_php_exists=explode('.', phpversion());
define('PCPIN_PHP5', $_pcpin_php_exists[0]==5);
foreach ($_pcpin_php_needed as $_pcpin_key=>$_pcpin_val) {
  if (!isset($_pcpin_php_exists[$_pcpin_key])) {
    // Installed PHP version is OK
    break;
  } else {
    $l=strlen($_pcpin_php_exists[$_pcpin_key]);
    for ($i=0; $i<$l; $i++) {
      if ($_pcpin_php_exists[$_pcpin_key]{$i}!=='0' && ($_pcpin_php_exists[$_pcpin_key]{$i}<1 || $_pcpin_php_exists[$_pcpin_key]{$i}>9)) {
        $_pcpin_php_exists[$_pcpin_key]=substr($_pcpin_php_exists[$_pcpin_key], 0, $i);
        break;
      }
    }
    if ($_pcpin_val>$_pcpin_php_exists[$_pcpin_key]) {
      // PHP version is too old
      die("<b>Fatal error</b>: Installed PHP version is <b>".phpversion()."</b> (minimum required PHP version is <b>".PCPIN_REQUIRESPHP."</b>)");
    } elseif ($_pcpin_val<$_pcpin_php_exists[$_pcpin_key]) {
      // Installed PHP version is OK
      break;
    }
  }
}
unset($_pcpin_key);
unset($_pcpin_val);
unset($_pcpin_php_needed);
unset($_pcpin_php_exists);

/**
 * Get client's IP address
 */
define('PCPIN_CLIENT_IP', (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR']!='')? $_SERVER['REMOTE_ADDR'] : ((isset($HTTP_SERVER_VARS['REMOTE_ADDR']) && $HTTP_SERVER_VARS['REMOTE_ADDR']!='')? $HTTP_SERVER_VARS['REMOTE_ADDR'] : 'UNKNOWN'));


/**
 * Get client info
 */
$_pcpin_os='';
$_pcpin_agent_name='';
$_pcpin_agent_ver='';
if (!empty($_SERVER['HTTP_USER_AGENT'])) PCPIN_Common::getClientInfo($_SERVER['HTTP_USER_AGENT'], $_pcpin_os, $_pcpin_agent_name, $_pcpin_agent_ver);
define('PCPIN_CLIENT_OS', $_pcpin_os);
define('PCPIN_CLIENT_AGENT_NAME', $_pcpin_agent_name);
define('PCPIN_CLIENT_AGENT_VERSION', $_pcpin_agent_ver);
unset($_pcpin_os);
unset($_pcpin_agent_name);
unset($_pcpin_agent_ver);


// Create initial class
$__pcpin_init_class=new stdClass();
$__pcpin_init_class->_cache=array(); // Cahced data (to be used by all child objects)


// Connect to database
new PCPIN_DB($__pcpin_init_class, ${$dbcn});
unset(${$dbcn});

// Create config
new PCPIN_Config($__pcpin_init_class);

// Create session
$session=new PCPIN_Session($__pcpin_init_class);

/**
 * Strip magic quotes from GPC vars and extract them into the global scope.
 * This software uses own security algorithm to prevent SQL injections.
 */
if (get_magic_quotes_gpc()) {
  $_pcpin_magic_quotes_sybase=ini_get('magic_quotes_sybase')=='1';
  $_GET=PCPIN_Common::stripSlashesRecursive($_GET, $_pcpin_magic_quotes_sybase);
  $_POST=PCPIN_Common::stripSlashesRecursive($_POST, $_pcpin_magic_quotes_sybase);
  $_COOKIE=PCPIN_Common::stripSlashesRecursive($_COOKIE, $_pcpin_magic_quotes_sybase);
//  $_SESSION=PCPIN_Common::stripSlashesRecursive($_SESSION, $_pcpin_magic_quotes_sybase); // <-- not needed yet
  unset($_pcpin_magic_quotes_sybase);
}



/**
 * Yes, we extract GPC+F superglobals into the global scope.
 * This software knows, how to handle them.
 */

// $_GET vars
extract($_GET);

// $_POST vars
extract($_POST);

// $_COOKIE vars
$_pcpin_cookies_found=!empty($_COOKIE);
//extract($_COOKIE); // <- not needed yet

// Posted files into the global scope
extract($_FILES);


/**
 * Clean some globals and superglobals
 */

unset($GLOBALS);
unset($_SESSION);
unset($_FILES);
unset($_COOKIE);
unset($_POST);
unset($_GET);
unset($_REQUEST);
unset($HTTP_GET_VARS);
unset($HTTP_POST_VARS);
unset($HTTP_POST_FILES);
unset($HTTP_COOKIE_VARS);
unset($HTTP_SESSION_VARS);
?>