<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * Return an array with bit numbers set in integer
 * @param   int   $num    Integer number
 * @return  array
 */
function getBits($num) {
  $bits=array();
  $bin=strrev(sprintf('%b', $num));
  $bin_len=strlen($bin);
  for ($i=0; $i<$bin_len; $i++) {
    if ($bin[$i]=='1') {
      $bits[]=$i;
    }
  }
  return $bits;
}


/**
 * Checks if all of the characters in the provided string are numerical
 * @param   mixed     $text   The tested string
 * @return  boolean   TRUE if every character in $text is a decimal digit, FALSE otherwise
 */
function pcpin_ctype_digit($text='') {
  $result=false;
  if (is_scalar($text) && $text!='') {
    $result=true;
    $text_len=strlen($text);
    for ($i=0; $i<$text_len; $i++) {
      $c=ord(substr($text, $i, 1));
      if ($c<48 || $c>57) {
        $result=false;
        break;
      }
    }
  }
  return $result;
}


/**
 * Convert a string with color tags into HTML-colored string
 * @param   string    $colored    String with color tags
 * @param   string    $tag        HTML tag to use
 * @return  string
 */
function coloredToHTML($colored='', $tag='span') {
  global $colors;
  $html='';
  $parts=explode('^', $colored);
  if (count($parts)==1) {
    $html=str_replace(' ', '&nbsp;', htmlspecialchars($parts[0]));
  } else {
    foreach ($parts as $part_nr=>$part) {
      if (strlen($part)>1) {
        $color_key=strtolower(substr($part, 0, 1));
        $html.='<'.$tag.' style="color:#'.(isset($colors[$color_key])? $colors[$color_key] : $colors['_default_']).'">'
             .str_replace(' ', '&nbsp;', htmlspecialchars($part_nr>0? substr($part, 1) : $part))
             .'</'.$tag.'>';
      }
    }
  }
  $html='<'.$tag.' style="color:#'.$colors['_default_'].'">'.$html.'</'.$tag.'>';
  return $html;
}


/**
 * Extract plain text from colored string
 * @param   string    $colored            String with color tags
 * @param   boolean   $do_html_entities   Optional. If TRUE (default), HTML entities will be converted.
 * @return  string
 */
function coloredToPlain($colored='', $do_html_entities=true) {
  $plain='';
  $parts=explode('^', $colored);
  if (count($parts)==1) {
    if ($do_html_entities) {
      $plain=str_replace(' ', '&nbsp;', htmlspecialchars($parts[0]));
    } else {
      $plain=$parts[0];
    }
  } else {
    foreach ($parts as $part_nr=>$part) {
      if (strlen($part)>1) {
        if ($do_html_entities) {
          $plain.=str_replace(' ', '&nbsp;', htmlspecialchars($part_nr>0? substr($part, 1) : $part));
        } else {
          $plain.=substr($part, 1);
        }
      }
    }
  }
  return $plain;
}


/**
 * Convert time in seconds into HH:MM:SS format
 * @param   int   $seconds    Seconds
 * @return  string
 */
function makeTimeFromSeconds($seconds) {
  $hours=floor($seconds/3600);
  $minutes=floor(($seconds-$hours*3600)/60);
  $seconds=$seconds-$hours*3600-$minutes*60;
  return $hours.':'.str_pad($minutes, 2, '0', STR_PAD_LEFT).':'.str_pad($seconds, 2, '0', STR_PAD_LEFT);
}


?>