
-- --------------------------------------------------------

-- 
-- Table structure for table `ets_cache`
-- 

CREATE TABLE `ets_cache` (
  `uri` varchar(255) NOT NULL default 'g',
  `html` longblob NOT NULL,
  PRIMARY KEY  (`uri`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_clientname`
-- 

CREATE TABLE `ets_clientname` (
  `game_id` int(11) NOT NULL,
  `guid` varchar(32) NOT NULL,
  `name` varchar(255) NOT NULL,
  `name_txt` varchar(255) NOT NULL,
  `last_used` enum('y','n') NOT NULL default 'n',
  KEY `game_id` (`game_id`),
  KEY `last_used` (`guid`,`last_used`),
  KEY `name` (`name`),
  KEY `name_txt` (`name_txt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_excludeguids`
-- 

CREATE TABLE `ets_excludeguids` (
  `guid` varchar(32) NOT NULL,
  PRIMARY KEY  (`guid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_game`
-- 

CREATE TABLE `ets_game` (
  `id` int(11) NOT NULL auto_increment,
  `mapname` varchar(255) NOT NULL,
  `duration` int(11) NOT NULL,
  `clients` int(11) NOT NULL,
  `players` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `mapname` (`mapname`),
  KEY `duration` (`duration`),
  KEY `clients` (`clients`,`players`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_gameclient`
-- 

CREATE TABLE `ets_gameclient` (
  `game_id` int(11) NOT NULL,
  `guid` varchar(32) NOT NULL,
  `time_axis` int(11) NOT NULL,
  `time_allies` int(11) NOT NULL,
  `time_spectator` int(11) NOT NULL,
  `killed_enemies` int(11) NOT NULL,
  `killed_teammates` int(11) NOT NULL,
  `killed_by_enemies` int(11) NOT NULL,
  `killed_by_teammates` int(11) NOT NULL,
  `killed_by_world` int(11) NOT NULL,
  `suicides` int(11) NOT NULL,
  `score` int(11) NOT NULL,
  `ping` int(11) NOT NULL,
  `revives` int(11) NOT NULL,
  `health_given` int(11) NOT NULL,
  `ammo_given` int(11) NOT NULL,
  `health_taken` int(11) NOT NULL,
  `ammo_taken` int(11) NOT NULL,
  `dynamite_plant` int(11) NOT NULL,
  `dynamite_diffuse` int(11) NOT NULL,
  `repairs` int(11) NOT NULL,
  `disguises` int(11) NOT NULL,
  `objectives_taken` int(11) NOT NULL,
  `kill_sprees` int(11) NOT NULL,
  `longest_kill_spree` int(11) NOT NULL,
  `death_sprees` int(11) NOT NULL,
  `longest_death_spree` int(11) NOT NULL,
  `first_kill` enum('y','n') NOT NULL default 'n',
  `first_death` enum('y','n') NOT NULL default 'n',
  `bounties` int(11) NOT NULL,
  `engineer_kills` int(11) NOT NULL,
  `fieldops_kills` int(11) NOT NULL,
  `covertops_kills` int(11) NOT NULL,
  KEY `game_id` (`game_id`),
  KEY `guid` (`guid`),
  KEY `time` (`time_axis`,`time_allies`,`time_spectator`),
  KEY `kills` (`killed_enemies`,`killed_teammates`),
  KEY `deaths` (`killed_by_enemies`,`killed_by_teammates`,`killed_by_world`,`suicides`),
  KEY `score` (`score`),
  KEY `ping` (`ping`),
  KEY `kill_sprees` (`kill_sprees`,`longest_kill_spree`,`death_sprees`,`longest_death_spree`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_gameclientammo`
-- 

CREATE TABLE `ets_gameclientammo` (
  `game_id` int(11) NOT NULL,
  `guid` varchar(32) NOT NULL,
  `victim_guid` varchar(32) NOT NULL,
  `team` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  KEY `game_id` (`game_id`),
  KEY `guid` (`guid`),
  KEY `victim_guid` (`victim_guid`),
  KEY `team` (`team`),
  KEY `count` (`count`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_gameclientdamage`
-- 

CREATE TABLE `ets_gameclientdamage` (
  `guid` varchar(32) NOT NULL,
  `damage_given` int(11) NOT NULL,
  `damage_received` int(11) NOT NULL,
  `team_damage` int(11) NOT NULL,
  PRIMARY KEY  (`guid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_gameclientdeath`
-- 

CREATE TABLE `ets_gameclientdeath` (
  `game_id` int(11) NOT NULL,
  `guid` varchar(32) NOT NULL,
  `killer_guid` varchar(32) NOT NULL,
  `team` int(11) NOT NULL,
  `enemy` enum('y','n','w') NOT NULL,
  `mod` varchar(255) NOT NULL,
  `count` int(11) NOT NULL,
  KEY `game_id` (`game_id`,`guid`),
  KEY `killer_guid` (`killer_guid`),
  KEY `team` (`team`),
  KEY `enemy` (`enemy`),
  KEY `mod` (`mod`),
  KEY `count` (`count`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_gameclienthealth`
-- 

CREATE TABLE `ets_gameclienthealth` (
  `game_id` int(11) NOT NULL,
  `guid` varchar(32) NOT NULL,
  `victim_guid` varchar(32) NOT NULL,
  `team` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  KEY `game_id` (`game_id`),
  KEY `guid` (`guid`),
  KEY `victim_guid` (`victim_guid`),
  KEY `team` (`team`),
  KEY `count` (`count`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_gameclientkill`
-- 

CREATE TABLE `ets_gameclientkill` (
  `game_id` int(11) NOT NULL,
  `guid` varchar(32) NOT NULL,
  `class` int(11) NOT NULL,
  `victim_guid` varchar(32) NOT NULL,
  `team` int(11) NOT NULL,
  `enemy` enum('y','n') NOT NULL,
  `mod` varchar(255) NOT NULL,
  `count` int(11) NOT NULL,
  KEY `game_id` (`game_id`,`guid`),
  KEY `victim_guid` (`victim_guid`),
  KEY `team` (`team`),
  KEY `enemy` (`enemy`),
  KEY `mod` (`mod`),
  KEY `count` (`count`),
  KEY `class` (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_gameclientmisc`
-- 

CREATE TABLE `ets_gameclientmisc` (
  `game_id` int(11) NOT NULL,
  `guid` varchar(32) NOT NULL,
  `team` int(11) NOT NULL,
  `dynamite_plant` int(11) NOT NULL,
  `dynamite_diffuse` int(11) NOT NULL,
  `repairs` int(11) NOT NULL,
  `disguises` int(11) NOT NULL,
  `objectives_taken` int(11) NOT NULL,
  KEY `game_id` (`game_id`),
  KEY `guid` (`guid`),
  KEY `team` (`team`),
  KEY `dynamite_plant` (`dynamite_plant`),
  KEY `dynamite_diffuse` (`dynamite_diffuse`),
  KEY `repairs` (`repairs`),
  KEY `disguises` (`disguises`),
  KEY `objectives_taken` (`objectives_taken`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_gameclientrevive`
-- 

CREATE TABLE `ets_gameclientrevive` (
  `game_id` int(11) NOT NULL,
  `guid` varchar(32) NOT NULL,
  `victim_guid` varchar(32) NOT NULL,
  `team` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  KEY `game_id` (`game_id`),
  KEY `guid` (`guid`),
  KEY `victim_guid` (`victim_guid`),
  KEY `team` (`team`),
  KEY `count` (`count`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_gameclientsuicide`
-- 

CREATE TABLE `ets_gameclientsuicide` (
  `game_id` int(11) NOT NULL,
  `guid` varchar(32) NOT NULL,
  `team` int(11) NOT NULL,
  `mod` varchar(255) NOT NULL,
  `count` int(11) NOT NULL,
  KEY `game_id` (`game_id`),
  KEY `guid` (`guid`),
  KEY `team` (`team`),
  KEY `mod` (`mod`),
  KEY `count` (`count`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_gameclientteamclass`
-- 

CREATE TABLE `ets_gameclientteamclass` (
  `game_id` int(11) NOT NULL,
  `guid` varchar(32) NOT NULL,
  `team` int(11) NOT NULL,
  `class` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  KEY `game_id` (`game_id`),
  KEY `guid` (`guid`),
  KEY `team` (`team`),
  KEY `class` (`class`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_gameclientws`
-- 

CREATE TABLE `ets_gameclientws` (
  `guid` varchar(32) NOT NULL,
  `weapon` int(11) NOT NULL,
  `hits` int(11) NOT NULL,
  `shots` int(11) NOT NULL,
  `kills` int(11) NOT NULL,
  `deaths` int(11) NOT NULL,
  `headshots` int(11) NOT NULL,
  PRIMARY KEY  (`guid`,`weapon`),
  KEY `weapon` (`weapon`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

-- 
-- Table structure for table `ets_parsedfiles`
-- 

CREATE TABLE `ets_parsedfiles` (
  `filename` varchar(255) NOT NULL,
  `checksum` varchar(32) NOT NULL,
  KEY `filename` (`filename`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
