<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


// NoQuarter 1.1.1 beta defs


// DO NOT CHANGE THIS FILE !!!

// Teams
$def_teams=array( 1 => 'Axis',
                  2 => 'Allies',
                  3 => 'Spectator'
                 );

// Classes
$def_classes=array( 0 => 'Soldier',
                    1 => 'Medic',
                    2 => 'Engineer',
                    3 => 'Field Ops',
                    4 => 'Covert Ops'
                   );

// MODs
$def_mods=array('MOD_UNKNOWN' => 'Unknown',
                'MOD_MACHINEGUN' => 'Machine Gun',
                'MOD_BROWNING' => 'Browning',
                'MOD_MG42' => 'MG42',
                'MOD_GRENADE' => 'Grenade',
                'MOD_KNIFE' => 'Knife',
                'MOD_LUGER' => 'Luger',
                'MOD_COLT' => 'Colt',
                'MOD_MP40' => 'MP40',
                'MOD_THOMPSON' => 'Thompson',
                'MOD_STEN' => 'Sten',
                'MOD_GARAND' => 'Garand',
                'MOD_SILENCER' => 'Silenced Luger',
                'MOD_FG42' => 'FG42',
                'MOD_FG42_SCOPE' => 'FG42 w.Scope',
                'MOD_PANZERFAUST' => 'Panzerfaust',
                'MOD_GRENADE_LAUNCHER' => 'Grenade',
                'MOD_FLAMETHROWER' => 'Flamethrower',
                'MOD_GRENADE_PINEAPPLE' => 'Pineapple grenade',
                'MOD_MAPMORTAR' => 'Mortar',
                'MOD_MAPMORTAR_SPLASH' => 'Mortar (splash)',
                'MOD_KICKED' => '(was kicked)',
                'MOD_GRABBER' => 'Grabber',
                'MOD_DYNAMITE' => 'Dynamite',
                'MOD_AIRSTRIKE' => 'Airstrike',
                'MOD_SYRINGE' => 'Syringe',
                'MOD_AMMO' => 'Ammo',
                'MOD_ARTY' => 'Artillery',
                'MOD_WATER' => '(drowned)',
                'MOD_SLIME' => 'Slime',
                'MOD_LAVA' => 'Lava',
                'MOD_CRUSH' => '(crushed)',
                'MOD_TELEFRAG' => 'Telefrag',
                'MOD_FALLING' => '(fell to death)',
                'MOD_SUICIDE' => 'Suicide',
                'MOD_TARGET_LASER' => 'Laser',
                'MOD_TRIGGER_HURT' => 'Electro shock/Barb wire/Fire',
                'MOD_EXPLOSIVE' => 'Explosive',
                'MOD_CARBINE' => 'Carabine',
                'MOD_KAR98' => 'KAR98',
                'MOD_GPG40' => 'GPG40',
                'MOD_M7' => 'M7',
                'MOD_LANDMINE' => 'Landmine',
                'MOD_SATCHEL' => 'Satchel',
                'MOD_TRIPMINE' => 'Tripmine',
                'MOD_SMOKEBOMB' => 'Smoke bomb',
                'MOD_MOBILE_MG42' => 'Mobile MG42',
                'MOD_SILENCED_COLT' => 'Silenced Colt',
                'MOD_GARAND_SCOPE' => 'Garand w.Scope',
                'MOD_CRUSH_CONSTRUCTION' => 'Construction',
                'MOD_CRUSH_CONSTRUCTIONDEATH' => 'Construction',
                'MOD_CRUSH_CONSTRUCTIONDEATH_NOATTACKER' => 'Construction',
                'MOD_K43' => 'K43',
                'MOD_K43_SCOPE' => 'K43 w.Scope',
                'MOD_MORTAR' => 'Mortar',
                'MOD_AKIMBO_COLT' => 'Akimbo Colt',
                'MOD_AKIMBO_LUGER' => 'Akimbo Luger',
                'MOD_AKIMBO_SILENCEDCOLT' => 'Akimbo silenced Colt',
                'MOD_AKIMBO_SILENCEDLUGER' => 'Akimbo silenced Luger',
                'MOD_SMOKEGRENADE' => 'Smoke grenade',
                'MOD_SWAP_PLACES' => 'Swap places',
                'MOD_SWITCHTEAM' => 'Switch team',
                'MOD_GOOMBA' => 'Goomba jump',
                'MOD_POISON' => 'Poison',
                'MOD_FEAR' => 'Fear',
                'MOD_CENSORED' => 'Censored',
                'MOD_SHOTGUN' => 'Shotgun',
                'MOD_BACKSTAB' => 'Backstab',
                'MOD_MOBILE_BROWNING' => 'Mobile Browning',
                'MOD_BAR' => 'BAR',
                'MOD_STG44' => 'STG44',
                'MOD_BAZOOKA' => 'Bazooka',
                'MOD_STEN_MKII' => 'Sten MKII',
                'MOD_MP34' => 'MP34',
                'MOD_VENOM' => 'Venom',
                'MOD_SHOVE' => 'Shove',
                'MOD_THROWKNIFE' => 'Thrown knife',
                );

// WeaponStats weapons => MOD mapping
$def_ws_weapons=array(  0 => 'MOD_KNIFE', // WS_KNIFE
                        1 => 'MOD_LUGER', // WS_LUGER
                        2 => 'MOD_COLT', // WS_COLT
                        3 => 'MOD_MP40', // WS_MP40
                        4 => 'MOD_THOMPSON', // WS_THOMPSON
                        5 => 'MOD_STEN', // WS_STEN
                        6 => 'MOD_FG42', // WS_FG42
                        7 => 'MOD_PANZERFAUST', // WS_PANZERFAUST
                        8 => 'MOD_FLAMETHROWER', // WS_FLAMETHROWER
                        9 => 'MOD_GRENADE', // WS_GRENADE
                       10 => 'MOD_MORTAR', // WS_MORTAR
                       11 => 'MOD_DYNAMITE', // WS_DYNAMITE
                       12 => 'MOD_AIRSTRIKE', // WS_AIRSTRIKE
                       13 => 'MOD_ARTY', // WS_ARTILLERY
                       14 => 'MOD_SYRINGE', // WS_SYRINGE
                       15 => 'MOD_SMOKEGRENADE', // WS_SMOKE
                       16 => 'MOD_SATCHEL', // WS_SATCHEL
                       17 => 'MOD_GRENADE_LAUNCHER', // WS_GRENADELAUNCHER
                       18 => 'MOD_LANDMINE', // WS_LANDMINE
                       19 => 'MOD_MG42', // WS_MG42
                       20 => 'MOD_GARAND', // WS_GARAND
                       21 => 'MOD_K43', // WS_K43
                       22 => 'MOD_SHOTGUN', // WS_SHOTGUN
                       23 => 'MOD_BROWNING', // WS_BROWNING
                       24 => 'MOD_STG44', // WS_STG44
                       25 => 'MOD_STEN_MKII', // WS_STEN_MKII
                       26 => 'MOD_BAR', // WS_BAR
                       27 => 'MOD_BAZOOKA', // WS_BAZOOKA
                       28 => 'MOD_MP34', // WS_MP34
                       29 => 'MOD_VENOM', // WS_VENOM
                       30 => 'MOD_POISON', // WS_POISON
                      );


// ET color codes
$colors=array('_default_' => 'DDDDDD',
              '0' => '000000', '1' => 'DA0120', '2' => '00B906', '3' => 'E8FF19',
              '4' => '170BDB', '5' => '23C2C6', '6' => 'E201DB', '7' => 'FFFFFF',
              '8' => 'CA7C27', '9' => '757575', 'a' => 'EB9F53', 'b' => '106F59',
              'c' => '5A134F', 'd' => '035AFF', 'e' => '681EA7', 'f' => '5097C1',
              'g' => 'BEDAC4', 'h' => '024D2C', 'i' => '7D081B', 'j' => '90243E',
              'k' => '743313', 'l' => 'A7905E', 'm' => '555C26', 'n' => 'AEAC97',
              'o' => 'C0BF7F', 'p' => '000000', 'q' => 'DA0120', 'r' => '00B906',
              's' => 'E8FF19', 't' => '170BDB', 'u' => '23C2C6', 'v' => 'E201DB',
              'w' => 'FFFFFF', 'x' => 'CA7C27', 'y' => '757575', 'z' => 'CC8034',
              '/' => 'DBDF70', '*' => 'BBBBBB', '-' => '747228', '+' => '993400',
              '?' => '670504', '@' => '623307', '<' => '007F00', '>' => '00007F',
              ':' => 'BFBFBF', ';' => '0D1015', '=' => '7F7F00', '?' => '7F0000',
              '@' => '7F3F00');





/**
 * Convert class number into class name
 * @param   int   $class_nr   Class Nr.
 * @return string
 */
function getClassName($class_nr) {
  global $def_classes;
  $class='unknown'.$class_nr;
  if (isset($def_classes[$class_nr])) {
    $class=$def_classes[$class_nr];
  }
  return $class;
}

/**
 * Convert WS weapon number into MOD
 * @param   int   $ws_weapon    WS weapon Nr.
 * @return string
 */
function wsToMOD($ws_weapon) {
  global $def_ws_weapons;
  $mod='unknown'.$ws_weapon;
  if (isset($def_ws_weapons[$ws_weapon])) {
    $mod=$def_ws_weapons[$ws_weapon];
  }
  return $mod;
}

/**
 * Convert MOD into human readable weapon name
 * @param   string    $mod    MOD
 * @return string
 */
function MODToWeaponName($mod) {
  global $def_mods;
  $weapon=$mod;
  if (isset($def_mods[$mod])) {
    $weapon=$def_mods[$mod];
  }
  return $weapon;
}

/**
 * Convert team number into human readable team name
 * @param   int   $team     Team number
 * @return string
 */
function getTeamName($team_nr) {
  global $def_teams;
  $team='';
  if (isset($def_teams[$team_nr])) {
    $team=$def_teams[$team_nr];
  }
  return $team;
}



?>