<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


define('PCPIN_DIR_OFFSET', '../');

require_once('../init.php');

require_once('../class/parser.class.php');
require_once('../class/parsedfiles.class.php');

echo date('Y-m-d H:i:s')."\tParser started <br />\n";
flush();

$timer_start=explode(' ', microtime());
$timer_start=$timer_start[0]+$timer_start[1];

// Get parsed files
$parsed_files=new PCPIN_ParsedFiles($session);
$parsed_files->_db_getList();
$parsed=array();
foreach ($parsed_files->_db_list as $data) {
  $parsed[$data['checksum']]=$data['filename'];
}
$parsed_files->_db_freeList();

// Get files
$files=array();
if ($h=opendir('./')) {
  while ($filename=readdir($h)) {
    if ($filename!='.' && $filename!='..' && substr($filename, -4)=='.log') {
      $checksum=md5_file('./'.$filename);
      if (!isset($parsed[$checksum])) {
        $files[$filename]=$checksum;
      }
    }
  }
  closedir($h);
}
ksort($files);



// Parse each file
$parsed_games=0;
foreach ($files as $filename=>$checksum) {
  if ($h=fopen('./'.$filename, 'rb')) {
    // Store file before parsing it
    $parsed_files=new PCPIN_ParsedFiles($session);
    $parsed_files->filename=$filename;
    $parsed_files->checksum=$checksum;
    $parsed_files->_db_insertObj();
    // Parse file
    echo "Parsing file $filename ... ";
    $parser=new PCPIN_Parser($session);
    $parser->parseFile($h);
    fclose($h);
    $parsed_games+=$parser->parsed_games;
    // Delete parsed file
    @unlink('./'.$filename);
    echo "done!\n";
    flush();
  }
}


// Reload banned players from shrzubbot config file
$shrubbot_filename='./shrubbot.cfg';
if (file_exists($shrubbot_filename) && is_readable($shrubbot_filename)) {
  echo "Parsing shrubbot config file $shrubbot_filename ... ";
  $raw=file($shrubbot_filename);
  $shrub=array();
  $current_name='';
  $current_data=array();
  foreach ($raw as $line) {
    $line=trim($line);
    if ($line!='') {
      if (substr($line, 0, 1)=='[' && substr($line, -1)==']') {
        if ($current_name!='' && !empty($current_data)) {
          if (!isset($shrub[$current_name])) {
            $shrub[$current_name]=array();
          }
          $shrub[$current_name][]=$current_data;
        }
        $current_name=substr($line, 1, -1);
        $current_data=array();
      } else {
        $key=trim(substr($line, 0, strpos($line, '=')));
        $val=trim(substr($line, strpos($line, '=')+1));
        $current_data[$key]=$val;
      }
    }
  }
  if ($current_name!='' && !empty($current_data)) {
    if (!isset($shrub[$current_name])) {
      $shrub[$current_name]=array();
    }
    $shrub[$current_name][]=$current_data;
  }
  unset($raw);
  if (!empty($shrub['ban'])) {
    // Store new ban list
    $excludeguids=new PCPIN_ExcludeGUIDs($session);
    $excludeguids->deleteAllGUIDs();
    foreach ($shrub['ban'] as $data) {
      $excludeguids->addRecord($data['guid']);
    }
  }
  @unlink($shrubbot_filename);
  echo "done!\n";
}

// Clear cache
$cache=new PCPIN_Cache($session);
$cache->clearCache();

// Optimize/repair tables
$session->_db_cure();

$timer_stop=explode(' ', microtime());
$timer_stop=$timer_stop[0]+$timer_stop[1];
$timer=round($timer_stop-$timer_start, 2);


echo "Total files: ".count($files)." <br />\n";
echo "Total games: $parsed_games <br />\n";
echo "Total time: $timer seconds <br />\n";
echo date('Y-m-d H:i:s')."\tParser finished <br />\n";

?>