<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class PCPIN_Session
 * Manage sessions.
 * @author Konstantin Reznichak <k.reznichak@pcpin.com>
 * @copyright Copyright &copy; 2007, Konstantin Reznichak
 */
class PCPIN_Session extends PCPIN_Config {

  /**
   * Session ID
   * @var   string
   */
  var $_s_id='';

  /**
   * Client IP address
   * @var   string
   */
  var $_s_ip='';

  /**
   * Session createion time (MySQL DATETIME).
   * The time when the session has been created.
   * @var   string
   */
  var $_s_created='';

  /**
   * Time the session was last time renewed (MySQL DATETIME)
   * @var   string
   */
  var $_s_last_ping='';

  /**
   * Session language ID
   * @var   int
   */
  var $_s_language_id=0;

  /**
   * Session owner's user ID (if logged in)
   * @var   int
   */
  var $_s_user_id=0;

  /**
   * Client's browser name
   * @var   string
   */
  var $_s_client_agent_name='';

  /**
   * Client's browser version
   * @var   string
   */
  var $_s_client_agent_version='';

  /**
   * Client's OS version
   * @var   string
   */
  var $_s_client_os='';



  /**
   * Constructor. Initialize _Session class.
   * Check and update session, or create new one.
   * @param   object    &$config        Configuration and database connection handler
   */
  function PCPIN_Session(&$config) {
    // Initialize database layer and load configuration
    if (!is_object($config) || empty($config->_conf_all) || empty($config->_db_conn) || !is_resource($config->_db_conn)) {
      PCPIN_Common::dieWithError(1, '<b>Fatal error:</b> not allowed call of "'.__CLASS__.'" class');
    } else {
      $this->_db_pass_vars($config, $this, true);
    }
  }

  /**
   * Pass session vars to a child object
   */
  function _s_init(&$session, &$child) {
    if (!is_object($session) || empty($session->_conf_all) || empty($session->_db_conn) || !is_resource($session->_db_conn) && isset($session->_s_id)) {
      PCPIN_Common::dieWithError(1, '<b>Fatal error:</b> invalid call of "'.__CLASS__.'" class');
    } else {
      $this->_db_pass_vars($session, $child);
    }
  }


}
?>