<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * Class PCPIN_GameClientSuicide
 * Manage suicides
 * @author Konstantin Reznichak <k.reznichak@pcpin.com>
 * @copyright Copyright &copy; 2007, Konstantin Reznichak
 */
class PCPIN_GameClientSuicide extends PCPIN_Session {

  /**
   * Game ID
   * @var int
   */
  var $game_id=0;

  /**
   * GUID
   * @var string
   */
  var $guid='';

  /**
   * Team
   * @var int
   */
  var $team=0;

  /**
   * MOD (mean of death)
   * @var string
   */
  var $mod='';

  /**
   * Suicides count
   * @var int
   */
  var $count=0;



  /**
   * Constructor
   * @param   object  &$sessionhandler  Session handler
   */
  function PCPIN_GameClientSuicide(&$sessionhandler) {
    // Init object
    $this->_s_init($sessionhandler, $this);
  }


  /**
   * Store new record
   * @param   int       $game_id        Game ID
   * @param   string    $guid           GUID
   * @param   int       $team           Team
   * @param   string    $mod            MOD
   * @param   int       $count          Kills count
   */
  function addRecord($game_id, $guid, $team, $mod, $count) {
    $this->game_id=$game_id;
    $this->guid=$guid;
    $this->team=$team;
    $this->mod=$mod;
    $this->count=$count;
    $this->_db_insertObj();
  }


  /**
   * Get player's suicides count grouped by weapon
   * @param   string    $guid       GUID
   * @param   int       $game_id    Optional. Game ID
   * @return array
   */
  function getSuicidesWeapon($guid, $game_id=0) {
    $suicides=array();
    $query=$this->_db_makeQuery(1060, $guid, $game_id);
    $result=$this->_db_query($query);
    while ($data=$this->_db_fetch($result)) {
      $suicides[$data['MOD']]=$data['Count'];
    }
    $this->_db_freeResult($result);
    return $suicides;
  }


  /**
   * Get player's suicides count grouped by weapon and team
   * @param   int       $game_id    Game ID
   * @return array
   */
  function getSuicidesWeaponTeam($game_id) {
    $list=array();
    $query=$this->_db_makeQuery(1065, $game_id);
    $result=$this->_db_query($query);
    while ($data=$this->_db_fetch($result)) {
      $list[]=$data;
    }
    $this->_db_freeResult($result);
    return $list;
  }


  /**
   * Get suicides for all players for specified game
   * @param   int       $game_id      Game ID
   * @return array
   */
  function getSuicidesByTeam($game_id) {
    $suicides=array();
    if ($this->_db_getList('game_id = '.$game_id)) {
      $suicides=$this->_db_list;
      $this->_db_freeList();
    }
    return $suicides;
  }





}
?>