<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * Class PCPIN_GameClientRevive
 * Manage revives
 * @author Konstantin Reznichak <k.reznichak@pcpin.com>
 * @copyright Copyright &copy; 2007, Konstantin Reznichak
 */
class PCPIN_GameClientRevive extends PCPIN_Session {

  /**
   * Game ID
   * @var int
   */
  var $game_id=0;

  /**
   * Killer GUID
   * @var string
   */
  var $guid='';

  /**
   * Victim GUID
   * @var string
   */
  var $victim_guid='';

  /**
   * Team
   * @var int
   */
  var $team=0;

  /**
   * Kills count
   * @var int
   */
  var $count=0;



  /**
   * Constructor
   * @param   object  &$sessionhandler  Session handler
   */
  function PCPIN_GameClientRevive(&$sessionhandler) {
    // Init object
    $this->_s_init($sessionhandler, $this);
  }


  /**
   * Store new record
   * @param   int       $game_id        Game ID
   * @param   string    $guid           GUID
   * @param   string    $victim_guid    Victim GUID
   * @param   int       $team           Team
   * @param   int       $count          Kills count
   */
  function addRecord($game_id, $guid, $victim_guid, $team, $count) {
    $this->game_id=$game_id;
    $this->guid=$guid;
    $this->victim_guid=$victim_guid;
    $this->team=$team;
    $this->count=$count;
    $this->_db_insertObj();
  }


  /**
   * Get revives made by all players for specified game
   * @param   int       $game_id      Game ID
   * @return array
   */
  function getRevivesByTeam($game_id) {
    $revives=array();
    $query=$this->_db_makeQuery(1160, $game_id);
    $result=$this->_db_query($query);
    while ($data=$this->_db_fetch($result)) {
      $revives[]=$data;
    }
    $this->_db_freeResult($result);
    return $revives;
  }



}
?>