<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * Class PCPIN_GameClientMisc
 * Manage miscellaneous data
 * @author Konstantin Reznichak <k.reznichak@pcpin.com>
 * @copyright Copyright &copy; 2007, Konstantin Reznichak
 */
class PCPIN_GameClientMisc extends PCPIN_Session {

  /**
   * Game ID
   * @var int
   */
  var $game_id=0;

  /**
   * Killer GUID
   * @var string
   */
  var $guid='';

  /**
   * Team
   * @var int
   */
  var $team=0;

  /**
   * Dynamite plants count
   * @var int
   */
  var $dynamite_plant=0;

  /**
   * Dynamite diffuses count
   * @var int
   */
  var $dynamite_diffuse=0;

  /**
   * Repairs count
   * @var int
   */
  var $repairs=0;

  /**
   * Disguises count
   * @var int
   */
  var $disguises=0;

  /**
   * Taken objectives count
   * @var int
   */
  var $objectives_taken=0;



  /**
   * Constructor
   * @param   object  &$sessionhandler  Session handler
   */
  function PCPIN_GameClientMisc(&$sessionhandler) {
    // Init object
    $this->_s_init($sessionhandler, $this);
  }


  /**
   * Store new record
   * @param   int       $game_id          Game ID
   * @param   string    $guid             GUID
   * @param   int       $team             Team
   * @param   int       $dynamite_plant
   * @param   int       $dynamite_diffuse
   * @param   int       $repairs
   * @param   int       $disguises
   * @param   int       $objectives_taken
   */
  function addRecord($game_id, $guid, $team, $dynamite_plant, $dynamite_diffuse, $repairs, $disguises, $objectives_taken) {
    $this->game_id=$game_id;
    $this->guid=$guid;
    $this->team=$team;
    $this->dynamite_plant=$dynamite_plant;
    $this->dynamite_diffuse=$dynamite_diffuse;
    $this->repairs=$repairs;
    $this->disguises=$disguises;
    $this->objectives_taken=$objectives_taken;
    $this->_db_insertObj();
  }


  /**
   * Get misc stats for specified game count grouped by GUID and team
   * @param   int     $game_id    Game ID
   * @return array
   */
  function getMiscTeam($game_id) {
    $misc=array();
    $query=$this->_db_makeQuery(1150, $game_id);
    $result=$this->_db_query($query);
    while ($data=$this->_db_fetch($result)) {
      $misc[]=$data;
    }
    $this->_db_freeResult($result);
    return $misc;
  }




}
?>