<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * Class PCPIN_GameClientDamage
 * Manage damage stats
 * @author Konstantin Reznichak <k.reznichak@pcpin.com>
 * @copyright Copyright &copy; 2007, Konstantin Reznichak
 */
class PCPIN_GameClientDamage extends PCPIN_Session {

  /**
   * GUID
   * @var string
   */
  var $guid='';

  /**
   * Damage given
   * @var int
   */
  var $damage_given=0;

  /**
   * Damage received
   * @var int
   */
  var $damage_received=0;

  /**
   * Team damage
   * @var int
   */
  var $team_damage=0;



  /**
   * Constructor
   * @param   object  &$sessionhandler  Session handler
   */
  function PCPIN_GameClientDamage(&$sessionhandler) {
    // Init object
    $this->_s_init($sessionhandler, $this);
  }


  /**
   * Store new record
   * @param   string    $guid             GUID
   * @param   int       $damage_given     Damage given
   * @param   int       $damage_received  Damage received
   * @param   int       $team_damage      Team damage
   */
  function addRecord($guid, $damage_given, $damage_received, $team_damage) {
    $this->guid=$guid;
    $this->damage_given=0;
    $this->damage_received=0;
    $this->team_damage=0;
    if ($this->_db_getList('guid = '.$guid, 1)) {
      $this->_db_setObject($this->_db_list[0]);
      $this->_db_freeList();
      $this->_db_deleteRow($guid, 'guid');
    }
    $this->damage_given+=$damage_given;
    $this->damage_received+=$damage_received;
    $this->team_damage+=$team_damage;
    $this->_db_insertObj();
  }


}
?>