<?php
/**
 *    This file is part of "Liberty Gaming NQ Stats Analyzer".
 *
 *    "Liberty Gaming NQ Stats Analyzer" is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    "Liberty Gaming NQ Stats Analyzer" is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class PCPIN_ClientName
 * Manage names used by clients
 * @author Konstantin Reznichak <k.reznichak@pcpin.com>
 * @copyright Copyright &copy; 2007, Konstantin Reznichak
 */
class PCPIN_ClientName extends PCPIN_Session {

  /**
   * Game ID
   * @var int
   */
  var $game_id=0;

  /**
   * GUID
   * @var string
   */
  var $guid='';

  /**
   * Name with color tags
   * @var string
   */
  var $name='';

  /**
   * Name without color tags
   * @var string
   */
  var $name_txt='';

  /**
   * Flag: "y" if name was used in the last game (must be unique for every GUID)
   * @var string
   */
  var $last_used='';



  /**
   * Constructor
   * @param   object  &$sessionhandler  Session handler
   */
  function PCPIN_ClientName(&$sessionhandler) {
    // Init object
    $this->_s_init($sessionhandler, $this);
  }


  /**
   * Store new client name record
   * @param   int       $game_id    Game ID
   * @param   string    $guid       GUID
   * @param   string    $name       Name
   */
  function addNameRecord($game_id, $guid, $name) {
    $this->game_id=$game_id;
    $this->guid=$guid;
    $this->name=$name;
    $this->name_txt=coloredToPlain($name, false);
    if ($this->_db_getList('guid = '.$guid, 'last_used = y', 1)) {
      $this->_db_freeList();
      $this->_db_deleteRowMultiCond(array('guid'=>$guid, 'last_used'=>'y'));
      $this->last_used='n';
      $this->_db_insertObj();
    }
    $this->last_used='y';
    $this->_db_insertObj();
  }


  /**
   * Get names used by client
   * @param   string    $guid   GUID
   * @return array
   */
  function getUsedNames($guid) {
    $names=array();
    $query=$this->_db_makeQuery(1020, $guid);
    $result=$this->_db_query($query);
    while ($data=$this->_db_fetch($result)) {
      $names[]=$data;
    }
    $this->_db_freeResult($result);
    return $names;
  }


}
?>