/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

class gravyStats {
    static String appName = "gravystats";
    static String version = "0.10";
    String logfileName = "etconsole.log";
    File logfile;
    File outputDirectory;
    File includeDirectory;
    JFrame window;
    static JTextArea output_textarea;
    static JTextArea debug_textarea;
    Pattern logfileOpenedEvent;
    Pattern enteredGameEvent;
    Pattern joinedTeamEvent;
    Pattern renamedEvent;
    Pattern teamKillEvent;
    Pattern generickillEvent;
    Pattern landmineKillEvent;
    Pattern mortarKillEvent;
    Pattern slashKillEvent;
    Pattern suicideEvent;
    Pattern mm1Event;
    Pattern matchPausedEvent;
    Pattern matchUnpausedEvent;
    Pattern etProRoundResetEvent;
    Pattern round1End1Event;
    Pattern round2End1Event;
    Pattern round2End2Event;
    Pattern mapNameEvent;
    Pattern mapNameEvent2;
    Pattern statlineEvent;
    Round currentRound;
    Round firstRound;
    Game currentGame;
    Game firstGame;
    PlayerList players_global = new PlayerList();
    PlayerList team1_global = new PlayerList();
    PlayerList team2_global = new PlayerList();
    PlayerList teamunknown_global = new PlayerList();
    int[] score = new int[3];
    int[] weaponStats_global = new int[MeansOfDeath.num_mod];
    Matcher m;
    Date logDate;
    String currentLoadedMap;
    static String[] args;
    static boolean debug;
    long starttime;
    HashMap debug_times = new HashMap();
    int debug_id = 1;
    Round lastBuiltRound;
    boolean firstrealround = true;
    ArrayList awards = new ArrayList();
    static String newline;
    DecimalFormat twoDecimalPlaces = new DecimalFormat("0.00");
    DecimalFormat noDecimalPlaces = new DecimalFormat("0");
    int sortable_table_num = 1;

    public static void main(String[] args) {
        gravyStats.args = args;
        new gravyStats();
    }

    public gravyStats() {
        try {
            this.initialise();
            this.parseLogFile();
            this.buildGames();
            this.processRounds();
            this.processGames();
            this.generateAwards();
            this.writeHTML();
            this.stdout("complete");
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            this.stdout("ERROR: " + e.getMessage());
            StackTraceElement[] ste = e.getStackTrace();
            for (int i = 0; i < ste.length; ++i) {
                this.stdout("  " + ste[i].toString());
            }
            e.printStackTrace();
        }
    }

    public int debug_processingTime_start() {
        this.starttime = System.currentTimeMillis();
        this.debug_times.put(new Integer(this.debug_id), new Long(this.starttime));
        return this.debug_id++;
    }

    public long debug_processingTime_end(int id) {
        this.starttime = (Long)this.debug_times.get(new Integer(id));
        return System.currentTimeMillis() - this.starttime;
    }

    public static void debug(String s) {
        if (debug && debug_textarea != null) {
            debug_textarea.append(s + newline);
        }
    }

    public void stdout(String s) {
        if (output_textarea != null) {
            output_textarea.append(s + newline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() throws Exception {
        int debug_initialise = this.debug_processingTime_start();
        this.process_arguments();
        this.initialise_GUI();
        this.logfile = new File(this.logfileName);
        if (!this.logfile.exists() || !this.logfile.isFile()) {
            throw new Exception("Could not locate logfile");
        }
        this.outputDirectory = new File("gravystats");
        if (!(this.outputDirectory.exists() && this.outputDirectory.isDirectory() || this.outputDirectory.mkdir())) {
            throw new Exception("Could not create output directory");
        }
        this.includeDirectory = new File(this.outputDirectory.getCanonicalPath() + File.separator + "include");
        if (!(this.includeDirectory.exists() && this.includeDirectory.isDirectory() || this.includeDirectory.mkdir())) {
            throw new Exception("Could not create include directory");
        }
        File zipfile = new File("gravystats.jar");
        if (!zipfile.exists() || !zipfile.isFile()) {
            this.stdout("WARNING: Could not locate jar file. Skipping file extraction");
        } else {
            gravyStats.debug("checking resources");
            ZipFile zip = new ZipFile(zipfile);
            try {
                String js = "gravystats/include/gravy.js";
                String css = "gravystats/include/gravy.css";
                if (!new File(js).exists()) {
                    this.extractResource(zip, js);
                }
                if (!new File(css).exists()) {
                    this.extractResource(zip, css);
                }
            }
            finally {
                zip.close();
                gravyStats.debug("jar file closed.");
            }
        }
        this.initialisePatterns();
        gravyStats.debug("initialisation completed in... " + this.debug_processingTime_end(debug_initialise) + newline);
    }

    public void process_arguments() {
        int argcount = args.length;
        for (int argnum = 0; argnum < argcount; ++argnum) {
            if (args[argnum].equals("-debug")) {
                debug = true;
            }
            if (!args[argnum].equals("-log") || ++argnum >= argcount) continue;
            this.logfileName = args[argnum];
        }
    }

    public void initialise_GUI() throws Exception {
        this.window = new JFrame(appName + " " + version);
        output_textarea = new JTextArea();
        output_textarea.setEditable(false);
        JScrollPane output_scroller = new JScrollPane(output_textarea);
        output_scroller.setPreferredSize(new Dimension(410, 150));
        output_scroller.setBorder(new LineBorder(Color.BLUE));
        if (debug) {
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab("output", output_scroller);
            debug_textarea = new JTextArea();
            debug_textarea.setEditable(false);
            JScrollPane debug_scroller = new JScrollPane(debug_textarea);
            debug_scroller.setPreferredSize(new Dimension(410, 150));
            tabs.addTab("debug", debug_scroller);
            this.window.getContentPane().add((Component)tabs, "Center");
        } else {
            this.window.getContentPane().add((Component)output_scroller, "Center");
        }
        this.window.setDefaultCloseOperation(3);
        this.window.pack();
        this.window.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractResource(ZipFile zip, String file) {
        block11: {
            if (zip == null || file == null) {
                return;
            }
            try {
                gravyStats.debug("trying to extract " + file + " from " + zip);
                ZipEntry entry = zip.getEntry(file);
                if (entry != null) {
                    gravyStats.debug("found");
                    InputStream entryStream = zip.getInputStream(entry);
                    try {
                        FileOutputStream fileout = new FileOutputStream(entry.getName());
                        try {
                            int bytesRead;
                            byte[] buffer = new byte[1024];
                            while ((bytesRead = entryStream.read(buffer)) != -1) {
                                fileout.write(buffer, 0, bytesRead);
                            }
                            gravyStats.debug("success!");
                            break block11;
                        }
                        finally {
                            fileout.close();
                        }
                    }
                    finally {
                        entryStream.close();
                    }
                }
                gravyStats.debug("not found.");
            }
            catch (IOException ioe) {
                gravyStats.debug("extraction of " + file + " from " + zip + " failed");
                gravyStats.debug(ioe.toString());
                this.stdout("WARNING: couldnt extract " + file);
            }
        }
    }

    public void initialisePatterns() {
        this.logfileOpenedEvent = Pattern.compile("^logfile opened on (.+)$");
        this.enteredGameEvent = Pattern.compile("^\\[skipnotify\\](.+)\\^7 entered the game$");
        this.joinedTeamEvent = Pattern.compile("^(.+)\\^7 has joined the (.+)\\^7!$");
        this.renamedEvent = Pattern.compile("^\\[skipnotify\\](.+)\\^7 renamed to (.+)$");
        this.teamKillEvent = Pattern.compile("^\\^1TEAM KILL\\^7: (.+)$");
        this.generickillEvent = Pattern.compile("^(.+)\\^7 (was .+ by) (.+)\\^7's (.+)$");
        this.landmineKillEvent = Pattern.compile("^(.+)\\^7 (failed to spot) (.+)\\^7's (Landmine)$");
        this.mortarKillEvent = Pattern.compile("^(.+)\\^7 (never saw) (.+)\\^7's (mortar round coming)$");
        this.slashKillEvent = Pattern.compile("^(.+)\\^7 killed himself.$");
        this.suicideEvent = Pattern.compile("^(.+)\\^7 (dove on his own grenade|ate his own rifle grenade|dynamited himself to pieces|failed to spot his own landmine|vaporized himself|played with fire|never saw his own mortar round coming|ate his own artillery fire|obliterated himself|danced on his airstrike marker|embraced his own satchel explosion|engineered himself into oblivion|fell to his death|was crushed|drowned|was killed to death)\\.$");
        this.mm1Event = Pattern.compile("^(.+)\\^7: \\^2(.+)$");
        this.matchPausedEvent = Pattern.compile("^\\[skipnotify\\]\\*\\*\\* \\^3INFO: \\^5\\^3Match is \\^1PAUSED\\^3! \\(\\^\\d(\\w+)\\^7\\^3\\)$");
        this.matchUnpausedEvent = Pattern.compile("^\\^3Match is \\^5UNPAUSED\\^3 \\.\\.\\. resuming in 10 seconds!$");
        this.etProRoundResetEvent = Pattern.compile("^\\[skipnotify\\]etpro: Server version (.+)$");
        this.round1End1Event = Pattern.compile("^\\[skipnotify\\]>>> \\^3Clock set to: (.+)$");
        this.round2End1Event = Pattern.compile("^\\[skipnotify\\]>>> \\^3Objective reached at (.+) \\(original: (.+)\\)$");
        this.round2End2Event = Pattern.compile("^\\[skipnotify\\]>>> \\^3Objective NOT reached in time \\((.+)\\)$");
        this.mapNameEvent = Pattern.compile("^\\^3>>> Map: \\^2(.+)$");
        this.mapNameEvent2 = Pattern.compile("^LOADING\\.\\.\\. maps/(.+)\\.bsp$");
        this.statlineEvent = Pattern.compile("^\\[skipnotify\\]\\^\\d(.+)\\^7\\s*\\^\\d(.+?)\\s*\\^3\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\^\\d\\s+(\\d+)\\^\\d\\s+(\\d+)\\^\\d\\s+(\\d+)\\^\\d\\s+(\\d+)\\^\\d\\s+(\\d+)\\^\\d\\s+(\\d+)$");
    }

    public void parseLogFile() throws Exception {
        String nextLine;
        int debug_parseLogFile = this.debug_processingTime_start();
        gravyStats.debug("parsing...");
        this.stdout("Opening logfile...");
        BufferedReader br = new BufferedReader(new FileReader(this.logfileName));
        this.firstRound = this.currentRound = new Round();
        int lineCount = 0;
        while ((nextLine = br.readLine()) != null) {
            this.parseLine(nextLine);
            ++lineCount;
        }
        br.close();
        this.stdout(lineCount + " lines read");
        gravyStats.debug("parsing completed in... " + this.debug_processingTime_end(debug_parseLogFile) + newline);
    }

    public boolean parseLine(String line) throws Exception {
        String player1;
        if (line.startsWith("GL_EXTENSIONS:")) {
            return true;
        }
        if (line.equals("Match starting...")) {
            this.currentRound.roundType = (short)3;
            return true;
        }
        if (line.equals("[skipnotify]^1FIGHT!")) {
            if (this.currentRound.roundType == 0) {
                this.currentRound.roundType = (short)4;
            }
            return true;
        }
        if (line.equals("[skipnotify]Timelimit hit.")) {
            this.currentRound.timelimitHit = true;
            return true;
        }
        this.m = this.enteredGameEvent.matcher(line);
        if (this.m.find()) {
            String name = this.m.group(1);
            this.currentRound.eventList.add(new ParsedEvent(6, name, null, null, null, false));
            return true;
        }
        this.m = this.mapNameEvent.matcher(line);
        if (this.m.find()) {
            if (!this.currentRound.mapname.equals(this.m.group(1))) {
                this.stdout("WARNING: end of round map name - " + this.m.group(1) + " - overriding loaded map name - " + this.currentRound.mapname);
            }
            this.currentRound.mapname = this.m.group(1);
        }
        if ((this.m = this.mapNameEvent2.matcher(line)).find()) {
            if (this.currentLoadedMap == null) {
                this.currentRound.mapname = this.currentLoadedMap = this.m.group(1);
            } else {
                this.currentLoadedMap = this.m.group(1);
            }
            gravyStats.debug("current map set to " + this.currentLoadedMap);
        }
        if ((this.m = this.logfileOpenedEvent.matcher(line)).find()) {
            String s = this.m.group(1);
            SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
            if (this.logDate == null) {
                this.logDate = df.parse(s);
            }
        }
        if ((this.m = this.etProRoundResetEvent.matcher(line)).find()) {
            Round newRound;
            this.currentRound.nextRound = newRound = new Round();
            newRound.prevRound = this.currentRound;
            this.currentRound = newRound;
            this.currentRound.mapname = this.currentLoadedMap;
            return true;
        }
        this.m = this.round1End1Event.matcher(line);
        if (this.m.find()) {
            this.currentRound.roundTime = this.m.group(1);
            this.currentRound.roundType = 1;
            return true;
        }
        this.m = this.round2End1Event.matcher(line);
        if (this.m.find()) {
            this.currentRound.roundTime = this.m.group(1);
            this.currentRound.roundType = (short)2;
            return true;
        }
        this.m = this.round2End2Event.matcher(line);
        if (this.m.find()) {
            this.currentRound.roundTime = this.m.group(1);
            this.currentRound.roundType = (short)2;
            return true;
        }
        this.m = this.renamedEvent.matcher(line);
        if (this.m.find()) {
            String oldName = this.m.group(1);
            String newName = this.m.group(2);
            boolean found = false;
            this.currentRound.eventList.add(new ParsedEvent(1, oldName, newName, "", "", false));
            return true;
        }
        boolean wasTK = false;
        this.m = this.teamKillEvent.matcher(line);
        if (this.m.find()) {
            line = this.m.group(1);
            wasTK = true;
        }
        if ((this.m = this.generickillEvent.matcher(line)).find()) {
            player1 = this.m.group(1);
            String method1 = this.m.group(2);
            String player2 = this.m.group(3);
            String method2 = this.m.group(4);
            this.currentRound.eventList.add(new ParsedEvent(2, player1, player2, method1, method2, wasTK));
            return true;
        }
        this.m = this.landmineKillEvent.matcher(line);
        if (this.m.find()) {
            player1 = this.m.group(1);
            String method1 = this.m.group(2);
            String player2 = this.m.group(3);
            String method2 = this.m.group(4);
            this.currentRound.eventList.add(new ParsedEvent(2, player1, player2, method1, method2, wasTK));
            return true;
        }
        this.m = this.mortarKillEvent.matcher(line);
        if (this.m.find()) {
            player1 = this.m.group(1);
            String method1 = this.m.group(2);
            String player2 = this.m.group(3);
            String method2 = this.m.group(4);
            this.currentRound.eventList.add(new ParsedEvent(2, player1, player2, method1, method2, wasTK));
            return true;
        }
        this.m = this.slashKillEvent.matcher(line);
        if (this.m.find()) {
            player1 = this.m.group(1);
            this.currentRound.eventList.add(new ParsedEvent(3, player1, null, null, null, false));
            return true;
        }
        this.m = this.suicideEvent.matcher(line);
        if (this.m.find()) {
            player1 = this.m.group(1);
            String method1 = this.m.group(2);
            this.currentRound.eventList.add(new ParsedEvent(4, player1, null, method1, null, false));
            return true;
        }
        this.m = this.mm1Event.matcher(line);
        if (this.m.find()) {
            this.currentRound.mm1.add(line);
            String name = this.m.group(1);
            this.currentRound.eventList.add(new ParsedEvent(7, name, null, null, null, false));
            return true;
        }
        this.m = this.matchPausedEvent.matcher(line);
        if (this.m.find()) {
            String team = this.m.group(1);
            this.currentRound.mm1.add(team + " PAUSED THE MATCH");
            return true;
        }
        this.m = this.matchUnpausedEvent.matcher(line);
        if (this.m.find()) {
            this.currentRound.mm1.add("Match Resuming in 10 seconds");
            return true;
        }
        this.m = this.statlineEvent.matcher(line);
        if (this.m.find()) {
            boolean found = false;
            this.currentRound.eventList.add(new ParsedEvent(5, this.m.group(2), null, line, null, false));
            return true;
        }
        return false;
    }

    public void buildGames() throws Exception {
        int debug_buildGames = this.debug_processingTime_start();
        gravyStats.debug("building games...");
        Round prRound = this.firstRound;
        int roundNumber = 1;
        while (prRound != null) {
            gravyStats.debug("round number " + roundNumber + " type " + prRound.roundType + ", map " + prRound.mapname + ", time " + prRound.roundTime + ", events " + prRound.eventList.size());
            if (prRound.eventList.size() == 0) {
                gravyStats.debug("round " + roundNumber + " - no events found, dumped");
                prRound.roundType = (short)5;
            } else if (!prRound.createsPlayers()) {
                gravyStats.debug("round " + roundNumber + " - " + prRound.eventList.size() + " events but no players! dumped");
                prRound.roundType = (short)5;
            }
            if (prRound.roundType == 0) {
                gravyStats.debug("round " + roundNumber + " - unknown round type found");
            }
            if (prRound.roundType == 4) {
                gravyStats.debug("round " + roundNumber + " - active round type found...");
                boolean found = false;
                Round temp = prRound.prevRound;
                while (temp != null && !found) {
                    if (temp.roundType == 1) {
                        if (!prRound.mapname.equals(temp.mapname)) {
                            prRound.roundType = 1;
                            gravyStats.debug("Previous active round was round1, but map names arent equal! Setting round1");
                            found = true;
                            break;
                        }
                        prRound.roundType = (short)2;
                        gravyStats.debug("Previous active round was round1, setting round2");
                        found = true;
                        break;
                    }
                    if (temp.roundType == 2) {
                        prRound.roundType = 1;
                        gravyStats.debug("Previous active round was round2, setting 1");
                        found = true;
                        break;
                    }
                    if (temp.prevRound != null) {
                        temp = temp.prevRound;
                        continue;
                    }
                    found = true;
                    gravyStats.debug("looking for previous active round to make a guess - not found! assume 1");
                    prRound.roundType = 1;
                }
            }
            if (prRound.roundType == 1) {
                if (this.firstGame == null) {
                    this.firstGame = this.currentGame = new Game();
                } else {
                    Game g;
                    this.currentGame.nextGame = g = new Game();
                    g.prevGame = this.currentGame;
                    this.currentGame = g;
                }
                this.currentGame.round1 = prRound;
                prRound.parentGame = this.currentGame;
            }
            if (prRound.roundType == 2) {
                if (this.firstGame == null) {
                    this.firstGame = this.currentGame = new Game();
                }
                this.currentGame.round2 = prRound;
                prRound.parentGame = this.currentGame;
            }
            prRound = prRound.nextRound;
            ++roundNumber;
        }
        if (this.firstGame == null) {
            gravyStats.debug("first game is null, trying to fix...");
            if (this.firstRound.roundType == 0 && this.firstRound.nextRound == null) {
                this.firstRound.roundType = 1;
                this.firstGame = this.currentGame = new Game();
                this.currentGame.round1 = this.firstRound;
                this.firstRound.parentGame = this.currentGame;
                gravyStats.debug("rectified");
            } else {
                throw new Exception("couldnt create game :(");
            }
        }
        gravyStats.debug("building games completed in... " + this.debug_processingTime_end(debug_buildGames) + newline);
    }

    public void processRounds() throws Exception {
        int debug_processRounds = this.debug_processingTime_start();
        gravyStats.debug("processing rounds...");
        Round prRound = this.firstRound;
        int roundNumber = 1;
        while (prRound != null) {
            this.processEvents(prRound);
            this.processEvents2(prRound);
            gravyStats.debug("round " + roundNumber + ", map " + prRound.mapname + ", time " + prRound.roundTime + ", players " + prRound.playersInRound.size() + ", events " + prRound.eventList.size());
            if (prRound.roundType == 1 || prRound.roundType == 2) {
                this.buildTeamsForRound(prRound);
                if (prRound.roundType == 2) {
                    this.subtractRound1Stats(prRound);
                }
                this.buildRoundStats(prRound);
                this.updateGlobalPlayers(prRound);
                this.updateGlobalTeams(prRound);
            }
            prRound = prRound.nextRound;
            ++roundNumber;
        }
        gravyStats.debug("processing rounds completed in... " + this.debug_processingTime_end(debug_processRounds) + newline);
    }

    public void processEvents(Round prRound) {
        Iterator i = prRound.eventList.iterator();
        block8: while (i.hasNext()) {
            ParsedEvent event = (ParsedEvent)i.next();
            switch (event.eventType) {
                case 1: {
                    String oldName = event.player1;
                    String newName = event.player2;
                    Player p1 = prRound.getPlayer(oldName, 0, false);
                    Player p2 = prRound.getPlayer(newName, 0, false);
                    if (p1 != null && p2 == null) {
                        p1.rename(newName, 0);
                    }
                    Player p1_global = this.players_global.getPlayer(oldName, 0, false);
                    Player p2_global = this.players_global.getPlayer(newName, 0, false);
                    if (p1_global == null || p2_global != null) break;
                    p1_global.rename(newName, 0);
                    break;
                }
                case 2: {
                    if (prRound.roundType != 1 && prRound.roundType != 2) break;
                    this.processKillEvent(prRound, event);
                    break;
                }
                case 3: {
                    if (prRound.roundType != 1 && prRound.roundType != 2) break;
                    String name = event.player1;
                    Player p1 = prRound.getPlayer(name, 1, true);
                    ++p1.stats.slashkills;
                    p1.killEvents.add(event);
                    p1.stats.nullStreak();
                    break;
                }
                case 4: {
                    if (prRound.roundType != 1 && prRound.roundType != 2) break;
                    String name = event.player1;
                    String means = event.method1;
                    Player p1 = prRound.getPlayer(name, 1, true);
                    ++p1.stats.suicides;
                    p1.killEvents.add(event);
                    p1.stats.deathStreak();
                    boolean found = false;
                    for (int j = 0; j < MeansOfDeath.num_mod; ++j) {
                        MeansOfDeath m = MeansOfDeath.mod[j];
                        if (m.suicideString == null || !m.suicideString.equals(means)) continue;
                        event.mod = m;
                        found = true;
                        break;
                    }
                    if (found) continue block8;
                    event.mod = MeansOfDeath.mod_unknown;
                    gravyStats.debug("means of suicide not found " + means);
                    break;
                }
                case 5: {
                    String line = event.method1;
                    this.m = this.statlineEvent.matcher(line);
                    if (!this.m.find()) break;
                    String name = event.player1;
                    Player p1 = prRound.getPlayer(name, 2, false);
                    if (p1 != null) {
                        String team = this.m.group(1);
                        if (team.equals("Allies")) {
                            p1.team = 1;
                        } else if (team.equals("Axis")) {
                            p1.team = 2;
                        }
                        p1.stats.gibs = Integer.parseInt(this.m.group(8));
                        p1.stats.damageGiven = Integer.parseInt(this.m.group(9));
                        p1.stats.damageReceived = Integer.parseInt(this.m.group(10));
                        p1.stats.teamDamage = Integer.parseInt(this.m.group(11));
                        p1.stats.xp = Integer.parseInt(this.m.group(12));
                        break;
                    }
                    gravyStats.debug("player not found for stat line event: " + name);
                    break;
                }
                case 7: {
                    String name = event.player1;
                    Player p1 = prRound.getPlayer(name, 0, false);
                    Player p2 = this.players_global.getPlayer(name, 0, false);
                    if (p1 != null) {
                        ++p1.stats.mm1count;
                    }
                    if (p2 == null) break;
                    ++p2.stats.mm1count;
                }
            }
        }
    }

    public void processEvents2(Round prRound) {
        Iterator i = prRound.eventList.iterator();
        while (i.hasNext()) {
            ParsedEvent event = (ParsedEvent)i.next();
            switch (event.eventType) {
                case 6: {
                    String name = event.player1;
                    prRound.getPlayer(name, 0, false);
                    this.players_global.getPlayer(name, 0, false);
                }
            }
        }
    }

    public void processKillEvent(Round round, ParsedEvent event) {
        boolean p2_hasteam;
        String player1 = event.player1;
        String player2 = event.player2;
        String method1 = event.method1;
        String method2 = event.method2;
        boolean wasTK = event.wasTK;
        Player p1 = round.getPlayer(player1, 1, true);
        Player p2 = round.getPlayer(player2, 1, true);
        Player p1_global = this.players_global.getPlayer(player1, 1, true);
        Player p2_global = this.players_global.getPlayer(player2, 1, true);
        p1.killEvents.add(event);
        p2.killEvents.add(event);
        boolean p1_hasteam = p1.team == 1 || p1.team == 2;
        boolean bl = p2_hasteam = p2.team == 1 || p2.team == 2;
        if (!wasTK) {
            ++p1.stats.deaths;
            p1.stats.deathStreak();
            ++p2.stats.kills;
            p2.stats.killStreak();
            if (p2_global.stats.killedPlayer.containsKey(p1_global)) {
                p2_global.stats.killedPlayer.put(p1_global, new Integer((Integer)p2_global.stats.killedPlayer.get(p1_global) + 1));
            } else {
                p2_global.stats.killedPlayer.put(p1_global, new Integer(1));
            }
            p1.addEnemy(p2);
            p2.addEnemy(p1);
            boolean found = false;
            for (int i = 0; i < MeansOfDeath.num_mod; ++i) {
                MeansOfDeath m = MeansOfDeath.mod[i];
                if (m.weaponString == null || !m.weaponString.equals(method2) || m.methodString == null || !m.methodString.equals(method1)) continue;
                int[] nArray = p2.stats.weaponStats[0];
                int n = i;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = p1.stats.weaponStats[1];
                int n2 = i;
                nArray2[n2] = nArray2[n2] + 1;
                event.mod = m;
                found = true;
                break;
            }
            if (!found) {
                event.mod = MeansOfDeath.mod_unknown;
                gravyStats.debug("means of death not found " + method1 + " - " + method2);
            }
            if (p1_hasteam && !p2_hasteam) {
                if (p1.team == 1) {
                    p2.team = 2;
                } else if (p1.team == 2) {
                    p2.team = 1;
                } else {
                    gravyStats.debug("wtf " + p1.team);
                }
            }
            if (p2_hasteam && !p1_hasteam) {
                if (p2.team == 1) {
                    p1.team = 2;
                } else if (p2.team == 2) {
                    p1.team = 1;
                } else {
                    gravyStats.debug("wtf " + p2.team);
                }
            }
        } else {
            ++p1.stats.teamdeaths;
            ++p2.stats.teamkills;
            if (p2_global.stats.teamKilledPlayer.containsKey(p1_global)) {
                p2_global.stats.teamKilledPlayer.put(p1_global, new Integer((Integer)p2_global.stats.teamKilledPlayer.get(p1_global) + 1));
            } else {
                p2_global.stats.teamKilledPlayer.put(p1_global, new Integer(1));
            }
            p1.addTeammate(p2);
            p2.addTeammate(p1);
            boolean found = false;
            for (int i = 0; i < MeansOfDeath.num_mod; ++i) {
                MeansOfDeath m = MeansOfDeath.mod[i];
                if (m.weaponString == null || !m.weaponString.equals(method2) || m.methodString == null || !m.methodString.equals(method1)) continue;
                event.mod = m;
                found = true;
                break;
            }
            if (!found) {
                event.mod = MeansOfDeath.mod_unknown;
                gravyStats.debug("means of death not found " + method1 + " - " + method2);
            }
            if (p1_hasteam && !p2_hasteam) {
                if (p1.team == 1) {
                    p2.team = 1;
                } else if (p1.team == 2) {
                    p2.team = 2;
                } else {
                    gravyStats.debug("wtf " + p1.team);
                }
            }
            if (p2_hasteam && !p1_hasteam) {
                if (p2.team == 1) {
                    p1.team = 1;
                } else if (p2.team == 2) {
                    p1.team = 2;
                } else {
                    gravyStats.debug("wtf " + p2.team);
                }
            }
        }
    }

    public void buildTeamsForRound(Round prRound) {
        prRound.populateTeams();
        if (prRound.team1.isEmpty() && prRound.team2.isEmpty()) {
            Player temp;
            prRound.noTeamInformation = true;
            if (this.lastBuiltRound != null) {
                temp = (Player)prRound.teamunknown.get(0);
                gravyStats.debug("***** grabbed " + temp.getName());
                Player prev = this.lastBuiltRound.getPlayer(temp.getName(), 0, false, false);
                if (prev != null) {
                    gravyStats.debug("found in previous round");
                    if (prev.team == 1) {
                        gravyStats.debug("was on team 1");
                        if (prRound.roundType == 1) {
                            gravyStats.debug("this round is 1, so add player to team1");
                            prRound.team1.add(temp);
                        } else {
                            gravyStats.debug("this round is 2, so add player to team2");
                            prRound.team2.add(temp);
                        }
                    } else if (prev.team == 2) {
                        gravyStats.debug("was on team 2");
                        if (prRound.roundType == 1) {
                            gravyStats.debug("this round is 1, so add player to team2");
                            prRound.team2.add(temp);
                        } else {
                            gravyStats.debug("this round is 2, so add player to team1");
                            prRound.team1.add(temp);
                        }
                    } else {
                        gravyStats.debug("previous player had no team :(");
                        prRound.team1.add(temp);
                        prRound.teamunknown.remove(temp);
                    }
                } else {
                    gravyStats.debug("not found in previous round");
                    prRound.team1.add(temp);
                    prRound.teamunknown.remove(temp);
                }
            } else {
                gravyStats.debug("No team information found! Shoving a random player onto allies");
                temp = (Player)prRound.teamunknown.get(0);
                prRound.team1.add(temp);
                prRound.teamunknown.remove(temp);
                gravyStats.debug("***** grabbed " + temp.getName());
            }
        }
        int unknown_count = prRound.teamunknown.size();
        while (unknown_count > 0) {
            gravyStats.debug(unknown_count + " players with unknown teams");
            this.fillInTeams(prRound);
            if (prRound.teamunknown.size() == unknown_count) {
                gravyStats.debug("none found with " + unknown_count + " remaining");
                break;
            }
            int diff = unknown_count - prRound.teamunknown.size();
            unknown_count = prRound.teamunknown.size();
            gravyStats.debug(diff + " found, " + unknown_count + " remaining");
        }
        this.lastBuiltRound = prRound;
    }

    public void fillInTeams(Round prRound) {
        ArrayList<Player> teamFound = new ArrayList<Player>();
        Iterator i = prRound.teamunknown.iterator();
        while (i.hasNext()) {
            Player p_test;
            Player p_unknown = (Player)i.next();
            boolean found = false;
            Iterator j = prRound.team1.iterator();
            while (j.hasNext()) {
                p_test = (Player)j.next();
                if (p_test.isTeammate(p_unknown) && !p_test.isEnemy(p_unknown)) {
                    prRound.team1.add(p_unknown);
                    p_unknown.team = 1;
                    found = true;
                    break;
                }
                if (!p_test.isEnemy(p_unknown) || p_test.isTeammate(p_unknown)) continue;
                prRound.team2.add(p_unknown);
                p_unknown.team = 2;
                found = true;
                break;
            }
            if (found) {
                teamFound.add(p_unknown);
                continue;
            }
            j = prRound.team2.iterator();
            while (j.hasNext()) {
                p_test = (Player)j.next();
                if (p_test.isTeammate(p_unknown) && !p_test.isEnemy(p_unknown)) {
                    prRound.team2.add(p_unknown);
                    found = true;
                    break;
                }
                if (!p_test.isEnemy(p_unknown) || p_test.isTeammate(p_unknown)) continue;
                prRound.team1.add(p_unknown);
                found = true;
                break;
            }
            if (!found) continue;
            teamFound.add(p_unknown);
        }
        i = teamFound.iterator();
        while (i.hasNext()) {
            prRound.teamunknown.remove(i.next());
        }
    }

    public void subtractRound1Stats(Round prRound) {
        if (prRound.roundType != 2) {
            return;
        }
        Round round1 = prRound.parentGame.round1;
        if (round1 == null) {
            gravyStats.debug("subtractRound1Stats, round1 doesnt exist, aborting");
            return;
        }
        Iterator i = prRound.playersInRound.iterator();
        while (i.hasNext()) {
            Player p1 = (Player)i.next();
            Player p2 = round1.getPlayer(p1.getName(), 0, false, false);
            if (p2 == null) {
                gravyStats.debug("subtractRound1Stats, not found: " + p1.getName());
                Player global = this.players_global.getPlayer(p1.getName(), 0, false, false);
                if (global == null) {
                    gravyStats.debug("no global player :(");
                } else {
                    Iterator j = global.previous_names.iterator();
                    while (j.hasNext()) {
                        String[] s = (String[])j.next();
                        String bestName = s[0] == null ? (s[1] == null ? s[2] : s[1]) : s[0];
                        if (bestName == null) continue;
                        gravyStats.debug("previous name: " + bestName);
                        Player p3 = round1.getPlayer(bestName, 0, false, false);
                        if (p3 == null) continue;
                        gravyStats.debug("found!");
                        p2 = p3;
                        break;
                    }
                }
            }
            if (p2 == null) continue;
            int old_dg = p2.stats.damageGiven;
            int dg = p1.stats.damageGiven;
            int old_dr = p2.stats.damageReceived;
            int dr = p1.stats.damageReceived;
            int old_td = p2.stats.teamDamage;
            int td = p1.stats.teamDamage;
            int old_gibs = p2.stats.gibs;
            int gibs = p1.stats.gibs;
            if (old_dg > 0 && old_dg < dg) {
                dg -= old_dg;
            }
            if (old_dr > 0 && old_dr < dr) {
                dr -= old_dr;
            }
            if (old_td > 0 && old_td < td) {
                td -= old_td;
            }
            if (old_gibs > 0 && old_gibs < gibs) {
                gibs -= old_gibs;
            }
            p1.stats.damageGiven = dg;
            p1.stats.damageReceived = dr;
            p1.stats.teamDamage = td;
            p1.stats.gibs = gibs;
        }
    }

    public void buildRoundStats(Round prRound) {
        Iterator i = prRound.playersInRound.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            p.stats.calculate_efficiencies();
        }
        Collections.sort(prRound.team1, Player.SORT_ORDER_EFFICIENCY);
        Collections.reverse(prRound.team1);
        Collections.sort(prRound.team2, Player.SORT_ORDER_EFFICIENCY);
        Collections.reverse(prRound.team2);
        prRound.team1.calculate_total();
        prRound.team2.calculate_total();
    }

    public void updateGlobalPlayers(Round prRound) {
        Iterator j = prRound.playersInRound.iterator();
        while (j.hasNext()) {
            Player p = (Player)j.next();
            Player p2 = this.players_global.getPlayer(p.getName(), 0, true, false);
            Player.syndicate(p2, p);
        }
    }

    public void updateGlobalTeams(Round prRound) throws Exception {
        if (this.firstrealround) {
            Player p2;
            Player p;
            this.firstrealround = false;
            gravyStats.debug("updateGlobalTeams - first round");
            Iterator j = prRound.team1.iterator();
            while (j.hasNext()) {
                p = (Player)j.next();
                p2 = this.players_global.getPlayer(p.getName(), 0, true, false);
                p2.team = 1;
            }
            prRound.team1.globalteam = 1;
            j = prRound.team2.iterator();
            while (j.hasNext()) {
                p = (Player)j.next();
                p2 = this.players_global.getPlayer(p.getName(), 0, true, false);
                p2.team = 2;
            }
            prRound.team2.globalteam = 2;
        } else {
            Player p2;
            Player p;
            int team1score = 0;
            int team2score = 0;
            int team1update = 0;
            int team2update = 0;
            ArrayList<Player> updateme = new ArrayList<Player>();
            gravyStats.debug("updateGlobalTeams - building team scores");
            Iterator j = prRound.team1.iterator();
            while (j.hasNext()) {
                p = (Player)j.next();
                p2 = this.players_global.getPlayer(p.getName(), 0, false, false);
                if (p2 != null) {
                    if (p2.team == 1) {
                        ++team1score;
                        continue;
                    }
                    if (p2.team == 2) {
                        --team1score;
                        continue;
                    }
                    updateme.add(p);
                    continue;
                }
                gravyStats.debug("WARNING: updateGlobalTeams - global player not found for " + p.getName() + " (team1)");
            }
            gravyStats.debug("team1 score is " + team1score + " so they are " + (team1score == 0 ? "unknown" : (team1score > 0 ? "likely global1" : "likely global2")));
            j = prRound.team2.iterator();
            while (j.hasNext()) {
                p = (Player)j.next();
                p2 = this.players_global.getPlayer(p.getName(), 0, false, false);
                if (p2 != null) {
                    if (p2.team == 1) {
                        ++team2score;
                        continue;
                    }
                    if (p2.team == 2) {
                        --team2score;
                        continue;
                    }
                    updateme.add(p);
                    continue;
                }
                gravyStats.debug("WARNING: updateGlobalTeams - global player not found for " + p.getName() + " (team2)");
            }
            gravyStats.debug("team2 score is " + team2score + " so they are " + (team2score == 0 ? "unknown" : (team2score > 0 ? "likely global1" : "likely global2")));
            if (team1score > 0 && team2score < 0) {
                team1update = 1;
                prRound.team1.globalteam = 1;
                team2update = 2;
                prRound.team2.globalteam = 2;
            } else if (team1score < 0 && team2score > 0) {
                team1update = 2;
                prRound.team1.globalteam = 2;
                team2update = 1;
                prRound.team2.globalteam = 1;
            } else if (team1score > team2score) {
                gravyStats.debug("WARNING: dubious teams");
                team1update = 1;
                prRound.team1.globalteam = 1;
                team2update = 2;
                prRound.team2.globalteam = 2;
            } else {
                gravyStats.debug("WARNING: dubious teams");
                team1update = 2;
                prRound.team1.globalteam = 2;
                team2update = 1;
                prRound.team2.globalteam = 1;
            }
            j = updateme.iterator();
            while (j.hasNext()) {
                p = (Player)j.next();
                p2 = this.players_global.getPlayer(p.getName(), 0, false, false);
                gravyStats.debug("updating global players team for " + p.getName());
                if (p2 != null) {
                    if (p.team == 1) {
                        p2.team = team1update;
                        gravyStats.debug("they were team1 in this round, so they are now global team " + team1update);
                        continue;
                    }
                    if (p.team == 2) {
                        p2.team = team2update;
                        gravyStats.debug("they were team2 in this round, so they are now global team " + team2update);
                        continue;
                    }
                    gravyStats.debug("uhh :( local player doesnt have a team! please report me");
                    continue;
                }
                gravyStats.debug("wtf :( local player doesnt have a global equivalent! please report me");
            }
        }
    }

    public void processGames() throws Exception {
        Player p;
        int debug_processGames = this.debug_processingTime_start();
        gravyStats.debug("processing games...");
        Game prGame = this.firstGame;
        int gameNumber = 1;
        while (prGame != null) {
            Round round1 = prGame.round1;
            Round round2 = prGame.round2;
            if (round1 == null) {
                // empty if block
            }
            if (round1 != null && round1.mapname != null) {
                if (round2 != null && round2.mapname != null && !round1.mapname.equals(round2.mapname)) {
                    throw new Exception("round map names dont match! " + round1.mapname + " and " + round2.mapname);
                }
                prGame.mapname = round1.mapname;
            } else {
                prGame.mapname = round2 != null && round2.mapname != null ? round2.mapname : "unknown";
            }
            gravyStats.debug("game number " + gameNumber + " map " + prGame.mapname);
            if (round1 == null) {
                gravyStats.debug("  round1 null");
            } else {
                gravyStats.debug("  round1 " + round1.roundTime + ", " + round1.playersInRound.size() + " players " + round1.eventList.size() + " events");
            }
            if (round2 == null) {
                gravyStats.debug("  round2 null");
            } else {
                gravyStats.debug("  round2 " + round2.roundTime + ", " + round2.playersInRound.size() + " players " + round2.eventList.size() + " events");
            }
            if (round1 != null && round2 != null) {
                if (round1.noTeamInformation) {
                    gravyStats.debug("  round1 no team information");
                }
                if (round2.noTeamInformation) {
                    gravyStats.debug("  round2 no team information");
                }
                if (!round1.noTeamInformation && !round2.noTeamInformation) {
                    if (round1.timelimitHit && round2.timelimitHit) {
                        gravyStats.debug("  double full hold");
                        prGame.winner = 3;
                        this.score[0] = this.score[0] + 1;
                    } else if (round1.timelimitHit && !round2.timelimitHit) {
                        gravyStats.debug("  team 2 wins");
                        prGame.winner = 2;
                        int n = prGame.round1.team2.globalteam;
                        this.score[n] = this.score[n] + 1;
                    } else if (!round1.timelimitHit && round2.timelimitHit) {
                        gravyStats.debug("  team 1 wins");
                        prGame.winner = 1;
                        int n = prGame.round1.team1.globalteam;
                        this.score[n] = this.score[n] + 1;
                    } else if (!round1.timelimitHit && !round2.timelimitHit) {
                        gravyStats.debug("  team 2 wins");
                        prGame.winner = 2;
                        int n = prGame.round1.team2.globalteam;
                        this.score[n] = this.score[n] + 1;
                    }
                }
            } else {
                gravyStats.debug("  unknown game winner as both rounds arent present");
            }
            prGame = prGame.nextGame;
            ++gameNumber;
        }
        Iterator i = this.players_global.iterator();
        while (i.hasNext()) {
            p = (Player)i.next();
            if (p.team == 1) {
                this.team1_global.add(p);
                continue;
            }
            if (p.team == 2) {
                this.team2_global.add(p);
                continue;
            }
            this.teamunknown_global.add(p);
        }
        this.team1_global.teamname = "team1";
        this.team2_global.teamname = "team2";
        this.lookForTag(this.team1_global);
        this.lookForTag(this.team2_global);
        this.attachTeamNamesToRoundLabels();
        i = this.players_global.iterator();
        while (i.hasNext()) {
            p = (Player)i.next();
            for (int j = 0; j < MeansOfDeath.num_mod; ++j) {
                int n = j;
                this.weaponStats_global[n] = this.weaponStats_global[n] + p.stats.weaponStats[0][j];
                if (p.stats.weaponStats[0][j] > MeansOfDeath.mod[j].mostKills_count) {
                    MeansOfDeath.mod[j].mostKills_count = p.stats.weaponStats[0][j];
                    MeansOfDeath.mod[j].mostKills = p;
                }
                if (p.stats.weaponStats[1][j] <= MeansOfDeath.mod[j].mostDeaths_count) continue;
                MeansOfDeath.mod[j].mostDeaths_count = p.stats.weaponStats[1][j];
                MeansOfDeath.mod[j].mostDeaths = p;
            }
        }
        this.addMM1RoundStatus();
        this.buildMatchStats();
        gravyStats.debug("processing games completed in... " + this.debug_processingTime_end(debug_processGames) + newline);
    }

    public void attachTeamNamesToRoundLabels() {
        Game prGame = this.firstGame;
        while (prGame != null) {
            if (prGame.round1 != null) {
                this.attachTeamNameForRound(prGame.round1);
            }
            if (prGame.round2 != null) {
                this.attachTeamNameForRound(prGame.round2);
            }
            prGame = prGame.nextGame;
        }
    }

    public void attachTeamNameForRound(Round round) {
        this.attachTeamNameForTeam(round.team1);
        this.attachTeamNameForTeam(round.team2);
    }

    public void attachTeamNameForTeam(PlayerList team) {
        if (team.globalteam == 1) {
            team.teamname = this.team1_global.teamname;
        } else if (team.globalteam == 2) {
            team.teamname = this.team2_global.teamname;
        }
    }

    public void lookForTag(PlayerList team) {
        Object[] o = team.toArray();
        int numplayers = o.length;
        HashMap<String, Integer> matchedstrings = new HashMap<String, Integer>(20);
        HashMap<String, Integer> matchedstrings2 = new HashMap<String, Integer>(20);
        String new_teamname = "";
        gravyStats.debug("looking for tag");
        for (int i = 0; i < numplayers; ++i) {
            Player p1 = (Player)o[i];
            String p1name = p1.getName(2);
            if (p1name == null) {
                p1name = Player.cleanName(p1.getName());
            }
            gravyStats.debug("checking " + p1name);
            for (int j = i + 1; j < numplayers; ++j) {
                int k;
                Player p2 = (Player)o[j];
                String p2name = p2.getName(2);
                if (p2name == null) {
                    p2name = Player.cleanName(p2.getName());
                }
                int charactersMatched = 0;
                int maxlength = p1name.length();
                if (p2name.length() < maxlength) {
                    maxlength = p2name.length();
                }
                for (k = 0; k < maxlength && p1name.charAt(k) == p2name.charAt(k); ++k) {
                    ++charactersMatched;
                }
                if (charactersMatched > 0) {
                    String matched = p1name.substring(0, charactersMatched);
                    if (matchedstrings.containsKey(matched)) {
                        matchedstrings.put(matched, new Integer((Integer)matchedstrings.get(matched) + 1));
                    } else {
                        matchedstrings.put(matched, new Integer(1));
                    }
                }
                p1name = new StringBuffer(p1name).reverse().toString();
                p2name = new StringBuffer(p2name).reverse().toString();
                charactersMatched = 0;
                for (k = 0; k < maxlength && p1name.charAt(k) == p2name.charAt(k); ++k) {
                    ++charactersMatched;
                }
                if (charactersMatched > 0) {
                    String matched = p1name.substring(0, charactersMatched);
                    if (matchedstrings2.containsKey(matched)) {
                        matchedstrings2.put(matched, new Integer((Integer)matchedstrings2.get(matched) + 1));
                    } else {
                        matchedstrings2.put(matched, new Integer(1));
                    }
                }
                p1name = new StringBuffer(p1name).reverse().toString();
            }
        }
        int max = 2;
        String start = "";
        int samecount = 0;
        Iterator i = matchedstrings.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry match = i.next();
            String key = (String)match.getKey();
            int value = (Integer)match.getValue();
            gravyStats.debug(key + " matched " + value + " times");
            if (value > max) {
                max = value;
                start = key;
                samecount = 0;
                gravyStats.debug("*");
                continue;
            }
            if (value != max) continue;
            if (key.length() > start.length()) {
                start = key;
                gravyStats.debug("*");
            }
            ++samecount;
        }
        if (start.length() > 0 && samecount < 3) {
            new_teamname = new_teamname + start;
            gravyStats.debug("tag start found: " + start);
        }
        max = 2;
        String end = "";
        samecount = 0;
        Iterator i2 = matchedstrings2.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry match = i2.next();
            String key = (String)match.getKey();
            int value = (Integer)match.getValue();
            gravyStats.debug(key + " matched " + value + " times");
            if (value > max) {
                max = value;
                end = key;
                samecount = 0;
                gravyStats.debug("*");
                continue;
            }
            if (value != max) continue;
            if (key.length() > end.length()) {
                end = key;
                gravyStats.debug("*");
            }
            ++samecount;
        }
        if (end.length() > 0 && samecount < 3) {
            end = new StringBuffer(end).reverse().toString();
            new_teamname = new_teamname + end;
            gravyStats.debug("tag end found: " + end);
        }
        if (!new_teamname.equals("")) {
            team.teamname = new_teamname;
        }
    }

    public void test_harness() {
        this.name_test("^1M^7iss^zu^7sed^1*^7P^zantie^7S^1!", "^1M^7iss^zu^7sed^1*^7P^zantie^7S^", "Missused*Pantie");
        this.name_test("^0S^etr^va^7p^no^on^e.^oP^7antie^oS", "^0S^etr^va^7p^no^on^e.^oP^7antie^", "Strapon.PantieS");
        System.out.println();
        System.out.println("^3^^47^fD^5i^3^^0Mickeyy " + Player.cleanName("^3^^47^fD^5i^3^^0Mickeyy") + " " + Player.cleanName2("^3^^47^fD^5i^3^^0Mickeyy"));
        System.out.println("^0S^etr^va^7p^no^on^e.^oP^7antie^ " + Player.cleanName("^0S^etr^va^7p^no^on^e.^oP^7antie^") + " " + Player.cleanName2("^0S^etr^va^7p^no^on^e.^oP^7antie^"));
    }

    public void name_test(String namefull, String name33, String name15) {
        Player p1 = new Player(namefull, 0);
        System.out.println("full: matching with 33: " + p1.indirectNameMatch(name33, 1, false));
        System.out.println("full: matching with 15: " + p1.indirectNameMatch(name15, 2, false));
        Player p2 = new Player(name33, 1);
        System.out.println("33: matching with full: " + p2.indirectNameMatch(namefull, 0, false));
        System.out.println("33: matching with 15: " + p2.indirectNameMatch(name15, 2, false));
        Player p3 = new Player(name15, 2);
        System.out.println("15: matching with full: " + p3.indirectNameMatch(namefull, 0, false));
        System.out.println("15: matching with 33: " + p3.indirectNameMatch(name15, 1, false));
    }

    public void generateAwards() throws Exception {
        Player fff;
        int i;
        String recips;
        int debug_generateAwards = this.debug_processingTime_start();
        gravyStats.debug("generating awards...");
        PlayerComparator pc = new PlayerComparator();
        Object lols = null;
        pc.setSortDesc(true);
        pc.setSortType(1);
        Collections.sort(this.players_global, pc);
        int mosti = ((Player)this.players_global.get((int)0)).stats.damageGiven;
        if (mosti > 0) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.damageGiven != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("RAMBO", "most damage given", recips, "" + mosti));
            }
        }
        pc.setSortType(2);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.damageReceived;
        if (mosti > 0) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.damageReceived != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("MEAT SHIELD", "most damage received", recips, "" + mosti));
            }
        }
        pc.setSortType(22);
        Collections.sort(this.players_global, pc);
        float mostf = ((Player)this.players_global.get((int)0)).stats.dmg_efficiency;
        if ((double)mostf > 1.0) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.dmg_efficiency != mostf) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("PUNISHER", "best damage ratio", recips, this.twoDecimalPlaces.format(mostf).toString()));
            }
        }
        pc.setSortType(23);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.teamDamage;
        if (mosti > 0) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.teamDamage != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("BACKRAGER", "most team damage", recips, "" + mosti));
            }
        }
        pc.setSortType(3);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.kills;
        recips = "";
        for (i = 0; i < this.players_global.size(); ++i) {
            fff = (Player)this.players_global.get(i);
            if (fff.stats.kills != mosti) break;
            recips = recips + fff.getName() + " ";
        }
        if (!recips.equals("")) {
            this.awards.add(new Award("BODY COUNT", "most kills", recips, "" + mosti));
        }
        pc.setSortType(4);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.deaths;
        recips = "";
        for (i = 0; i < this.players_global.size(); ++i) {
            fff = (Player)this.players_global.get(i);
            if (fff.stats.deaths != mosti) break;
            recips = recips + fff.getName() + " ";
        }
        if (!recips.equals("")) {
            this.awards.add(new Award("TARGET PRACTICE", "most deaths", recips, "" + mosti));
        }
        pc.setSortType(33);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.suicides;
        if (mosti > 0) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.suicides != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("EMO", "most suicides", recips, "" + mosti));
            }
        }
        pc.setSortType(5);
        Collections.sort(this.players_global, pc);
        mostf = ((Player)this.players_global.get((int)0)).stats.efficiency;
        recips = "";
        for (i = 0; i < this.players_global.size(); ++i) {
            fff = (Player)this.players_global.get(i);
            if (fff.stats.efficiency != mostf) break;
            recips = recips + fff.getName() + " ";
        }
        if (!recips.equals("")) {
            this.awards.add(new Award("WHO'S YOUR DADDY?", "best efficiency", recips, this.twoDecimalPlaces.format(mostf).toString()));
        }
        pc.setSortType(6);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.getWeaponStat(0, 0);
        if (mosti > 0) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.getWeaponStat(0, 0) != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("ASSASSIN", "most knifes", recips, "" + mosti));
            }
        }
        pc.setSortType(7);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.getWeaponStat(1, 0);
        if (mosti > 0) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.getWeaponStat(1, 0) != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("HUMILIATION", "most knifed", recips, "" + mosti));
            }
        }
        pc.setSortDesc(true);
        pc.setSortType(81);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.gibs;
        if (mosti > 2) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.gibs != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("ST PETER", "most gibs", recips, "" + mosti));
            }
        }
        pc.setSortDesc(true);
        pc.setSortType(9);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.damagePerDeath;
        if (mosti > 100) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.damagePerDeath != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("PACK WHORE", "highest damage received per death", recips, "" + mosti));
            }
        }
        pc.setSortDesc(true);
        pc.setSortType(100);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.damagePerKill;
        if (mosti > 100) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.damagePerKill != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("UNFINISHED BUSINESS", "highest damage given per kill", recips, "" + mosti));
            }
        }
        pc.setSortType(10);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.slashkills;
        if (mosti > 2) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.slashkills != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("IT WAS FOR SPAWN!!", "most slash kills", recips, "" + mosti));
            }
        }
        pc.setSortType(11);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.maxkillstreak;
        if (mosti > 2) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.maxkillstreak != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("DEATH DEFIER", "longest kill streak", recips, "" + mosti));
            }
        }
        pc.setSortType(12);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.maxdeathstreak;
        if (mosti > 2) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.maxdeathstreak != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("STUCK IN SPAWN", "longest death streak", recips, "" + mosti));
            }
        }
        pc.setSortType(13);
        Collections.sort(this.players_global, pc);
        mosti = ((Player)this.players_global.get((int)0)).stats.mm1count;
        if (mosti > 2) {
            recips = "";
            for (i = 0; i < this.players_global.size(); ++i) {
                fff = (Player)this.players_global.get(i);
                if (fff.stats.mm1count != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("CHATTERBOX", "most mm1", recips, "" + mosti));
            }
        }
        Collections.sort(this.players_global, Player.SORT_ORDER_EFFICIENCY);
        Collections.reverse(this.players_global);
        gravyStats.debug("generating awards completed in... " + this.debug_processingTime_end(debug_generateAwards) + newline);
    }

    public void writeln(BufferedWriter bw, String line) throws Exception {
        bw.write(line);
        bw.newLine();
    }

    public void write(BufferedWriter bw, String line) throws Exception {
        bw.write(line);
    }

    public String removeNaughtyWinFileChars(String s) {
        gravyStats.debug("removeNaughtyWinFileChars for " + s);
        s = s.replace('\\', '*');
        s = s.replace('/', '*');
        s = s.replace(':', '*');
        s = s.replace('?', '*');
        s = s.replace('\"', '*');
        s = s.replace('<', '*');
        s = s.replace('>', '*');
        s = s.replace('|', '*');
        s = s.replace('.', '*');
        s = s.replace(' ', '*');
        s = s.replace('#', '*');
        gravyStats.debug("remove these " + s);
        StringBuffer sb = new StringBuffer(s);
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '*') {
                sb.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        gravyStats.debug("result " + sb.toString());
        return sb.toString();
    }

    public void addMM1RoundStatus() {
        Game prGame = this.firstGame;
        while (prGame != null) {
            Round round1 = prGame.round1;
            Round round2 = prGame.round2;
            if (round1 != null && !round1.noTeamInformation) {
                round1.mm1.add(round1.team1.teamname + " set " + round1.roundTime + (round1.timelimitHit ? " (held)" : ""));
            }
            if (round2 != null && !round2.noTeamInformation) {
                round2.mm1.add(round2.team1.teamname + (round2.timelimitHit ? " didnt" : "") + " beat the clock - " + round2.roundTime);
            }
            prGame = prGame.nextGame;
        }
    }

    public void buildMatchStats() throws Exception {
        gravyStats.debug("buildMatchStats()");
        Iterator i = this.players_global.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            p.stats.calculate_efficiencies();
        }
        Collections.sort(this.team1_global, Player.SORT_ORDER_EFFICIENCY);
        Collections.reverse(this.team1_global);
        Collections.sort(this.team2_global, Player.SORT_ORDER_EFFICIENCY);
        Collections.reverse(this.team2_global);
        this.team1_global.calculate_total();
        this.team2_global.calculate_total();
    }

    public void writeHTML() throws Exception {
        Player p;
        int i;
        int debug_writeHTML = this.debug_processingTime_start();
        gravyStats.debug("writing HTML...");
        if (this.logDate == null) {
            this.logDate = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd-HHmm-");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yy-MM-dd");
        SimpleDateFormat sdf3 = new SimpleDateFormat("EEE MMM dd yyyy");
        String outputFileName = this.outputDirectory + File.separator + sdf.format(this.logDate) + this.removeNaughtyWinFileChars(this.team1_global.teamname) + "-vs-" + this.removeNaughtyWinFileChars(this.team2_global.teamname) + ".html";
        this.stdout("writing " + outputFileName);
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputFileName));
        String pageTitle = "gravyStats " + sdf2.format(this.logDate) + " " + this.team1_global.teamname + " vs. " + this.team2_global.teamname;
        this.writeln(bw, "<!-- " + appName + " " + version + " -->");
        this.writeln(bw, "<html><head><title>" + pageTitle + "</title>");
        this.writeln(bw, "<link href=\"include/gravy.css\" rel=\"stylesheet\" type=\"text/css\">");
        this.writeln(bw, "<script language=\"Javascript\" src=\"include/gravy.js\"></script>");
        this.writeln(bw, "</head><body>");
        Game prGame = this.firstGame;
        int gameNumber = 1;
        this.writeln(bw, "<table class=\"roundtimes\" rules=\"cols\" frame=\"void\">");
        this.writeln(bw, "<tr>");
        this.writeln(bw, "<td rowspan=\"3\" class=\"summary1\">");
        this.writeln(bw, "<div class=\"h1\">" + this.team1_global.teamname + " vs. " + this.team2_global.teamname + "</div>");
        this.writeln(bw, sdf3.format(this.logDate) + "<br>");
        this.writeln(bw, "</td>");
        StringBuffer[] scoreboard = new StringBuffer[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            scoreboard[i2] = new StringBuffer();
        }
        scoreboard[3].append("<td class=\"summary2_on\" id=\"summ_global\" title=\"Click to show stats for whole match\" onClick=\"summary_scope('global')\">" + (this.score[1] > this.score[2] ? this.team1_global.teamname + " win " : (this.score[2] > this.score[1] ? this.team2_global.teamname + " win " : "draw ")) + this.score[1] + "-" + this.score[0] + "-" + this.score[2] + "</td>" + newline);
        while (prGame != null) {
            scoreboard[0].append("<td class=\"map\">" + prGame.mapname + "</td>" + newline);
            scoreboard[1].append("<td class=\"round\">");
            if (prGame.round1 != null) {
                scoreboard[1].append("<table><tr><td>");
                if (prGame.round1.noTeamInformation) {
                    scoreboard[1].append("- ");
                } else {
                    scoreboard[1].append(prGame.round1.team1.teamname + " ");
                }
                if (prGame.round1.timelimitHit) {
                    scoreboard[1].append("<span class=\"h\">(held)</span>");
                }
                scoreboard[1].append("</td><td class=\"clock\">" + prGame.round1.roundTime + "</td></tr></table>");
            } else {
                scoreboard[1].append("-");
            }
            scoreboard[1].append("</td>" + newline);
            scoreboard[2].append("<td class=\"round\">");
            if (prGame.round2 != null) {
                scoreboard[2].append("<table><tr><td>");
                if (prGame.round2.noTeamInformation) {
                    scoreboard[2].append("- ");
                } else {
                    scoreboard[2].append(prGame.round2.team1.teamname + " ");
                }
                if (prGame.round2.timelimitHit) {
                    scoreboard[2].append("<span class=\"h\">(held)</span>");
                }
                scoreboard[2].append("</td><td class=\"clock\">" + prGame.round2.roundTime + "</td></tr></table>");
            }
            scoreboard[2].append("</td>" + newline);
            scoreboard[3].append("<td class=\"result\" id=\"summ_game" + gameNumber + "\" title=\"Click to show stats for this game\" onClick=\"summary_scope('game" + gameNumber + "')\">");
            if (prGame.winner == 1) {
                scoreboard[3].append(prGame.round1.team1.teamname + " win");
            } else if (prGame.winner == 2) {
                scoreboard[3].append(prGame.round1.team2.teamname + " win");
            } else if (prGame.winner == 3) {
                scoreboard[3].append("draw");
            } else {
                scoreboard[3].append("-");
            }
            scoreboard[3].append("</td>" + newline);
            ++gameNumber;
            prGame = prGame.nextGame;
        }
        this.writeln(bw, scoreboard[0].toString());
        this.writeln(bw, "</tr><tr>");
        this.writeln(bw, scoreboard[1].toString());
        this.writeln(bw, "</tr><tr>");
        this.writeln(bw, scoreboard[2].toString());
        this.writeln(bw, "</tr><tr>");
        this.writeln(bw, scoreboard[3].toString());
        this.writeln(bw, "</tr></table>");
        this.writeln(bw, "<script language=\"Javascript\">numGames = " + gameNumber + "</script>");
        this.writeln(bw, "<br>");
        this.writeln(bw, "<div id=\"global\">");
        this.writeln(bw, "<div class=\"h2\">Match summary ( <a href=\"javascript:summary_type('simple')\">simple</a> <a href=\"javascript:summary_type('detailed')\">detailed</a> )</div>");
        this.writeln(bw, "<div id=\"global_simple\">");
        this.writeln(bw, "<table><tr><td valign=\"top\">");
        this.writeln(bw, this.teamSummary_simple(this.team1_global));
        this.writeln(bw, "</td><td width=\"20\">&nbsp;</td><td valign=\"top\">");
        this.writeln(bw, this.teamSummary_simple(this.team2_global));
        this.writeln(bw, "</td></tr></table>");
        this.writeln(bw, "</div>");
        this.writeln(bw, "<div id=\"global_detailed\" style=\"display:none\">");
        this.writeln(bw, this.teamSummary_detailed(this.team1_global, this.team2_global));
        this.writeln(bw, "</div>");
        this.writeln(bw, "</div>");
        prGame = this.firstGame;
        gameNumber = 1;
        while (prGame != null) {
            this.writeln(bw, "<div id=\"game" + gameNumber + "\" style=\"display:none\">");
            Round round1 = prGame.round1;
            Round round2 = prGame.round2;
            this.writeln(bw, "<div class=\"h2\">Game " + gameNumber + " summary ( <a href=\"javascript:summary_type('simple')\">simple</a> <a href=\"javascript:summary_type('detailed')\">detailed</a> <a href=\"javascript:summary_type('history')\">history</a> )</div>");
            this.writeln(bw, "<div id=\"game" + gameNumber + "_simple\">");
            if (round1 != null) {
                this.writeln(bw, "round 1 - " + round1.roundTime);
                this.writeln(bw, "<table><tr><td valign=\"top\">");
                this.writeln(bw, this.teamSummary_simple(round1.team1));
                this.writeln(bw, "</td><td width=\"20\">&nbsp;</td><td valign=\"top\">");
                this.writeln(bw, this.teamSummary_simple(round1.team2));
                this.writeln(bw, "</td></tr></table>");
            }
            if (round2 != null) {
                this.writeln(bw, "round 2 - " + round2.roundTime);
                this.writeln(bw, "<table><tr><td valign=\"top\">");
                this.writeln(bw, this.teamSummary_simple(round2.team1));
                this.writeln(bw, "</td><td width=\"20\">&nbsp;</td><td valign=\"top\">");
                this.writeln(bw, this.teamSummary_simple(round2.team2));
                this.writeln(bw, "</td></tr></table>");
            }
            this.writeln(bw, "</div>");
            this.writeln(bw, "<div id=\"game" + gameNumber + "_detailed\" style=\"display:none\">");
            if (round1 != null) {
                this.writeln(bw, "round 1 - " + round1.roundTime);
                this.writeln(bw, this.teamSummary_detailed(round1.team1, round1.team2));
            }
            if (round2 != null) {
                this.writeln(bw, "round 2 - " + round2.roundTime);
                this.writeln(bw, this.teamSummary_detailed(round2.team1, round2.team2));
            }
            this.writeln(bw, "</div>");
            this.writeln(bw, "<div id=\"game" + gameNumber + "_history\" style=\"display:none\">");
            if (round1 != null) {
                this.writeln(bw, "round 1 - " + round1.roundTime);
                this.writeln(bw, this.teamSummary_history(round1.team1, round1.team2));
            }
            if (round2 != null) {
                this.writeln(bw, "round 2 - " + round2.roundTime);
                this.writeln(bw, this.teamSummary_history(round2.team1, round2.team2));
            }
            this.writeln(bw, "</div>");
            this.writeln(bw, "</div>");
            prGame = prGame.nextGame;
            ++gameNumber;
        }
        this.writeln(bw, "<hr noshade size=\"1\">");
        this.writeln(bw, "<div class=\"h2\">Awards</div>");
        this.writeln(bw, "<table class=\"awards\" rules=\"groups\" frame=\"void\">");
        this.writeln(bw, "<colgroup/><colgroup/><colgroup/><colgroup/>");
        this.writeln(bw, "<thead>");
        this.writeln(bw, "<tr>");
        this.writeln(bw, "<th>award</th>");
        this.writeln(bw, "<th>description</th>");
        this.writeln(bw, "<th>amount</th>");
        this.writeln(bw, "<th>winnah</th>");
        this.writeln(bw, "</tr>");
        this.writeln(bw, "</thead>");
        this.writeln(bw, "<tbody>");
        Iterator i3 = this.awards.iterator();
        while (i3.hasNext()) {
            Award a = (Award)i3.next();
            this.writeln(bw, "<tr>");
            this.writeln(bw, "<td>" + a.name + "</td>");
            this.writeln(bw, "<td>" + a.description + "</td>");
            this.writeln(bw, "<td class=\"amount\">" + a.amount + "</td>");
            this.writeln(bw, "<td class=\"winnah\">" + gravyStats.htmlcolourcodes(a.recipients) + "</td>");
            this.writeln(bw, "</tr>");
        }
        this.writeln(bw, "</tbody>");
        this.writeln(bw, "</table>");
        this.writeln(bw, "<hr noshade size=\"1\">");
        this.writeln(bw, "<div class=\"h2\">Weapon stats ( <a href=\"javascript:switch_weapon('simple')\">simple</a> <a href=\"javascript:switch_weapon('detailed')\">detailed</a> )</div>");
        this.writeln(bw, "<div id=\"weaponstats_simple\">");
        this.writeln(bw, "<table class=\"weaponstats_simple\" cellspacing=\"0\" rules=\"groups\" frame=\"void\">");
        this.writeln(bw, "<colgroup><colgroup span=\"2\"><colgroup span=\"2\"><colgroup span=\"2\">");
        this.writeln(bw, "<thead>");
        this.writeln(bw, "<tr>");
        this.writeln(bw, "<th>Weapon</th>");
        this.writeln(bw, "<th>Kills</th>");
        this.writeln(bw, "<th>% total</th>");
        this.writeln(bw, "<th colspan=\"2\">Most kills</th>");
        this.writeln(bw, "<th colspan=\"2\">Most deaths</th>");
        this.writeln(bw, "<th>" + this.team1_global.teamname + "</th>");
        this.writeln(bw, "<th>" + this.team2_global.teamname + "</th>");
        this.writeln(bw, "</tr>");
        this.writeln(bw, "</thead>");
        this.writeln(bw, "<tbody>");
        class WeaponStat_SortObject
        implements Comparable {
            MeansOfDeath mod;
            int count;

            WeaponStat_SortObject(MeansOfDeath mod, int count) {
                this.mod = mod;
                this.count = count;
            }

            public int compareTo(Object o) {
                int c1 = ((WeaponStat_SortObject)o).count;
                if (this.count < c1) {
                    return -1;
                }
                if (this.count > c1) {
                    return 1;
                }
                return 0;
            }
        }
        Object[] sort = new WeaponStat_SortObject[MeansOfDeath.num_mod];
        int totalkills = 0;
        for (i = 0; i < MeansOfDeath.num_mod; ++i) {
            sort[i] = new WeaponStat_SortObject(MeansOfDeath.mod[i], this.weaponStats_global[i]);
            totalkills += this.weaponStats_global[i];
        }
        Arrays.sort(sort);
        Collections.reverse(Arrays.asList(sort));
        for (i = 0; i < MeansOfDeath.num_mod && ((WeaponStat_SortObject)sort[i]).count != 0; ++i) {
            this.writeln(bw, "<tr>");
            this.writeln(bw, "<td class=\"weap\">" + ((WeaponStat_SortObject)sort[i]).mod.means + "</td>");
            this.writeln(bw, "<td>" + ((WeaponStat_SortObject)sort[i]).count + "</td>");
            this.writeln(bw, "<td>" + this.noDecimalPlaces.format((float)((WeaponStat_SortObject)sort[i]).count / (float)totalkills * 100.0f) + "</td>");
            if (((WeaponStat_SortObject)sort[i]).mod.mostKills != null) {
                this.writeln(bw, "<td class=\"name\">" + gravyStats.htmlcolourcodes(((WeaponStat_SortObject)sort[i]).mod.mostKills.getName()) + "</td>");
                this.writeln(bw, "<td>" + ((WeaponStat_SortObject)sort[i]).mod.mostKills_count + "</td>");
            } else {
                this.writeln(bw, "<td>&nbsp;</td><td>&nbsp;</td>");
            }
            if (((WeaponStat_SortObject)sort[i]).mod.mostDeaths != null) {
                this.writeln(bw, "<td class=\"name\">" + gravyStats.htmlcolourcodes(((WeaponStat_SortObject)sort[i]).mod.mostDeaths.getName()) + "</td>");
                this.writeln(bw, "<td>" + ((WeaponStat_SortObject)sort[i]).mod.mostDeaths_count + "</td>");
            } else {
                this.writeln(bw, "<td>&nbsp;</td><td>&nbsp;</td>");
            }
            this.writeln(bw, "<td>" + this.team1_global.total_stats.getWeaponStat(0, ((WeaponStat_SortObject)sort[i]).mod.mod_num) + "</td>");
            this.writeln(bw, "<td>" + this.team2_global.total_stats.getWeaponStat(0, ((WeaponStat_SortObject)sort[i]).mod.mod_num) + "</td>");
            this.writeln(bw, "</tr>");
        }
        this.writeln(bw, "</tbody></table>");
        this.writeln(bw, "</div>");
        this.writeln(bw, "<div id=\"weaponstats_detailed\" style=\"display:none\">");
        this.writeln(bw, "<a href=\"javascript:switch_kd('kills')\">kills</a> <a href=\"javascript:switch_kd('deaths')\">deaths</a>");
        this.writeln(bw, "<table class=\"weaponstats_detailed\" rules=\"groups\" frame=\"void\">");
        this.writeln(bw, "<colgroup span=\"1\"/><colgroup span=\"1\"/><colgroup span=\"4\"/><colgroup span=\"2\"/><colgroup span=\"2\"/><colgroup span=\"4\"/><colgroup span=\"3\"/><colgroup span=\"2\"/>");
        this.writeln(bw, "<thead>");
        this.writeln(bw, "<tr>");
        this.writeln(bw, "<th>&nbsp;</th>");
        this.writeln(bw, "<th title=\"Knife\">kfe</th>");
        this.writeln(bw, "<th title=\"Pistol\">pstl</th>");
        this.writeln(bw, "<th title=\"SMG\">smg</th>");
        this.writeln(bw, "<th title=\"Rifle\">rfl</th>");
        this.writeln(bw, "<th title=\"Scoped rifle\">scpd</th>");
        this.writeln(bw, "<th title=\"Grenade\">grn</th>");
        this.writeln(bw, "<th title=\"Rifle grenade\">rgrn</th>");
        this.writeln(bw, "<th title=\"Dynomite\">dyn</th>");
        this.writeln(bw, "<th title=\"Mine\">mine</th>");
        this.writeln(bw, "<th title=\"Panzer\">pnz</th>");
        this.writeln(bw, "<th title=\"Flamethrower\">flm</th>");
        this.writeln(bw, "<th title=\"Mortar\">mrt</th>");
        this.writeln(bw, "<th title=\"Machinegun\">mg</th>");
        this.writeln(bw, "<th title=\"Artillery\">art</th>");
        this.writeln(bw, "<th title=\"Airstrike\">astrk</th>");
        this.writeln(bw, "<th title=\"Canister\">can</th>");
        this.writeln(bw, "<th title=\"Satchel\">stch</th>");
        this.writeln(bw, "<th title=\"Construction\">cnstr</th>");
        this.writeln(bw, "</tr>");
        this.writeln(bw, "</thead>");
        this.writeln(bw, "<tbody id=\"weapon_kills\">");
        Iterator i4 = this.team1_global.iterator();
        while (i4.hasNext()) {
            p = (Player)i4.next();
            this.writeln(bw, this.weaponStat_row(0, p.getName(), p.stats));
        }
        this.writeln(bw, "</tbody>");
        this.writeln(bw, "<tbody id=\"weapon_kills2\">");
        this.writeln(bw, this.weaponStat_row(0, this.team1_global.teamname, this.team1_global.total_stats));
        this.writeln(bw, "</tbody>");
        this.writeln(bw, "<tbody id=\"weapon_kills3\">");
        i4 = this.team2_global.iterator();
        while (i4.hasNext()) {
            p = (Player)i4.next();
            this.writeln(bw, this.weaponStat_row(0, p.getName(), p.stats));
        }
        this.writeln(bw, "</tbody>");
        this.writeln(bw, "<tbody id=\"weapon_kills4\">");
        this.writeln(bw, this.weaponStat_row(0, this.team2_global.teamname, this.team2_global.total_stats));
        this.writeln(bw, "</tbody>");
        this.writeln(bw, "<tbody id=\"weapon_deaths\" style=\"display:none\">");
        i4 = this.team1_global.iterator();
        while (i4.hasNext()) {
            p = (Player)i4.next();
            this.writeln(bw, this.weaponStat_row(1, p.getName(), p.stats));
        }
        this.writeln(bw, "</tbody>");
        this.writeln(bw, "<tbody id=\"weapon_deaths2\" style=\"display:none\">");
        this.writeln(bw, this.weaponStat_row(1, this.team1_global.teamname, this.team1_global.total_stats));
        this.writeln(bw, "</tbody>");
        this.writeln(bw, "<tbody id=\"weapon_deaths3\" style=\"display:none\">");
        i4 = this.team2_global.iterator();
        while (i4.hasNext()) {
            p = (Player)i4.next();
            this.writeln(bw, this.weaponStat_row(1, p.getName(), p.stats));
        }
        this.writeln(bw, "</tbody>");
        this.writeln(bw, "<tbody id=\"weapon_deaths4\" style=\"display:none\">");
        this.writeln(bw, this.weaponStat_row(1, this.team2_global.teamname, this.team2_global.total_stats));
        this.writeln(bw, "</tbody>");
        this.writeln(bw, "</table><br/>");
        this.writeln(bw, "</div><hr noshade size=\"1\">");
        this.writeln(bw, "<div class=\"h2\">Kill matrix</div>");
        this.writeln(bw, this.killMatrix(this.players_global));
        this.writeln(bw, "<hr noshade size=\"1\">");
        this.writeln(bw, "<div class=\"h2\">mm1</div>");
        Round prRound = this.firstRound;
        int mm1LineCount = 1;
        this.writeln(bw, "<div class=\"mm1\">");
        this.writeln(bw, "<table class=\"mm1\">");
        while (prRound != null) {
            int mm1_size = prRound.mm1.size();
            for (int i5 = 0; i5 < mm1_size; ++i5) {
                bw.write("<tr>");
                String mm1_line = (String)prRound.mm1.get(i5);
                this.m = this.mm1Event.matcher(mm1_line);
                if (this.m.find()) {
                    String player = this.m.group(1);
                    String text = this.m.group(2);
                    bw.write("<td>" + mm1LineCount++ + "</td><td>" + gravyStats.htmlcolourcodes(player) + "</td><td>" + text + "</td>");
                } else {
                    bw.write("<td>" + mm1LineCount++ + "<td>&nbsp;</td><td class=\"pauseevent\">" + mm1_line + "</td>");
                }
                bw.write("</tr>" + newline);
            }
            prRound = prRound.nextRound;
        }
        this.writeln(bw, "</table>");
        this.writeln(bw, "</div>");
        this.writeln(bw, "</body></html>");
        bw.flush();
        bw.close();
        gravyStats.debug("writing HTML completed in... " + this.debug_processingTime_end(debug_writeHTML) + newline);
    }

    public String weaponStat_row(int type, String name, PlayerStats stats) {
        StringBuffer sb = new StringBuffer(2000);
        sb.append("<tr>");
        sb.append("<td class=\"name\">" + gravyStats.htmlcolourcodes(name) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 0) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 1, 4) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 5, 8) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 9, 10) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 11, 13) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 14) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 15) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 16) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 17) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 18) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 19) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 20) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 21, 24) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 25) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 26) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 27) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 28) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 29) + "</td>");
        sb.append("</tr>");
        return sb.toString();
    }

    public String teamSummary_simple(PlayerList team) {
        StringBuffer sb = new StringBuffer(5000);
        String alt = "statrow1";
        sb.append("<table class=\"teamSummary\" cellspacing=\"0\" rules=\"groups\" frame=\"void\">");
        sb.append("<colgroup><colgroup><colgroup span=\"4\"><colgroup>");
        sb.append("<thead><tr><th class=\"name\">Player</th><th>Eff</th><th>K</th><th title=\"Deaths including Suicides\">D*</th><th>/K</th><th>Gib</th><th>dmg</th></tr></thead>" + newline);
        Iterator i = team.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            sb.append("<tr class=\"" + alt + "\">");
            sb.append("<td class=\"name\" nowrap>" + gravyStats.htmlcolourcodes(p.getName()) + "</td><td class=\"eff\">" + this.twoDecimalPlaces.format(p.stats.efficiency) + "</td><td>" + p.stats.kills + "</td><td>" + (p.stats.deaths + p.stats.suicides) + "</td><td>" + p.stats.slashkills + "</td><td>" + p.stats.gibs + "</td><td>" + this.twoDecimalPlaces.format(p.stats.dmg_efficiency) + "</td></tr>" + newline);
            alt = alt.equals("statrow1") ? "statrow2" : "statrow1";
        }
        sb.append("<tbody><tr class=\"footer\"><td class=\"name\">" + team.teamname + (team.side == null ? "" : " <span class=\"side\">(" + team.side + ")</span>") + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.efficiency) + "</td><td>" + team.total_stats.kills + "</td><td>" + (team.total_stats.deaths + team.total_stats.suicides) + "</td><td>" + team.total_stats.slashkills + "</td><td>" + team.total_stats.gibs + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.dmg_efficiency) + "</td></tr></tbody>");
        sb.append("</table>" + newline);
        return sb.toString();
    }

    public String teamSummary_detailed(PlayerList team1, PlayerList team2) {
        StringBuffer sb = new StringBuffer(5000);
        sb.append("<table class=\"teamSummary_detailed\" cellspacing=\"0\" rules=\"groups\" frame=\"void\">");
        sb.append("<colgroup><colgroup span=\"2\"><colgroup span=\"6\"><colgroup span=\"2\"><colgroup span=\"3\"><colgroup span=\"3\">");
        sb.append("<thead><tr><th class=\"name\">Player</th><th title=\"Efficiency\">Eff</th><th title=\"Harsh efficiency - includes slash kills\">H-Eff</th><th title=\"Kills\">K</th><th title=\"Deaths\">D</th><th title=\"Suicides\">S</th><th title=\"Slash kills\">/K</th><th title=\"Team kills\">TK</th><th title=\"Gibs\">Gib</th><th title=\"Damage efficiency\">dmg</th><th title=\"Harsh damage efficiency - includes team damage\">H-dmg</th><th title=\"Damage given\">DG</th><th title=\"Damage received\">DR</th><th title=\"Team damage\">TD</th><th title=\"Damage given per kill\">d/k</th><th title=\"Damage received per death\">d/d</th><th title=\"Gibs per kill\">g/k</th><th title=\"XP\">XP</th></tr></thead>" + newline);
        sb.append(this.teamSummary_detailed_2(team1));
        sb.append(this.teamSummary_detailed_2(team2));
        sb.append("</table>" + newline);
        return sb.toString();
    }

    public String teamSummary_detailed_2(PlayerList team) {
        StringBuffer sb = new StringBuffer(5000);
        String alt = "statrow1";
        sb.append("<tbody>");
        Iterator i = team.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            sb.append("<tr class=\"" + alt + "\"><td class=\"name\" nowrap>");
            sb.append(gravyStats.htmlcolourcodes(p.getName()) + "</td><td class=\"eff\">" + this.twoDecimalPlaces.format(p.stats.efficiency) + "</td><td class=\"heff\">" + this.twoDecimalPlaces.format(p.stats.harsh_efficiency) + "</td><td>" + p.stats.kills + "</td><td>" + p.stats.deaths + "</td><td>" + p.stats.suicides + "</td><td>" + p.stats.slashkills + "</td><td>" + p.stats.teamkills + "</td><td>" + p.stats.gibs + "</td><td>" + this.twoDecimalPlaces.format(p.stats.dmg_efficiency) + "</td><td>" + this.twoDecimalPlaces.format(p.stats.harsh_dmg_efficiency) + "</td><td>" + p.stats.damageGiven + "</td><td>" + p.stats.damageReceived + "</td><td>" + p.stats.teamDamage + "</td><td>" + p.stats.damagePerKill + "</td><td>" + p.stats.damagePerDeath + "</td><td>" + this.twoDecimalPlaces.format(p.stats.gibsPerKill) + "</td><td>" + p.stats.xp);
            sb.append("</td></tr>" + newline);
            alt = alt.equals("statrow1") ? "statrow2" : "statrow1";
        }
        sb.append("</tbody>");
        sb.append("<tbody><tr class=\"footer\"><td class=\"name\">" + team.teamname + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.efficiency) + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.harsh_efficiency) + "</td><td>" + team.total_stats.kills + "</td><td>" + team.total_stats.deaths + "</td><td>" + team.total_stats.suicides + "</td><td>" + team.total_stats.slashkills + "</td><td>" + team.total_stats.teamkills + "</td><td>" + team.total_stats.gibs + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.dmg_efficiency) + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.harsh_dmg_efficiency) + "</td><td>" + team.total_stats.damageGiven + "</td><td>" + team.total_stats.damageReceived + "</td><td>" + team.total_stats.teamDamage + "</td><td>" + team.total_stats.damagePerKill + "</td><td>" + team.total_stats.damagePerDeath + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.gibsPerKill) + "</td><td>" + team.total_stats.xp + "</td></tr></tbody>");
        return sb.toString();
    }

    public String teamSummary_history(PlayerList team1, PlayerList team2) {
        StringBuffer sb = new StringBuffer(5000);
        sb.append("<table class=\"teamSummary_history\" cellspacing=\"0\" rules=\"groups\" frame=\"void\">");
        sb.append("<colgroup><colgroup>");
        sb.append("<thead><tr><th class=\"name\">Player</th><th title=\"History\">History</th></tr></thead>" + newline);
        sb.append(this.teamSummary_history_2(team1));
        sb.append(this.teamSummary_history_2(team2));
        sb.append("</table>" + newline);
        return sb.toString();
    }

    public String teamSummary_history_2(PlayerList team) {
        StringBuffer sb = new StringBuffer(5000);
        String alt = "statrow1";
        sb.append("<tbody>");
        Iterator i = team.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            sb.append("<tr class=\"" + alt + "\">");
            sb.append("<td class=\"name\" nowrap>");
            sb.append(gravyStats.htmlcolourcodes(p.getName()));
            sb.append("</td><td class=\"eff\">");
            sb.append(this.killHistory(p));
            sb.append("</td></tr>" + newline);
            alt = alt.equals("statrow1") ? "statrow2" : "statrow1";
        }
        sb.append("</tbody>");
        sb.append("<tbody><tr class=\"footer\"><td class=\"name\">" + team.teamname + "</td><td>&nbsp;</td></tr></tbody>");
        return sb.toString();
    }

    public String killHistory(Player p) {
        StringBuffer sb = new StringBuffer(2000);
        Iterator j = p.killEvents.iterator();
        while (j.hasNext()) {
            ParsedEvent event = (ParsedEvent)j.next();
            switch (event.eventType) {
                case 3: {
                    sb.append("<span class=\"slash\" title=\"slash killed\">/</span>");
                    break;
                }
                case 4: {
                    sb.append("<span class=\"sui\" title=\"suicided by " + event.mod.means + "\">S</span>");
                    break;
                }
                case 2: {
                    event.player1 = event.player1.trim();
                    event.player2 = event.player2.trim();
                    if (p.directNameMatch(event.player1, 1) || p.indirectNameMatch(event.player1, 1, false)) {
                        if (event.wasTK) {
                            sb.append("<span class=\"TKD\" title=\"team killed by " + Player.cleanName(event.player2) + " using " + event.mod.means + "\">t</span>");
                            break;
                        }
                        sb.append("<span class=\"D\" title=\"killed by " + Player.cleanName(event.player2) + " using " + event.mod.means + "\">D</span>");
                        break;
                    }
                    if (!p.directNameMatch(event.player2, 1) && !p.indirectNameMatch(event.player2, 1, false)) break;
                    if (event.wasTK) {
                        sb.append("<span class=\"TK\" title=\"team killed " + Player.cleanName(event.player1) + " using " + event.mod.means + "\">T</span>");
                        break;
                    }
                    sb.append("<span class=\"K\" title=\"killed " + Player.cleanName(event.player1) + " using " + event.mod.means + "\">K</span>");
                }
            }
        }
        return sb.toString();
    }

    public String killMatrix(PlayerList players) {
        StringBuffer sb = new StringBuffer(5000);
        String alt = "row1";
        sb.append("<table class=\"killmatrix\" cellspacing=\"0\"><tr><th>&nbsp;</th>");
        for (int i = 1; i <= players.size(); ++i) {
            sb.append("<th><b>" + i + "</b></th>");
        }
        sb.append("</tr>" + newline);
        int row = 1;
        Iterator i = players.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            sb.append("<tr class=\"" + alt + "\"><td class=\"name\"><b>").append(row).append("</b> ").append(gravyStats.htmlcolourcodes(p.getName())).append("</td>");
            Iterator k = players.iterator();
            while (k.hasNext()) {
                Player p2 = (Player)k.next();
                if (p.equals(p2)) {
                    sb.append("<td class=\"s\">" + p.stats.suicides + "</td>");
                    continue;
                }
                Integer c = (Integer)p.stats.killedPlayer.get(p2);
                if (c != null) {
                    sb.append("<td title=\"" + Player.cleanName(p2.getName()) + "\">" + c + "</td>");
                    continue;
                }
                c = (Integer)p.stats.teamKilledPlayer.get(p2);
                if (c != null) {
                    sb.append("<td class=\"t\" title=\"" + Player.cleanName(p2.getName()) + "\">" + c + "</td>");
                    continue;
                }
                sb.append("<td>&nbsp;</td>");
            }
            sb.append("</tr>" + newline);
            alt = alt.equals("row1") ? "row2" : "row1";
            ++row;
        }
        sb.append("</table>" + newline);
        return sb.toString();
    }

    public static String htmlcolourcodes(String name) {
        StringBuffer sb = new StringBuffer(name);
        for (int i = 0; i < sb.length() - 1; ++i) {
            String color;
            if (sb.charAt(i) != '^' || sb.charAt(i + 1) == '^') continue;
            char c = sb.charAt(i + 1);
            switch (Character.toLowerCase(c)) {
                case '0': {
                    color = "c0";
                    break;
                }
                case '1': {
                    color = "c1";
                    break;
                }
                case '2': {
                    color = "c2";
                    break;
                }
                case '3': {
                    color = "c3";
                    break;
                }
                case '4': {
                    color = "c4";
                    break;
                }
                case '5': {
                    color = "c5";
                    break;
                }
                case '6': {
                    color = "c6";
                    break;
                }
                case '7': {
                    color = "c7";
                    break;
                }
                case '8': {
                    color = "c8";
                    break;
                }
                case '9': {
                    color = "c9";
                    break;
                }
                case 'a': {
                    color = "ca";
                    break;
                }
                case 'b': {
                    color = "cb";
                    break;
                }
                case 'c': {
                    color = "cc";
                    break;
                }
                case 'd': {
                    color = "cd";
                    break;
                }
                case 'e': {
                    color = "ce";
                    break;
                }
                case 'f': {
                    color = "cf";
                    break;
                }
                case 'g': {
                    color = "cg";
                    break;
                }
                case 'h': {
                    color = "ch";
                    break;
                }
                case 'i': {
                    color = "ci";
                    break;
                }
                case 'j': {
                    color = "cj";
                    break;
                }
                case 'k': {
                    color = "ck";
                    break;
                }
                case 'l': {
                    color = "cl";
                    break;
                }
                case 'm': {
                    color = "cm";
                    break;
                }
                case 'n': {
                    color = "cn";
                    break;
                }
                case 'o': {
                    color = "co";
                    break;
                }
                case 'p': {
                    color = "cp";
                    break;
                }
                case 'q': {
                    color = "cq";
                    break;
                }
                case 'r': {
                    color = "cr";
                    break;
                }
                case 's': {
                    color = "cs";
                    break;
                }
                case 't': {
                    color = "ct";
                    break;
                }
                case 'u': {
                    color = "cu";
                    break;
                }
                case 'v': {
                    color = "cv";
                    break;
                }
                case 'w': {
                    color = "cw";
                    break;
                }
                case 'x': {
                    color = "cx";
                    break;
                }
                case 'y': {
                    color = "cy";
                    break;
                }
                case 'z': {
                    color = "cz";
                    break;
                }
                case '/': {
                    color = "csl";
                    break;
                }
                case '*': {
                    color = "cst";
                    break;
                }
                case '-': {
                    color = "cmi";
                    break;
                }
                case '+': {
                    color = "cpl";
                    break;
                }
                case '?': {
                    color = "cqu";
                    break;
                }
                case '@': {
                    color = "cat";
                    break;
                }
                default: {
                    color = "c0";
                }
            }
            sb.replace(i, i + 2, "</span><span class=\"" + color + "\">");
        }
        String r = "<span class=\"c0\">" + sb.toString() + "</span>";
        String s = r.replaceAll("<span class=\"c\\w+\"></span>", "");
        return s;
    }

    static {
        debug = false;
        newline = System.getProperty("line.separator");
    }
}

