/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;

class PlayerStats {
    int kills;
    int deaths;
    int suicides;
    int killstreak;
    int maxkillstreak;
    int deathstreak;
    int maxdeathstreak;
    int teamkills;
    int teamdeaths;
    int slashkills;
    int gibs;
    int damageGiven;
    int damageReceived;
    int teamDamage;
    int xp;
    HashMap killedPlayer = new HashMap(20);
    HashMap teamKilledPlayer = new HashMap(20);
    int[][] weaponStats = new int[2][MeansOfDeath.num_mod];
    float efficiency;
    float harsh_efficiency;
    float dmg_efficiency;
    float harsh_dmg_efficiency;
    int damagePerKill;
    int damagePerDeath;
    float gibsPerKill;
    int mm1count;

    public void deathStreak() {
        this.killstreak = 0;
        ++this.deathstreak;
        if (this.deathstreak > this.maxdeathstreak) {
            this.maxdeathstreak = this.deathstreak;
        }
    }

    public void killStreak() {
        this.deathstreak = 0;
        ++this.killstreak;
        if (this.killstreak > this.maxkillstreak) {
            this.maxkillstreak = this.killstreak;
        }
    }

    public void nullStreak() {
        this.killstreak = 0;
        this.deathstreak = 0;
    }

    PlayerStats() {
    }

    public String toString() {
        return this.kills + "k\\" + this.deaths + "d\\" + this.suicides + "s\\" + this.teamkills + "tk\\" + this.teamdeaths + "tkd\\" + this.slashkills + "slashk\\" + this.gibs + "gib\\" + this.damageGiven + "dg\\" + this.damageReceived + "dr\\" + this.teamDamage + "td";
    }

    public int getWeaponStat(int type, int index) {
        return this.getWeaponStat(type, index, index);
    }

    public int getWeaponStat(int type, int startindex, int endindex) {
        if (type == 0) {
            return this.getWeaponKillTotal(startindex, endindex);
        }
        if (type == 1) {
            return this.getWeaponDeathTotal(startindex, endindex);
        }
        return 0;
    }

    public int getWeaponKillTotal(int index) {
        return this.getWeaponKillTotal(index, index);
    }

    public int getWeaponKillTotal(int startindex, int endindex) {
        int total = 0;
        for (int i = startindex; i <= endindex; ++i) {
            total += this.weaponStats[0][i];
        }
        return total;
    }

    public int getWeaponDeathTotal(int index) {
        return this.getWeaponDeathTotal(index, index);
    }

    public int getWeaponDeathTotal(int startindex, int endindex) {
        int total = 0;
        for (int i = startindex; i <= endindex; ++i) {
            total += this.weaponStats[1][i];
        }
        return total;
    }

    static void syndicate(PlayerStats to, PlayerStats from) {
        to.kills += from.kills;
        to.deaths += from.deaths;
        to.suicides += from.suicides;
        to.teamkills += from.teamkills;
        to.teamdeaths += from.teamdeaths;
        to.slashkills += from.slashkills;
        for (int i = 0; i < MeansOfDeath.num_mod; ++i) {
            int[] nArray = to.weaponStats[0];
            int n = i;
            nArray[n] = nArray[n] + from.weaponStats[0][i];
            int[] nArray2 = to.weaponStats[1];
            int n2 = i;
            nArray2[n2] = nArray2[n2] + from.weaponStats[1][i];
        }
        to.gibs += from.gibs;
        to.damageGiven += from.damageGiven;
        to.damageReceived += from.damageReceived;
        to.teamDamage += from.teamDamage;
        to.xp += from.xp;
        if (from.maxkillstreak > to.maxkillstreak) {
            to.maxkillstreak = from.maxkillstreak;
        }
        if (from.maxdeathstreak > to.maxdeathstreak) {
            to.maxdeathstreak = from.maxdeathstreak;
        }
    }

    public void calculate_efficiencies() {
        this.efficiency = this.deaths + this.suicides > 0 ? (float)this.kills / (float)(this.deaths + this.suicides) : (float)this.kills;
        this.harsh_efficiency = this.deaths + this.suicides + this.slashkills > 0 ? (float)this.kills / (float)(this.deaths + this.suicides + this.slashkills) : (float)this.kills;
        this.dmg_efficiency = this.damageReceived > 0 ? (float)this.damageGiven / (float)this.damageReceived : 1.0f;
        this.harsh_dmg_efficiency = this.damageReceived + this.teamDamage > 0 ? (float)this.damageGiven / (float)(this.damageReceived + this.teamDamage) : 1.0f;
        this.damagePerKill = this.kills > 0 ? this.damageGiven / this.kills : 0;
        this.damagePerDeath = this.deaths > 0 ? this.damageReceived / this.deaths : 0;
        this.gibsPerKill = this.kills > 0 ? (float)this.gibs / (float)this.kills : 0.0f;
    }
}

