/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Comparator;

class Player {
    static final Comparator SORT_ORDER_EFFICIENCY = new Comparator(){

        public int compare(Object p1, Object p2) {
            float p1eff = ((Player)p1).stats.efficiency;
            float p2eff = ((Player)p2).stats.efficiency;
            if (p1eff == p2eff) {
                return 0;
            }
            if (p1eff < p2eff) {
                return -1;
            }
            if (p2eff < p1eff) {
                return 1;
            }
            return 0;
        }
    };
    static final short NAME_TYPE_FULL = 0;
    static final short NAME_TYPE_33 = 1;
    static final short NAME_TYPE_15 = 2;
    String[] names;
    ArrayList previous_names;
    boolean has_changed_names;
    int team;
    PlayerStats stats;
    ArrayList killEvents;
    static int idcount = 0;
    int id = idcount++;
    ArrayList teammates;
    ArrayList enemies;

    Player(String name, int nameType) {
        this.names = new String[3];
        this.names[nameType] = name;
        this.previous_names = new ArrayList(5);
        this.has_changed_names = false;
        this.stats = new PlayerStats();
        this.killEvents = new ArrayList(500);
        this.teammates = new ArrayList(10);
        this.enemies = new ArrayList(10);
    }

    boolean isTeammate(Player test) {
        return this.teammates.contains(test);
    }

    void addTeammate(Player teammate) {
        if (!this.isTeammate(teammate)) {
            this.teammates.add(teammate);
        }
    }

    boolean isEnemy(Player test) {
        return this.enemies.contains(test);
    }

    void addEnemy(Player enemy) {
        if (!this.isEnemy(enemy)) {
            this.enemies.add(enemy);
        }
    }

    public void rename(String newName, int nameType) {
        this.has_changed_names = true;
        String[] new_names = new String[3];
        new_names[nameType] = newName;
        this.previous_names.add(this.names);
        this.names = new_names;
    }

    public String getName() {
        if (this.names[0] != null) {
            return this.names[0];
        }
        if (this.names[1] != null) {
            return this.names[1];
        }
        if (this.names[2] != null) {
            return this.names[2];
        }
        return null;
    }

    public String getName(int nameType) {
        if (this.names[nameType] != null) {
            return this.names[nameType];
        }
        return null;
    }

    static void syndicate(Player to, Player from) {
        PlayerStats.syndicate(to.stats, from.stats);
    }

    static String cleanName2(String dirty) {
        StringBuffer sb = new StringBuffer(dirty);
        for (int i = 0; i < sb.length() - 1; ++i) {
            if (sb.charAt(i) != '^') continue;
            sb.delete(i, i + 2);
            --i;
        }
        return sb.toString();
    }

    static String cleanName(String dirty) {
        StringBuffer sb = new StringBuffer(dirty);
        for (int i = 0; i < sb.length() - 1; ++i) {
            if (sb.charAt(i) != '^' || sb.charAt(i + 1) == '^') continue;
            sb.delete(i, i + 2);
            --i;
        }
        if (sb.charAt(sb.length() - 1) == '^') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public boolean directNameMatch(String name, int nameType) {
        return this.names[nameType] != null && this.names[nameType].equals(name);
    }

    public boolean indirectNameMatch(String name, int nameType, boolean fillInTheGaps) {
        String storedName = null;
        String prname = name;
        switch (nameType) {
            case 0: {
                if (this.names[1] != null) {
                    if (prname.length() > 33) {
                        prname = prname.substring(0, 33);
                    }
                    if (prname.equals(this.names[1])) {
                        if (fillInTheGaps) {
                            this.names[0] = name;
                        }
                        return true;
                    }
                }
                if (this.names[2] == null) break;
                if ((prname = Player.cleanName(prname)).length() > 15) {
                    prname = prname.substring(0, 15);
                }
                if (!prname.equals(this.names[2])) break;
                if (fillInTheGaps) {
                    this.names[0] = name;
                }
                return true;
            }
            case 1: {
                if (this.names[0] != null) {
                    storedName = this.names[0];
                    if (storedName.length() > 33) {
                        storedName = storedName.substring(0, 33);
                    }
                    if (name.equals(storedName)) {
                        if (fillInTheGaps) {
                            this.names[1] = name;
                        }
                        return true;
                    }
                }
                if (this.names[2] == null) break;
                prname = name;
                storedName = this.names[2];
                if (prname.length() > 33) {
                    gravyStats.debug("warning: 33 name is greater than 33 chars >.<");
                }
                prname = Player.cleanName(prname);
                int prlength = prname.length();
                int stlength = storedName.length();
                if (prname.length() > 15) {
                    prname = prname.substring(0, 15);
                } else {
                    int ttt = prname.length();
                    if (storedName.length() > ttt) {
                        storedName = storedName.substring(0, ttt);
                    }
                }
                if (!prname.equals(storedName)) break;
                if (fillInTheGaps) {
                    this.names[1] = name;
                }
                return true;
            }
            case 2: {
                if (this.names[0] != null) {
                    storedName = Player.cleanName(this.names[0]);
                    if (storedName.length() > 15) {
                        storedName = storedName.substring(0, 15);
                    }
                    if (name.equals(storedName)) {
                        if (fillInTheGaps) {
                            this.names[2] = name;
                        }
                        return true;
                    }
                }
                if (this.names[1] == null) break;
                prname = name;
                storedName = Player.cleanName(this.names[1]);
                if (storedName.length() > 15) {
                    storedName = storedName.substring(0, 15);
                } else {
                    int ttt = storedName.length();
                    if (prname.length() > ttt) {
                        prname = prname.substring(0, ttt);
                    }
                }
                if (!prname.equals(storedName)) break;
                if (fillInTheGaps) {
                    this.names[2] = name;
                }
                return true;
            }
        }
        return false;
    }
}

