/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

class gravyStats {
    static String appName = "gravystats";
    static String version = "0.13";
    String logfileName = "etconsole.log";
    File logfile;
    File outputDirectory;
    File includeDirectory;
    File backupDirectory;
    JFrame window;
    static JTextArea output_textarea;
    static JTextArea debug_textarea;
    static JTextArea console_textarea;
    Pattern logfileOpenedEvent;
    Pattern enteredGameEvent;
    Pattern joinedTeamEvent;
    Pattern renamedEvent;
    Pattern teamKillEvent;
    Pattern generickillEvent;
    Pattern landmineKillEvent;
    Pattern mortarKillEvent;
    Pattern slashKillEvent;
    Pattern suicideEvent;
    Pattern mm1Event;
    Pattern matchPausedEvent;
    Pattern matchUnpausedEvent;
    Pattern etProRoundResetEvent;
    Pattern round1End1Event;
    Pattern round2End1Event;
    Pattern round2End2Event;
    Pattern mapNameEvent;
    Pattern mapNameEvent2;
    Pattern statlineEvent;
    Pattern statsallPlayerEvent;
    Pattern statsallWeaponEvent;
    Pattern used_headshot;
    Pattern used_noheadshot;
    Pattern notused_headshot;
    Pattern notused_noheadshot;
    Matcher match;
    Round currentRound;
    Round firstRound;
    Game currentGame;
    Game firstGame;
    Date logDate;
    String currentLoadedMap;
    String currentStatsallPlayerName;
    static String[] args;
    static boolean forcestatsall;
    static boolean debug;
    static boolean console;
    long starttime;
    HashMap debug_times = new HashMap();
    int debug_id = 1;
    boolean firstrealround = true;
    ArrayList awards = new ArrayList();
    static String newline;
    DecimalFormat twoDecimalPlaces = new DecimalFormat("0.00");
    DecimalFormat noDecimalPlaces = new DecimalFormat("0");
    int sortable_table_num = 1;

    public static void main(String[] args) {
        gravyStats.args = args;
        new gravyStats();
    }

    public gravyStats() {
        try {
            this.initialise();
            this.parseLogFile();
            this.buildGames();
            this.processRounds();
            this.processGames();
            this.generateAwards();
            this.writeHTML();
            this.stdout("complete");
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            this.stdout("ERROR: " + e.getMessage());
            StackTraceElement[] ste = e.getStackTrace();
            for (int i = 0; i < ste.length; ++i) {
                this.stdout("  " + ste[i].toString());
            }
            e.printStackTrace();
        }
    }

    public int debug_processingTime_start() {
        this.starttime = System.currentTimeMillis();
        this.debug_times.put(new Integer(this.debug_id), new Long(this.starttime));
        return this.debug_id++;
    }

    public long debug_processingTime_end(int id) {
        this.starttime = (Long)this.debug_times.get(new Integer(id));
        return System.currentTimeMillis() - this.starttime;
    }

    public static void debug(String s) {
        if (debug && debug_textarea != null) {
            debug_textarea.append(s + newline);
        }
    }

    public void test_harness() {
        this.name_test("^1M^7iss^zu^7sed^1*^7P^zantie^7S^1!", "^1M^7iss^zu^7sed^1*^7P^zantie^7S^", "Missused*Pantie");
        this.name_test("^0S^etr^va^7p^no^on^e.^oP^7antie^oS", "^0S^etr^va^7p^no^on^e.^oP^7antie^", "Strapon.PantieS");
        System.out.println();
        System.out.println("^3^^47^fD^5i^3^^0Mickeyy " + Player.cleanName("^3^^47^fD^5i^3^^0Mickeyy") + " " + Player.cleanName2("^3^^47^fD^5i^3^^0Mickeyy"));
        System.out.println("^0S^etr^va^7p^no^on^e.^oP^7antie^ " + Player.cleanName("^0S^etr^va^7p^no^on^e.^oP^7antie^") + " " + Player.cleanName2("^0S^etr^va^7p^no^on^e.^oP^7antie^"));
        System.out.println("^0-/^7S^9n^7a^9k^7e^0/- GOGO GADGET " + Player.cleanName("^0-/^7S^9n^7a^9k^7e^0/- GOGO GADGET") + " " + Player.cleanName2("^0-/^7S^9n^7a^9k^7e^0/- GOGO GADGET"));
    }

    public void name_test(String namefull, String name33, String name15) {
        Player p1 = new Player(namefull, 0);
        System.out.println("full: matching with 33: " + p1.indirectNameMatch(name33, 1, false));
        System.out.println("full: matching with 15: " + p1.indirectNameMatch(name15, 2, false));
        Player p2 = new Player(name33, 1);
        System.out.println("33: matching with full: " + p2.indirectNameMatch(namefull, 0, false));
        System.out.println("33: matching with 15: " + p2.indirectNameMatch(name15, 2, false));
        Player p3 = new Player(name15, 2);
        System.out.println("15: matching with full: " + p3.indirectNameMatch(namefull, 0, false));
        System.out.println("15: matching with 33: " + p3.indirectNameMatch(name15, 1, false));
    }

    public void stdout(String s) {
        if (output_textarea != null) {
            output_textarea.append(s + newline);
        }
    }

    public void copyFile(File in, File out) throws Exception {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        sourceChannel.close();
        destinationChannel.close();
    }

    static boolean AxisAttackingMap(String mapname) {
        if (mapname == null) {
            return false;
        }
        return mapname.equals("et_ice") || mapname.equals("railgun") || mapname.equals("vengence_final") || mapname.equals("caen");
    }

    public static String matchNames(String name1, String name2) {
        int maxlength = name1.length();
        if (name2.length() < maxlength) {
            maxlength = name2.length();
        }
        int charactersMatched = 0;
        for (int k = 0; k < maxlength && name1.charAt(k) == name2.charAt(k); ++k) {
            ++charactersMatched;
        }
        if (charactersMatched > 0) {
            String matched = name1.substring(0, charactersMatched);
            return matched;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() throws Exception {
        int debug_initialise = this.debug_processingTime_start();
        this.process_arguments();
        this.initialise_GUI();
        this.logfile = new File(this.logfileName);
        if (!this.logfile.exists() || !this.logfile.isFile()) {
            throw new Exception("Could not locate logfile");
        }
        this.outputDirectory = new File("gravystats");
        if (!(this.outputDirectory.exists() && this.outputDirectory.isDirectory() || this.outputDirectory.mkdir())) {
            throw new Exception("Could not create output directory");
        }
        this.includeDirectory = new File(this.outputDirectory.getCanonicalPath() + File.separator + "include");
        if (!(this.includeDirectory.exists() && this.includeDirectory.isDirectory() || this.includeDirectory.mkdir())) {
            throw new Exception("Could not create include directory");
        }
        this.backupDirectory = new File(this.outputDirectory.getCanonicalPath() + File.separator + "backup");
        File zipfile = new File("gravystats.jar");
        if (!zipfile.exists() || !zipfile.isFile()) {
            this.stdout("WARNING: Could not locate jar file. Skipping file extraction");
        } else {
            gravyStats.debug("checking resources");
            ZipFile zip = new ZipFile(zipfile);
            try {
                String js = "gravystats/include/gravy.js";
                String css = "gravystats/include/gravy.css";
                String sort_js = "gravystats/include/sorttable.js";
                String sort_up = "gravystats/include/upsimple.png";
                String sort_down = "gravystats/include/downsimple.png";
                if (!new File(js).exists()) {
                    this.extractResource(zip, js);
                }
                if (!new File(css).exists()) {
                    this.extractResource(zip, css);
                }
                if (!new File(sort_js).exists()) {
                    this.extractResource(zip, sort_js);
                }
                if (!new File(sort_up).exists()) {
                    this.extractResource(zip, sort_up);
                }
                if (!new File(sort_down).exists()) {
                    this.extractResource(zip, sort_down);
                }
            }
            finally {
                zip.close();
            }
        }
        this.initialisePatterns();
        gravyStats.debug("initialisation completed in... " + this.debug_processingTime_end(debug_initialise) + newline);
    }

    public void process_arguments() {
        int argcount = args.length;
        for (int argnum = 0; argnum < argcount; ++argnum) {
            if (args[argnum].equals("-debug")) {
                debug = true;
            }
            if (args[argnum].equals("-forcestatsall")) {
                forcestatsall = true;
            }
            if (!args[argnum].equals("-log") || ++argnum >= argcount) continue;
            this.logfileName = args[argnum];
        }
    }

    public void initialise_GUI() throws Exception {
        this.window = new JFrame(appName + " " + version);
        output_textarea = new JTextArea();
        output_textarea.setEditable(false);
        JScrollPane output_scroller = new JScrollPane(output_textarea);
        output_scroller.setPreferredSize(new Dimension(410, 150));
        output_scroller.setBorder(new LineBorder(Color.BLUE));
        if (debug) {
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab("output", output_scroller);
            debug_textarea = new JTextArea();
            debug_textarea.setEditable(false);
            JScrollPane debug_scroller = new JScrollPane(debug_textarea);
            debug_scroller.setPreferredSize(new Dimension(410, 150));
            tabs.addTab("debug", debug_scroller);
            if (console) {
                JPanel console_panel = new JPanel(new BorderLayout());
                final JTextField console_textfield = new JTextField(30);
                console_panel.add((Component)console_textfield, "South");
                console_textarea = new JTextArea();
                console_textarea.setEditable(false);
                JScrollPane console_scroller = new JScrollPane(console_textarea);
                console_scroller.setPreferredSize(new Dimension(410, 125));
                console_panel.add((Component)console_scroller, "Center");
                console_textfield.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        String text = console_textfield.getText();
                        String[] tokens = text.split("\\s+");
                        if (tokens.length > 0 && !tokens[0].equals("rounds")) {
                            if (tokens[0].equals("players")) {
                                Iterator i = Global.players.iterator();
                                while (i.hasNext()) {
                                    Player p = (Player)i.next();
                                    console_textarea.append(p.toString() + newline);
                                }
                            } else if (tokens[0].equals("aliases")) {
                                Iterator i = Global.players.iterator();
                                while (i.hasNext()) {
                                    Player p = (Player)i.next();
                                    Iterator j = p.previous_names.iterator();
                                    while (j.hasNext()) {
                                        String[] s = (String[])j.next();
                                        console_textarea.append(s[0] + " " + s[1] + " " + s[2] + newline);
                                    }
                                }
                            } else if (tokens[0].equals("modify")) {
                                // empty if block
                            }
                        }
                        console_textarea.append(text + newline);
                        console_textfield.setText("");
                    }
                });
                tabs.addTab("console", console_panel);
            }
            this.window.getContentPane().add((Component)tabs, "Center");
        } else {
            this.window.getContentPane().add((Component)output_scroller, "Center");
        }
        this.window.setDefaultCloseOperation(3);
        this.window.pack();
        this.window.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractResource(ZipFile zip, String file) {
        block11: {
            if (zip == null || file == null) {
                return;
            }
            try {
                gravyStats.debug("extracting " + file);
                ZipEntry entry = zip.getEntry(file);
                if (entry != null) {
                    InputStream entryStream = zip.getInputStream(entry);
                    try {
                        FileOutputStream fileout = new FileOutputStream(entry.getName());
                        try {
                            int bytesRead;
                            byte[] buffer = new byte[1024];
                            while ((bytesRead = entryStream.read(buffer)) != -1) {
                                fileout.write(buffer, 0, bytesRead);
                            }
                            break block11;
                        }
                        finally {
                            fileout.close();
                        }
                    }
                    finally {
                        entryStream.close();
                    }
                }
                throw new IOException("not found");
            }
            catch (IOException ioe) {
                gravyStats.debug("extraction of " + file + " from " + zip + " failed");
                gravyStats.debug(ioe.toString());
                this.stdout("WARNING: couldnt extract " + file);
            }
        }
    }

    public void initialisePatterns() {
        this.logfileOpenedEvent = Pattern.compile("^logfile opened on (.+)$");
        this.enteredGameEvent = Pattern.compile("^\\[skipnotify\\](.+)\\^7 entered the game$");
        this.joinedTeamEvent = Pattern.compile("^(.+)\\^7 has joined the (.+)\\^7!$");
        this.renamedEvent = Pattern.compile("^\\[skipnotify\\](.+)\\^7 renamed to (.+)$");
        this.teamKillEvent = Pattern.compile("^\\^1TEAM KILL\\^7: (.+)$");
        this.generickillEvent = Pattern.compile("^(.+)\\^7 (was .+ by) (.+)\\^7's (.+)$");
        this.landmineKillEvent = Pattern.compile("^(.+)\\^7 (failed to spot) (.+)\\^7's (Landmine)$");
        this.mortarKillEvent = Pattern.compile("^(.+)\\^7 (never saw) (.+)\\^7's (mortar round coming)$");
        this.slashKillEvent = Pattern.compile("^(.+)\\^7 killed himself.$");
        this.suicideEvent = Pattern.compile("^(.+)\\^7 (dove on his own grenade|ate his own rifle grenade|dynamited himself to pieces|failed to spot his own landmine|vaporized himself|played with fire|never saw his own mortar round coming|ate his own artillery fire|obliterated himself|danced on his airstrike marker|embraced his own satchel explosion|engineered himself into oblivion|fell to his death|was crushed|drowned|was killed to death)\\.$");
        this.mm1Event = Pattern.compile("^(.+)\\^7: \\^2(.+)$");
        this.matchPausedEvent = Pattern.compile("^\\[skipnotify\\]\\*\\*\\* \\^3INFO: \\^5\\^3Match is \\^1PAUSED\\^3! \\(\\^\\d(\\w+)\\^7\\^3\\)$");
        this.matchUnpausedEvent = Pattern.compile("^\\^3Match is \\^5UNPAUSED\\^3 \\.\\.\\. resuming in 10 seconds!$");
        this.etProRoundResetEvent = Pattern.compile("^\\[skipnotify\\]etpro: Server version (.+)$");
        this.round1End1Event = Pattern.compile("^\\[skipnotify\\]>>> \\^3Clock set to: (.+)$");
        this.round2End1Event = Pattern.compile("^\\[skipnotify\\]>>> \\^3Objective reached at (.+) \\(original: (.+)\\)$");
        this.round2End2Event = Pattern.compile("^\\[skipnotify\\]>>> \\^3Objective NOT reached in time \\((.+)\\)$");
        this.mapNameEvent = Pattern.compile("^\\^3>>> Map: \\^2(.+)$");
        this.mapNameEvent2 = Pattern.compile("^LOADING\\.\\.\\. maps/(.+)\\.bsp$");
        this.statlineEvent = Pattern.compile("^\\[skipnotify\\]\\^\\d(.+)\\^7\\s*\\^\\d(.+?)\\s*\\^3\\s*(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\^\\d\\s+(\\d+)\\^\\d\\s+(\\d+)\\^\\d\\s+(\\d+)\\^\\d\\s+(\\d+)\\^\\d\\s+(\\d+)\\^\\d\\s+(\\d+)$");
        this.statsallPlayerEvent = Pattern.compile("^(?:\\[skipnotify\\])?\\^7Overall stats for: \\^3(.+) \\^7\\(\\^2\\d\\^7 Round[s]*\\)$");
        this.statsallWeaponEvent = Pattern.compile("^(?:\\[skipnotify\\])?\\^3(.+):\\s+((\\^7.+\\^5.+)?\\^2.+\\^1.+)$");
        this.used_headshot = Pattern.compile("^\\^7\\s*(\\d+\\.\\d)\\s\\^5\\s*(\\d+)/(\\d+)\\s+\\^2\\s+(\\d+)\\s\\^1\\s+(\\d+)\\s\\^3\\s+(\\d+)$");
        this.used_noheadshot = Pattern.compile("^\\^7\\s*(\\d+\\.\\d)\\s\\^5\\s*(\\d+)/(\\d+)\\s+\\^2\\s+(\\d+)\\s\\^1\\s+(\\d+)$");
        this.notused_headshot = Pattern.compile("^\\^2\\s+(\\d+)\\s\\^1\\s+(\\d+)\\s\\^3\\s+(\\d+)$");
        this.notused_noheadshot = Pattern.compile("^\\^2\\s+(\\d+)\\s\\^1\\s+(\\d+)$");
    }

    public void parseLogFile() throws Exception {
        String nextLine;
        int debug_parseLogFile = this.debug_processingTime_start();
        gravyStats.debug("parsing...");
        this.stdout("Opening logfile...");
        BufferedReader br = new BufferedReader(new FileReader(this.logfileName));
        this.firstRound = this.currentRound = new Round();
        int lineCount = 0;
        while ((nextLine = br.readLine()) != null) {
            this.parseLine(nextLine);
            ++lineCount;
        }
        br.close();
        this.stdout(lineCount + " lines read");
        gravyStats.debug("parsing completed in... " + this.debug_processingTime_end(debug_parseLogFile) + newline);
    }

    public void parseLine(String line) throws Exception {
        if (line.startsWith("GL_EXTENSIONS:")) {
            return;
        }
        if (line.startsWith("Userinfo:")) {
            return;
        }
        if (line.equals("Match starting...")) {
            this.currentRound.roundType = (short)3;
            return;
        }
        if (line.equals("[skipnotify]^1FIGHT!")) {
            if (this.currentRound.roundType == 0) {
                this.currentRound.roundType = (short)4;
            }
            return;
        }
        if (line.equals("[skipnotify]Timelimit hit.")) {
            this.currentRound.timelimitHit = true;
            return;
        }
        this.match = this.enteredGameEvent.matcher(line);
        if (this.match.find()) {
            this.currentRound.eventList.add(new ParsedEvent(6, this.match.group(1), null, null, null, false));
            return;
        }
        this.match = this.mapNameEvent.matcher(line);
        if (this.match.find()) {
            if (!this.currentRound.mapname.equals(this.match.group(1))) {
                this.stdout("WARNING: end of round map name - " + this.match.group(1) + " - overriding loaded map name - " + this.currentRound.mapname);
            }
            this.currentRound.mapname = this.match.group(1);
            return;
        }
        this.match = this.mapNameEvent2.matcher(line);
        if (this.match.find()) {
            if (this.currentLoadedMap == null) {
                this.currentRound.mapname = this.currentLoadedMap = this.match.group(1);
            } else {
                this.currentLoadedMap = this.match.group(1);
            }
            gravyStats.debug("current map set to " + this.currentLoadedMap);
            return;
        }
        this.match = this.logfileOpenedEvent.matcher(line);
        if (this.match.find()) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.ENGLISH);
                if (this.logDate == null) {
                    this.logDate = df.parse(this.match.group(1));
                }
            }
            catch (Exception e) {
                this.stdout("WARNING: couldn't parse log date, ignoring");
            }
            return;
        }
        this.match = this.etProRoundResetEvent.matcher(line);
        if (this.match.find()) {
            Round newRound;
            this.currentRound.nextRound = newRound = new Round();
            newRound.prevRound = this.currentRound;
            this.currentRound = newRound;
            this.currentRound.mapname = this.currentLoadedMap;
            return;
        }
        this.match = this.round1End1Event.matcher(line);
        if (this.match.find()) {
            this.currentRound.roundTime = this.match.group(1);
            this.currentRound.roundType = 1;
            return;
        }
        this.match = this.round2End1Event.matcher(line);
        if (this.match.find()) {
            this.currentRound.roundTime = this.match.group(1);
            this.currentRound.roundType = (short)2;
            return;
        }
        this.match = this.round2End2Event.matcher(line);
        if (this.match.find()) {
            this.currentRound.roundTime = this.match.group(1);
            this.currentRound.roundType = (short)2;
            return;
        }
        this.match = this.renamedEvent.matcher(line);
        if (this.match.find()) {
            this.currentRound.eventList.add(new ParsedEvent(1, this.match.group(1), this.match.group(2), "", "", false));
            return;
        }
        boolean wasTK = false;
        this.match = this.teamKillEvent.matcher(line);
        if (this.match.find()) {
            line = this.match.group(1);
            wasTK = true;
        }
        if ((this.match = this.generickillEvent.matcher(line)).find()) {
            String player1 = this.match.group(1);
            String method1 = this.match.group(2);
            String player2 = this.match.group(3);
            String method2 = this.match.group(4);
            this.currentRound.eventList.add(new ParsedEvent(2, player1, player2, method1, method2, wasTK));
            return;
        }
        this.match = this.landmineKillEvent.matcher(line);
        if (this.match.find()) {
            String player1 = this.match.group(1);
            String method1 = this.match.group(2);
            String player2 = this.match.group(3);
            String method2 = this.match.group(4);
            this.currentRound.eventList.add(new ParsedEvent(2, player1, player2, method1, method2, wasTK));
            return;
        }
        this.match = this.mortarKillEvent.matcher(line);
        if (this.match.find()) {
            String player1 = this.match.group(1);
            String method1 = this.match.group(2);
            String player2 = this.match.group(3);
            String method2 = this.match.group(4);
            this.currentRound.eventList.add(new ParsedEvent(2, player1, player2, method1, method2, wasTK));
            return;
        }
        this.match = this.slashKillEvent.matcher(line);
        if (this.match.find()) {
            String player1 = this.match.group(1);
            this.currentRound.eventList.add(new ParsedEvent(3, player1, null, null, null, false));
            return;
        }
        this.match = this.suicideEvent.matcher(line);
        if (this.match.find()) {
            String player1 = this.match.group(1);
            String method1 = this.match.group(2);
            this.currentRound.eventList.add(new ParsedEvent(4, player1, null, method1, null, false));
            return;
        }
        this.match = this.mm1Event.matcher(line);
        if (this.match.find()) {
            this.currentRound.mm1.add(line);
            this.currentRound.eventList.add(new ParsedEvent(7, this.match.group(1), null, null, null, false));
            return;
        }
        this.match = this.matchPausedEvent.matcher(line);
        if (this.match.find()) {
            this.currentRound.mm1.add(this.match.group(1) + " PAUSED THE MATCH");
            return;
        }
        this.match = this.matchUnpausedEvent.matcher(line);
        if (this.match.find()) {
            this.currentRound.mm1.add("Match Resuming in 10 seconds");
            return;
        }
        this.match = this.statlineEvent.matcher(line);
        if (this.match.find()) {
            this.currentRound.eventList.add(new ParsedEvent(5, this.match.group(2), null, line, null, false));
            return;
        }
        this.match = this.statsallPlayerEvent.matcher(line);
        if (this.match.find()) {
            this.currentStatsallPlayerName = this.match.group(1);
            return;
        }
        this.match = this.statsallWeaponEvent.matcher(line);
        if (this.match.find()) {
            this.currentRound.eventList.add(new ParsedEvent(8, this.currentStatsallPlayerName, null, this.match.group(1), this.match.group(2), true));
            return;
        }
    }

    public void buildGames() throws Exception {
        int debug_buildGames = this.debug_processingTime_start();
        gravyStats.debug("building games...");
        Round prRound = this.firstRound;
        int roundNumber = 1;
        while (prRound != null) {
            Game g;
            gravyStats.debug("round number " + roundNumber + " " + prRound.toString());
            if (prRound.eventList.size() == 0) {
                gravyStats.debug(" - no events found, dumped");
                prRound.roundType = (short)5;
            } else if (!prRound.createsPlayers()) {
                gravyStats.debug(" - " + prRound.eventList.size() + " events but no players! dumped");
                prRound.roundType = (short)5;
            }
            if (prRound.roundType == 0) {
                gravyStats.debug(" - unknown round type found");
            }
            if (prRound.roundType == 4) {
                gravyStats.debug(" - active round type found...");
                prRound.processActiveRound();
            }
            if (prRound.roundType == 1) {
                if (this.firstGame == null) {
                    this.firstGame = this.currentGame = new Game();
                } else {
                    this.currentGame.nextGame = g = new Game();
                    g.prevGame = this.currentGame;
                    this.currentGame = g;
                }
                this.currentGame.round1 = prRound;
                prRound.parentGame = this.currentGame;
            }
            if (prRound.roundType == 2) {
                if (this.firstGame == null) {
                    this.firstGame = this.currentGame = new Game();
                }
                if (this.currentGame.round2 != null) {
                    this.currentGame.nextGame = g = new Game();
                    g.prevGame = this.currentGame;
                    this.currentGame = g;
                }
                this.currentGame.round2 = prRound;
                prRound.parentGame = this.currentGame;
            }
            prRound = prRound.nextRound;
            ++roundNumber;
        }
        if (this.firstGame == null) {
            gravyStats.debug("first game is null, trying to fix...");
            if (this.firstRound.roundType == 0 && this.firstRound.nextRound == null) {
                this.firstRound.roundType = 1;
                this.firstGame = this.currentGame = new Game();
                this.currentGame.round1 = this.firstRound;
                this.firstRound.parentGame = this.currentGame;
                gravyStats.debug("rectified");
            } else {
                throw new Exception("couldnt create game :(");
            }
        }
        gravyStats.debug("building games completed in... " + this.debug_processingTime_end(debug_buildGames) + newline);
    }

    public void processRounds() throws Exception {
        int debug_processRounds = this.debug_processingTime_start();
        gravyStats.debug("processing rounds...");
        Round prRound = this.firstRound;
        int roundNumber = 1;
        while (prRound != null) {
            this.processEvents(prRound);
            this.processEvents2(prRound);
            gravyStats.debug("round number " + roundNumber + " " + prRound.toString());
            if (prRound.roundType == 1 || prRound.roundType == 2) {
                prRound.buildTeams();
                if (prRound.roundType == 2) {
                    this.subtractRound1Stats(prRound);
                }
                this.buildRoundStats(prRound);
                this.updateGlobalPlayers(prRound);
                this.updateGlobalTeams(prRound);
            }
            prRound = prRound.nextRound;
            ++roundNumber;
        }
        gravyStats.debug("processing rounds completed in... " + this.debug_processingTime_end(debug_processRounds) + newline);
    }

    public void processEvents(Round prRound) {
        Iterator i = prRound.eventList.iterator();
        block8: while (i.hasNext()) {
            ParsedEvent event = (ParsedEvent)i.next();
            switch (event.eventType) {
                case 1: {
                    String oldName = event.player1;
                    String newName = event.player2;
                    Player p1 = prRound.players.getPlayer(oldName, 0, false);
                    Player p2 = prRound.players.getPlayer(newName, 0, false);
                    if (p1 != null && p2 == null) {
                        p1.rename(newName, 0);
                    }
                    Player p1_global = Global.players.getPlayer(oldName, 0, false);
                    Player p2_global = Global.players.getPlayer(newName, 0, false);
                    if (p1_global == null || p2_global != null) break;
                    p1_global.rename(newName, 0);
                    break;
                }
                case 2: {
                    if (prRound.roundType != 1 && prRound.roundType != 2) break;
                    this.processKillEvent(prRound, event);
                    break;
                }
                case 3: {
                    if (prRound.roundType != 1 && prRound.roundType != 2) break;
                    String name = event.player1;
                    Player p1 = prRound.players.getPlayer(name, 1, true);
                    ++p1.stats.slashkills;
                    p1.killEvents.add(event);
                    p1.stats.nullStreak();
                    break;
                }
                case 4: {
                    if (prRound.roundType != 1 && prRound.roundType != 2) break;
                    String name = event.player1;
                    String means = event.method1;
                    Player p1 = prRound.players.getPlayer(name, 1, true);
                    ++p1.stats.suicides;
                    p1.killEvents.add(event);
                    p1.stats.deathStreak();
                    boolean found = false;
                    for (int j = 0; j < MeansOfDeath.num_mod; ++j) {
                        MeansOfDeath m = MeansOfDeath.mod[j];
                        if (m.suicideString == null || !m.suicideString.equals(means)) continue;
                        event.mod = m;
                        found = true;
                        break;
                    }
                    if (found) continue block8;
                    event.mod = MeansOfDeath.mod_unknown;
                    gravyStats.debug("means of suicide not found " + means);
                    break;
                }
                case 5: {
                    String line = event.method1;
                    this.match = this.statlineEvent.matcher(line);
                    if (!this.match.find()) break;
                    String name = event.player1;
                    Player p1 = prRound.players.getPlayer(name, 2, false);
                    if (p1 != null) {
                        String team = this.match.group(1);
                        if (team.equals("Allies")) {
                            p1.team = 1;
                        } else if (team.equals("Axis")) {
                            p1.team = 2;
                        }
                        p1.stats.gibs = Integer.parseInt(this.match.group(8));
                        p1.stats.damageGiven = Integer.parseInt(this.match.group(9));
                        p1.stats.damageReceived = Integer.parseInt(this.match.group(10));
                        p1.stats.teamDamage = Integer.parseInt(this.match.group(11));
                        p1.stats.xp = Integer.parseInt(this.match.group(12));
                        break;
                    }
                    gravyStats.debug("player not found for stat line event: " + name);
                    break;
                }
                case 7: {
                    String name = event.player1;
                    Player p1 = prRound.players.getPlayer(name, 0, false);
                    Player p2 = Global.players.getPlayer(name, 0, false);
                    if (p1 != null) {
                        ++p1.stats.mm1count;
                    }
                    if (p2 == null) break;
                    ++p2.stats.mm1count;
                }
            }
        }
    }

    public void processEvents2(Round prRound) {
        Iterator i = prRound.eventList.iterator();
        while (i.hasNext()) {
            ParsedEvent event = (ParsedEvent)i.next();
            switch (event.eventType) {
                case 6: {
                    String name = event.player1;
                    prRound.players.getPlayer(name, 0, false);
                    Global.players.getPlayer(name, 0, false);
                    break;
                }
                case 8: {
                    String name = event.player1;
                    String stat = event.method1.trim();
                    String line = event.method2.trim();
                    Player p1 = prRound.players.getPlayer(name, 0, false, false);
                    if (p1 != null) {
                        p1.stats.statsallobserved = true;
                        if (!stat.equals("Syringe") || !(this.match = this.used_noheadshot.matcher(line)).find()) break;
                        p1.stats.revives = Integer.parseInt(this.match.group(2));
                        p1.stats.reviveAttempts = Integer.parseInt(this.match.group(3));
                        break;
                    }
                    gravyStats.debug("couldnt find player for statsall event for : " + name);
                }
            }
        }
    }

    public void processKillEvent(Round round, ParsedEvent event) {
        boolean p2_hasteam;
        String player1 = event.player1;
        String player2 = event.player2;
        String method1 = event.method1;
        String method2 = event.method2;
        boolean wasTK = event.wasTK;
        Player p1 = round.players.getPlayer(player1, 1, true);
        Player p2 = round.players.getPlayer(player2, 1, true);
        Player p1_global = Global.players.getPlayer(player1, 1, true);
        Player p2_global = Global.players.getPlayer(player2, 1, true);
        p1.killEvents.add(event);
        p2.killEvents.add(event);
        boolean p1_hasteam = p1.team == 1 || p1.team == 2;
        boolean bl = p2_hasteam = p2.team == 1 || p2.team == 2;
        if (!wasTK) {
            ++p1.stats.deaths;
            p1.stats.deathStreak();
            ++p2.stats.kills;
            p2.stats.killStreak();
            if (p2_global.stats.killedPlayer.containsKey(p1_global)) {
                p2_global.stats.killedPlayer.put(p1_global, new Integer((Integer)p2_global.stats.killedPlayer.get(p1_global) + 1));
            } else {
                p2_global.stats.killedPlayer.put(p1_global, new Integer(1));
            }
            p1.addEnemy(p2);
            p2.addEnemy(p1);
            boolean found = false;
            for (int i = 0; i < MeansOfDeath.num_mod; ++i) {
                MeansOfDeath m = MeansOfDeath.mod[i];
                if (m.weaponString == null || !m.weaponString.equals(method2) || m.methodString == null || !m.methodString.equals(method1)) continue;
                int[] nArray = p2.stats.weaponStats[0];
                int n = i;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = p1.stats.weaponStats[1];
                int n2 = i;
                nArray2[n2] = nArray2[n2] + 1;
                event.mod = m;
                found = true;
                break;
            }
            if (!found) {
                event.mod = MeansOfDeath.mod_unknown;
                gravyStats.debug("means of death not found " + method1 + " - " + method2);
            }
            if (p1_hasteam && !p2_hasteam) {
                if (p1.team == 1) {
                    p2.team = 2;
                } else if (p1.team == 2) {
                    p2.team = 1;
                }
            }
            if (p2_hasteam && !p1_hasteam) {
                if (p2.team == 1) {
                    p1.team = 2;
                } else if (p2.team == 2) {
                    p1.team = 1;
                }
            }
        } else {
            ++p1.stats.teamdeaths;
            ++p2.stats.teamkills;
            if (p2_global.stats.teamKilledPlayer.containsKey(p1_global)) {
                p2_global.stats.teamKilledPlayer.put(p1_global, new Integer((Integer)p2_global.stats.teamKilledPlayer.get(p1_global) + 1));
            } else {
                p2_global.stats.teamKilledPlayer.put(p1_global, new Integer(1));
            }
            p1.addTeammate(p2);
            p2.addTeammate(p1);
            boolean found = false;
            for (int i = 0; i < MeansOfDeath.num_mod; ++i) {
                MeansOfDeath m = MeansOfDeath.mod[i];
                if (m.weaponString == null || !m.weaponString.equals(method2) || m.methodString == null || !m.methodString.equals(method1)) continue;
                event.mod = m;
                found = true;
                break;
            }
            if (!found) {
                event.mod = MeansOfDeath.mod_unknown;
                gravyStats.debug("means of death not found " + method1 + " - " + method2);
            }
            if (p1_hasteam && !p2_hasteam) {
                if (p1.team == 1) {
                    p2.team = 1;
                } else if (p1.team == 2) {
                    p2.team = 2;
                }
            }
            if (p2_hasteam && !p1_hasteam) {
                if (p2.team == 1) {
                    p1.team = 1;
                } else if (p2.team == 2) {
                    p1.team = 2;
                }
            }
        }
    }

    public void subtractRound1Stats(Round prRound) {
        if (prRound.roundType != 2) {
            return;
        }
        Round round1 = prRound.parentGame.round1;
        if (round1 == null) {
            gravyStats.debug("subtractRound1Stats, round1 doesnt exist, aborting");
            return;
        }
        Iterator i = prRound.players.iterator();
        while (i.hasNext()) {
            Player p1 = (Player)i.next();
            Player p2 = round1.players.getPlayer(p1.getName(), 0, false, false);
            if (p2 == null) {
                gravyStats.debug("subtractRound1Stats, not found: " + p1.getName());
                Player global = Global.players.getPlayer(p1.getName(), 0, false, false);
                if (global == null) {
                    gravyStats.debug("no global player :(");
                } else {
                    Iterator j = global.previous_names.iterator();
                    while (j.hasNext()) {
                        String[] s = (String[])j.next();
                        String bestName = s[0] == null ? (s[1] == null ? s[2] : s[1]) : s[0];
                        if (bestName == null) continue;
                        gravyStats.debug("previous name: " + bestName);
                        Player p3 = round1.players.getPlayer(bestName, 0, false, false);
                        if (p3 == null) continue;
                        gravyStats.debug("found!");
                        p2 = p3;
                        break;
                    }
                }
            }
            if (p2 == null) continue;
            int old_dg = p2.stats.damageGiven;
            int dg = p1.stats.damageGiven;
            int old_dr = p2.stats.damageReceived;
            int dr = p1.stats.damageReceived;
            int old_td = p2.stats.teamDamage;
            int td = p1.stats.teamDamage;
            int old_gibs = p2.stats.gibs;
            int gibs = p1.stats.gibs;
            int old_rev = p2.stats.revives;
            int rev = p1.stats.revives;
            int old_reva = p2.stats.reviveAttempts;
            int reva = p1.stats.reviveAttempts;
            if (old_dg > 0 && old_dg <= dg) {
                dg -= old_dg;
            }
            if (old_dr > 0 && old_dr <= dr) {
                dr -= old_dr;
            }
            if (old_td > 0 && old_td <= td) {
                td -= old_td;
            }
            if (old_gibs > 0 && old_gibs <= gibs) {
                gibs -= old_gibs;
            }
            if (old_rev > 0 && old_rev <= rev) {
                rev -= old_rev;
            }
            if (old_reva > 0 && old_reva <= reva) {
                reva -= old_reva;
            }
            p1.stats.damageGiven = dg;
            p1.stats.damageReceived = dr;
            p1.stats.teamDamage = td;
            p1.stats.gibs = gibs;
            p1.stats.revives = rev;
            p1.stats.reviveAttempts = reva;
        }
    }

    public void buildRoundStats(Round prRound) {
        Iterator i = prRound.players.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            p.stats.calculate_efficiencies();
            if (p.stats.statsallobserved) {
                prRound.statsallobserved[1] = prRound.statsallobserved[1] + 1;
                continue;
            }
            prRound.statsallobserved[0] = prRound.statsallobserved[0] + 1;
        }
        float statsallobservedratio = (float)prRound.statsallobserved[1] / (float)(prRound.statsallobserved[1] + prRound.statsallobserved[0]);
        gravyStats.debug("statsall observed ratio: " + prRound.statsallobserved[1] + " / " + (prRound.statsallobserved[1] + prRound.statsallobserved[0]) + "  " + statsallobservedratio);
        prRound.statsall = (double)statsallobservedratio > 0.6;
        Collections.sort(prRound.team1, Player.SORT_ORDER_EFFICIENCY);
        Collections.reverse(prRound.team1);
        Collections.sort(prRound.team2, Player.SORT_ORDER_EFFICIENCY);
        Collections.reverse(prRound.team2);
        prRound.team1.calculate_total();
        prRound.team2.calculate_total();
    }

    public void updateGlobalPlayers(Round prRound) {
        Iterator j = prRound.players.iterator();
        while (j.hasNext()) {
            Player round = (Player)j.next();
            Player global = Global.players.getPlayer(round.getName(), 0, true, false);
            Player.syndicate(global, round);
        }
    }

    public void updateGlobalTeams(Round prRound) throws Exception {
        if (this.firstrealround) {
            Player p2;
            Player p;
            this.firstrealround = false;
            gravyStats.debug("updateGlobalTeams - first round " + Global.players.size());
            Iterator j = prRound.team1.iterator();
            while (j.hasNext()) {
                p = (Player)j.next();
                p2 = Global.players.getPlayer(p.getName(), 0, true, false);
                p2.team = 1;
            }
            prRound.team1.globalteam = 1;
            j = prRound.team2.iterator();
            while (j.hasNext()) {
                p = (Player)j.next();
                p2 = Global.players.getPlayer(p.getName(), 0, true, false);
                p2.team = 2;
            }
            prRound.team2.globalteam = 2;
        } else {
            Player p2;
            Player p;
            int team1score = 0;
            int team2score = 0;
            int team1update = 0;
            int team2update = 0;
            ArrayList<Player> updateme = new ArrayList<Player>();
            gravyStats.debug("updateGlobalTeams - building team scores " + Global.players.size());
            Iterator j = prRound.team1.iterator();
            while (j.hasNext()) {
                p = (Player)j.next();
                p2 = Global.players.getPlayer(p.getName(), 0, false, false);
                if (p2 != null) {
                    if (p2.team == 1) {
                        ++team1score;
                        continue;
                    }
                    if (p2.team == 2) {
                        --team1score;
                        continue;
                    }
                    updateme.add(p);
                    continue;
                }
                gravyStats.debug("WARNING: updateGlobalTeams - global player not found for " + p.getName() + " (team1)");
            }
            gravyStats.debug("team1 score is " + team1score + " so they are " + (team1score == 0 ? "unknown" : (team1score > 0 ? "likely global1" : "likely global2")));
            j = prRound.team2.iterator();
            while (j.hasNext()) {
                p = (Player)j.next();
                p2 = Global.players.getPlayer(p.getName(), 0, false, false);
                if (p2 != null) {
                    if (p2.team == 1) {
                        ++team2score;
                        continue;
                    }
                    if (p2.team == 2) {
                        --team2score;
                        continue;
                    }
                    updateme.add(p);
                    continue;
                }
                gravyStats.debug("WARNING: updateGlobalTeams - global player not found for " + p.getName() + " (team2)");
            }
            gravyStats.debug("team2 score is " + team2score + " so they are " + (team2score == 0 ? "unknown" : (team2score > 0 ? "likely global1" : "likely global2")));
            if (team1score > 0 && team2score < 0) {
                team1update = 1;
                prRound.team1.globalteam = 1;
                team2update = 2;
                prRound.team2.globalteam = 2;
            } else if (team1score < 0 && team2score > 0) {
                team1update = 2;
                prRound.team1.globalteam = 2;
                team2update = 1;
                prRound.team2.globalteam = 1;
            } else if (team1score > team2score) {
                gravyStats.debug("WARNING: dubious teams");
                team1update = 1;
                prRound.team1.globalteam = 1;
                team2update = 2;
                prRound.team2.globalteam = 2;
            } else {
                gravyStats.debug("WARNING: dubious teams");
                team1update = 2;
                prRound.team1.globalteam = 2;
                team2update = 1;
                prRound.team2.globalteam = 1;
            }
            j = updateme.iterator();
            while (j.hasNext()) {
                p = (Player)j.next();
                p2 = Global.players.getPlayer(p.getName(), 0, false, false);
                gravyStats.debug("updating global players team for " + p.getName());
                if (p2 != null) {
                    if (p.team == 1) {
                        p2.team = team1update;
                        continue;
                    }
                    if (p.team == 2) {
                        p2.team = team2update;
                        continue;
                    }
                    gravyStats.debug("uhh :( local player doesnt have a team! please report me");
                    continue;
                }
                gravyStats.debug("wtf :( local player doesnt have a global equivalent! please report me");
            }
        }
    }

    public void processGames() throws Exception {
        int debug_processGames = this.debug_processingTime_start();
        gravyStats.debug("processing games...");
        Game prGame = this.firstGame;
        int gameNumber = 1;
        while (prGame != null) {
            Round round1 = prGame.round1;
            Round round2 = prGame.round2;
            if (round1 != null && round1.mapname != null) {
                if (round2 != null && round2.mapname != null && !round1.mapname.equals(round2.mapname)) {
                    throw new Exception("round map names dont match! " + round1.mapname + " and " + round2.mapname);
                }
                prGame.mapname = round1.mapname;
            } else {
                prGame.mapname = round2 != null && round2.mapname != null ? round2.mapname : "unknown";
            }
            gravyStats.debug("game number " + gameNumber + " map " + prGame.mapname);
            if (round1 == null) {
                gravyStats.debug("  round1 null");
            } else {
                gravyStats.debug("  round1 " + round1.roundTime + ", " + round1.players.size() + " players " + round1.eventList.size() + " events");
            }
            if (round2 == null) {
                gravyStats.debug("  round2 null");
            } else {
                gravyStats.debug("  round2 " + round2.roundTime + ", " + round2.players.size() + " players " + round2.eventList.size() + " events");
            }
            if (round1 != null && round2 != null) {
                if (round1.noTeamInformation) {
                    gravyStats.debug("  round1 no team information");
                }
                if (round2.noTeamInformation) {
                    gravyStats.debug("  round2 no team information");
                }
                if (!round1.noTeamInformation && !round2.noTeamInformation) {
                    if (round1.timelimitHit && round2.timelimitHit) {
                        gravyStats.debug("  double full hold");
                        prGame.winner = 3;
                        Global.score[0] = Global.score[0] + 1;
                    } else if (round1.timelimitHit && !round2.timelimitHit) {
                        gravyStats.debug("  team 2 wins");
                        prGame.winner = 2;
                        int n = prGame.round1.getChasingTeam().globalteam;
                        Global.score[n] = Global.score[n] + 1;
                    } else if (!round1.timelimitHit && round2.timelimitHit) {
                        gravyStats.debug("  team 1 wins");
                        prGame.winner = 1;
                        int n = prGame.round1.getAttackingTeam().globalteam;
                        Global.score[n] = Global.score[n] + 1;
                    } else if (!round1.timelimitHit && !round2.timelimitHit) {
                        gravyStats.debug("  team 2 wins");
                        prGame.winner = 2;
                        int n = prGame.round1.getChasingTeam().globalteam;
                        Global.score[n] = Global.score[n] + 1;
                    }
                }
            } else {
                gravyStats.debug("  unknown game winner as both rounds arent present");
            }
            if (round1 != null) {
                if (round1.statsall) {
                    Global.statsallobserved[1] = Global.statsallobserved[1] + 1;
                } else {
                    Global.statsallobserved[0] = Global.statsallobserved[0] + 1;
                }
            }
            if (round2 != null) {
                if (round2.statsall) {
                    Global.statsallobserved[1] = Global.statsallobserved[1] + 1;
                } else {
                    Global.statsallobserved[0] = Global.statsallobserved[0] + 1;
                }
            }
            prGame = prGame.nextGame;
            ++gameNumber;
        }
        float statsallobservedratio = (float)Global.statsallobserved[1] / (float)(Global.statsallobserved[1] + Global.statsallobserved[0]);
        gravyStats.debug("global statsall observed ratio: " + statsallobservedratio);
        Global.statsall = (double)statsallobservedratio > 0.6 || forcestatsall;
        Global.buildTeams();
        Global.team1.teamname = "team1";
        Global.team2.teamname = "team2";
        Global.team1.lookForTag();
        Global.team2.lookForTag();
        this.attachTeamNamesToRoundLabels();
        this.calculateWeaponStats();
        this.addMM1RoundStatus();
        this.buildMatchStats();
        gravyStats.debug("processing games completed in... " + this.debug_processingTime_end(debug_processGames) + newline);
    }

    public void attachTeamNamesToRoundLabels() {
        Game prGame = this.firstGame;
        while (prGame != null) {
            if (prGame.round1 != null) {
                this.attachTeamNameForRound(prGame.round1);
            }
            if (prGame.round2 != null) {
                this.attachTeamNameForRound(prGame.round2);
            }
            prGame = prGame.nextGame;
        }
    }

    public void attachTeamNameForRound(Round round) {
        this.attachTeamNameForTeam(round.team1);
        this.attachTeamNameForTeam(round.team2);
    }

    public void attachTeamNameForTeam(PlayerList team) {
        if (team.globalteam == 1) {
            team.teamname = Global.team1.teamname;
        } else if (team.globalteam == 2) {
            team.teamname = Global.team2.teamname;
        }
    }

    public void calculateWeaponStats() {
        Iterator i = Global.players.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            for (int j = 0; j < MeansOfDeath.num_mod; ++j) {
                int n = j;
                Global.weaponStats[n] = Global.weaponStats[n] + p.stats.weaponStats[0][j];
                if (p.stats.weaponStats[0][j] > MeansOfDeath.mod[j].mostKills_count) {
                    MeansOfDeath.mod[j].mostKills_count = p.stats.weaponStats[0][j];
                    MeansOfDeath.mod[j].mostKills.clear();
                    MeansOfDeath.mod[j].mostKills.add(p);
                } else if (p.stats.weaponStats[0][j] == MeansOfDeath.mod[j].mostKills_count) {
                    MeansOfDeath.mod[j].mostKills.add(p);
                }
                if (p.stats.weaponStats[1][j] > MeansOfDeath.mod[j].mostDeaths_count) {
                    MeansOfDeath.mod[j].mostDeaths_count = p.stats.weaponStats[1][j];
                    MeansOfDeath.mod[j].mostDeaths.clear();
                    MeansOfDeath.mod[j].mostDeaths.add(p);
                    continue;
                }
                if (p.stats.weaponStats[1][j] != MeansOfDeath.mod[j].mostDeaths_count) continue;
                MeansOfDeath.mod[j].mostDeaths.add(p);
            }
        }
    }

    public void addMM1RoundStatus() {
        Game prGame = this.firstGame;
        while (prGame != null) {
            Round round1 = prGame.round1;
            Round round2 = prGame.round2;
            if (round1 != null && !round1.noTeamInformation) {
                round1.mm1.add(round1.team1.teamname + " set " + round1.roundTime + (round1.timelimitHit ? " (held)" : ""));
            }
            if (round2 != null && !round2.noTeamInformation) {
                round2.mm1.add(round2.team1.teamname + (round2.timelimitHit ? " didnt" : "") + " beat the clock - " + round2.roundTime);
            }
            prGame = prGame.nextGame;
        }
    }

    public void buildMatchStats() throws Exception {
        gravyStats.debug("buildMatchStats()");
        Iterator i = Global.players.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            p.stats.calculate_efficiencies();
        }
        Collections.sort(Global.team1, Player.SORT_ORDER_EFFICIENCY);
        Collections.reverse(Global.team1);
        Collections.sort(Global.team2, Player.SORT_ORDER_EFFICIENCY);
        Collections.reverse(Global.team2);
        Global.team1.calculate_total();
        Global.team2.calculate_total();
    }

    public void generateAwards() throws Exception {
        Player fff;
        int i;
        String recips;
        int debug_generateAwards = this.debug_processingTime_start();
        gravyStats.debug("generating awards...");
        PlayerComparator pc = new PlayerComparator();
        pc.setSortType(1);
        Collections.sort(Global.players, pc);
        int mosti = ((Player)Global.players.get((int)0)).stats.damageGiven;
        if (mosti > 0) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.damageGiven != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("RAMBO", "most damage given", recips, "" + mosti));
            }
        }
        pc.setSortType(2);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.damageReceived;
        if (mosti > 0) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.damageReceived != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("MEAT SHIELD", "most damage received", recips, "" + mosti));
            }
        }
        pc.setSortType(3);
        Collections.sort(Global.players, pc);
        float mostf = ((Player)Global.players.get((int)0)).stats.dmg_efficiency;
        if ((double)mostf > 1.0) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.dmg_efficiency != mostf) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("PUNISHER", "best damage ratio", recips, this.twoDecimalPlaces.format(mostf).toString()));
            }
        }
        pc.setSortType(4);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.teamDamage;
        if (mosti > 0) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.teamDamage != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("BACKRAGER", "most team damage", recips, "" + mosti));
            }
        }
        pc.setSortType(11);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.kills;
        recips = "";
        for (i = 0; i < Global.players.size(); ++i) {
            fff = (Player)Global.players.get(i);
            if (fff.stats.kills != mosti) break;
            recips = recips + fff.getName() + " ";
        }
        if (!recips.equals("")) {
            this.awards.add(new Award("BODY COUNT", "most kills", recips, "" + mosti));
        }
        pc.setSortType(12);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.deaths;
        recips = "";
        for (i = 0; i < Global.players.size(); ++i) {
            fff = (Player)Global.players.get(i);
            if (fff.stats.deaths != mosti) break;
            recips = recips + fff.getName() + " ";
        }
        if (!recips.equals("")) {
            this.awards.add(new Award("TARGET PRACTICE", "most deaths", recips, "" + mosti));
        }
        pc.setSortType(13);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.suicides;
        if (mosti > 0) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.suicides != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("EMO", "most suicides", recips, "" + mosti));
            }
        }
        pc.setSortType(15);
        Collections.sort(Global.players, pc);
        mostf = ((Player)Global.players.get((int)0)).stats.efficiency;
        recips = "";
        for (i = 0; i < Global.players.size(); ++i) {
            fff = (Player)Global.players.get(i);
            if (fff.stats.efficiency != mostf) break;
            recips = recips + fff.getName() + " ";
        }
        if (!recips.equals("")) {
            this.awards.add(new Award("WHO'S YOUR DADDY?", "best efficiency", recips, this.twoDecimalPlaces.format(mostf).toString()));
        }
        pc.setSortType(21);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.getWeaponStat(0, 0);
        if (mosti > 0) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.getWeaponStat(0, 0) != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("ASSASSIN", "most knifes", recips, "" + mosti));
            }
        }
        pc.setSortType(22);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.getWeaponStat(1, 0);
        if (mosti > 0) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.getWeaponStat(1, 0) != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("HUMILIATION", "most knifed", recips, "" + mosti));
            }
        }
        pc.setSortType(23);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.gibs;
        if (mosti > 2) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.gibs != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("ST PETER", "most gibs", recips, "" + mosti));
            }
        }
        if (Global.statsall) {
            pc.setSortType(35);
            Collections.sort(Global.players, pc);
            mosti = ((Player)Global.players.get((int)0)).stats.revives;
            if (mosti > 2) {
                recips = "";
                for (i = 0; i < Global.players.size(); ++i) {
                    fff = (Player)Global.players.get(i);
                    if (fff.stats.revives != mosti) break;
                    recips = recips + fff.getName() + " ";
                }
                if (!recips.equals("")) {
                    this.awards.add(new Award("DOOGIE HOWSER", "most revives", recips, "" + mosti));
                }
            }
        }
        pc.setSortType(25);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.damagePerDeath;
        if (mosti > 100) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.damagePerDeath != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("PACK WHORE", "highest damage received per death", recips, "" + mosti));
            }
        }
        pc.setSortType(26);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.damagePerKill;
        if (mosti > 100) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.damagePerKill != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("UNFINISHED BUSINESS", "highest damage given per kill", recips, "" + mosti));
            }
        }
        pc.setSortType(14);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.slashkills;
        if (mosti > 2) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.slashkills != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("IT WAS FOR SPAWN!!", "most slash kills", recips, "" + mosti));
            }
        }
        pc.setSortType(27);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.maxkillstreak;
        if (mosti > 2) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.maxkillstreak != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("DEATH DEFIER", "longest kill streak", recips, "" + mosti));
            }
        }
        pc.setSortType(28);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.maxdeathstreak;
        if (mosti > 2) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.maxdeathstreak != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("STUCK IN SPAWN", "longest death streak", recips, "" + mosti));
            }
        }
        pc.setSortType(29);
        Collections.sort(Global.players, pc);
        mosti = ((Player)Global.players.get((int)0)).stats.mm1count;
        if (mosti > 2) {
            recips = "";
            for (i = 0; i < Global.players.size(); ++i) {
                fff = (Player)Global.players.get(i);
                if (fff.stats.mm1count != mosti) break;
                recips = recips + fff.getName() + " ";
            }
            if (!recips.equals("")) {
                this.awards.add(new Award("CHATTERBOX", "most mm1", recips, "" + mosti));
            }
        }
        Collections.sort(Global.players, Player.SORT_ORDER_EFFICIENCY);
        Collections.reverse(Global.players);
        gravyStats.debug("generating awards completed in... " + this.debug_processingTime_end(debug_generateAwards) + newline);
    }

    public void writeln(BufferedWriter bw, String line) throws Exception {
        bw.write(line);
        bw.newLine();
    }

    public String removeNaughtyWinFileChars(String s) {
        String orig = new String(s);
        s = s.replace('\\', '*');
        s = s.replace('/', '*');
        s = s.replace(':', '*');
        s = s.replace('?', '*');
        s = s.replace('\"', '*');
        s = s.replace('<', '*');
        s = s.replace('>', '*');
        s = s.replace('|', '*');
        s = s.replace('.', '*');
        s = s.replace(' ', '*');
        s = s.replace('#', '*');
        StringBuffer sb = new StringBuffer(s);
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '*') {
                sb.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        gravyStats.debug("removeNaughtyWinFileChars: " + orig + " - " + sb.toString());
        return sb.toString();
    }

    public String htmlise(String s) {
        s = s.replaceAll("([^^])<", "$1&lt;");
        s = s.replaceAll("([^^])>", "$1&gt;");
        return s;
    }

    public void writeHTML() throws Exception {
        int debug_writeHTML = this.debug_processingTime_start();
        gravyStats.debug("writing HTML...");
        if (this.logDate == null) {
            this.logDate = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd-HHmm-");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yy-MM-dd");
        String outputFileName = this.outputDirectory + File.separator + sdf.format(this.logDate) + this.removeNaughtyWinFileChars(Global.team1.teamname) + "-vs-" + this.removeNaughtyWinFileChars(Global.team2.teamname) + ".html";
        if (this.backupDirectory.exists() && this.backupDirectory.isDirectory()) {
            int debug_backup = this.debug_processingTime_start();
            String backupFileName = this.backupDirectory + File.separator + sdf.format(this.logDate) + this.removeNaughtyWinFileChars(Global.team1.teamname) + "-vs-" + this.removeNaughtyWinFileChars(Global.team2.teamname) + ".log";
            this.stdout("backing up log file");
            this.copyFile(this.logfile, new File(backupFileName));
            gravyStats.debug("backup log file completed in... " + this.debug_processingTime_end(debug_backup) + newline);
        }
        this.stdout("writing " + outputFileName);
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputFileName));
        String pageTitle = "gravyStats " + sdf2.format(this.logDate) + " " + this.htmlise(Global.team1.teamname) + " vs. " + this.htmlise(Global.team2.teamname);
        this.writeln(bw, "<!-- " + appName + " " + version + " -->");
        this.writeln(bw, "<html><head><title>" + this.htmlise(pageTitle) + "</title>");
        this.writeln(bw, "<link href=\"include/gravy.css\" rel=\"stylesheet\" type=\"text/css\" title=\"default\">");
        this.writeln(bw, "<script language=\"Javascript\" src=\"include/gravy.js\"></script>");
        this.writeln(bw, "<script language=\"Javascript\" src=\"include/sorttable.js\"></script>");
        this.writeln(bw, "</head><body>");
        this.writeln(bw, this.htmlout_scoreboard());
        this.writeln(bw, "<br>");
        this.writeln(bw, this.htmlout_stats());
        this.writeln(bw, "<hr noshade size=\"1\">");
        this.writeln(bw, this.htmlout_awards());
        this.writeln(bw, "<hr noshade size=\"1\">");
        this.writeln(bw, this.htmlout_simple_weaponstats());
        this.writeln(bw, this.htmlout_detailed_weaponstats());
        this.writeln(bw, "<hr noshade size=\"1\">");
        this.writeln(bw, this.htmlout_killMatrix(Global.players));
        this.writeln(bw, "<hr noshade size=\"1\">");
        this.writeln(bw, "<div class=\"h2\">mm1</div>");
        this.writeln(bw, this.htmlout_mm1());
        this.writeln(bw, "</body></html>");
        bw.flush();
        bw.close();
        gravyStats.debug("writing HTML completed in... " + this.debug_processingTime_end(debug_writeHTML) + newline);
    }

    public String htmlout_scoreboard() {
        SimpleDateFormat sdf3 = new SimpleDateFormat("EEE MMM dd yyyy");
        StringBuffer sb = new StringBuffer(5000);
        Game prGame = this.firstGame;
        int gameNumber = 1;
        sb.append("<table class=\"roundtimes\" rules=\"cols\" frame=\"void\">" + newline);
        sb.append("<tr>" + newline);
        sb.append("<td rowspan=\"3\" class=\"summary1\">" + newline);
        sb.append("<div class=\"h1\">" + this.htmlise(Global.team1.teamname) + " vs. " + this.htmlise(Global.team2.teamname) + "</div>" + newline);
        sb.append(sdf3.format(this.logDate) + "<br>" + newline);
        sb.append("</td>" + newline);
        StringBuffer[] scoreboard = new StringBuffer[4];
        for (int i = 0; i < 4; ++i) {
            scoreboard[i] = new StringBuffer();
        }
        scoreboard[3].append("<td class=\"summary2_on\" id=\"summ_global\" title=\"Click to show stats for whole match\" onClick=\"summary_scope('global')\">" + (Global.score[1] > Global.score[2] ? this.htmlise(Global.team1.teamname) + " win " : (Global.score[2] > Global.score[1] ? this.htmlise(Global.team2.teamname) + " win " : "draw ")) + Global.score[1] + "-" + Global.score[0] + "-" + Global.score[2] + "</td>" + newline);
        while (prGame != null) {
            scoreboard[0].append("<td class=\"map\">" + prGame.mapname + "</td>" + newline);
            scoreboard[1].append("<td class=\"round\">");
            if (prGame.round1 != null) {
                scoreboard[1].append("<table><tr><td>");
                if (prGame.round1.noTeamInformation) {
                    scoreboard[1].append("- ");
                } else {
                    scoreboard[1].append(this.htmlise(prGame.round1.getAttackingTeam().teamname) + " ");
                }
                if (prGame.round1.timelimitHit) {
                    scoreboard[1].append("<span class=\"h\">(held)</span>");
                }
                scoreboard[1].append("</td><td class=\"clock\">" + prGame.round1.roundTime + "</td></tr></table>");
            } else {
                scoreboard[1].append("-");
            }
            scoreboard[1].append("</td>" + newline);
            scoreboard[2].append("<td class=\"round\">");
            if (prGame.round2 != null) {
                scoreboard[2].append("<table><tr><td>");
                if (prGame.round2.noTeamInformation) {
                    scoreboard[2].append("- ");
                } else {
                    scoreboard[2].append(this.htmlise(prGame.round2.getAttackingTeam().teamname) + " ");
                }
                if (prGame.round2.timelimitHit) {
                    scoreboard[2].append("<span class=\"h\">(held)</span>");
                }
                scoreboard[2].append("</td><td class=\"clock\">" + prGame.round2.roundTime + "</td></tr></table>");
            }
            scoreboard[2].append("</td>" + newline);
            scoreboard[3].append("<td class=\"result\" id=\"summ_game" + gameNumber + "\" title=\"Click to show stats for this game\" onClick=\"summary_scope('game" + gameNumber + "')\">");
            if (prGame.winner == 1) {
                scoreboard[3].append(this.htmlise(prGame.round1.getAttackingTeam().teamname) + " win");
            } else if (prGame.winner == 2) {
                scoreboard[3].append(this.htmlise(prGame.round1.getChasingTeam().teamname) + " win");
            } else if (prGame.winner == 3) {
                scoreboard[3].append("draw");
            } else {
                scoreboard[3].append("-");
            }
            scoreboard[3].append("</td>" + newline);
            ++gameNumber;
            prGame = prGame.nextGame;
        }
        sb.append(scoreboard[0].toString());
        sb.append("</tr><tr>");
        sb.append(scoreboard[1].toString());
        sb.append("</tr><tr>");
        sb.append(scoreboard[2].toString());
        sb.append("</tr><tr>");
        sb.append(scoreboard[3].toString());
        sb.append("</tr></table>");
        sb.append("<script language=\"Javascript\">numGames = " + gameNumber + "</script>");
        return sb.toString();
    }

    public String htmlout_stats() {
        StringBuffer sb = new StringBuffer(50000);
        sb.append("<div id=\"global\">");
        sb.append("<div class=\"h2\">Match summary ( <a href=\"javascript:summary_type('simple')\">simple</a> <a href=\"javascript:summary_type('detailed')\">detailed</a> )</div>");
        sb.append("<div id=\"global_simple\">");
        sb.append("<table><tr><td valign=\"top\">");
        sb.append(this.teamSummary_simple(Global.team1));
        sb.append("</td><td width=\"20\">&nbsp;</td><td valign=\"top\">");
        sb.append(this.teamSummary_simple(Global.team2));
        sb.append("</td></tr></table>");
        sb.append("</div>");
        sb.append("<div id=\"global_detailed\" style=\"display:none\">");
        sb.append(this.teamSummary_detailed(Global.team1, Global.team2));
        sb.append("</div>");
        sb.append("</div>");
        Game prGame = this.firstGame;
        int gameNumber = 1;
        while (prGame != null) {
            sb.append("<div id=\"game" + gameNumber + "\" style=\"display:none\">");
            Round round1 = prGame.round1;
            Round round2 = prGame.round2;
            sb.append("<div class=\"h2\">Game " + gameNumber + " summary ( <a href=\"javascript:summary_type('simple')\">simple</a> <a href=\"javascript:summary_type('detailed')\">detailed</a> <a href=\"javascript:summary_type('history')\">history</a> )</div>");
            sb.append("<div id=\"game" + gameNumber + "_simple\">");
            if (round1 != null) {
                sb.append("round 1 - " + round1.roundTime);
                sb.append("<table><tr><td valign=\"top\">");
                sb.append(this.teamSummary_simple(round1.team1));
                sb.append("</td><td width=\"20\">&nbsp;</td><td valign=\"top\">");
                sb.append(this.teamSummary_simple(round1.team2));
                sb.append("</td></tr></table>");
            }
            if (round2 != null) {
                sb.append("round 2 - " + round2.roundTime);
                sb.append("<table><tr><td valign=\"top\">");
                sb.append(this.teamSummary_simple(round2.team2));
                sb.append("</td><td width=\"20\">&nbsp;</td><td valign=\"top\">");
                sb.append(this.teamSummary_simple(round2.team1));
                sb.append("</td></tr></table>");
            }
            sb.append("</div>");
            sb.append("<div id=\"game" + gameNumber + "_detailed\" style=\"display:none\">");
            if (round1 != null) {
                sb.append("round 1 - " + round1.roundTime);
                sb.append(this.teamSummary_detailed(round1.team1, round1.team2));
            }
            if (round2 != null) {
                sb.append("round 2 - " + round2.roundTime);
                sb.append(this.teamSummary_detailed(round2.team2, round2.team1));
            }
            sb.append("</div>");
            sb.append("<div id=\"game" + gameNumber + "_history\" style=\"display:none\">");
            if (round1 != null) {
                sb.append("round 1 - " + round1.roundTime);
                sb.append(this.teamSummary_history(round1.team1, round1.team2));
            }
            if (round2 != null) {
                sb.append("round 2 - " + round2.roundTime);
                sb.append(this.teamSummary_history(round2.team2, round2.team1));
            }
            sb.append("</div>");
            sb.append("</div>");
            prGame = prGame.nextGame;
            ++gameNumber;
        }
        return sb.toString();
    }

    public String teamSummary_simple(PlayerList team) {
        StringBuffer sb = new StringBuffer(5000);
        String alt = "statrow1";
        sb.append("<table id=\"sortable" + this.sortable_table_num++ + "\" class=\"teamSummary\" cellspacing=\"0\" rules=\"groups\" frame=\"void\">");
        sb.append("<colgroup><colgroup><colgroup span=\"4\"><colgroup>");
        sb.append("<thead><tr><th class=\"name\">Player</th><th>Eff</th><th>K</th><th title=\"Deaths including Suicides\">D*</th><th>TK</th><th>/K</th><th>Gib</th><th>dmg</th></tr></thead>" + newline);
        Iterator i = team.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            sb.append("<tr class=\"" + alt + "\">");
            sb.append("<td class=\"name\" nowrap>" + gravyStats.htmlcolourcodes(this.htmlise(p.getName())) + "</td><td class=\"eff\">" + this.twoDecimalPlaces.format(p.stats.efficiency) + "</td><td>" + p.stats.kills + "</td><td>" + (p.stats.deaths + p.stats.suicides) + "</td><td>" + p.stats.teamkills + "</td><td>" + p.stats.slashkills + "</td><td>" + p.stats.gibs + "</td><td>" + this.twoDecimalPlaces.format(p.stats.dmg_efficiency) + "</td></tr>" + newline);
            alt = alt.equals("statrow1") ? "statrow2" : "statrow1";
        }
        sb.append("<tbody><tr class=\"footer\"><td class=\"name\">" + this.htmlise(team.teamname) + (team.side == null ? "" : " <span class=\"side\">(" + team.side + ")</span>") + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.efficiency) + "</td><td>" + team.total_stats.kills + "</td><td>" + (team.total_stats.deaths + team.total_stats.suicides) + "</td><td>" + team.total_stats.teamkills + "</td><td>" + team.total_stats.slashkills + "</td><td>" + team.total_stats.gibs + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.dmg_efficiency) + "</td></tr></tbody>");
        sb.append("</table>" + newline);
        return sb.toString();
    }

    public String teamSummary_detailed(PlayerList team1, PlayerList team2) {
        StringBuffer sb = new StringBuffer(5000);
        sb.append("<table id=\"sortable" + this.sortable_table_num++ + "\" class=\"teamSummary_detailed\" cellspacing=\"0\" rules=\"groups\" frame=\"void\">");
        sb.append("<colgroup><colgroup span=\"2\"><colgroup span=\"5\"><colgroup" + (Global.statsall ? " span=\"2\"" : "") + "><colgroup span=\"2\"><colgroup span=\"3\"><colgroup span=\"3\">");
        sb.append("<thead><tr><th class=\"name\">Player</th><th title=\"Efficiency\">Eff</th><th title=\"Harsh efficiency - includes slash kills\">H-Eff</th><th title=\"Kills\">K</th><th title=\"Deaths\">D</th><th title=\"Suicides\">S</th><th title=\"Slash kills\">/K</th><th title=\"Team kills\">TK</th><th title=\"Gibs\">Gib</th>" + (Global.statsall ? "<th title=\"Revives/Attempts\">Rev</th>" : "") + "<th title=\"Damage efficiency\">dmg</th>" + "<th title=\"Harsh damage efficiency - includes team damage\">H-dmg</th>" + "<th title=\"Damage given\">DG</th>" + "<th title=\"Damage received\">DR</th>" + "<th title=\"Team damage\">TD</th>" + "<th title=\"Damage given per kill\">d/k</th>" + "<th title=\"Damage received per death\">d/d</th>" + "<th title=\"Gibs per kill\">g/k</th>" + "<th title=\"XP\">XP</th>" + "</tr></thead>" + newline);
        sb.append(this.teamSummary_detailed_2(team1));
        sb.append(this.teamSummary_detailed_2(team2));
        sb.append("</table>" + newline);
        return sb.toString();
    }

    public String teamSummary_detailed_2(PlayerList team) {
        StringBuffer sb = new StringBuffer(5000);
        String alt = "statrow1";
        sb.append("<tbody>");
        Iterator i = team.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            sb.append("<tr class=\"" + alt + "\"><td class=\"name\" nowrap>");
            sb.append(gravyStats.htmlcolourcodes(this.htmlise(p.getName())) + "</td><td class=\"eff\">" + this.twoDecimalPlaces.format(p.stats.efficiency) + "</td><td class=\"heff\">" + this.twoDecimalPlaces.format(p.stats.harsh_efficiency) + "</td><td>" + p.stats.kills + "</td><td>" + p.stats.deaths + "</td><td>" + p.stats.suicides + "</td><td>" + p.stats.slashkills + "</td><td>" + p.stats.teamkills + "</td><td>" + p.stats.gibs + (Global.statsall ? "</td><td>" + (p.stats.revives == -1 ? "-" : String.valueOf(p.stats.revives)) + "/" + (p.stats.reviveAttempts == -1 ? "-" : String.valueOf(p.stats.reviveAttempts)) : "") + "</td><td>" + this.twoDecimalPlaces.format(p.stats.dmg_efficiency) + "</td><td>" + this.twoDecimalPlaces.format(p.stats.harsh_dmg_efficiency) + "</td><td>" + p.stats.damageGiven + "</td><td>" + p.stats.damageReceived + "</td><td>" + p.stats.teamDamage + "</td><td>" + p.stats.damagePerKill + "</td><td>" + p.stats.damagePerDeath + "</td><td>" + this.twoDecimalPlaces.format(p.stats.gibsPerKill) + "</td><td>" + p.stats.xp);
            sb.append("</td></tr>" + newline);
            alt = alt.equals("statrow1") ? "statrow2" : "statrow1";
        }
        sb.append("</tbody>");
        sb.append("<tbody><tr class=\"footer\"><td class=\"name\">" + this.htmlise(team.teamname) + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.efficiency) + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.harsh_efficiency) + "</td><td>" + team.total_stats.kills + "</td><td>" + team.total_stats.deaths + "</td><td>" + team.total_stats.suicides + "</td><td>" + team.total_stats.slashkills + "</td><td>" + team.total_stats.teamkills + "</td><td>" + team.total_stats.gibs + (Global.statsall ? "</td><td>" + (team.total_stats.revives == -1 ? "-" : String.valueOf(team.total_stats.revives)) + "/" + (team.total_stats.reviveAttempts == -1 ? "-" : String.valueOf(team.total_stats.reviveAttempts)) : "") + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.dmg_efficiency) + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.harsh_dmg_efficiency) + "</td><td>" + team.total_stats.damageGiven + "</td><td>" + team.total_stats.damageReceived + "</td><td>" + team.total_stats.teamDamage + "</td><td>" + team.total_stats.damagePerKill + "</td><td>" + team.total_stats.damagePerDeath + "</td><td>" + this.twoDecimalPlaces.format(team.total_stats.gibsPerKill) + "</td><td>" + team.total_stats.xp + "</td></tr></tbody>");
        return sb.toString();
    }

    public String teamSummary_history(PlayerList team1, PlayerList team2) {
        StringBuffer sb = new StringBuffer(5000);
        sb.append("<table class=\"teamSummary_history\" cellspacing=\"0\" rules=\"groups\" frame=\"void\">");
        sb.append("<colgroup><colgroup>");
        sb.append("<thead><tr><th class=\"name\">Player</th><th title=\"History\">History</th></tr></thead>" + newline);
        sb.append(this.teamSummary_history_2(team1));
        sb.append(this.teamSummary_history_2(team2));
        sb.append("</table>" + newline);
        return sb.toString();
    }

    public String teamSummary_history_2(PlayerList team) {
        StringBuffer sb = new StringBuffer(5000);
        String alt = "statrow1";
        sb.append("<tbody>");
        Iterator i = team.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            sb.append("<tr class=\"" + alt + "\">");
            sb.append("<td class=\"name\" nowrap>");
            sb.append(gravyStats.htmlcolourcodes(this.htmlise(p.getName())));
            sb.append("</td><td class=\"eff\">");
            sb.append(this.killHistory(p));
            sb.append("</td></tr>" + newline);
            alt = alt.equals("statrow1") ? "statrow2" : "statrow1";
        }
        sb.append("</tbody>");
        sb.append("<tbody><tr class=\"footer\"><td class=\"name\">" + this.htmlise(team.teamname) + "</td><td>&nbsp;</td></tr></tbody>");
        return sb.toString();
    }

    public String killHistory(Player p) {
        StringBuffer sb = new StringBuffer(2000);
        Iterator j = p.killEvents.iterator();
        while (j.hasNext()) {
            ParsedEvent event = (ParsedEvent)j.next();
            switch (event.eventType) {
                case 3: {
                    sb.append("<span class=\"slash\" title=\"slash killed\">/</span>");
                    break;
                }
                case 4: {
                    sb.append("<span class=\"sui\" title=\"suicided by " + event.mod.means + "\">S</span>");
                    break;
                }
                case 2: {
                    event.player1 = event.player1.trim();
                    event.player2 = event.player2.trim();
                    if (p.directNameMatch(event.player1, 1) || p.indirectNameMatch(event.player1, 1, false)) {
                        if (event.wasTK) {
                            sb.append("<span class=\"TKD\" title=\"team killed by " + this.htmlise(Player.cleanName(event.player2)) + " using " + event.mod.means + "\">t</span>");
                            break;
                        }
                        sb.append("<span class=\"D\" title=\"killed by " + this.htmlise(Player.cleanName(event.player2)) + " using " + event.mod.means + "\">D</span>");
                        break;
                    }
                    if (!p.directNameMatch(event.player2, 1) && !p.indirectNameMatch(event.player2, 1, false)) break;
                    if (event.wasTK) {
                        sb.append("<span class=\"TK\" title=\"team killed " + this.htmlise(Player.cleanName(event.player1)) + " using " + event.mod.means + "\">T</span>");
                        break;
                    }
                    sb.append("<span class=\"K\" title=\"killed " + this.htmlise(Player.cleanName(event.player1)) + " using " + event.mod.means + "\">K</span>");
                }
            }
        }
        return sb.toString();
    }

    public String htmlout_awards() {
        StringBuffer sb = new StringBuffer(5000);
        sb.append("<div class=\"h2\">Awards</div>");
        sb.append("<table class=\"awards\" rules=\"groups\" frame=\"void\">");
        sb.append("<colgroup/><colgroup/><colgroup/><colgroup/>");
        sb.append("<thead>");
        sb.append("<tr>");
        sb.append("<th>award</th>");
        sb.append("<th>description</th>");
        sb.append("<th>amount</th>");
        sb.append("<th>winnah</th>");
        sb.append("</tr>");
        sb.append("</thead>");
        sb.append("<tbody>");
        Iterator i = this.awards.iterator();
        while (i.hasNext()) {
            Award a = (Award)i.next();
            sb.append("<tr>");
            sb.append("<td>" + a.name + "</td>");
            sb.append("<td>" + a.description + "</td>");
            sb.append("<td class=\"amount\">" + a.amount + "</td>");
            sb.append("<td class=\"winnah\">" + gravyStats.htmlcolourcodes(this.htmlise(a.recipients)) + "</td>");
            sb.append("</tr>");
        }
        sb.append("</tbody>");
        sb.append("</table>");
        return sb.toString();
    }

    public String htmlout_simple_weaponstats() {
        int i;
        StringBuffer sb = new StringBuffer(10000);
        sb.append("<div class=\"h2\">Weapon stats ( <a href=\"javascript:switch_weapon('simple')\">simple</a> <a href=\"javascript:switch_weapon('detailed')\">detailed</a> )</div>" + newline);
        sb.append("<div id=\"weaponstats_simple\">" + newline);
        sb.append("<table class=\"weaponstats_simple\" cellspacing=\"0\" rules=\"groups\" frame=\"void\">" + newline);
        sb.append("<colgroup><colgroup span=\"2\"><colgroup span=\"2\"><colgroup span=\"2\">" + newline);
        sb.append("<thead>" + newline);
        sb.append("<tr>" + newline);
        sb.append("<th>Weapon</th>" + newline);
        sb.append("<th>Kills</th>" + newline);
        sb.append("<th>% total</th>" + newline);
        sb.append("<th colspan=\"2\">Most kills</th>" + newline);
        sb.append("<th colspan=\"2\">Most deaths</th>" + newline);
        sb.append("<th>" + this.htmlise(Global.team1.teamname) + "</th>" + newline);
        sb.append("<th>" + this.htmlise(Global.team2.teamname) + "</th>" + newline);
        sb.append("</tr>" + newline);
        sb.append("</thead>" + newline);
        sb.append("<tbody>" + newline);
        Object[] sort = new WeaponStat_SortObject[MeansOfDeath.num_mod];
        int totalkills = 0;
        for (i = 0; i < MeansOfDeath.num_mod; ++i) {
            sort[i] = new WeaponStat_SortObject(MeansOfDeath.mod[i], Global.weaponStats[i]);
            totalkills += Global.weaponStats[i];
        }
        Arrays.sort(sort);
        Collections.reverse(Arrays.asList(sort));
        for (i = 0; i < MeansOfDeath.num_mod && ((WeaponStat_SortObject)sort[i]).count != 0; ++i) {
            Player p;
            Iterator j;
            sb.append("<tr>" + newline);
            sb.append("<td class=\"weap\">" + ((WeaponStat_SortObject)sort[i]).mod.means + "</td>" + newline);
            sb.append("<td>" + ((WeaponStat_SortObject)sort[i]).count + "</td>" + newline);
            sb.append("<td>" + this.noDecimalPlaces.format((float)((WeaponStat_SortObject)sort[i]).count / (float)totalkills * 100.0f) + "</td>" + newline);
            if (((WeaponStat_SortObject)sort[i]).mod.mostKills != null) {
                sb.append("<td class=\"name\">");
                if (((WeaponStat_SortObject)sort[i]).mod.mostKills.size() < 4) {
                    j = ((WeaponStat_SortObject)sort[i]).mod.mostKills.iterator();
                    while (j.hasNext()) {
                        p = (Player)j.next();
                        sb.append(gravyStats.htmlcolourcodes(this.htmlise(p.getName())));
                        sb.append(" ");
                    }
                } else {
                    sb.append("<span title=\"");
                    j = ((WeaponStat_SortObject)sort[i]).mod.mostKills.iterator();
                    while (j.hasNext()) {
                        p = (Player)j.next();
                        sb.append(this.htmlise(Player.cleanName(p.getName())));
                        sb.append(" ");
                    }
                    sb.append("\">multiple</span>");
                }
                sb.append("</td>");
                sb.append("<td>" + ((WeaponStat_SortObject)sort[i]).mod.mostKills_count + "</td>");
            } else {
                sb.append("<td>&nbsp;</td><td>&nbsp;</td>");
            }
            if (((WeaponStat_SortObject)sort[i]).mod.mostDeaths != null) {
                sb.append("<td class=\"name\">");
                if (((WeaponStat_SortObject)sort[i]).mod.mostDeaths.size() < 4) {
                    j = ((WeaponStat_SortObject)sort[i]).mod.mostDeaths.iterator();
                    while (j.hasNext()) {
                        p = (Player)j.next();
                        sb.append(gravyStats.htmlcolourcodes(this.htmlise(p.getName())));
                        sb.append(" ");
                    }
                } else {
                    sb.append("<span title=\"");
                    j = ((WeaponStat_SortObject)sort[i]).mod.mostDeaths.iterator();
                    while (j.hasNext()) {
                        p = (Player)j.next();
                        sb.append(this.htmlise(Player.cleanName(p.getName())));
                        sb.append(" ");
                    }
                    sb.append("\">multiple</span>");
                }
                sb.append("</td>");
                sb.append("<td>" + ((WeaponStat_SortObject)sort[i]).mod.mostDeaths_count + "</td>");
            } else {
                sb.append("<td>&nbsp;</td><td>&nbsp;</td>");
            }
            sb.append("<td>" + Global.team1.total_stats.getWeaponStat(0, ((WeaponStat_SortObject)sort[i]).mod.mod_num) + "</td>");
            sb.append("<td>" + Global.team2.total_stats.getWeaponStat(0, ((WeaponStat_SortObject)sort[i]).mod.mod_num) + "</td>");
            sb.append("</tr>" + newline);
        }
        sb.append("</tbody></table>" + newline);
        sb.append("</div>" + newline);
        return sb.toString();
    }

    public String htmlout_detailed_weaponstats() {
        Player p;
        StringBuffer sb = new StringBuffer(20000);
        sb.append("<div id=\"weaponstats_detailed\" style=\"display:none\">" + newline);
        sb.append("<a href=\"javascript:switch_kd('kills')\">kills</a> <a href=\"javascript:switch_kd('deaths')\">deaths</a>" + newline);
        sb.append("<table class=\"weaponstats_detailed\" id=\"sortable" + this.sortable_table_num++ + "\" rules=\"groups\" frame=\"void\">" + newline);
        sb.append("<colgroup span=\"1\"/><colgroup span=\"1\"/><colgroup span=\"4\"/><colgroup span=\"2\"/>" + newline);
        sb.append("<colgroup span=\"2\"/><colgroup span=\"4\"/><colgroup span=\"3\"/><colgroup span=\"2\"/>" + newline);
        sb.append("<thead>" + newline);
        sb.append("<tr>" + newline);
        sb.append("<th>&nbsp;</th>" + newline);
        sb.append("<th title=\"Knife\">kfe</th>" + newline);
        sb.append("<th title=\"Pistol\">pstl</th>" + newline);
        sb.append("<th title=\"SMG\">smg</th>" + newline);
        sb.append("<th title=\"Rifle\">rfl</th>" + newline);
        sb.append("<th title=\"Scoped rifle\">scpd</th>" + newline);
        sb.append("<th title=\"Grenade\">grn</th>" + newline);
        sb.append("<th title=\"Rifle grenade\">rgrn</th>" + newline);
        sb.append("<th title=\"Dynomite\">dyn</th>" + newline);
        sb.append("<th title=\"Mine\">mine</th>" + newline);
        sb.append("<th title=\"Panzer\">pnz</th>" + newline);
        sb.append("<th title=\"Flamethrower\">flm</th>" + newline);
        sb.append("<th title=\"Mortar\">mrt</th>" + newline);
        sb.append("<th title=\"Machinegun\">mg</th>" + newline);
        sb.append("<th title=\"Artillery\">art</th>" + newline);
        sb.append("<th title=\"Airstrike\">astrk</th>" + newline);
        sb.append("<th title=\"Canister\">can</th>" + newline);
        sb.append("<th title=\"Satchel\">stch</th>" + newline);
        sb.append("<th title=\"Construction\">cnstr</th>" + newline);
        sb.append("</tr>" + newline);
        sb.append("</thead>" + newline);
        sb.append("<tbody id=\"weapon_kills\">" + newline);
        Iterator i = Global.team1.iterator();
        while (i.hasNext()) {
            p = (Player)i.next();
            sb.append(this.weaponStat_row(0, p.getName(), p.stats) + newline);
        }
        sb.append("</tbody>" + newline);
        sb.append("<tbody id=\"weapon_kills2\">" + newline);
        sb.append(this.weaponStat_row(0, Global.team1.teamname, Global.team1.total_stats) + newline);
        sb.append("</tbody>" + newline);
        sb.append("<tbody id=\"weapon_kills3\">" + newline);
        i = Global.team2.iterator();
        while (i.hasNext()) {
            p = (Player)i.next();
            sb.append(this.weaponStat_row(0, p.getName(), p.stats) + newline);
        }
        sb.append("</tbody>" + newline);
        sb.append("<tbody id=\"weapon_kills4\">" + newline);
        sb.append(this.weaponStat_row(0, Global.team2.teamname, Global.team2.total_stats) + newline);
        sb.append("</tbody>" + newline);
        sb.append("<tbody id=\"weapon_deaths\" style=\"display:none\">" + newline);
        i = Global.team1.iterator();
        while (i.hasNext()) {
            p = (Player)i.next();
            sb.append(this.weaponStat_row(1, p.getName(), p.stats) + newline);
        }
        sb.append("</tbody>" + newline);
        sb.append("<tbody id=\"weapon_deaths2\" style=\"display:none\">" + newline);
        sb.append(this.weaponStat_row(1, Global.team1.teamname, Global.team1.total_stats) + newline);
        sb.append("</tbody>" + newline);
        sb.append("<tbody id=\"weapon_deaths3\" style=\"display:none\">" + newline);
        i = Global.team2.iterator();
        while (i.hasNext()) {
            p = (Player)i.next();
            sb.append(this.weaponStat_row(1, p.getName(), p.stats) + newline);
        }
        sb.append("</tbody>" + newline);
        sb.append("<tbody id=\"weapon_deaths4\" style=\"display:none\">" + newline);
        sb.append(this.weaponStat_row(1, Global.team2.teamname, Global.team2.total_stats) + newline);
        sb.append("</tbody>" + newline);
        sb.append("</table><br/>" + newline);
        sb.append("</div>" + newline);
        return sb.toString();
    }

    public String weaponStat_row(int type, String name, PlayerStats stats) {
        StringBuffer sb = new StringBuffer(2000);
        sb.append("<tr>");
        sb.append("<td class=\"name\">" + gravyStats.htmlcolourcodes(this.htmlise(name)) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 0) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 1, 4) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 5, 8) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 9, 10) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 11, 13) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 14) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 15) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 16) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 17) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 18) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 19) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 20) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 21, 24) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 25) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 26) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 27) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 28) + "</td>");
        sb.append("<td>" + stats.getWeaponStat(type, 29) + "</td>");
        sb.append("</tr>");
        return sb.toString();
    }

    public String htmlout_killMatrix(PlayerList players) {
        StringBuffer sb = new StringBuffer(5000);
        String alt = "row1";
        sb.append("<div class=\"h2\">Kill matrix</div>");
        sb.append("<table class=\"killmatrix\" id=\"killmatrix\" cellspacing=\"0\"><tr><th>&nbsp;</th>");
        for (int i = 1; i <= players.size(); ++i) {
            sb.append("<th><b>" + i + "</b></th>");
        }
        sb.append("</tr>" + newline);
        int row = 1;
        Iterator i = players.iterator();
        while (i.hasNext()) {
            Player p = (Player)i.next();
            sb.append("<tr class=\"" + alt + "\"><td class=\"name\"><b>").append(row).append("</b> ").append(gravyStats.htmlcolourcodes(this.htmlise(p.getName()))).append("</td>");
            Iterator k = players.iterator();
            while (k.hasNext()) {
                Player p2 = (Player)k.next();
                if (p.equals(p2)) {
                    sb.append("<td><span class=\"s\">" + p.stats.suicides + "</span></td>");
                    continue;
                }
                Integer c = (Integer)p.stats.killedPlayer.get(p2);
                if (c != null) {
                    sb.append("<td title=\"" + this.htmlise(Player.cleanName(p2.getName())) + "\">" + c + "</td>");
                    continue;
                }
                c = (Integer)p.stats.teamKilledPlayer.get(p2);
                if (c != null) {
                    sb.append("<td title=\"" + this.htmlise(Player.cleanName(p2.getName())) + "\"><span class=\"t\">" + c + "</span></td>");
                    continue;
                }
                sb.append("<td>&nbsp;</td>");
            }
            sb.append("</tr>" + newline);
            alt = alt.equals("row1") ? "row2" : "row1";
            ++row;
        }
        sb.append("</table>" + newline);
        sb.append("<script language=\"Javascript\">create_matrix_hover();</script>" + newline);
        return sb.toString();
    }

    public String htmlout_mm1() {
        StringBuffer sb = new StringBuffer(20000);
        Round prRound = this.firstRound;
        int mm1LineCount = 1;
        sb.append("<div class=\"mm1\">" + newline);
        sb.append("<table class=\"mm1\">" + newline);
        while (prRound != null) {
            int mm1_size = prRound.mm1.size();
            for (int i = 0; i < mm1_size; ++i) {
                sb.append("<tr>");
                String mm1_line = (String)prRound.mm1.get(i);
                this.match = this.mm1Event.matcher(mm1_line);
                if (this.match.find()) {
                    String player = this.match.group(1);
                    String text = this.match.group(2);
                    sb.append("<td>" + mm1LineCount++ + "</td><td>" + gravyStats.htmlcolourcodes(this.htmlise(player)) + "</td><td>" + this.htmlise(text) + "</td>");
                } else {
                    sb.append("<td>" + mm1LineCount++ + "<td>&nbsp;</td><td class=\"pauseevent\">" + this.htmlise(mm1_line) + "</td>");
                }
                sb.append("</tr>" + newline);
            }
            prRound = prRound.nextRound;
        }
        sb.append("</table>" + newline);
        sb.append("</div>" + newline);
        return sb.toString();
    }

    public static String htmlcolourcodes(String name) {
        StringBuffer sb = new StringBuffer(name);
        for (int i = 0; i < sb.length() - 1; ++i) {
            String color;
            if (sb.charAt(i) != '^' || sb.charAt(i + 1) == '^') continue;
            char c = sb.charAt(i + 1);
            switch (Character.toLowerCase(c)) {
                case '0': {
                    color = "c0";
                    break;
                }
                case '1': {
                    color = "c1";
                    break;
                }
                case '2': {
                    color = "c2";
                    break;
                }
                case '3': {
                    color = "c3";
                    break;
                }
                case '4': {
                    color = "c4";
                    break;
                }
                case '5': {
                    color = "c5";
                    break;
                }
                case '6': {
                    color = "c6";
                    break;
                }
                case '7': {
                    color = "c7";
                    break;
                }
                case '8': {
                    color = "c8";
                    break;
                }
                case '9': {
                    color = "c9";
                    break;
                }
                case 'a': {
                    color = "ca";
                    break;
                }
                case 'b': {
                    color = "cb";
                    break;
                }
                case 'c': {
                    color = "cc";
                    break;
                }
                case 'd': {
                    color = "cd";
                    break;
                }
                case 'e': {
                    color = "ce";
                    break;
                }
                case 'f': {
                    color = "cf";
                    break;
                }
                case 'g': {
                    color = "cg";
                    break;
                }
                case 'h': {
                    color = "ch";
                    break;
                }
                case 'i': {
                    color = "ci";
                    break;
                }
                case 'j': {
                    color = "cj";
                    break;
                }
                case 'k': {
                    color = "ck";
                    break;
                }
                case 'l': {
                    color = "cl";
                    break;
                }
                case 'm': {
                    color = "cm";
                    break;
                }
                case 'n': {
                    color = "cn";
                    break;
                }
                case 'o': {
                    color = "co";
                    break;
                }
                case 'p': {
                    color = "cp";
                    break;
                }
                case 'q': {
                    color = "cq";
                    break;
                }
                case 'r': {
                    color = "cr";
                    break;
                }
                case 's': {
                    color = "cs";
                    break;
                }
                case 't': {
                    color = "ct";
                    break;
                }
                case 'u': {
                    color = "cu";
                    break;
                }
                case 'v': {
                    color = "cv";
                    break;
                }
                case 'w': {
                    color = "cw";
                    break;
                }
                case 'x': {
                    color = "cx";
                    break;
                }
                case 'y': {
                    color = "cy";
                    break;
                }
                case 'z': {
                    color = "cz";
                    break;
                }
                case '/': {
                    color = "csl";
                    break;
                }
                case '*': {
                    color = "cst";
                    break;
                }
                case '-': {
                    color = "cmi";
                    break;
                }
                case '+': {
                    color = "cpl";
                    break;
                }
                case '?': {
                    color = "cqu";
                    break;
                }
                case '@': {
                    color = "cat";
                    break;
                }
                default: {
                    color = "c0";
                }
            }
            sb.replace(i, i + 2, "</span><span class=\"" + color + "\">");
        }
        String r = "<span class=\"c7\">" + sb.toString() + "</span>";
        String s = r.replaceAll("<span class=\"c\\w+\"></span>", "");
        return s;
    }

    static {
        forcestatsall = false;
        debug = false;
        console = false;
        newline = System.getProperty("line.separator");
    }

    class WeaponStat_SortObject
    implements Comparable {
        MeansOfDeath mod;
        int count;

        WeaponStat_SortObject(MeansOfDeath mod, int count) {
            this.mod = mod;
            this.count = count;
        }

        public int compareTo(Object o) {
            int c1 = ((WeaponStat_SortObject)o).count;
            if (this.count < c1) {
                return -1;
            }
            if (this.count > c1) {
                return 1;
            }
            return 0;
        }
    }
}

