/*
QMM - Q3 MultiMod
Copyright QMM Team 2005
http://www.q3mm.org/

Licensing:
    QMM is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    QMM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with QMM; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Created By:
    Kevin Masterson a.k.a. CyberMind <kevinm@planetquake.com>

*/

/* $Id: game_jka.cpp,v 1.3 2005/03/03 16:06:03 cybermind Exp $ */

#include <jka/game/q_shared.h>
#include <jka/game/g_public.h>
#include "game_api.h"

GEN_MSGS(JKA);

const char* JKA_eng_msg_names(int cmd) {
	switch(cmd) {
		case G_PRINT:
			return "G_PRINT";
		case G_ERROR:
			return "G_ERROR";
		case G_MILLISECONDS:
			return "G_MILLISECONDS";
		case G_PRECISIONTIMER_START:
			return "G_PRECISIONTIMER_START";
		case G_PRECISIONTIMER_END:
			return "G_PRECISIONTIMER_END";
		case G_CVAR_REGISTER:
			return "G_CVAR_REGISTER";
		case G_CVAR_UPDATE:
			return "G_CVAR_UPDATE";
		case G_CVAR_SET:
			return "G_CVAR_SET";
		case G_CVAR_VARIABLE_INTEGER_VALUE:
			return "G_CVAR_VARIABLE_INTEGER_VALUE";
		case G_CVAR_VARIABLE_STRING_BUFFER:
			return "G_CVAR_VARIABLE_STRING_BUFFER";
		case G_ARGC:
			return "G_ARGC";
		case G_ARGV:
			return "G_ARGV";
		case G_FS_FOPEN_FILE:
			return "G_FS_FOPEN_FILE";
		case G_FS_READ:
			return "G_FS_READ";
		case G_FS_WRITE:
			return "G_FS_WRITE";
		case G_FS_FCLOSE_FILE:
			return "G_FS_FCLOSE_FILE";
		case G_SEND_CONSOLE_COMMAND:
			return "G_SEND_CONSOLE_COMMAND";
		case G_LOCATE_GAME_DATA:
			return "G_LOCATE_GAME_DATA";
		case G_DROP_CLIENT:
			return "G_DROP_CLIENT";
		case G_SEND_SERVER_COMMAND:
			return "G_SEND_SERVER_COMMAND";
		case G_SET_CONFIGSTRING:
			return "G_SET_CONFIGSTRING";
		case G_GET_CONFIGSTRING:
			return "G_GET_CONFIGSTRING";
		case G_GET_USERINFO:
			return "G_GET_USERINFO";
		case G_SET_USERINFO:
			return "G_SET_USERINFO";
		case G_GET_SERVERINFO:
			return "G_GET_SERVERINFO";
		case G_SET_SERVER_CULL:
			return "G_SET_SERVER_CULL";
		case G_SET_BRUSH_MODEL:
			return "G_SET_BRUSH_MODEL";
		case G_TRACE:
			return "G_TRACE";
		case G_G2TRACE:
			return "G_G2TRACE";
		case G_POINT_CONTENTS:
			return "G_POINT_CONTENTS";
		case G_IN_PVS:
			return "G_IN_PVS";
		case G_IN_PVS_IGNORE_PORTALS:
			return "G_IN_PVS_IGNORE_PORTALS";
		case G_ADJUST_AREA_PORTAL_STATE:
			return "G_ADJUST_AREA_PORTAL_STATE";
		case G_AREAS_CONNECTED:
			return "G_AREAS_CONNECTED";
		case G_LINKENTITY:
			return "G_LINKENTITY";
		case G_UNLINKENTITY:
			return "G_UNLINKENTITY";
		case G_ENTITIES_IN_BOX:
			return "G_ENTITIES_IN_BOX";
		case G_ENTITY_CONTACT:
			return "G_ENTITY_CONTACT";
		case G_BOT_ALLOCATE_CLIENT:
			return "G_BOT_ALLOCATE_CLIENT";
		case G_BOT_FREE_CLIENT:
			return "G_BOT_FREE_CLIENT";
		case G_GET_USERCMD:
			return "G_GET_USERCMD";
		case G_GET_ENTITY_TOKEN:
			return "G_GET_ENTITY_TOKEN";
		case G_SIEGEPERSSET:
			return "G_SIEGEPERSSET";
		case G_SIEGEPERSGET:
			return "G_SIEGEPERSGET";
		case G_FS_GETFILELIST:
			return "G_FS_GETFILELIST";
		case G_DEBUG_POLYGON_CREATE:
			return "G_DEBUG_POLYGON_CREATE";
		case G_DEBUG_POLYGON_DELETE:
			return "G_DEBUG_POLYGON_DELETE";
		case G_REAL_TIME:
			return "G_REAL_TIME";
		case G_SNAPVECTOR:
			return "G_SNAPVECTOR";
		case G_TRACECAPSULE:
			return "G_TRACECAPSULE";
		case G_ENTITY_CONTACTCAPSULE:
			return "G_ENTITY_CONTACTCAPSULE";
	//	case SP_REGISTER_SERVER_CMD:
	//		return "SP_REGISTER_SERVER_CMD";
		case SP_GETSTRINGTEXTSTRING:
			return "SP_GETSTRINGTEXTSTRING";
		case G_ROFF_CLEAN:
			return "G_ROFF_CLEAN";
		case G_ROFF_UPDATE_ENTITIES:
			return "G_ROFF_UPDATE_ENTITIES";
		case G_ROFF_CACHE:
			return "G_ROFF_CACHE";
		case G_ROFF_PLAY:
			return "G_ROFF_PLAY";
		case G_ROFF_PURGE_ENT:
			return "G_ROFF_PURGE_ENT";
		case G_TRUEMALLOC:
			return "G_TRUEMALLOC";
		case G_TRUEFREE:
			return "G_TRUEFREE";
		case G_ICARUS_RUNSCRIPT:
			return "G_ICARUS_RUNSCRIPT";
		case G_ICARUS_REGISTERSCRIPT:
			return "G_ICARUS_REGISTERSCRIPT";
		case G_ICARUS_INIT:
			return "G_ICARUS_INIT";
		case G_ICARUS_VALIDENT:
			return "G_ICARUS_VALIDENT";
		case G_ICARUS_ISINITIALIZED:
			return "G_ICARUS_ISINITIALIZED";
		case G_ICARUS_MAINTAINTASKMANAGER:
			return "G_ICARUS_MAINTAINTASKMANAGER";
		case G_ICARUS_ISRUNNING:
			return "G_ICARUS_ISRUNNING";
		case G_ICARUS_TASKIDPENDING:
			return "G_ICARUS_TASKIDPENDING";
		case G_ICARUS_INITENT:
			return "G_ICARUS_INITENT";
		case G_ICARUS_FREEENT:
			return "G_ICARUS_FREEENT";
		case G_ICARUS_ASSOCIATEENT:
			return "G_ICARUS_ASSOCIATEENT";
		case G_ICARUS_SHUTDOWN:
			return "G_ICARUS_SHUTDOWN";
		case G_ICARUS_TASKIDSET:
			return "G_ICARUS_TASKIDSET";
		case G_ICARUS_TASKIDCOMPLETE:
			return "G_ICARUS_TASKIDCOMPLETE";
		case G_ICARUS_SETVAR:
			return "G_ICARUS_SETVAR";
		case G_ICARUS_VARIABLEDECLARED:
			return "G_ICARUS_VARIABLEDECLARED";
		case G_ICARUS_GETFLOATVARIABLE:
			return "G_ICARUS_GETFLOATVARIABLE";
		case G_ICARUS_GETSTRINGVARIABLE:
			return "G_ICARUS_GETSTRINGVARIABLE";
		case G_ICARUS_GETVECTORVARIABLE:
			return "G_ICARUS_GETVECTORVARIABLE";
		case G_SET_SHARED_BUFFER:
			return "G_SET_SHARED_BUFFER";
		case G_MEMSET:
			return "G_MEMSET";
		case G_MEMCPY:
			return "G_MEMCPY";
		case G_STRNCPY:
			return "G_STRNCPY";
		case G_SIN:
			return "G_SIN";
		case G_COS:
			return "G_COS";
		case G_ATAN2:
			return "G_ATAN2";
		case G_SQRT:
			return "G_SQRT";
		case G_MATRIXMULTIPLY:
			return "G_MATRIXMULTIPLY";
		case G_ANGLEVECTORS:
			return "G_ANGLEVECTORS";
		case G_PERPENDICULARVECTOR:
			return "G_PERPENDICULARVECTOR";
		case G_FLOOR:
			return "G_FLOOR";
		case G_CEIL:
			return "G_CEIL";
		case G_TESTPRINTINT:
			return "G_TESTPRINTINT";
		case G_TESTPRINTFLOAT:
			return "G_TESTPRINTFLOAT";
		case G_ACOS:
			return "G_ACOS";
		case G_ASIN:
			return "G_ASIN";
		case G_NAV_INIT:
			return "G_NAV_INIT";
		case G_NAV_FREE:
			return "G_NAV_FREE";
		case G_NAV_LOAD:
			return "G_NAV_LOAD";
		case G_NAV_SAVE:
			return "G_NAV_SAVE";
		case G_NAV_ADDRAWPOINT:
			return "G_NAV_ADDRAWPOINT";
		case G_NAV_CALCULATEPATHS:
			return "G_NAV_CALCULATEPATHS";
		case G_NAV_HARDCONNECT:
			return "G_NAV_HARDCONNECT";
		case G_NAV_SHOWNODES:
			return "G_NAV_SHOWNODES";
		case G_NAV_SHOWEDGES:
			return "G_NAV_SHOWEDGES";
		case G_NAV_SHOWPATH:
			return "G_NAV_SHOWPATH";
		case G_NAV_GETNEARESTNODE:
			return "G_NAV_GETNEARESTNODE";
		case G_NAV_GETBESTNODE:
			return "G_NAV_GETBESTNODE";
		case G_NAV_GETNODEPOSITION:
			return "G_NAV_GETNODEPOSITION";
		case G_NAV_GETNODENUMEDGES:
			return "G_NAV_GETNODENUMEDGES";
		case G_NAV_GETNODEEDGE:
			return "G_NAV_GETNODEEDGE";
		case G_NAV_GETNUMNODES:
			return "G_NAV_GETNUMNODES";
		case G_NAV_CONNECTED:
			return "G_NAV_CONNECTED";
		case G_NAV_GETPATHCOST:
			return "G_NAV_GETPATHCOST";
		case G_NAV_GETEDGECOST:
			return "G_NAV_GETEDGECOST";
		case G_NAV_GETPROJECTEDNODE:
			return "G_NAV_GETPROJECTEDNODE";
		case G_NAV_CHECKFAILEDNODES:
			return "G_NAV_CHECKFAILEDNODES";
		case G_NAV_ADDFAILEDNODE:
			return "G_NAV_ADDFAILEDNODE";
		case G_NAV_NODEFAILED:
			return "G_NAV_NODEFAILED";
		case G_NAV_NODESARENEIGHBORS:
			return "G_NAV_NODESARENEIGHBORS";
		case G_NAV_CLEARFAILEDEDGE:
			return "G_NAV_CLEARFAILEDEDGE";
		case G_NAV_CLEARALLFAILEDEDGES:
			return "G_NAV_CLEARALLFAILEDEDGES";
		case G_NAV_EDGEFAILED:
			return "G_NAV_EDGEFAILED";
		case G_NAV_ADDFAILEDEDGE:
			return "G_NAV_ADDFAILEDEDGE";
		case G_NAV_CHECKFAILEDEDGE:
			return "G_NAV_CHECKFAILEDEDGE";
		case G_NAV_CHECKALLFAILEDEDGES:
			return "G_NAV_CHECKALLFAILEDEDGES";
		case G_NAV_ROUTEBLOCKED:
			return "G_NAV_ROUTEBLOCKED";
		case G_NAV_GETBESTNODEALTROUTE:
			return "G_NAV_GETBESTNODEALTROUTE";
		case G_NAV_GETBESTNODEALT2:
			return "G_NAV_GETBESTNODEALT2";
		case G_NAV_GETBESTPATHBETWEENENTS:
			return "G_NAV_GETBESTPATHBETWEENENTS";
		case G_NAV_GETNODERADIUS:
			return "G_NAV_GETNODERADIUS";
		case G_NAV_CHECKBLOCKEDEDGES:
			return "G_NAV_CHECKBLOCKEDEDGES";
		case G_NAV_CLEARCHECKEDNODES:
			return "G_NAV_CLEARCHECKEDNODES";
		case G_NAV_CHECKEDNODE:
			return "G_NAV_CHECKEDNODE";
		case G_NAV_SETCHECKEDNODE:
			return "G_NAV_SETCHECKEDNODE";
		case G_NAV_FLAGALLNODES:
			return "G_NAV_FLAGALLNODES";
		case G_NAV_GETPATHSCALCULATED:
			return "G_NAV_GETPATHSCALCULATED";
		case G_NAV_SETPATHSCALCULATED:
			return "G_NAV_SETPATHSCALCULATED";
		case BOTLIB_SETUP:
			return "BOTLIB_SETUP";
		case BOTLIB_SHUTDOWN:
			return "BOTLIB_SHUTDOWN";
		case BOTLIB_LIBVAR_SET:
			return "BOTLIB_LIBVAR_SET";
		case BOTLIB_LIBVAR_GET:
			return "BOTLIB_LIBVAR_GET";
		case BOTLIB_PC_ADD_GLOBAL_DEFINE:
			return "BOTLIB_PC_ADD_GLOBAL_DEFINE";
		case BOTLIB_START_FRAME:
			return "BOTLIB_START_FRAME";
		case BOTLIB_LOAD_MAP:
			return "BOTLIB_LOAD_MAP";
		case BOTLIB_UPDATENTITY:
			return "BOTLIB_UPDATENTITY";
		case BOTLIB_TEST:
			return "BOTLIB_TEST";
		case BOTLIB_GET_SNAPSHOT_ENTITY:
			return "BOTLIB_GET_SNAPSHOT_ENTITY";
		case BOTLIB_GET_CONSOLE_MESSAGE:
			return "BOTLIB_GET_CONSOLE_MESSAGE";
		case BOTLIB_USER_COMMAND:
			return "BOTLIB_USER_COMMAND";
		case BOTLIB_AAS_ENABLE_ROUTING_AREA:
			return "BOTLIB_AAS_ENABLE_ROUTING_AREA";
		case BOTLIB_AAS_BBOX_AREAS:
			return "BOTLIB_AAS_BBOX_AREAS";
		case BOTLIB_AAS_AREA_INFO:
			return "BOTLIB_AAS_AREA_INFO";
		case BOTLIB_AAS_ENTITY_INFO:
			return "BOTLIB_AAS_ENTITY_INFO";
		case BOTLIB_AAS_INITIALIZED:
			return "BOTLIB_AAS_INITIALIZED";
		case BOTLIB_AAS_PRESENCE_TYPE_BOUNDING_BOX:
			return "BOTLIB_AAS_PRESENCE_TYPE_BOUNDING_BOX";
		case BOTLIB_AAS_TIME:
			return "BOTLIB_AAS_TIME";
		case BOTLIB_AAS_POINT_AREA_NUM:
			return "BOTLIB_AAS_POINT_AREA_NUM";
		case BOTLIB_AAS_TRACE_AREAS:
			return "BOTLIB_AAS_TRACE_AREAS";
		case BOTLIB_AAS_POINT_CONTENTS:
			return "BOTLIB_AAS_POINT_CONTENTS";
		case BOTLIB_AAS_NEXT_BSP_ENTITY:
			return "BOTLIB_AAS_NEXT_BSP_ENTITY";
		case BOTLIB_AAS_VALUE_FOR_BSP_EPAIR_KEY:
			return "BOTLIB_AAS_VALUE_FOR_BSP_EPAIR_KEY";
		case BOTLIB_AAS_VECTOR_FOR_BSP_EPAIR_KEY:
			return "BOTLIB_AAS_VECTOR_FOR_BSP_EPAIR_KEY";
		case BOTLIB_AAS_FLOAT_FOR_BSP_EPAIR_KEY:
			return "BOTLIB_AAS_FLOAT_FOR_BSP_EPAIR_KEY";
		case BOTLIB_AAS_INT_FOR_BSP_EPAIR_KEY:
			return "BOTLIB_AAS_INT_FOR_BSP_EPAIR_KEY";
		case BOTLIB_AAS_AREA_REACHABILITY:
			return "BOTLIB_AAS_AREA_REACHABILITY";
		case BOTLIB_AAS_AREA_TRAVEL_TIME_TO_GOAL_AREA:
			return "BOTLIB_AAS_AREA_TRAVEL_TIME_TO_GOAL_AREA";
		case BOTLIB_AAS_SWIMMING:
			return "BOTLIB_AAS_SWIMMING";
		case BOTLIB_AAS_PREDICT_CLIENT_MOVEMENT:
			return "BOTLIB_AAS_PREDICT_CLIENT_MOVEMENT";
		case BOTLIB_EA_SAY:
			return "BOTLIB_EA_SAY";
		case BOTLIB_EA_SAY_TEAM:
			return "BOTLIB_EA_SAY_TEAM";
		case BOTLIB_EA_COMMAND:
			return "BOTLIB_EA_COMMAND";
		case BOTLIB_EA_ACTION:
			return "BOTLIB_EA_ACTION";
		case BOTLIB_EA_GESTURE:
			return "BOTLIB_EA_GESTURE";
		case BOTLIB_EA_TALK:
			return "BOTLIB_EA_TALK";
		case BOTLIB_EA_ATTACK:
			return "BOTLIB_EA_ATTACK";
		case BOTLIB_EA_ALT_ATTACK:
			return "BOTLIB_EA_ALT_ATTACK";
		case BOTLIB_EA_FORCEPOWER:
			return "BOTLIB_EA_FORCEPOWER";
		case BOTLIB_EA_USE:
			return "BOTLIB_EA_USE";
		case BOTLIB_EA_RESPAWN:
			return "BOTLIB_EA_RESPAWN";
		case BOTLIB_EA_CROUCH:
			return "BOTLIB_EA_CROUCH";
		case BOTLIB_EA_MOVE_UP:
			return "BOTLIB_EA_MOVE_UP";
		case BOTLIB_EA_MOVE_DOWN:
			return "BOTLIB_EA_MOVE_DOWN";
		case BOTLIB_EA_MOVE_FORWARD:
			return "BOTLIB_EA_MOVE_FORWARD";
		case BOTLIB_EA_MOVE_BACK:
			return "BOTLIB_EA_MOVE_BACK";
		case BOTLIB_EA_MOVE_LEFT:
			return "BOTLIB_EA_MOVE_LEFT";
		case BOTLIB_EA_MOVE_RIGHT:
			return "BOTLIB_EA_MOVE_RIGHT";
		case BOTLIB_EA_SELECT_WEAPON:
			return "BOTLIB_EA_SELECT_WEAPON";
		case BOTLIB_EA_JUMP:
			return "BOTLIB_EA_JUMP";
		case BOTLIB_EA_DELAYED_JUMP:
			return "BOTLIB_EA_DELAYED_JUMP";
		case BOTLIB_EA_MOVE:
			return "BOTLIB_EA_MOVE";
		case BOTLIB_EA_VIEW:
			return "BOTLIB_EA_VIEW";
		case BOTLIB_EA_END_REGULAR:
			return "BOTLIB_EA_END_REGULAR";
		case BOTLIB_EA_GET_INPUT:
			return "BOTLIB_EA_GET_INPUT";
		case BOTLIB_EA_RESET_INPUT:
			return "BOTLIB_EA_RESET_INPUT";
		case BOTLIB_AI_LOAD_CHARACTER:
			return "BOTLIB_AI_LOAD_CHARACTER";
		case BOTLIB_AI_FREE_CHARACTER:
			return "BOTLIB_AI_FREE_CHARACTER";
		case BOTLIB_AI_CHARACTERISTIC_FLOAT:
			return "BOTLIB_AI_CHARACTERISTIC_FLOAT";
		case BOTLIB_AI_CHARACTERISTIC_BFLOAT:
			return "BOTLIB_AI_CHARACTERISTIC_BFLOAT";
		case BOTLIB_AI_CHARACTERISTIC_INTEGER:
			return "BOTLIB_AI_CHARACTERISTIC_INTEGER";
		case BOTLIB_AI_CHARACTERISTIC_BINTEGER:
			return "BOTLIB_AI_CHARACTERISTIC_BINTEGER";
		case BOTLIB_AI_CHARACTERISTIC_STRING:
			return "BOTLIB_AI_CHARACTERISTIC_STRING";
		case BOTLIB_AI_ALLOC_CHAT_STATE:
			return "BOTLIB_AI_ALLOC_CHAT_STATE";
		case BOTLIB_AI_FREE_CHAT_STATE:
			return "BOTLIB_AI_FREE_CHAT_STATE";
		case BOTLIB_AI_QUEUE_CONSOLE_MESSAGE:
			return "BOTLIB_AI_QUEUE_CONSOLE_MESSAGE";
		case BOTLIB_AI_REMOVE_CONSOLE_MESSAGE:
			return "BOTLIB_AI_REMOVE_CONSOLE_MESSAGE";
		case BOTLIB_AI_NEXT_CONSOLE_MESSAGE:
			return "BOTLIB_AI_NEXT_CONSOLE_MESSAGE";
		case BOTLIB_AI_NUM_CONSOLE_MESSAGE:
			return "BOTLIB_AI_NUM_CONSOLE_MESSAGE";
		case BOTLIB_AI_INITIAL_CHAT:
			return "BOTLIB_AI_INITIAL_CHAT";
		case BOTLIB_AI_REPLY_CHAT:
			return "BOTLIB_AI_REPLY_CHAT";
		case BOTLIB_AI_CHAT_LENGTH:
			return "BOTLIB_AI_CHAT_LENGTH";
		case BOTLIB_AI_ENTER_CHAT:
			return "BOTLIB_AI_ENTER_CHAT";
		case BOTLIB_AI_STRING_CONTAINS:
			return "BOTLIB_AI_STRING_CONTAINS";
		case BOTLIB_AI_FIND_MATCH:
			return "BOTLIB_AI_FIND_MATCH";
		case BOTLIB_AI_MATCH_VARIABLE:
			return "BOTLIB_AI_MATCH_VARIABLE";
		case BOTLIB_AI_UNIFY_WHITE_SPACES:
			return "BOTLIB_AI_UNIFY_WHITE_SPACES";
		case BOTLIB_AI_REPLACE_SYNONYMS:
			return "BOTLIB_AI_REPLACE_SYNONYMS";
		case BOTLIB_AI_LOAD_CHAT_FILE:
			return "BOTLIB_AI_LOAD_CHAT_FILE";
		case BOTLIB_AI_SET_CHAT_GENDER:
			return "BOTLIB_AI_SET_CHAT_GENDER";
		case BOTLIB_AI_SET_CHAT_NAME:
			return "BOTLIB_AI_SET_CHAT_NAME";
		case BOTLIB_AI_RESET_GOAL_STATE:
			return "BOTLIB_AI_RESET_GOAL_STATE";
		case BOTLIB_AI_RESET_AVOID_GOALS:
			return "BOTLIB_AI_RESET_AVOID_GOALS";
		case BOTLIB_AI_PUSH_GOAL:
			return "BOTLIB_AI_PUSH_GOAL";
		case BOTLIB_AI_POP_GOAL:
			return "BOTLIB_AI_POP_GOAL";
		case BOTLIB_AI_EMPTY_GOAL_STACK:
			return "BOTLIB_AI_EMPTY_GOAL_STACK";
		case BOTLIB_AI_DUMP_AVOID_GOALS:
			return "BOTLIB_AI_DUMP_AVOID_GOALS";
		case BOTLIB_AI_DUMP_GOAL_STACK:
			return "BOTLIB_AI_DUMP_GOAL_STACK";
		case BOTLIB_AI_GOAL_NAME:
			return "BOTLIB_AI_GOAL_NAME";
		case BOTLIB_AI_GET_TOP_GOAL:
			return "BOTLIB_AI_GET_TOP_GOAL";
		case BOTLIB_AI_GET_SECOND_GOAL:
			return "BOTLIB_AI_GET_SECOND_GOAL";
		case BOTLIB_AI_CHOOSE_LTG_ITEM:
			return "BOTLIB_AI_CHOOSE_LTG_ITEM";
		case BOTLIB_AI_CHOOSE_NBG_ITEM:
			return "BOTLIB_AI_CHOOSE_NBG_ITEM";
		case BOTLIB_AI_TOUCHING_GOAL:
			return "BOTLIB_AI_TOUCHING_GOAL";
		case BOTLIB_AI_ITEM_GOAL_IN_VIS_BUT_NOT_VISIBLE:
			return "BOTLIB_AI_ITEM_GOAL_IN_VIS_BUT_NOT_VISIBLE";
		case BOTLIB_AI_GET_LEVEL_ITEM_GOAL:
			return "BOTLIB_AI_GET_LEVEL_ITEM_GOAL";
		case BOTLIB_AI_AVOID_GOAL_TIME:
			return "BOTLIB_AI_AVOID_GOAL_TIME";
		case BOTLIB_AI_INIT_LEVEL_ITEMS:
			return "BOTLIB_AI_INIT_LEVEL_ITEMS";
		case BOTLIB_AI_UPDATE_ENTITY_ITEMS:
			return "BOTLIB_AI_UPDATE_ENTITY_ITEMS";
		case BOTLIB_AI_LOAD_ITEM_WEIGHTS:
			return "BOTLIB_AI_LOAD_ITEM_WEIGHTS";
		case BOTLIB_AI_FREE_ITEM_WEIGHTS:
			return "BOTLIB_AI_FREE_ITEM_WEIGHTS";
		case BOTLIB_AI_SAVE_GOAL_FUZZY_LOGIC:
			return "BOTLIB_AI_SAVE_GOAL_FUZZY_LOGIC";
		case BOTLIB_AI_ALLOC_GOAL_STATE:
			return "BOTLIB_AI_ALLOC_GOAL_STATE";
		case BOTLIB_AI_FREE_GOAL_STATE:
			return "BOTLIB_AI_FREE_GOAL_STATE";
		case BOTLIB_AI_RESET_MOVE_STATE:
			return "BOTLIB_AI_RESET_MOVE_STATE";
		case BOTLIB_AI_MOVE_TO_GOAL:
			return "BOTLIB_AI_MOVE_TO_GOAL";
		case BOTLIB_AI_MOVE_IN_DIRECTION:
			return "BOTLIB_AI_MOVE_IN_DIRECTION";
		case BOTLIB_AI_RESET_AVOID_REACH:
			return "BOTLIB_AI_RESET_AVOID_REACH";
		case BOTLIB_AI_RESET_LAST_AVOID_REACH:
			return "BOTLIB_AI_RESET_LAST_AVOID_REACH";
		case BOTLIB_AI_REACHABILITY_AREA:
			return "BOTLIB_AI_REACHABILITY_AREA";
		case BOTLIB_AI_MOVEMENT_VIEW_TARGET:
			return "BOTLIB_AI_MOVEMENT_VIEW_TARGET";
		case BOTLIB_AI_ALLOC_MOVE_STATE:
			return "BOTLIB_AI_ALLOC_MOVE_STATE";
		case BOTLIB_AI_FREE_MOVE_STATE:
			return "BOTLIB_AI_FREE_MOVE_STATE";
		case BOTLIB_AI_INIT_MOVE_STATE:
			return "BOTLIB_AI_INIT_MOVE_STATE";
		case BOTLIB_AI_CHOOSE_BEST_FIGHT_WEAPON:
			return "BOTLIB_AI_CHOOSE_BEST_FIGHT_WEAPON";
		case BOTLIB_AI_GET_WEAPON_INFO:
			return "BOTLIB_AI_GET_WEAPON_INFO";
		case BOTLIB_AI_LOAD_WEAPON_WEIGHTS:
			return "BOTLIB_AI_LOAD_WEAPON_WEIGHTS";
		case BOTLIB_AI_ALLOC_WEAPON_STATE:
			return "BOTLIB_AI_ALLOC_WEAPON_STATE";
		case BOTLIB_AI_FREE_WEAPON_STATE:
			return "BOTLIB_AI_FREE_WEAPON_STATE";
		case BOTLIB_AI_RESET_WEAPON_STATE:
			return "BOTLIB_AI_RESET_WEAPON_STATE";
		case BOTLIB_AI_GENETIC_PARENTS_AND_CHILD_SELECTION:
			return "BOTLIB_AI_GENETIC_PARENTS_AND_CHILD_SELECTION";
		case BOTLIB_AI_INTERBREED_GOAL_FUZZY_LOGIC:
			return "BOTLIB_AI_INTERBREED_GOAL_FUZZY_LOGIC";
		case BOTLIB_AI_MUTATE_GOAL_FUZZY_LOGIC:
			return "BOTLIB_AI_MUTATE_GOAL_FUZZY_LOGIC";
		case BOTLIB_AI_GET_NEXT_CAMP_SPOT_GOAL:
			return "BOTLIB_AI_GET_NEXT_CAMP_SPOT_GOAL";
		case BOTLIB_AI_GET_MAP_LOCATION_GOAL:
			return "BOTLIB_AI_GET_MAP_LOCATION_GOAL";
		case BOTLIB_AI_NUM_INITIAL_CHATS:
			return "BOTLIB_AI_NUM_INITIAL_CHATS";
		case BOTLIB_AI_GET_CHAT_MESSAGE:
			return "BOTLIB_AI_GET_CHAT_MESSAGE";
		case BOTLIB_AI_REMOVE_FROM_AVOID_GOALS:
			return "BOTLIB_AI_REMOVE_FROM_AVOID_GOALS";
		case BOTLIB_AI_PREDICT_VISIBLE_POSITION:
			return "BOTLIB_AI_PREDICT_VISIBLE_POSITION";
		case BOTLIB_AI_SET_AVOID_GOAL_TIME:
			return "BOTLIB_AI_SET_AVOID_GOAL_TIME";
		case BOTLIB_AI_ADD_AVOID_SPOT:
			return "BOTLIB_AI_ADD_AVOID_SPOT";
		case BOTLIB_AAS_ALTERNATIVE_ROUTE_GOAL:
			return "BOTLIB_AAS_ALTERNATIVE_ROUTE_GOAL";
		case BOTLIB_AAS_PREDICT_ROUTE:
			return "BOTLIB_AAS_PREDICT_ROUTE";
		case BOTLIB_AAS_POINT_REACHABILITY_AREA_INDEX:
			return "BOTLIB_AAS_POINT_REACHABILITY_AREA_INDEX";
		case BOTLIB_PC_LOAD_SOURCE:
			return "BOTLIB_PC_LOAD_SOURCE";
		case BOTLIB_PC_FREE_SOURCE:
			return "BOTLIB_PC_FREE_SOURCE";
		case BOTLIB_PC_READ_TOKEN:
			return "BOTLIB_PC_READ_TOKEN";
		case BOTLIB_PC_SOURCE_FILE_AND_LINE:
			return "BOTLIB_PC_SOURCE_FILE_AND_LINE";
		case G_R_REGISTERSKIN:
			return "G_R_REGISTERSKIN";
		case G_G2_LISTBONES:
			return "G_G2_LISTBONES";
		case G_G2_LISTSURFACES:
			return "G_G2_LISTSURFACES";
		case G_G2_HAVEWEGHOULMODELS:
			return "G_G2_HAVEWEGHOULMODELS";
		case G_G2_SETMODELS:
			return "G_G2_SETMODELS";
		case G_G2_GETBOLT:
			return "G_G2_GETBOLT";
		case G_G2_GETBOLT_NOREC:
			return "G_G2_GETBOLT_NOREC";
		case G_G2_GETBOLT_NOREC_NOROT:
			return "G_G2_GETBOLT_NOREC_NOROT";
		case G_G2_INITGHOUL2MODEL:
			return "G_G2_INITGHOUL2MODEL";
		case G_G2_SETSKIN:
			return "G_G2_SETSKIN";
		case G_G2_SIZE:
			return "G_G2_SIZE";
		case G_G2_ADDBOLT:
			return "G_G2_ADDBOLT";
		case G_G2_SETBOLTINFO:
			return "G_G2_SETBOLTINFO";
		case G_G2_ANGLEOVERRIDE:
			return "G_G2_ANGLEOVERRIDE";
		case G_G2_PLAYANIM:
			return "G_G2_PLAYANIM";
		case G_G2_GETBONEANIM:
			return "G_G2_GETBONEANIM";
		case G_G2_GETGLANAME:
			return "G_G2_GETGLANAME";
		case G_G2_COPYGHOUL2INSTANCE:
			return "G_G2_COPYGHOUL2INSTANCE";
		case G_G2_COPYSPECIFICGHOUL2MODEL:
			return "G_G2_COPYSPECIFICGHOUL2MODEL";
		case G_G2_DUPLICATEGHOUL2INSTANCE:
			return "G_G2_DUPLICATEGHOUL2INSTANCE";
		case G_G2_HASGHOUL2MODELONINDEX:
			return "G_G2_HASGHOUL2MODELONINDEX";
		case G_G2_REMOVEGHOUL2MODEL:
			return "G_G2_REMOVEGHOUL2MODEL";
		case G_G2_REMOVEGHOUL2MODELS:
			return "G_G2_REMOVEGHOUL2MODELS";
		case G_G2_CLEANMODELS:
			return "G_G2_CLEANMODELS";
		case G_G2_COLLISIONDETECT:
			return "G_G2_COLLISIONDETECT";
		case G_G2_COLLISIONDETECTCACHE:
			return "G_G2_COLLISIONDETECTCACHE";
		case G_G2_SETROOTSURFACE:
			return "G_G2_SETROOTSURFACE";
		case G_G2_SETSURFACEONOFF:
			return "G_G2_SETSURFACEONOFF";
		case G_G2_SETNEWORIGIN:
			return "G_G2_SETNEWORIGIN";
		case G_G2_DOESBONEEXIST:
			return "G_G2_DOESBONEEXIST";
		case G_G2_GETSURFACERENDERSTATUS:
			return "G_G2_GETSURFACERENDERSTATUS";
		case G_G2_ABSURDSMOOTHING:
			return "G_G2_ABSURDSMOOTHING";
		case G_G2_SETRAGDOLL:
			return "G_G2_SETRAGDOLL";
		case G_G2_ANIMATEG2MODELS:
			return "G_G2_ANIMATEG2MODELS";
		case G_G2_RAGPCJCONSTRAINT:
			return "G_G2_RAGPCJCONSTRAINT";
		case G_G2_RAGPCJGRADIENTSPEED:
			return "G_G2_RAGPCJGRADIENTSPEED";
		case G_G2_RAGEFFECTORGOAL:
			return "G_G2_RAGEFFECTORGOAL";
		case G_G2_GETRAGBONEPOS:
			return "G_G2_GETRAGBONEPOS";
		case G_G2_RAGEFFECTORKICK:
			return "G_G2_RAGEFFECTORKICK";
		case G_G2_RAGFORCESOLVE:
			return "G_G2_RAGFORCESOLVE";
		case G_G2_SETBONEIKSTATE:
			return "G_G2_SETBONEIKSTATE";
		case G_G2_IKMOVE:
			return "G_G2_IKMOVE";
		case G_G2_REMOVEBONE:
			return "G_G2_REMOVEBONE";
		case G_G2_ATTACHINSTANCETOENTNUM:
			return "G_G2_ATTACHINSTANCETOENTNUM";
		case G_G2_CLEARATTACHEDINSTANCE:
			return "G_G2_CLEARATTACHEDINSTANCE";
		case G_G2_CLEANENTATTACHMENTS:
			return "G_G2_CLEANENTATTACHMENTS";
		case G_G2_OVERRIDESERVER:
			return "G_G2_OVERRIDESERVER";
		case G_G2_GETSURFACENAME:
			return "G_G2_GETSURFACENAME";
		case G_SET_ACTIVE_SUBBSP:
			return "G_SET_ACTIVE_SUBBSP";
		case G_CM_REGISTER_TERRAIN:
			return "G_CM_REGISTER_TERRAIN";
		case G_RMG_INIT:
			return "G_RMG_INIT";
		case G_BOT_UPDATEWAYPOINTS:
			return "G_BOT_UPDATEWAYPOINTS";
		case G_BOT_CALCULATEPATHS:
			return "G_BOT_CALCULATEPATHS";
		default:
			return "unknown";
	}
}

const char* JKA_mod_msg_names(int cmd) {
	switch(cmd) {
		case GAME_INIT:
			return "GAME_INIT";
		case GAME_SHUTDOWN:
			return "GAME_SHUTDOWN";
		case GAME_CLIENT_CONNECT:
			return "GAME_CLIENT_CONNECT";
		case GAME_CLIENT_BEGIN:
			return "GAME_CLIENT_BEGIN";
		case GAME_CLIENT_USERINFO_CHANGED:
			return "GAME_CLIENT_USERINFO_CHANGED";
		case GAME_CLIENT_DISCONNECT:
			return "GAME_CLIENT_DISCONNECT";
		case GAME_CLIENT_COMMAND:
			return "GAME_CLIENT_COMMAND";
		case GAME_CLIENT_THINK:
			return "GAME_CLIENT_THINK";
		case GAME_RUN_FRAME:
			return "GAME_RUN_FRAME";
		case GAME_CONSOLE_COMMAND:
			return "GAME_CONSOLE_COMMAND";
		case BOTAI_START_FRAME:
			return "BOTAI_START_FRAME";
		case GAME_ROFF_NOTETRACK_CALLBACK:
			return "GAME_ROFF_NOTETRACK_CALLBACK";
		case GAME_SPAWN_RMG_ENTITY:
			return "GAME_SPAWN_RMG_ENTITY";
		case GAME_ICARUS_PLAYSOUND:
			return "GAME_ICARUS_PLAYSOUND";
		case GAME_ICARUS_SET:
			return "GAME_ICARUS_SET";
		case GAME_ICARUS_LERP2POS:
			return "GAME_ICARUS_LERP2POS";
		case GAME_ICARUS_LERP2ORIGIN:
			return "GAME_ICARUS_LERP2ORIGIN";
		case GAME_ICARUS_LERP2ANGLES:
			return "GAME_ICARUS_LERP2ANGLES";
		case GAME_ICARUS_GETTAG:
			return "GAME_ICARUS_GETTAG";
		case GAME_ICARUS_LERP2START:
			return "GAME_ICARUS_LERP2START";
		case GAME_ICARUS_LERP2END:
			return "GAME_ICARUS_LERP2END";
		case GAME_ICARUS_USE:
			return "GAME_ICARUS_USE";
		case GAME_ICARUS_KILL:
			return "GAME_ICARUS_KILL";
		case GAME_ICARUS_REMOVE:
			return "GAME_ICARUS_REMOVE";
		case GAME_ICARUS_PLAY:
			return "GAME_ICARUS_PLAY";
		case GAME_ICARUS_GETFLOAT:
			return "GAME_ICARUS_GETFLOAT";
		case GAME_ICARUS_GETVECTOR:
			return "GAME_ICARUS_GETVECTOR";
		case GAME_ICARUS_GETSTRING:
			return "GAME_ICARUS_GETSTRING";
		case GAME_ICARUS_SOUNDINDEX:
			return "GAME_ICARUS_SOUNDINDEX";
		case GAME_ICARUS_GETSETIDFORSTRING:
			return "GAME_ICARUS_GETSETIDFORSTRING";
		case GAME_NAV_CLEARPATHTOPOINT:
			return "GAME_NAV_CLEARPATHTOPOINT";
		case GAME_NAV_CLEARLOS:
			return "GAME_NAV_CLEARLOS";
		case GAME_NAV_CLEARPATHBETWEENPOINTS:
			return "GAME_NAV_CLEARPATHBETWEENPOINTS";
		case GAME_NAV_CHECKNODEFAILEDFORENT:
			return "GAME_NAV_CHECKNODEFAILEDFORENT";
		case GAME_NAV_ENTISUNLOCKEDDOOR:
			return "GAME_NAV_ENTISUNLOCKEDDOOR";
		case GAME_NAV_ENTISDOOR:
			return "GAME_NAV_ENTISDOOR";
		case GAME_NAV_ENTISBREAKABLE:
			return "GAME_NAV_ENTISBREAKABLE";
		case GAME_NAV_ENTISREMOVABLEUSABLE:
			return "GAME_NAV_ENTISREMOVABLEUSABLE";
		case GAME_NAV_FINDCOMBATPOINTWAYPOINTS:
			return "GAME_NAV_FINDCOMBATPOINTWAYPOINTS";
		case GAME_GETITEMINDEXBYTAG:
			return "GAME_GETITEMINDEXBYTAG";
		default:
			return "unknown";
	}
}
