#!/bin/bash

##################################################################################

function red_msg {
echo -e "\\033[31;1m${@}\033[0m"
}

function green_msg {
echo -e "\\033[32;1m${@}\033[0m"
}

function blue_msg {
echo -e "\\033[34;1m${@}\033[0m"
}

function yellow_msg() {
echo -e "\\033[33;1m${@}\033[0m"
}

function magenta_msg() {
echo -e "\\033[35;1m${@}\033[0m"
}

##################################################################################
##################################################################################
#                                                                                #
#  FORK OF  by SSF User stxShadow                                                #
#                                                                                #
#  Variante of GetStatus AntiFlood Script by OldMan (et-zone.de)                 #
#  MyVersion V1.6                                                                #
#                                                                                #
#  based on Q3-Engine-GetStatus-Flood-Fixer Version 1.4                          #
#  by schnoog (schnoog@wolffiles.de)                                             #
#                                                                                #
##################################################################################
########################       DESCRIPTION     ###################################
#                                                                                #
# This script try to get rid of the Q3-Engine getstatus-Abuse-Exploit            #
#                                                                                #
# About the exploit                                                              #
#                                                                                #
# This exploit use the getstatus udp query command with a spoofed sender         #
# adress. This 14 byte long command enganges the gameserver engine to            #
# respond the whole status of the gameserver ( > ~600 bytes on empty server)     #
# This amplification is visible if you use a tool like vnstat (vnstat -l)        #
# The outgoint traffic exceeds the incoming traffic with a faktor > 3            #
#                                                                                #
#                                                                                #
# About the script                                                               #
# This script capture the count of tcp packets set in config and search for      #
# answered getstatus queries. For any requesting IP adress the count of          #
# those packets is compared to the defind limit.                                 #
# If the limit is broken by an IP adress, the access for this IP will ne denied  #
# with iptables by adding a drop rule.                                           #
#                                                                                #
# Configuration                                                                  #
#                                                                                #
# By default, the script don`t need any configuration                            #
# The default values                                                             #
#                                                                                #
# Disable auto unban with the option RunPart   1= Ban only, 2= Ban & Unban       #
#                                                                                #
# CAPTURETIME=8        # <- captured time                                        #
# MAXPERSECONDS=15     # <- search patter max per second                         #
# UNBCNT=30            # <- amount of cycles before running Unban                #
# RunPart=2            # <- 1= Ban only, 2= Ban & Unban                          #
#                                                                                #
# will enforces drops in the case that:                                          #
#                                                                                #
# Each IP which requests more than 15 getstatus respones per second,             #
# averaged over 8 seconds                                                        #
#                                                                                #
# Requirements                                                                   #
#                                                                                #
# This script use a few open source tools to offence against this attacks        #
# tcpdump - capture incoming packets: http://www.tcpdump.org/                    #
# iptables - the most used linux firewall (packet filter)                        #
# GNU-tools - grep, cat , awk                                                    #
#                                                                                #
# THIS SCRIPT COMES WITH NO WARRANTY! USE IT AT YOUR OWN RISK ONLY!              #
#                                                                                #
##################################################################################
##################################################################################
##################################################################################
#                                                                                #
#                                SETUP                                           #
#                                                                                #
##################################################################################
##################################################################################
#                                                                                #
#      1. Ensure you installed iptables, tcpdump, grep, cat , awk                #
#                                                                                #
#      2. Place this script on your server, and allow execution for it           #
#           #chmod +x getstatus_*                                                #
#                                                                                #
#      3. Changing the configuration over the getstatus.ini.                     #
#         This file is created in the script folder after the first              #
#         start of the script.                                                   #
#                                                                                #
#                                                                                #
#      4. Run the script once to see any errors occour                           #
#         ./getstatus_ban.sh                                                     #
#                                                                                #
#      5. If all went well, configure a cronjob -Fto run the script periodically #
#                                                                                #
#      6. Optional create a Logfile-Rotation for the banfile-List                #
#                                                                                #
#      7. When the script runs without any problem disable the debug option      #
#                                                                                #
#                                                                                #
##################################################################################

##################################################################################
#############################      INIT     ######################################

SVERSION="V2.0"
thisscript=$(readlink -f $0)
mygoto=`dirname $thisscript`
mygoto="$mygoto"
cd $mygoto

##################################################################################
###############################  DETERMINE PATHS   ############################### 

PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
TCPDUMPBIN=`which  tcpdump`
IPTABLESBIN=`which iptables`

##################################################################################
####################################  Debug  #####################################

MYDEBUG=1  # <- 1= Debuginfo on  0= Debuginfo off

##################################################################################
################################  CONFIGURATION  #################################

if  [ -f $mygoto/getstatus.ini ] ; then
MYDEBUG=`grep "MYDEBUG" $mygoto/getstatus.ini | awk '{print $2}'`
CAPTURETIME=`grep "CAPTURETIME" $mygoto/getstatus.ini | awk '{print $2}'`
MAXPERSECONDS=`grep "MAXPERSECONDS" $mygoto/getstatus.ini | awk '{print $2}'`
UNBCNT=`grep "UNBCNT" $mygoto/getstatus.ini | awk '{print $2}'`
RunPart=`grep "RunPart" $mygoto/getstatus.ini | awk '{print $2}'`
COUNT=`grep "COUNT"  $mygoto/getstatus.ini | awk ' {print $2} '`
PATTERN=`grep "PATTERN"  $mygoto/getstatus.ini | awk ' {print $2} '`

else 
echo > $mygoto/getstatus.ini
fi

if [ -z $MYDEBUG ] ; then
MYDEBUG=1
fi

if [ -z $CAPTURETIME ] ;then
CAPTURETIME=8
fi

if [ -z $MAXPERSECONDS ] ;then
MAXPERSECONDS=15
fi

if [ -z $UNBCNT ] ; then
UNBCNT=30
fi

if [ -z $RunPart ] ;then
RunPart=2
fi

if  [ -z $COUNT ] ; then
COUNT=0
fi

if [ $COUNT -ge $UNBCNT ] ; then
RUNUNBAN=1
COUNT=1
else
RUNUNBAN=0
let "COUNT += 1"
fi

if [ -z $PATTERN ] ; then
PATTERN="getinf,getInf,getsta,getSta,].@..5u0"
fi

echo COUNT $COUNT > $mygoto/getstatus.ini
echo MYDEBUG $MYDEBUG >> $mygoto/getstatus.ini
echo CAPTURETIME $CAPTURETIME >> $mygoto/getstatus.ini
echo MAXPERSECONDS $MAXPERSECONDS >> $mygoto/getstatus.ini
echo UNBCNT $UNBCNT >> $mygoto/getstatus.ini
echo RunPart $RunPart >> $mygoto/getstatus.ini
echo PATTERN $PATTERN >> $mygoto/getstatus.ini

if [ $MYDEBUG == "1" ] ; then

magenta_msg "
SCRIPTVERSION $SVERSION"
blue_msg "
COUNT $COUNT
MYDEBUG $MYDEBUG
CAPTURETIME $CAPTURETIME
MAXPERSECONDS $MAXPERSECONDS
UNBCNT $UNBCNT
RunPart $RunPart
RUNUNBAN $RUNUNBAN
PATTERN $PATTERN
"
fi

PATTERN=$(echo $PATTERN| tr , ' ')


##################################################################################
############################ Check installed tools ###############################

if [ $MYDEBUG == "1" ] ; then

if [ "/bin/bash" != $SHELL ] ; then
red_msg "
Shell is $SHELL but /bin/bash is needed. 
Run for Ubuntu/Debian 'dpkg-reconfigure dash'
or 'chsh-s /bin/bash' to using bash.
"
sleep  8
else
green_msg "
shell $SHELL ok
"
fi


if [ "which grep" ] ; then
green_msg "search grep ok"
else
red_msg "search grep failed"
fi 

if [ "which cat" ] ; then
green_msg "search cat ok"
else
red_msg "search cat failed"
fi 

if [ `which awk` ] ; then
green_msg "search awk ok"
else
red_msg "search awk failed"
fi 

if [ `which tcpdump` ] ; then
green_msg "search tcpdmp ok"
else
red_msg "search tcpdmp failed"
fi 

if [ `which iptables` ] ; then
green_msg "search iptables ok
"
else
red_msg "search iptables failed
"
fi
fi

sleep 1

##################################################################################
###################### Set some variables and files ##############################

# All bans where stored in the file defined on next line
banfile="$mygoto/banlist"
captured_data="/tmp/tmp_captured"
touch $captured_data
captured_data_num="/tmp/tmp_captured_mypidnum"
touch $captured_data_num

##################################################################################
################## Add new Chain and Rules for getstatus - Bans ##################


$IPTABLESBIN -nL > $mygoto/iptab.tmp 
 
myChain=`grep "Chain getstatus" $mygoto/iptab.tmp | awk '{print $2}'`

if [ $myChain ] ; then
if [ $MYDEBUG == "1" ] ; then 
green_msg "
getstatus Chain exists "
fi
else
$IPTABLESBIN -N getstatus
if [ $MYDEBUG == "1" ] ; then
blue_msg "
Chain getstatus created"
fi
fi
#$IPTABLESBIN > $mygoto/iptab.tmp

myRules=`grep "getstatus  udp  --  0.0.0.0/0" $mygoto/iptab.tmp | awk '{print $1}'`

if [ "$myRules" ] ; then
getexist=$(iptables -nL --line-numbers | grep getstatus | grep -v DROP | grep -v Chain | awk '{print $1}')

if [ $MYDEBUG == "1" ] ; then 
green_msg "
getstatus Rules exists
"

if [ $getexist != "1" ] ; then
if [ $MYDEBUG == "1" ] ; then 
yellow_msg "
getstatus moved to the first position table iptables
"
fi
$IPTABLESBIN -D INPUT -p udp -m udp -j getstatus 
$IPTABLESBIN -I INPUT -p udp -m udp -j getstatus
fi

fi

else
$IPTABLESBIN -D INPUT -p udp -m udp -j getstatus
$IPTABLESBIN -I INPUT 1 -p udp -m udp -j getstatus
if [ $MYDEBUG == "1" ] ; then 
blue_msg "
Rules getstatus created
"
 
fi
fi

$IPTABLESBIN -nL > $mygoto/iptab.tmp
iptab="$mygoto/iptab.tmp"
if [ $MYDEBUG == "1" ] ; then 
cat $mygoto/iptab.tmp
fi

##################################################################################
################################  Functions ######################################
##################################################################################

function capture_data {
$TCPDUMPBIN -f -c 100000 -A >$captured_data 2>$captured_data_num & pid=$!
sleep $CAPTURETIME

}

##################################################################################
#######   ban          - Ban the given IP                                #########
#######                  and log data together with request frequence    #########
#######                  to "banlist"                                    #########
##################################################################################

function ban {
IP=$1

reqps=$((cnt/CAPTURETIME))
echo "banning IP: $IP" >> $banfile
$IPTABLESBIN -I getstatus 1 -s $IP -p UDP -j DROP
ts=`date`
rpsipcnt=$((IPCNT/CAPTURETIME))

out="$ts $IP $IPCNT = banned Reason: $reason for $cnt Requests in $CAPTURETIME seconds / $reqps  Requests per second "
echo $out >> $banfile
}

##################################################################################
#######   autoban      - starts the ban routine: calls capture_data      #########
#######                  greps the IPs to which getStatusRepsonsed       #########
##################################################################################

function autoban1 {
capture_data

for SEARCH in $PATTERN
do

	reason="(search pattern: $SEARCH and UDP)"
	allips1=$(grep -B2 $SEARCH $captured_data | grep UDP  | awk '{print $3}' | cut -d '.' -f 1,2,3,4 | sort -u)
 
	if [ $MYDEBUG == "1" ] ; then
	  yellow_msg "
	  allips1 $reason:
 
      	  $allips1"
   	fi

   	for newip in $allips1
   	do
        #vorkommen der IPs zaehlen
        cnt=$(grep -B2 $SEARCH $captured_data | grep UDP | grep $newip | wc -l)

        rps=$((cnt/CAPTURETIME))

        #check for already banned IP's 
        checkiptables

	if [ $CHK == "0" ] ; then
          if [ $rps -ge $MAXPERSECONDS ] ; then
            if [ $MYDEBUG == "1" ] ; then
              magenta_msg "
              ban $newip reason: $reason - for $cnt Requests in $CAPTURETIME seconds / $rps Requests per second"
            fi
            ban "$newip" "$rps"
          fi
        else
          if [ $MYDEBUG == "1" ] ; then
            red_msg "
            $newip already banned !"
          fi
        fi
	done
done 
}

########################################################################

function autoban2 {

for SEARCH in $PATTERN
do

	reason="(search pattern: $SEARCH and zoneRef)"

	allips2=$(grep -B2 $SEARCH $captured_data | grep zoneRef $captured_data | awk '{print $3}' | cut -d '.' -f 1,2,3,4 | sort -u)

	if [ $MYDEBUG == "1" ] 
	  then
	  yellow_msg "
	  allips2 $reason:

	  $allips2"
	fi

	for newip in $allips2
	do

	cnt=$(grep -B2 $SEARCH $captured_data | grep zoneRef $captured_data | grep $newip\.[domain] | wc -l)
 	rps=$((cnt/CAPTURETIME))

	# check for already banned IP's
 	checkiptables

	if [ $CHK == "0" ] ; then
	  if [ $rps -ge $MAXPERSECONDS ] ; then
	    if [ $MYDEBUG == "1" ] ; then
	      magenta_msg "
	      ban $newip  reason: $reason - for $cnt Requests in $CAPTURETIME seconds / $rps Requests per second"
	    fi
	    ban "$newip" "$rps"
 	  fi
	else
   	 if [ $MYDEBUG == "1" ] ; then
  	   red_msg"
	   $newip already banned !"
         fi
        fi
	done
done

        reason="(search pattern ].@.#.u0. and UDP)"

        allips2=$(grep -B2 '].@.#.u0.' $captured_data | grep UDP | awk '{print $3}' | cut -d '.' -f 1,2,3,4 | sort -u)

        if [ $MYDEBUG == "1" ]
          then
          yellow_msg "
          allips2 $reason:

          $allips2"
        fi

        for newip in $allips2
        do

        cnt=$(grep -B2 '].@.#.u0.' $captured_data | grep UDP | grep $newip | wc -l)
        rps=$((cnt/CAPTURETIME))

        # check for already banned IP's
        checkiptables

        if [ $CHK == "0" ] ; then
          if [ $rps -ge $MAXPERSECONDS ] ; then
            if [ $MYDEBUG == "1" ] ; then
              magenta_msg "
              ban $newip  reason: $reason - for $cnt Requests in $CAPTURETIME seconds / $rps Requests per second"
            fi
            ban "$newip" "$rps"
          fi
        else
         if [ $MYDEBUG == "1" ] ; then
         echo "$newip already banned !"
         fi
        fi
        done


}

######################  check for already banned IP's  ############################

function checkiptables {

$IPTABLESBIN -nL getstatus > $mygoto/chain   
banIP=$(grep ^DROP $mygoto/chain  | awk '{print $4}' ) 
CHK=0

for chkipt in $banIP ; do
if [ $newip == $chkipt ] ; then
let "CHK += 1"
fi
done
}

###################### Unban iptables getstatus  #################################

function unban {

# read banned IP from iptables chain

$IPTABLESBIN -nL getstatus > $mygoto/chain   
banIP=$(grep ^DROP  $mygoto/chain | awk '{print $4}' ) 

# read all IP's request, the getstatus

ips=$(grep -B2 getsta $captured_data | grep IP $captured_data | awk '{print $3}' | cut -d '.' -f 1,2,3,4 | sort -u) 

# Seeking IP's not to be unbanned

for oldip in $banIP
do

for banip in $ips
do

if [ $oldip == $banip ] ; then
echo oldip $oldip banip $banip >> $mygoto/unb
fi
done
done

if  [ -f $mygoto/unb ] ; then
for noDel in $(cat $mygoto/unb | awk '{print $2 " " $4}')
do
if [ "$noDel awk '{print $1}'"  ==   "$noDel awk '{print $2}'" ] ; then
echo $noDel | awk '{print $1}' >> $mygoto/noDel.tmp
fi
 
done
rm $mygoto/unb
fi

# remove duplicate IP's

if  [ -f $mygoto/noDel.tmp ] ; then
grep . $mygoto/noDel.tmp | awk '{print $1}' | sort -u > $mygoto/noDel
rm $mygoto/noDel.tmp
fi

# remove all clean IP's from iptables chain GetStatus

for oldip in $banIP
do

if  [ -f $mygoto/noDel ] ; then
unban=$(grep $oldip -F $mygoto/noDel)
fi

if  [ -z $unban ] ; then
ts=`date --utc +%s`
tshr=`date --utc --date "1970-01-01 $ts sec" "+%Y-%m-%d %T"`
ubout="$ts $oldip = unbanned $tshr"
echo $ubout >> $banfile
if [ $oldip != '0.0.0.0/0' ] ; then 
$IPTABLESBIN -D getstatus -p UDP -s $oldip -j DROP
if [ $MYDEBUG == "1" ] ; then
echo remove banned IP $oldip
fi
fi
else
if [ $MYDEBUG == "1" ] ; then
if [ $oldip != '0.0.0.0/0' ] ; then 
echo no remove banned IP $oldip
fi
fi
fi
done

if [ $MYDEBUG == "1" ] ; then 
$IPTABLESBIN -nL getstatus > $mygoto/chain
fi

if  [ -f $mygoto/noDel ] ; then
rm $mygoto/noDel
fi

}

##################################################################################
##################################################################################
###################            Script routine startup             ################
##################################################################################

autoban1
autoban2

if [ $RunPart == "2" ] ; then
if [ $RUNUNBAN == "1" ] ; then 
unban
fi
else
echo "Script section "Unban" disabled !!!"
fi

##################################################################################
##################################################################################
###################                 Cleanup               ########################
##################################################################################

if [ $pid ] ; then
kill $pid
fi

rm $captured_data 2>/dev/null
rm $captured_data_num 2>/dev/null
rm $mygoto/iptab.tmp 2>/dev/null
rm $mygoto/chain 2>/dev/null
rm $mygoto/0 2>/dev/null

##################################################################################
##################################################################################
##################################################################################
