/********************************************************************

    Copyright (C) 2005  Nicklas Larsson - etswitch@gmail.com - All rights reserved.

    $Id: $

    etswitch - switch to desktop

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

********************************************************************/

#if HAVE_CONFIG_H
# include <config.h>	/* autotool generated ifdef's */
#endif

#include <fcntl.h>	/* locking over nfs */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/ioctl.h>	/* for sending/geting data from special device */
#include <sys/file.h>	/* bsd? */


#include <dirent.h>	/* for scandir usage */
#include <libgen.h>	/* dirname / basename */

#include <pwd.h>	/* for getting home/user dir/settings */
#include <sys/types.h>

#include <sys/stat.h>	/* for file info/stat */

#include <malloc.h>
#include <linux/limits.h>

#include <signal.h>	/* signal handler */
#include <sys/time.h>
#include <sys/types.h>	/* kill */

#include <sys/resource.h>	/* resources */

#include "etswitch.h" 		/* etswitch */
#include "read_wid.h" 		/* .h */


#include <errno.h>
extern int errno;

/* read and malloc the game struct */
void readwid_conf(){
    int *file, *bin;

    FILE *fp;	/* wid file */

    int i=-1;    /* conf wid token */
    int y=0;
/* move this to .h ? */
char *confstr = "\n\
# please read docs on format of this config.\n# not a forgiving parser..\n\
\n\
America's Army: Operations	ArmyOps	SDL_App	SDL_App	armyops-bin	0\n\
Doomsday	*	SDL_App	SDL_App	*	1\n\
PlaneShift Crystal Blue	PlaneShift Crystal Blue	PlaneShift Crystal Blue	PlaneShift Crystal Blue	planeshift	15\n\
Nexuiz	*	*	*	*	0\n\
Enemy Territory	*	*	*	*	0\n\
Return to Castle Wolfenstein	*	*	*	*	0\n\
Quake III: Arena	*	*	*	*	0\n\
SoF	*	*	*	*	0\n\
Quake II	*	*	*	*	0\n\
Unreal Tournament 2004	*	*	*	*	0\n\
Silverback Engine	*	*	*	*	0\n\
Globulation 2	*	SDL_App	SDL_App	*	0\n\
LBreakout2	*	*	*	*	0\n\
DOOM 3	*	*	*	*	0\n\
Duke Nukem 3D	*	*	*	*	0\n\
MiniRacer	*	*	*	*	0\n\
ZSNES	*	*	*	*	0\n\
FCE Ultra	*	*	*	*	0\n\
Quake4	*	SDL_App	SDL_App	*	0\n\
QuakeForge	QuakeForge	qw-client	quakeforge	*	5\n\
Scorched3D	*	SDL_App	SDL_App	*	1\n\
bzflag	*	SDL_App	SDL_App	*	0\n\
CRX	*	*	*	*	0\n\
cube engine	*	SDL_App	SDL_App	*	0\n\
Warsow	*	*	*	*	0\n\
Tux Racer	*	SDL_App	SDL_App	*	1\n\
Mindware Engine	*	SDL_App	SDL_App	*	0\n\
Darwinia	*	SDL_App	SDL_App	*	0\n\
Scourge	*	SDL_App	SDL_App	*	0\n\
OpenTTD	*	SDL_App	SDL_App	*	1\n\
Trigger	*	SDL_App	SDL_App	*	0\n\
sauerbraten engine	*	SDL_App	SDL_App	*	0\n\
GLtron	*	SDL_App	SDL_App	*	0\n\
SuperTux	*	SDL_App	SDL_App	*	1\n\
Pingus	Pingus	*	*	*	3\n\
Neverball	*	SDL_App	SDL_App	*	0\n\
Neverputt	*	SDL_App	SDL_App	*	0\n\
UFO2000	*	allegro	Allegro	*	0\n\
Kobo Deluxe	*	SDL_App	SDL_App	*	1\n\
chromium B.S.U.	*	SDL_App	SDL_App	*	0\n";

#ifdef DEBUG
    fprintf(stdout, "readwid_conf: start\n");    
#endif

    /* patch me please */
    file = calloc(PATH_MAX+NAME_MAX+1,1);
    bin = calloc(78,1);
    
    snprintf(file, PATH_MAX+NAME_MAX+1, "%s/.etswitch/etswitch.wid", getenv("HOME"));
    if(wid != NULL){	
	free_array(wid);
    }
    wid = NULL;
    
    if (!(fp = fopen((char *)file, "r"))){
	fprintf(stderr, "fopen read failed: %s, at line: %d\n", strerror(errno),__LINE__);
	/* write default wid */
	writewid_conf(confstr);
    }else{
	int buff_size = 1024;
	char *buff, *token;
	char delimiters[] = "\t";

	char **lineptr;
	int *n;
	int tokn = 0;

	buff = (char*)malloc(*n);
	
	lineptr = &buff;
	n = &buff_size;
	
	while(getline(lineptr, n, fp) != -1){
	    token = strtok(buff, delimiters);
	    y=0;
	    tokn = 0;
	    while(token != NULL){    
    		if(token[0] == '#' || token[0] == '\n')	break;
		/* remove last \n */
    		    if(token[strlen(token)-1] == '\n'){
			token[strlen(token)-1] = '\0';
		    }
		    if(y == 0){
			i++;
			wid = ex2(wid);
		    }
		    y=1;
		    /* token loop */
		    if(tokn == 0){
			wid->WMNAME = (char *)strdup(token);
		    }else if(tokn == 1){
			wid->iconname = (char *)strdup(token);
		    }else if(tokn == 2){
			wid->res_name = (char *)strdup(token);
		    }else if(tokn == 3){
			wid->res_class = (char *)strdup(token);
		    }else if(tokn == 4){
			wid->known_binary = (char *)strdup(token);
		    }else if(tokn == 5){
			wid->tweak = atof(token);
		    }

		    token = strtok(NULL, delimiters);
		    tokn++;
		}
	    }

	free(file);
	free(bin);
	}
	if(wid != NULL){
/*	    printf("----- LOOPIE ----- \n"); 
	    loopie(wid->first_struct); */
	}
}

/* create a new struct, pointing old to new */
wid_info_struct *ex2(wid_info_struct *old){
    wid_info_struct *xy;

    if((xy = malloc(sizeof(wid_info_struct))) == NULL){
	perror("ex2: malloc().. out of memory\n");
	exit(1);
    }

    if(old != NULL){
	old->next_struct = (char *)xy;
	xy->id = old->id+1;
	xy->first_struct = old->first_struct;
    }else{
	xy->first_struct = (char *)xy;
	xy->id = 0;
    }

    /* default */
    xy->tweak = 0;
    xy->next_struct = NULL;
    return xy;
}

/* just test the sucker */
void loopie(wid_info_struct *old){

    wid_info_struct *p;

    printf("in loopie\n");    

    p = old; 

    while( 1 ){

	printf("--\nStruct ID:%i, twe: %i\n",p->id, p->tweak);	

	printf("WM:%s\nIC:%s\nNA:%s\nCL:%s\nTW:%i\n",
	p->WMNAME,
	p->iconname,
	p->res_name,
	p->res_class,
	p->tweak);	
	

	printf("--\n");
	if(p->next_struct == NULL) break;
	p = (wid_info_struct *)p->next_struct;
    }

}
/* free the array's */
void free_array(wid_info_struct *old){

    wid_info_struct *p;
    #ifdef DEBUG
    fprintf(stdout, "read_wid free_array: start\n");    
    #endif
    p = (wid_info_struct *)old->first_struct; 

    if(p != NULL){
	while( 1 ){
	    #ifdef DEBUG
	    printf("Struct ID:%i WM:%s IC:%s NA:%s CL:%s TW:%i\n",p->id,
	    p->WMNAME, p->iconname, p->res_name, p->res_class, p->tweak);	
	    #endif

	    free(p->WMNAME);
	    free(p->iconname);
	    free(p->res_name);
	    free(p->res_class);

	    if(p->next_struct == NULL) break;
    	    free(p);
    	    p = (wid_info_struct *)p->next_struct;
	}
	free(p);
    }else{
	#ifdef DEBUG
	fprintf(stdout, "read_wid free_array: Hmm.. array was allready cleared.\n");
	#endif
    }

    #ifdef DEBUG
    fprintf(stdout, "read_wid free_array: end\n");    
    #endif

}


void writewid_conf(char *key_string){
    int *file, *dir; /* , *home; */
    struct stat dir_stat;	/* test path */

    int fp;
    int r;
    int special;

    dir = calloc(PATH_MAX+1,1);
/*    home = calloc(PATH_MAX+1,1); */
    file = calloc(PATH_MAX+NAME_MAX+1,1);

    if((char *)file == NULL || (char *)dir == NULL){
	fprintf(stderr, "malloc failed: %s, at line: %d\n", strerror(errno),__LINE__);
	exit(EXIT_FAILURE);
    }
    /* change to get pw*/
    snprintf((char *)dir, PATH_MAX, "%s/.etswitch", getenv("HOME"));
    snprintf((char *)file, PATH_MAX+NAME_MAX, "%s/etswitch.wid", dir);
    if (stat((char *)dir, &dir_stat)!=-1){
	if (!S_ISDIR (dir_stat.st_mode)){    /* the name is a directory, and it exists  */
	    fprintf(stderr,"'%s' exists but it's not a directory, can't save config.\n", (char *)dir);
	}
    }else{
	fprintf(stdout,"Creating missing directory, '%s'.\n", (char *)dir);
	mkdir((char *)dir, S_IRWXU);
    }
    if (!(fp = open((char *)file, O_CREAT | O_TRUNC | O_WRONLY, S_IRWXU))){
        fprintf(stderr, "fopen read failed: %s, at line: %d\n", strerror(errno),__LINE__);
    }else{
        special = strlen(key_string);
        r = write(fp, key_string, special);
        if(r != special){
    	    printf("Hmm.. error '%i' writing to conf, make sure the path '%s' exists.\n", r,(char *)file);
	}
	close(fp);
    }
    free(file);
    free(dir);
    /* free(home); */
}

