/* $Id: etswitch.h,v 1.13 2005/04/14 18:42:18 larsson Exp $ */
#ifndef __ETSWITCH_H__
#define __ETSWITCH_H__

/* X11 */
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#ifdef HAVE_LIBXXF86VM
#include <X11/extensions/xf86vmode.h> /* gamma */
#endif

#define BIT(c, x)	( c[x/8]&(1<<(x%8)) )


/* function declarations */
int errorHandler(Display *dpy, XErrorEvent *e);
void usage();
void version();
/*static void signal_handler(int signal_number);*/
void signal_handler(int signal_number);

/*void timer_handler(int sig);*/
void win_init();
void win_close();
void keyboard_hook(Window root, unsigned long type);
/* void mapunmap(Window CHI); */
void mapunmap2(Window CHI, Display *display);

void sw(Window child_w);
int test_w(unsigned char *strz);
#ifdef HAVE_LIBXXF86VM
void get_res();
void save_res(int mode);
void restore_res(int mode);
void gammadown();
void gammaup(XF86VidModeGamma newg);
#endif
void setmix(int number, int lvalue, int rvalue);
void readmix(int dev);
void grab_key(Window window, unsigned int mask, unsigned int key);
int sc(char *binary);

/* ifdef X11 ?? */
/*
KeySym read_conf();
void write_conf(char *key_string);
*/
void select_bosskey();
void critical_info(char *string);

void DUMP(Window root);

typedef struct stereo {	/* struct for ioctl to dev mixer */
    unsigned char left;
    unsigned char right;
    unsigned char pad1;
    unsigned char pad2;
} StereoVolume;

typedef struct {	/* hmm.. kinda global */
    Display *d;		/* display */
    Window w;		/* gui window */
    GC gc;		/* gui window gfx content */
    char *display_name;
    int screen;		/* default screen for this display */
    Window root;	/* default rootw for this screen */
#ifdef HAVE_LIBXXF86VM
    /* xf86vidmode */
    XF86VidModeGamma desk_gamma;
    XF86VidModeGamma game_gamma;
    int *XF86VidModeVersionMajor;
    int *XF86VidModeVersionMinor;
    int res_count;
    XF86VidModeModeLine vm_modelines[2];	/* tweak me */ 
    XF86VidModeModeInfo **res_modelines; 
#endif
    /* gui */
    XSizeHints size_hints;
    XWMHints wm_hints;
    XClassHint class_hints;
    /* audio */
    struct stereo game_vol;
    int width;
    int height;
} win_struct;

/* future game struct */
typedef struct {
    char *binary;
    Window win;
    int width;
    int height;
    int pid;
    int prio;
} game_info_struct;


/*
typdef struct {
    char *bin;
    Window w;
    int width, height;
} a;

*/
#endif /* __ETSWITCH_H__ */
