/********************************************************************

    Copyright (C) 2005  Nicklas Larsson - etswitch@gmail.com - All rights reserved.

    $Id: conf.c,v 1.1 2005/04/14 18:42:18 larsson Exp $

    etswitch - switch to desktop

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

********************************************************************/

#if HAVE_CONFIG_H
# include <config.h>	/* autotool generated ifdef's */
#endif

#include <fcntl.h>	/* locking over nfs */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/ioctl.h>	/* for sending/geting data from special device */
#include <sys/file.h>	/* bsd? */


/* audio */
#include <sys/ioctl.h>	/* +term detect */
#ifdef FREEBSD
#include <machine/soundcard.h>
#endif
#ifdef LINUX
#include <linux/soundcard.h>
#endif

#include <dirent.h>	/* for scandir usage */
#include <libgen.h>	/* dirname / basename */

#include <pwd.h>	/* for getting home/user dir/settings */
#include <sys/types.h>

#include <sys/stat.h>	/* for file info/stat */

#include <X11/X.h>	/* X11 */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/xpm.h>	/* xpm */

#include <X11/Xos.h>
#include <X11/Xmu/WinUtil.h>
#include <X11/keysym.h>

/* for gamma and audio constants */
#define GAME 1
#define DESKTOP 0

#include <malloc.h>
#include <linux/limits.h>

#include <signal.h>	/* signal handler */
#include <sys/time.h>
#include <sys/types.h>	/* kill */

#include <sys/resource.h>	/* resources */

#include "etswitch.h" 		/* etswitch */
#include "conf.h" 		/* .h */

#include <errno.h>
extern int errno;

KeySym read_conf(){
    char *file;
    int *bin;
    int special = 77; /* fix me */
    int fp;
    int r;
    size_t max;
    char *home;    
    KeySym key;
    max = PATH_MAX+NAME_MAX+1;
    
    file = calloc(max,1);
    bin = calloc(78,1);
    home = (char *)getenv("HOME");
    snprintf((char *)file, (size_t)max, "%s/.etswitch/etswitch.rc", (char *)home);
    if (!(fp = open((char *)file,O_RDONLY))){
	fprintf(stderr, "fopen read failed: %s, at line: %d\n", strerror(errno),__LINE__);
    }else{
	r = read(fp,bin,special);
    }

    key = XStringToKeysym((char *)bin);
    if(key == NoSymbol){
	critical_info("Please configure etswitch, run with '-c' or '--config' option, now using default F10 as selected key.\n");
	key = XK_F10;
    }
    free(file);
    free(bin);
    return(key);
}

void write_conf(char *key_string){
    int *file, *dir; /* , *home; */
    struct stat dir_stat;	/* test path */

    int fp;
    int r;
    int special;

    dir = calloc(PATH_MAX+1,1);
/*    home = calloc(PATH_MAX+1,1); */
    file = calloc(PATH_MAX+NAME_MAX+1,1);

    if((char *)file == NULL || (char *)dir == NULL){
	fprintf(stderr, "malloc failed: %s, at line: %d\n", strerror(errno),__LINE__);
	exit(EXIT_FAILURE);
    }
    /* change to get pw*/
    snprintf((char *)dir, PATH_MAX, "%s/.etswitch", getenv("HOME"));
    snprintf((char *)file, PATH_MAX+NAME_MAX, "%s/etswitch.rc", dir);
    if (stat((char *)dir, &dir_stat)!=-1){
	if (!S_ISDIR (dir_stat.st_mode)){    /* the name is a directory, and it exists  */
	    fprintf(stderr,"'%s' exists but it's not a directory, can't save config.\n", (char *)dir);
	}
    }else{
	fprintf(stdout,"Creating missing directory, '%s'.\n", (char *)dir);
	mkdir((char *)dir, S_IRWXU);
    }
    if (!(fp = open((char *)file, O_CREAT | O_TRUNC | O_WRONLY, S_IRWXU))){
        fprintf(stderr, "fopen read failed: %s, at line: %d\n", strerror(errno),__LINE__);
    }else{
        special = strlen(key_string);
        r = write(fp, key_string, special);
        if(r != special){
    	    printf("Hmm.. error '%i' writing to conf, make sure the path '%s' exists.\n", r,(char *)file);
	}
	close(fp);
    }
    free(file);
    free(dir);
    /* free(home); */
}

