/*
 * W:ET Minimizer - A utility for minimizing RtCW: Enemy Territory
 * Copyright (C) 2003-2004  Erich Hoover
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Please submit bugs/updates using the Compholio.com feedback form
 * http://www.compholio.com/feedback.php
 *
 */

#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include "etmin.rh"

/* Default Registry Values */
#define CONNECT_DEFAULT       0
#define CONNECTADDR_DEFAULT   ""
#define LOADGAME_DEFAULT      1
#define AUTOLOAD_DEFAULT      0
#define PASSTHRU_DEFAULT      0
#define EMEREXIT_DEFAULT      1
#define RESIZE_DEFAULT        1
#define EXE_DEFAULT           "et.exe"
#define TITLE_DEFAULT         "Enemy Territory"
#define MINKEY_DEFAULT        "Z"
#define CUSTOMMIN_DEFAULT     1
#define CUSTOMCLOSE_DEFAULT   1
#define CUSTOMPROG_DEFAULT    ""
#define CUSTOMCMDLINE_DEFAULT ""
#define CUSTOMTITLE_DEFAULT   ""

/* Definitions */
#define WM_USER_SYSTRAY   WM_USER+1
#define MNU_ABOUT              9000
#define MNU_OPTIONS            9001
#define MNU_DIAGNOSTIC         9002
#define MNU_QUIT               9003

/* Variables */
static HWND WetWindow = NULL;
static BOOL WindowMaximized = TRUE;
static HWND CustomWindow = NULL;
static HWND IconHandlerWindow = NULL;
static HINSTANCE hProgInstance = NULL;
static char WindowString[MAX_PATH];

/* Functions */
void DoEvents(VOID) { };
DWORD WINAPI IconHandlerThread(void *_m);
DWORD WINAPI CheckOpen(void *_m);
void ClickMouse(VOID);
DEVMODE GetScreenResolution(VOID);
BOOL SetScreenResolution(DEVMODE DisplaySettings);
BOOL CALLBACK WindowProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK OptionsWindowProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam);
int GetPreferenceKey_INT(char *Preference, int DefaultValue);
char *GetPreferenceKey_CHAR(char *Preference, char *DefaultValue);
void SetPreferenceKey_INT(char *Preference, int NewValue);
void SetPreferenceKey_CHAR(char *Preference, char *NewValue);
char *ResolveHost(char *hostname);
DWORD WINAPI OptionsDialogThread(void *_m);

char State[2][5] = {"OFF", "ON"};

#pragma argsused
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
  MSG msg;
  DWORD nThreadID;
  long ret;
  char MinimizerKey, Opt[10];
  DEVMODE DefaultRes, GameRes;
  BOOL AutoConnect      = GetPreferenceKey_INT ("Auto Connect",         CONNECT_DEFAULT);
  BOOL AutoLoad         = GetPreferenceKey_INT ("Auto Load Custom App", LOADGAME_DEFAULT);
  BOOL LoadGame         = GetPreferenceKey_INT ("Auto Load Game",       AUTOLOAD_DEFAULT);
  BOOL CmdPassThru      = GetPreferenceKey_INT ("Command Passthru",     PASSTHRU_DEFAULT);
  BOOL UseEmergencyQuit = GetPreferenceKey_INT ("Use Emergency Quit",   EMEREXIT_DEFAULT);
  BOOL ResizeScreen     = GetPreferenceKey_INT ("Resize Screen",        RESIZE_DEFAULT);
  char *ETexe           = GetPreferenceKey_CHAR("Executable Name",      EXE_DEFAULT);
  char *WindowText      = GetPreferenceKey_CHAR("Window Title",         TITLE_DEFAULT);
  char *MinKey          = GetPreferenceKey_CHAR("Minimizer Key",        MINKEY_DEFAULT);
  
  HANDLE ThreadHandle;
  NOTIFYICONDATA SysTrayIcon;
  
  strcpy((char *) &WindowString, WindowText);
  free(WindowText);
  hProgInstance = hInstance;
  DefaultRes = GetScreenResolution();
  printf("Auto Game Load set to %s\n",       State[LoadGame]);
  printf("Command Passthru set to %s\n",     State[CmdPassThru]);
  printf("Use Emergency Quit set to %s\n",   State[UseEmergencyQuit]);
  printf("Executable set to: '%s'\n",        ETexe);
  printf("Window Title set to: '%s'\n",      WindowString);
  printf("Minimizer key set to: CTRL+%s.\n", MinKey);
  printf("Resize Screen set to: %s\n",       State[ResizeScreen]);
  MinimizerKey = MinKey[0];
  // Establish keyboard hotkey
  if(!RegisterHotKey(NULL, 0, MOD_CONTROL, MinimizerKey)) {
    printf("Failed to register keystroke min/max (CTRL+<key>).\n");
    return 1;
  }
  if(!RegisterHotKey(NULL, 1, MOD_CONTROL | MOD_SHIFT, MinimizerKey)) {
    printf("Failed to register keystroke min/max (CTRL+SHIFT+<key>).\n");
    return 1;
  }
  if(UseEmergencyQuit) {
    if(!RegisterHotKey(NULL, 2, MOD_CONTROL, 'Q')) {
      printf("Failed to register keystroke quit (CTRL+Q).\n");
      return 1;
    }
  }
  printf("Autoload custom application set to %s\n", State[AutoLoad]);
  if(AutoLoad) {
    BOOL AutoMinimize   = GetPreferenceKey_INT ("Custom-Auto Minimize", CUSTOMMIN_DEFAULT);
    BOOL AutoClose      = GetPreferenceKey_INT ("Custom-Auto Close",    CUSTOMCLOSE_DEFAULT);
    char *CustomProgram = GetPreferenceKey_CHAR("Custom-Program",       CUSTOMPROG_DEFAULT);
    char *CustomCommand = GetPreferenceKey_CHAR("Custom-CmdLine",       CUSTOMCMDLINE_DEFAULT);
    char *CustomTitle   = GetPreferenceKey_CHAR("Custom-Window Title",  CUSTOMTITLE_DEFAULT);
    
    printf("Program: %s\n",             CustomProgram);
    printf("Command-line: %s\n",        CustomCommand);
    printf("Window Title: %s\n",        CustomTitle);
    printf("Auto Minimize set to %s\n", State[AutoMinimize]);
    printf("Auto Close set to %s\n",    State[AutoClose]);
    CustomWindow = FindWindow(NULL, CustomTitle);
    if(CustomWindow != NULL) {
      printf("Application Already Running.\n");
      CustomWindow = NULL; // Don't close it later!
      ret = 32;
    } else if(AutoMinimize) {
      int i = 100; // 10 seconds
      printf("Loading...\n");
      ret = (long) ShellExecute(GetDesktopWindow(), "open", CustomProgram, CustomCommand, ".", SW_MINIMIZE);
      printf("Autominizing...\n");
      while(CustomWindow == NULL && i > 0) {
        CustomWindow = FindWindow(NULL, CustomTitle);
        Sleep(100); // Wait a little while for the app to load
        i--;
      }
      if(CustomWindow == NULL) {
        printf("Unable to find window to autominimize, sorry (the title is probably wrong)!\n");
      } else {
        // Now "force" it once it loads
        //SetWindowLong(CustomWindow, GWL_STYLE, GetWindowLong(CustomWindow, GWL_STYLE) | WS_MINIMIZE);
        ShowWindow(CustomWindow, SW_MINIMIZE);
        if(AutoClose) {
          // Leave value as-is so the program closes
        } else {
          CustomWindow = NULL; // Don't close (no handle)
        }
      }
    } else {
      ret = (long) ShellExecute(GetDesktopWindow(), "open", CustomProgram, CustomCommand, ".", 1);
    }
    if(ret < 32) {
      printf("Unable to load program, load it yourself! (Error Code %d)\n", ret);
    }
  }
  /* Start the Tray Icon */
  printf("Thread id: %d\n", GetCurrentThreadId());
  ThreadHandle = CreateThread(0, 0, IconHandlerThread, (void *) GetCurrentThreadId(), 0, 0);
  while(SetThreadPriority(ThreadHandle, THREAD_PRIORITY_NORMAL) == 0) {Sleep(100); DoEvents();}
  Sleep(100);
  /* */
  if(LoadGame) {
    printf("W:ET Minimizer Loaded, starting W:ET...\n");
  } else {
    printf("W:ET Minimizer Loaded, waiting for W:ET to open...\n");
    WetWindow = FindWindow(NULL, (char *) &WindowString);
    while(WetWindow == NULL) {
      WetWindow = FindWindow(NULL, (char *) &WindowString);
      Sleep(100);
    }
  }
  WetWindow = FindWindow(NULL, (char *) &WindowString);
  if(WetWindow == NULL && LoadGame) { //Load W:ET (if it's already open or told not to then DON'T)
    HKEY HKey;
    DWORD dwOpen,dwLen=256,dwType=REG_SZ;
    char szKeyWET[] = "SOFTWARE\\Activision\\Wolfenstein - Enemy Territory";
    char LoadLocation[1024], WETLocation[1024], WETFolder[1024];
    
    if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, szKeyWET, 0, 0, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &HKey, &dwOpen) == ERROR_SUCCESS) {
      if(RegQueryValueEx(HKey, "InstallPath", 0, &dwType, WETLocation, &dwLen) == ERROR_SUCCESS) {
        char CommandParameters[100] = "";
        
        printf("Auto connect to server set to %s\n", State[AutoLoad]);
        if(AutoConnect) {
          char *ServerAddress = GetPreferenceKey_CHAR("Auto Connect-Server",  "");
          
          strcpy(CommandParameters, "+connect ");
          strcat(CommandParameters, ResolveHost(ServerAddress));
        }
        strcpy(WETFolder, WETLocation);
        strcat(WETLocation, "\\");
        strcat(WETLocation, ETexe);
        free(ETexe);
        strcpy(LoadLocation, "\"");
        strcat(LoadLocation, WETLocation);
        strcat(LoadLocation, "\"");
        if(CmdPassThru) {
          strcpy(CommandParameters, lpCmdLine);
        }
        printf("W:ET Location:   \"%s\"\n", LoadLocation);
        printf("W:ET Parameters: \"%s\"\n", CommandParameters);
        ret = (long) ShellExecute(GetDesktopWindow(), "open", LoadLocation, CommandParameters, WETFolder, 1);
        if(ret < 32) {
          printf("Unable to load W:ET, load it yourself! (Error Code %d)\n", ret);
        }
      } else {
        //MessageBox(0, "Unable to locate W:ET Directory Key, Load it yourself!", "ERROR!", MB_OK);
        printf("Unable to locate W:ET Directory Key, load it yourself!\n");
      }
      RegCloseKey(HKey);
    } else {
      //MessageBox(0, "Unable to locate W:ET Registry Key, Load it yourself!", "ERROR!", MB_OK);
      printf("Unable to locate W:ET Registry Key, load it yourself!\n");
    }
  }
  while(WetWindow == NULL) {
    WetWindow = FindWindow(NULL, (char *) &WindowString);
    Sleep(1000);
    DoEvents();
  }
  printf("W:ET Window Found (id:%d).\n", WetWindow);
  CreateThread(0, 0, CheckOpen, (void*) GetCurrentThreadId(), 0, &nThreadID);
  while(GetMessage(&msg, NULL, 0,0)) {
    if(msg.message == WM_HOTKEY) {
      if(HIWORD(msg.lParam) == MinimizerKey && LOWORD(msg.lParam) == MOD_CONTROL) {
        if(!WindowMaximized) {
          // Already min'ed
          MessageBeep(MB_ICONASTERISK);
          printf("Software Reports: Window Already Minimized.\n");
        } else {
          // Minimize the window
          SetWindowLong(WetWindow, GWL_STYLE, WS_MINIMIZE);
          ClickMouse();
          Sleep(100);
          InvalidateRect(0, NULL, TRUE);
          GameRes = GetScreenResolution();
          if(ResizeScreen) SetScreenResolution(DefaultRes);
          EnableWindow(WetWindow, FALSE);
          printf("Window Minimized - Use CTRL+SHIFT+%s to maximize.\n", MinKey);
          WindowMaximized = FALSE;
        }
      } else if(HIWORD(msg.lParam) == MinimizerKey && LOWORD(msg.lParam) == MOD_CONTROL | MOD_SHIFT) {
        if(WindowMaximized) {
          // Already max'ed
          MessageBeep(MB_ICONASTERISK);
          printf("Software Reports: Window Already Maximized.\n");
        } else {
          // Maximize the window
          if(ResizeScreen) SetScreenResolution(GameRes);
          EnableWindow(WetWindow, TRUE);
          SetWindowLong(WetWindow, GWL_STYLE, WS_MAXIMIZE);
          ShowWindow(WetWindow, SW_MAXIMIZE);
          SetActiveWindow(WetWindow);
          Sleep(100);
          ClickMouse();
          printf("Window Maximized - Use CTRL+%s to minimize.\n", MinKey);
          WindowMaximized = TRUE;
        }
      } else if(HIWORD(msg.lParam) == 'Q') {
        PostQuitMessage(0);
      } else {
        printf("%d\n", HIWORD(msg.lParam));
      }
    }
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  printf("Application Stopped.\n");
  if(CustomWindow != NULL) {
    SendMessage(CustomWindow, WM_CLOSE, 0, 0);
    printf("Closed custom app.\n");
  }
  UnregisterHotKey(NULL, 0);
  UnregisterHotKey(NULL, 1);
  UnregisterHotKey(NULL, 2);
  if(ResizeScreen) SetScreenResolution(DefaultRes);
  
  // Close the tray icon, another instance will re-build it if there's one out there
  SysTrayIcon.cbSize = sizeof(SysTrayIcon);
  SysTrayIcon.hWnd = IconHandlerWindow;
  SysTrayIcon.uID = 0;
  SysTrayIcon.uFlags = 0;
  
  if(!Shell_NotifyIcon(NIM_DELETE, &SysTrayIcon)) {
    // Unable to destroy notify icon
    printf("Error destroying tray icon!\n");
  }
  TerminateThread(ThreadHandle, FALSE);
  free(MinKey);
  return 0;
}

void ClickMouse(VOID) {
  INPUT pInputs[1];
  MOUSEINPUT pMouseInput;
  
  pMouseInput.dx = 0;
  pMouseInput.dy = 0;
  pMouseInput.mouseData = XBUTTON1;
  pMouseInput.dwFlags = MOUSEEVENTF_LEFTDOWN;
  pMouseInput.time = 0;
  pInputs[0].type = INPUT_MOUSE;
  pInputs[0].mi = pMouseInput;
  SendInput(1, pInputs, sizeof(INPUT));
  pMouseInput.dwFlags = MOUSEEVENTF_LEFTUP;
  pInputs[0].mi = pMouseInput;
  SendInput(1, pInputs, sizeof(INPUT));
  return;
}

DWORD WINAPI CheckOpen(void *_m) {
  DWORD ParentThread = (DWORD) _m;
  char WetName[100];
  
  while(1){
    GetWindowText(WetWindow, WetName, 100);
    if(strcmp(WetName, (char *) &WindowString) != 0) {
      INPUT pInputs[1];
      KEYBDINPUT pKeyboardInput;
      
      printf("W:ET closed or became unavailable, exiting...\n");
      if(!PostThreadMessage(ParentThread, WM_HOTKEY, 1, MAKELPARAM(2, 'Q'))) {
        printf("Contacting parent thread failed, please press CTRL+Q.\n");
      }
      return 0;
    }
    Sleep(1000);
    DoEvents();
  }
}

DEVMODE GetScreenResolution(VOID) {
  DEVMODE mySettings;
  
  EnumDisplaySettings(NULL, ENUM_CURRENT_SETTINGS, &mySettings);
  return mySettings;
}

BOOL SetScreenResolution(DEVMODE DisplaySettings) {
  int ret;
  
  ret = ChangeDisplaySettings(&DisplaySettings, CDS_TEST);
  if(ret != DISP_CHANGE_SUCCESSFUL) return 0;
  ChangeDisplaySettings(&DisplaySettings, CDS_UPDATEREGISTRY);
  return 1;
}

#pragma argsused
DWORD WINAPI IconHandlerThread(void *_m) {
  DWORD ParentThread = (DWORD) _m;
  MSG msg;
  NOTIFYICONDATA SysTrayIcon;
  
  IconHandlerWindow = CreateDialogParam(hProgInstance, MAKEINTRESOURCE(ID_ICON_DIALOG), 0, (DLGPROC) WindowProc, (LPARAM) 0);
  if(IconHandlerWindow == NULL) {
    return 0;
  }
  ShowWindow(IconHandlerWindow, FALSE);
  
  // Now update the tray icon to recognize this handle as the parent
  SysTrayIcon.cbSize = sizeof(SysTrayIcon);
  SysTrayIcon.hWnd = IconHandlerWindow;
  SysTrayIcon.uID = 0;
  SysTrayIcon.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
  SysTrayIcon.uCallbackMessage = WM_USER_SYSTRAY;
  SysTrayIcon.hIcon = LoadIcon(hProgInstance, "SMALLICON");
  strcpy(SysTrayIcon.szTip, "W:ET Minimizer\0");
  
  if(!Shell_NotifyIcon(NIM_ADD, &SysTrayIcon)) {
    // Unable to create notify icon
    printf("Error creating tray icon!\n");
  }
  //HANDLE WINDOW MSGS
  while (GetMessage(&msg, NULL, 0, 0)) {
    if (!IsDialogMessage(IconHandlerWindow, &msg)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
  }
  
  // Close the tray icon, another instance will re-build it if there's one out there
  SysTrayIcon.cbSize = sizeof(SysTrayIcon);
  SysTrayIcon.hWnd = IconHandlerWindow;
  SysTrayIcon.uID = 0;
  SysTrayIcon.uFlags = 0;
  
  if(!Shell_NotifyIcon(NIM_DELETE, &SysTrayIcon)) {
    // Unable to destroy notify icon
    printf("Error destroying tray icon!\n");
  }
  if(!PostThreadMessage(ParentThread, WM_HOTKEY, 1, MAKELPARAM(2, 'Q'))) {
    printf("Contacting parent thread failed, please press CTRL+Q.\n");
  }
  IconHandlerWindow = NULL;
  Sleep(2000);
  printf("Minimizer forced to closed (hotkey handler not running).\n");
  exit(0);
  return 1;
}

#pragma argsused
BOOL CALLBACK WindowProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam) {
  if (uiMsg == WM_INITDIALOG) {
    return TRUE;
  } else if(uiMsg == WM_LBUTTONDOWN) {
/*
    SendMessage(hDlg, WM_CLOSE, 0, 0);
*/
  } else if(uiMsg == WM_COMMAND) {
    if(LOWORD(wParam) == MNU_ABOUT) {
      MessageBox(0, "W:ET Minimizer by Erich Hoover", "About", MB_OK);
    } else if(LOWORD(wParam) == MNU_OPTIONS) {
      HANDLE ThreadHandle;
      
      /* Load the Options Dialog */
      ThreadHandle = CreateThread(0, 0, OptionsDialogThread, (void*) 0, 0, 0);
      while(SetThreadPriority(ThreadHandle, THREAD_PRIORITY_NORMAL) == 0) {Sleep(100); DoEvents();}
      Sleep(100);
      /* */
    } else if(LOWORD(wParam) == MNU_QUIT) {
      // The 'quit' operation is handled after the message handler dumps
      PostQuitMessage(0);
    } else if(LOWORD(wParam) == MNU_DIAGNOSTIC) {
    }
  } else if(uiMsg == WM_USER_SYSTRAY) {
    if(hDlg == IconHandlerWindow) {
      if(lParam == WM_LBUTTONUP) {
        PostMessage(hDlg, WM_COMMAND, MNU_ABOUT, 0);
      } else if(lParam == WM_RBUTTONUP) {
        HMENU hMenu = CreatePopupMenu();
        POINT point;
        
        InsertMenu(hMenu, 0, MF_STRING | MF_BYPOSITION, (UINT) MNU_OPTIONS, "&Options");
        //InsertMenu(hMenu, 1, MF_STRING | MF_BYPOSITION, (UINT) MNU_DIAGNOSTIC, "&Diagnostics Window");
        InsertMenu(hMenu, 1, MF_STRING | MF_BYPOSITION, (UINT) MNU_QUIT, "&Quit W:ET Minimizer");
        InsertMenu(hMenu, 2, MF_SEPARATOR | MF_BYPOSITION, (UINT) -1, "");
        InsertMenu(hMenu, 3, MF_STRING | MF_BYPOSITION, (UINT) MNU_ABOUT, "&About W:ET Minimizer");
        SetMenuDefaultItem(hMenu, MNU_ABOUT, FALSE);
        GetCursorPos(&point);
        SetForegroundWindow(hDlg);
        TrackPopupMenu(hMenu, TPM_LEFTBUTTON | TPM_RIGHTBUTTON | TPM_LEFTALIGN, point.x, point.y, 0, hDlg, NULL);
        PostMessage(hDlg, WM_NULL, 0, 0);
        DestroyMenu(hMenu);
      }
    }
    return TRUE;
  } else if(uiMsg == WM_CLOSE) {
    DestroyWindow(hDlg);
    return TRUE;
  } else if(uiMsg == WM_DESTROY) {
    PostQuitMessage(0);
    return TRUE;
  }
  return FALSE;
}

#pragma argsused
BOOL CALLBACK OptionsWindowProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam) {
  if (uiMsg == WM_INITDIALOG) {
    char *tmptxt;
    
    /* Load all settings */
    SendMessage(GetDlgItem(hDlg, ID_CONNECT_CHECKBOX)  , BM_SETCHECK, GetPreferenceKey_INT("Auto Connect",          CONNECT_DEFAULT), 0);
    SendMessage(GetDlgItem(hDlg, ID_LOADGAME_CHECKBOX) , BM_SETCHECK, GetPreferenceKey_INT("Auto Load Game",        LOADGAME_DEFAULT), 0);
    SendMessage(GetDlgItem(hDlg, ID_AUTOLOAD_CHECKBOX) , BM_SETCHECK, GetPreferenceKey_INT("Auto Load Custom App",  AUTOLOAD_DEFAULT), 0);
    SendMessage(GetDlgItem(hDlg, ID_PASSTHRU_CHECKBOX) , BM_SETCHECK, GetPreferenceKey_INT("Command Passthru",      PASSTHRU_DEFAULT), 0);
    SendMessage(GetDlgItem(hDlg, ID_EMEREXIT_CHECKBOX) , BM_SETCHECK, GetPreferenceKey_INT("Use Emergency Quit",    EMEREXIT_DEFAULT), 0);
    SendMessage(GetDlgItem(hDlg, ID_AUTOMIN_CHECKBOX)  , BM_SETCHECK, GetPreferenceKey_INT ("Custom-Auto Minimize", CUSTOMMIN_DEFAULT), 0);
    SendMessage(GetDlgItem(hDlg, ID_AUTOCLOSE_CHECKBOX), BM_SETCHECK, GetPreferenceKey_INT ("Custom-Auto Close",    CUSTOMCLOSE_DEFAULT), 0);
    SendMessage(GetDlgItem(hDlg, ID_RESIZE_CHECKBOX)   , BM_SETCHECK, GetPreferenceKey_INT ("Resize Screen",        RESIZE_DEFAULT), 0);
    tmptxt = GetPreferenceKey_CHAR("Executable Name",     EXE_DEFAULT);
    SetWindowText(GetDlgItem(hDlg, ID_EXE_EDIT), tmptxt);
    free(tmptxt);
    tmptxt = GetPreferenceKey_CHAR("Window Title",        TITLE_DEFAULT);
    SetWindowText(GetDlgItem(hDlg, ID_TITLE_EDIT), tmptxt);
    free(tmptxt);
    tmptxt = GetPreferenceKey_CHAR("Minimizer Key",       MINKEY_DEFAULT);
    SetWindowText(GetDlgItem(hDlg, ID_MINKEY_EDIT), tmptxt);
    free(tmptxt);
    tmptxt = GetPreferenceKey_CHAR("Auto Connect-Server", CONNECTADDR_DEFAULT);
    SetWindowText(GetDlgItem(hDlg, ID_HOSTNAME_EDIT), tmptxt);
    free(tmptxt);
    tmptxt = GetPreferenceKey_CHAR("Custom-Program",      CUSTOMPROG_DEFAULT);
    SetWindowText(GetDlgItem(hDlg, ID_PROGRAM_EDIT), tmptxt);
    free(tmptxt);
    tmptxt = GetPreferenceKey_CHAR("Custom-CmdLine",      CUSTOMCMDLINE_DEFAULT);
    SetWindowText(GetDlgItem(hDlg, ID_CMDLINE_EDIT), tmptxt);
    free(tmptxt);
    tmptxt = GetPreferenceKey_CHAR("Custom-Window Title", CUSTOMTITLE_DEFAULT);
    SetWindowText(GetDlgItem(hDlg, ID_CUSTTITLE_EDIT), tmptxt);
    free(tmptxt);
    return TRUE;
  } else if(uiMsg == WM_COMMAND) {
    if(wParam == ID_OK_BUTTON) {
      char tmptxt[MAX_PATH];
      HWND tmpobj;
      
      /* Save Settings before Exiting */
      SetPreferenceKey_INT("Auto Connect",          SendMessage(GetDlgItem(hDlg, ID_CONNECT_CHECKBOX), BM_GETCHECK, 0, 0));
      SetPreferenceKey_INT("Auto Load Game",        SendMessage(GetDlgItem(hDlg, ID_LOADGAME_CHECKBOX), BM_GETCHECK, 0, 0));
      SetPreferenceKey_INT("Auto Load Custom App",  SendMessage(GetDlgItem(hDlg, ID_AUTOLOAD_CHECKBOX), BM_GETCHECK, 0, 0));
      SetPreferenceKey_INT("Command Passthru",      SendMessage(GetDlgItem(hDlg, ID_PASSTHRU_CHECKBOX), BM_GETCHECK, 0, 0));
      SetPreferenceKey_INT("Use Emergency Quit",    SendMessage(GetDlgItem(hDlg, ID_EMEREXIT_CHECKBOX), BM_GETCHECK, 0, 0));
      SetPreferenceKey_INT ("Custom-Auto Minimize", SendMessage(GetDlgItem(hDlg, ID_AUTOMIN_CHECKBOX), BM_GETCHECK, 0, 0));
      SetPreferenceKey_INT ("Custom-Auto Close",    SendMessage(GetDlgItem(hDlg, ID_AUTOCLOSE_CHECKBOX), BM_GETCHECK, 0, 0));
      SetPreferenceKey_INT ("Resize Screen",        SendMessage(GetDlgItem(hDlg, ID_RESIZE_CHECKBOX), BM_GETCHECK, 0, 0));
      tmpobj = GetDlgItem(hDlg, ID_EXE_EDIT);
      GetWindowText(tmpobj, (char *) &tmptxt, GetWindowTextLength(tmpobj) + 1);
      SetPreferenceKey_CHAR("Executable Name",     tmptxt);
      tmpobj = GetDlgItem(hDlg, ID_TITLE_EDIT);
      GetWindowText(tmpobj, (char *) &tmptxt, GetWindowTextLength(tmpobj) + 1);
      SetPreferenceKey_CHAR("Window Title",        tmptxt);
      tmpobj = GetDlgItem(hDlg, ID_MINKEY_EDIT);
      GetWindowText(tmpobj, (char *) &tmptxt, GetWindowTextLength(tmpobj) + 1);
      SetPreferenceKey_CHAR("Minimizer Key",       tmptxt);
      tmpobj = GetDlgItem(hDlg, ID_HOSTNAME_EDIT);
      GetWindowText(tmpobj, (char *) &tmptxt, GetWindowTextLength(tmpobj) + 1);
      SetPreferenceKey_CHAR("Auto Connect-Server", tmptxt);
      tmpobj = GetDlgItem(hDlg, ID_PROGRAM_EDIT);
      GetWindowText(tmpobj, (char *) &tmptxt, GetWindowTextLength(tmpobj) + 1);
      SetPreferenceKey_CHAR("Custom-Program",      tmptxt);
      tmpobj = GetDlgItem(hDlg, ID_CMDLINE_EDIT);
      GetWindowText(tmpobj, (char *) &tmptxt, GetWindowTextLength(tmpobj) + 1);
      SetPreferenceKey_CHAR("Custom-CmdLine",      tmptxt);
      tmpobj = GetDlgItem(hDlg, ID_CUSTTITLE_EDIT);
      GetWindowText(tmpobj, (char *) &tmptxt, GetWindowTextLength(tmpobj) + 1);
      SetPreferenceKey_CHAR("Custom-Window Title", tmptxt);
      PostMessage(hDlg, WM_CLOSE, 0, 0);
    } else if(wParam == ID_CANCEL_BUTTON || wParam == 2) {
      PostMessage(hDlg, WM_CLOSE, 0, 0);
    }
  } else if(uiMsg == WM_CLOSE) {
    DestroyWindow(hDlg);
    return TRUE;
  } else if(uiMsg == WM_DESTROY) {
    PostQuitMessage(0);
    return TRUE;
  }
  return FALSE;
}

#pragma argsused
DWORD WINAPI OptionsDialogThread(void *_m) {
  MSG msg;
  HWND OptionsWindow;
  
  OptionsWindow = CreateDialogParam(hProgInstance, MAKEINTRESOURCE(ID_OPTIONS_DIALOG), 0, (DLGPROC) OptionsWindowProc, (LPARAM) 0);
  if(OptionsWindow == NULL) {
    return 0;
  }
  SendMessage(OptionsWindow, WM_SETICON, ICON_SMALL, (LPARAM) LoadIcon(hProgInstance, "SMALLICON"));
  SendMessage(OptionsWindow, WM_SETICON, ICON_BIG,   (LPARAM) LoadIcon(hProgInstance, "LARGEICON"));
  ShowWindow(OptionsWindow, TRUE);
  
  //HANDLE WINDOW MSGS
  while(GetMessage(&msg, NULL, 0, 0)) {
    if(!IsDialogMessage(OptionsWindow, &msg)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
  }
  return 1;
}

void SetPreferenceKey_INT(char *Preference, int NewValue) {
  HKEY HKey;
  DWORD dwOpen;
  char szKeyCompany[] = "Software\\Compholio";
  char szKeyProgram[] = "Software\\Compholio\\etmin";

  if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, szKeyCompany, 0, 0, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &HKey, &dwOpen) == ERROR_SUCCESS) {
    if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, szKeyProgram, 0, 0, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &HKey, &dwOpen) == ERROR_SUCCESS) {
      RegSetValueEx(HKey, (LPCTSTR) Preference, 0, REG_BINARY, (LPBYTE) &NewValue, 4);
      RegCloseKey(HKey);
      return;
    }
  }
  printf("ERROR SAVING KEY!\n");
  return;
}

int GetPreferenceKey_INT(char *Preference, int DefaultValue) {
  HKEY HKey;
  DWORD dwOpen, dwLen = 4, dwType = REG_BINARY;
  int KeyValue;
  char szKeyCompany[] = "Software\\Compholio";
  char szKeyProgram[] = "Software\\Compholio\\etmin";
  
  if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, szKeyCompany, 0, 0, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &HKey, &dwOpen) == ERROR_SUCCESS) {
    if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, szKeyProgram, 0, 0, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &HKey, &dwOpen) == ERROR_SUCCESS) {
      if(RegQueryValueEx(HKey, (LPCTSTR) Preference, 0, &dwType, (LPBYTE) &KeyValue, &dwLen) == ERROR_SUCCESS) {
        return KeyValue;
      }
      RegSetValueEx(HKey, (LPCTSTR) Preference, 0, REG_BINARY, (LPBYTE) &DefaultValue, 4);
      RegCloseKey(HKey);
      return DefaultValue;
    }
  }
  printf("ERROR GETTING KEY!\n");
  return NULL;
}

void SetPreferenceKey_CHAR(char *Preference, char *NewValue) {
  HKEY HKey;
  DWORD dwOpen;
  char szKeyCompany[] = "Software\\Compholio";
  char szKeyProgram[] = "Software\\Compholio\\etmin";
  
  if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, szKeyCompany, 0, 0, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &HKey, &dwOpen) == ERROR_SUCCESS) {
    if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, szKeyProgram, 0, 0, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &HKey, &dwOpen) == ERROR_SUCCESS) {
      RegSetValueEx(HKey, (LPCTSTR) Preference, 0, REG_SZ, (unsigned char *) NewValue, strlen(NewValue));
      RegCloseKey(HKey);
      return;
    }
  }
  printf("ERROR SAVING KEY!\n");
  return;
}

char *GetPreferenceKey_CHAR(char *Preference, char *DefaultValue) {
  HKEY HKey;
  DWORD dwOpen, dwLen = 255, dwType = REG_SZ;
  unsigned char *KeyValue;
  char szKeyCompany[] = "Software\\Compholio";
  char szKeyProgram[] = "Software\\Compholio\\etmin";
  
  if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, szKeyCompany, 0, 0, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &HKey, &dwOpen) == ERROR_SUCCESS) {
    if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, szKeyProgram, 0, 0, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0, &HKey, &dwOpen) == ERROR_SUCCESS) {
      KeyValue = malloc(dwLen);
      if(RegQueryValueEx(HKey, (LPCTSTR) Preference, 0, &dwType, (unsigned char *) KeyValue, &dwLen) == ERROR_SUCCESS) {
        KeyValue[dwLen] = 0;
        return (char *) KeyValue;
      }
      RegSetValueEx(HKey, (LPCTSTR) Preference, 0, REG_SZ, (unsigned char *) DefaultValue, strlen(DefaultValue));
      RegCloseKey(HKey);
      free(KeyValue);
      return DefaultValue;
    }
  }
  printf("ERROR GETTING KEY!\n");
  return NULL;
}

char *ResolveHost(char *hostname) {
  WORD      wVersionRequested = MAKEWORD(1, 1);
  LPHOSTENT lpHostEntry;
  WSADATA   stWSAData;
  char      *ipaddr;
  int       nRet;

  // Initialize WinSock
  nRet = WSAStartup(wVersionRequested, &stWSAData);
  if(nRet) {
    printf("WSAStartup failed error #%d\n",nRet);
    return NULL;
  }
  // Resolve name
  lpHostEntry = gethostbyname((const char *) hostname);
  if(lpHostEntry == NULL)  {
    printf("Unable to resolve hostname!\n");
    return NULL;
  }
  // Convert the IP Address to a string
  ipaddr = inet_ntoa(*((LPIN_ADDR)*lpHostEntry->h_addr_list));
  printf("Host name resolved to: %s\n", ipaddr);
  return ipaddr;
}
