#!/bin/bash


#CAMPAIGN CHECKER
# by schnoog
# Version 1 (beta)
# checks if all maps needed to run a campaign from campaign-pk3 are in place at etmain folder
# ./scriptname FullPathToCampaignPK3 FullPathToETMain
#

##########CONFIGURATION
###SET YOUR TEMP DIR
tmpbase="/tmp/"
#######################












#################################
debug=0
MYIFS=$IFS

########D E B U G################
if [ "$debug" == "1" ]
then
CAMPPK3="/skriptdev/campchecker/testdaten/etpro/etw_campaign_01012011.pk3"
ETMAIN="/skriptdev/campchecker/testdaten/etmain/"
else
CAMPPK3="$1"
ETMAIN="$2"
if [ $# -ne 2 ] ; then
        echo -e "\nThis script expect 2 parameters."
        echo "those are"
        echo "1: full path to your campaign - pk3"
        echo "2: full path to your etmain folder"	
        exit 32
fi
####UNZIP TEST
trash=`which unzip 2>/dev/null`
if [ $? -eq 1 ]
then
echo "Sorry, unzip not found."
echo "pk3 files are zip archives, so unzip is needed for this script to work"
        exit 32
fi
####UNZIP TEST
fi
########D E B U G################

BASENAME=`basename $CAMPPK3`
tmphash=`echo $BASENAME |md5sum | cut -d " " -f 1` 

TMPDIR="$tmpbase$tmphash"
maplist="$TMPDIR/maplist.txt"
rm $maplist 2>/dev/null
mapbunker="$TMPDIR/mapbunker.txt"
rm $mapbunker 2>/dev/null
mkdir $TMPDIR
cd $TMPDIR
unzip -j -o "$CAMPPK3" -d $TMPDIR >/dev/null

#++++++++++++++++++++++++++++++++++++++++#
# -------------------------------------- #
# ----- MAPS  AUSLESEN in $maplist ----- #
erg1=`grep -B 1 '374 374' *.campaign | grep 'maps' | cut -d "\"" -f 2`
IFS="
"
for line in $erg1
do
IFS=";"
for mapcmd in $line
do
echo $mapcmd >> $maplist
########D E B U G################
if [ "$debug" == "1" ] 
then
echo $mapcmd >/dev/null
fi
########D E B U G################
done
done
# --- ENDE MAPS AUSLESEN in $maplist --- #
# -------------------------------------- #
#++++++++++++++++++++++++++++++++++++++++#

#++++++++++++++++++++++++++++++++++++++++#
# -------------------------------------- #
# ---- PK3s  AUSLESEN in $mapbunker ---- #

IFS=$MYIFS

cd "$ETMAIN"
pk3s=`dir *.pk3`
for pk3 in $pk3s
do
IFS="
"

ALL=$(unzip -l $pk3 | grep '.bsp')
for bsp in $ALL
do
########D E B U G################
if [ "$debug" == "1" ] 
then
echo $bsp
fi
########D E B U G################
FT=$(expr index "$bsp" maps/)
declare -i startpos
declare -i exlen
startpos=$FT+4
FILE1=${bsp:$startpos}
LEN1=${#FILE1}
exlen=$LEN1-4
MAPNAME=${FILE1:0:$exlen}
echo $MAPNAME >> $mapbunker
done
done
# --- ENDE  AUSLESEN  in  $mapbunker --- #
# -------------------------------------- #
#++++++++++++++++++++++++++++++++++++++++#

#++++++++++++++++++++++++++++++++++++++++#
# -------------------------------------- #
# ---- BENOETIGTE MAPS AUS $maplist ---- #
# ---- auslesen und mit vorhandenen ---- #
# ---- in $mapbunker abgleichen     ---- #


echo "**************************************"
echo "**************************************"
echo "**************************************"
CHECK=0

bedarf=`cat $maplist | sort -u`
IFS="
"

for mapbedarf in $bedarf
do
len=${#mapbedarf}
if [ $len -gt 1 ]
then

LINES=`grep "$mapbedarf" "$mapbunker" | wc -l`
#LINES=1
if [ "$LINES" == "0" ]
then
CHECK=1
echo "$mapbedarf"

fi

########D E B U G################
if [ "$debug" == "1" ]
then
echo $mapbedarf
grep "$mapbedarf" "$mapbunker" | wc -l
fi
########D E B U G################


fi

done


if [ "$CHECK" == "1" ]
then
echo " CHECK THE PK3 FILES FROM THE MAPS LISTED ABOVE!"
echo "**************************************"
echo "**************************************"
else
echo "ALL SEEMS TO BE FINE"


fi


cd $tmpbase
########D E B U G################
if [ "$debug" != "1" ]
then
rm -r $tmphash
fi
########D E B U G################

IFS=$MYIFS