# Copyright 1999-2004 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

inherit flag-o-matic eutils toolchain-funcs debug

DESCRIPTION="A 'minimizer' for a few games"
HOMEPAGE="http://hem.bredband.net/b400150/"
SRC_URI="http://hem.bredband.net/b400150/etswitch/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"

# now this is very broken
# ~ppc
KEYWORDS="~amd64 ~x86"

# audio? 
IUSE="debug"

#equery belongs libXmu.so libXt.so libXpm.so libXxf86vm.so

#AC_CHECK_LIB([X11], [XOpenDisplay],,AC_MSG_ERROR([The path for the X11 files not found! Make sure that X11 is installed and devel]), $X_LIBS)
#AC_CHECK_LIB([Xmu], [XmuClientWindow],,AC_MSG_ERROR([Please install Xmu libs]), $X_LIBS)
#AC_CHECK_LIB([Xt], [main],,AC_MSG_ERROR([Please install Xt libs]), $X_LIBS)
#AC_CHECK_LIB([Xxf86vm], [XF86VidModeGetAllModeLines],,AC_MSG_WARN([Some features will be disabled]); $nxf=1, $X_LIBS)
#AC_CHECK_LIB([Xpm], [main],,AC_MSG_ERROR("*** i need XPM stuff ***"), $X_LIBS)

#x11-libs/libX11
#x11-libs/libXmu
#x11-libs/libXxf86vm
#x11-libs/libXt
#x11-libs/libXpm

DEPEND="|| ( (	x11-libs/libX11
		x11-libs/libXmu
		x11-libs/libXxf86vm
		x11-libs/libXt
		x11-libs/libXpm
		)
		virtual/x11
		)"
				    
RDEPEND="|| ( ( x11-libs/libX11
		x11-libs/libXmu
		x11-libs/libXxf86vm
		x11-libs/libXt
		x11-libs/libXpm
		)
		virtual/x11 )"

print_etswitch_warning() {
	ewarn
	ewarn "If you experience problems with ${P}, please report back to"
	ewarn "the developer."
	ewarn
	ewarn "Be sure to USE=\"debug\" and include a backtrace for any segfaults"
	ewarn
	ewarn "Please read the documentation"
	ewarn
	ewarn "The author of etswitch is unemployed so if your"
	ewarn "company is hiering he is looking for work."
#	einfo
#	einfo "Hail to the king, baby."
#	einfo
	ebeep 5
	epause 3
}


src_compile() {
	use debug && myconf="${myconf} --enable-debug"
	econf || die
	emake || die "emake failed"
}

src_install() {
	make DESTDIR="${D}" install || die "make install failed"
	dodoc AUTHORS BUGS ChangeLog NEWS README TODO
}

pkg_postinst() {
	print_etswitch_warning
}
