//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _DEFINES_H
#define _DEFINES_H



/************************************************
* Vide le vector l de tout ses elements			*
* Effectue un delete de chaque elements			*
* L'element doit etre de type class*			*
************************************************/
#define EFFACER_LISTE(class,l)	\
	{\
		class * b ;\
		while (!l.empty())	\
		{\
			b = *l.begin() ;\
			l.erase (l.begin()) ;\
			delete (b) ;\
		}\
	}
/************************************************
* Vide le stack de tout ses elements			*
* Effectue un delete de chaque elements			*
* L'element doit etre de type class*			*
************************************************/
#define EFFACER_STACK(class,s) \
	{\
		class * b ; \
		while (!s.empty())	\
		{\
			b = s.top() ;\
			s.pop() ;\
			delete (b) ;\
		}\
	}

/************************************************
* Macros referencant le dialog principal		*
* et les preferences de l'application			*
************************************************/
#define MAIN_DLG				((CETBuddiesDlg*)AfxGetMainWnd())
#define MAIN_PREF				MAIN_DLG->getPref()
#define GET_SKIN_DIR			MAIN_DLG->getPref()->getRepInstall() + CString ("skins\\")




/************************************************
* Recupere la derniere erreur windows			*
* Stocke l'erreur dans destinantion				*
* Destination doit etre de type CString			*
************************************************/
#define GET_LAST_ERROR(destination) \
	{\
		LPVOID lpMsgBuf;\
		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,\
		NULL, GetLastError(), MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),\
		(LPTSTR) &lpMsgBuf, 0, NULL);\
		destination.Format ("%s", lpMsgBuf) ;\
		LocalFree (lpMsgBuf);\
	}\

/************************************************
* Recupere la derniere erreur windows			*
* Leve une exception contenant					*
* entete + erreur win							*
************************************************/
#define	ERREUR(entete)	\
	{\
		CString erreur ;\
		CString desc ; \
		GET_LAST_ERROR(desc) \
		erreur.Format ("%s : %s", entete, desc) ;\
		throw (Exception((CString)erreur)) ;\
	}


/************************************************
* Recupere la derniere erreur windows			*
* Affiche un message d'erreur contenant			*
* entete + erreur win							*
************************************************/
#define	ERREUR_MSB(entete)	\
	{\
		CString erreur ;\
		CString desc ; \
		GET_LAST_ERROR(desc) \
		erreur.Format ("%s : %s", entete, desc) ;\
		MessageBox (AfxGetMainWnd()->m_hWnd, erreur, "Erreur", MB_ICONERROR) ;\
	}



/************************************************
* Recupere une exception et l'affiche			*
************************************************/
#define CATCH_EXCEPTION					CATCH_EXCEPTION_T("Exception")
#define CATCH_EXCEPTION_T(titre) \
	catch (Exception e)\
	{\
		if (AfxGetMainWnd() && AfxGetMainWnd()->m_hWnd)\
			::MessageBox (AfxGetMainWnd()->m_hWnd, e.getMessage(), titre, MB_ICONERROR);\
	}


/************************************************
* Recupere une exception sans l'afficher		*
************************************************/
#define CATCH_EXCEPTION_NO_MSG	catch (Exception e){}

/************************************************
* Insere texte dans le fichier debug			*
************************************************/
#define DEBUG_LOG(texte)		MAIN_DLG->getLog()->ajouterLigne(texte);


/************************************************
* Recupere une exception puis l'insere			*
* dans le fichier debug							*
************************************************/
#define CATCH_LOG	\
	catch (Exception e)\
	{\
		DEBUG_LOG(e.getMessage());\
	}

	

/************************************************
* Diverses operations et constantes				*
************************************************/
#define	STR_BUFFER(s)			(s).GetBuffer((s).GetLength())
#define THROW_E(e)				throw (Exception(CString(e)))

// macros pour les combo et les zones de textes
#define EDIT(idc)		((CEdit*)GetDlgItem(idc))
#define COMBO(idc)		((CComboBox*)GetDlgItem(idc))

//#undef	IN
#define INP(p,r)			((p).x >= (r).left && (p).x <= (r).right && (p).y >= (r).top && (p).y <= (r).bottom)

#define TAILLE_LISTE(liste)		sizeof(liste)/sizeof((liste)[0])

#define WS_EX_LAYERED           0x00080000    

#define LWA_COLORKEY            0x00000001
#define LWA_ALPHA               0x00000002

#define MAKE_LOWER(c)		(((c) >= 'A' && (c) <='Z') ? (c) - ('A' - 'a') : (c))


/************************************************
* Declare un iterator pour le vecteur			*
* class		= Type des elements du vecteur		*
* indice	= Nom de l'iterateur a creer		*
************************************************/
#define VEC_ITER(class,indice)			vector<class>::iterator indice

/************************************************
* Declare un iterator pour le map				*
* class1 = Type des elements de la cle			*
* class2 = Type des elements associes a	la cle	*
* indice = Nom de l'iterateur a creer			*
************************************************/
#define MAP_ITER(class1,class2,indice)	map<class1,class2>::iterator indice


/************************************************
* Macro definissant un boucle for parcourant	*
* tout les elements du vecteur					*
* class		= type des elements du vecteur		*
* liste		= nom du vecteur					*
* indice	= nom de l'iterateur a creer		*
************************************************/
#define	FOR_VECTOR_IND(class,liste,indice)\
	vector<class>::iterator indice;\
	for (indice = liste.begin() ; indice != liste.end() ; indice++)

/*#define	FOR_VECTOR_CONST_IND(class,liste,indice)\
	vector<clas>::const_iterator indice;\
	for (indice = liste.begin() ; indice != liste.end() ; indice++)*/


#define	FOR_VECTOR(clas,liste)			FOR_VECTOR_IND(clas,liste,i)

//#define FOR_VECTOR_CONST(clas,liste)	FOR_VECTOR_CONST_IND(clas,liste,i)

#define FOR_VECTOR_COND_IND(class,liste,indice,condition)\
	vector<class>::iterator indice;\
	for (indice = liste.begin() ; indice != liste.end() && condition ; indice++)

#define FOR_VECTOR_COND(class,liste,condition)	FOR_VECTOR_COND_IND(class,liste,i,condition)

#define FOR_MAP_IND(class1,class2,m,indice)\
	MAP_ITER(class1,class2,indice);\
	for (indice = m.begin() ; indice != m.end() ; indice++)

#define FOR_MAP(class1,class2,m)		FOR_MAP_IND(class1,class2,m,i)

	



#endif