//this file is part of ETBuddies
//Copyright (C)2004 Jos ( josb@oreka.com / http://www.etbuddies.fr.st )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// TypeConnection.cpp : implementation file
//

#include "stdafx.h"
#include "ETBuddies.h"
#include "ETBuddiesDlg.h"
#include "TypeConnection.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define END_TYPE	""

class Con
{
public:
	CString con;
	UINT conType ;
	Con(CString con, UINT type) {this->con = con;this->conType = type;}
} ;

static Con connections[] = {	
								Con("56 Kb/s or -", Preferences::CON_56K),
								Con("128 Kb/s",		Preferences::CON_128K),
								Con("512 Kb/s",		Preferences::CON_512K),
								Con("1 Mb/s",		Preferences::CON_1M),
								Con("2 Mb/s or +",	Preferences::CON_2M),
								Con(END_TYPE,		-1) 
							} ;

/////////////////////////////////////////////////////////////////////////////
// TypeConnection

TypeConnection::TypeConnection()
{
}

TypeConnection::~TypeConnection()
{
}


BEGIN_MESSAGE_MAP(TypeConnection, MyComboBox)
	//{{AFX_MSG_MAP(TypeConnection)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TypeConnection message handlers
void TypeConnection::OnInitDialog()
{
	int index ;

	for (int i = 0 ; connections[i].con != END_TYPE ; i++) 
	{
		index = this->AddString (connections[i].con) ;
		if (index != CB_ERR) {
			this->SetItemData (index, connections[i].conType) ;
		}

	}

	bool ok = this->SetSelection (MAIN_PREF->getConnection()) ;
	ASSERT(ok);
}

UINT TypeConnection::GetSelection()
{
	return (this->GetItemData(this->GetCurSel())) ;
}

bool TypeConnection::SetSelection(UINT selection)
{
	bool trouve = false ;

	for (int i = 0 ; connections[i].con != END_TYPE && !trouve; i++) 
	{
		if (this->GetItemData(i) == selection) 
		{
			this->SetCurSel (i) ;
			trouve = true ;
		}
	}

	return (trouve) ;
}